#ifndef I2C_Register_Table__H
#define I2C_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t MASTER_MODE:1;
            uint32_t SPEED:2;
            uint32_t IC_10BITADDR_SLAVE:1;
            uint32_t IC_10BITADDR_MASTER:1;
            uint32_t IC_RESTART_EN:1;
            uint32_t IC_SLAVE_DISABLE:1;
            uint32_t STOP_DET_IFADDRESSED:1;
            uint32_t TX_EMPTY_CTRL:1;
            uint32_t RX_FIFO_FULL_HLD_CTRL:1;
            uint32_t STOP_DET_IF_MASTER_ACTIVE:1;
            uint32_t BUS_CLEAR_FEATURE_CTRL:1;
            uint32_t RSVD_IC_CON_1:4;
            uint32_t OPTIONAL_SAR_CTRL:1;
            uint32_t SMBUS_SLAVE_QUICK_EN:1;
            uint32_t SMBUS_ARP_EN:1;
            uint32_t SMBUS_PERSISTENT_SLV_ADDR_EN:1;
            uint32_t RSVD_IC_CON_2:12;
        } IC_CON;
        uint32_t IC_CON_W;
    };

    union {
        struct {
            uint32_t IC_TAR:10;
            uint32_t GC_OR_START:1;
            uint32_t SPECIAL:1;
            uint32_t IC_10BITADDR_MASTER:1;
            uint32_t DEVICE_ID:1;
            uint32_t RSVD_IC_TAR_1:2;
            uint32_t SMBUS_QUICK_CMD:1;
            uint32_t RSVD_IC_TAR_2:15;
        } IC_TAR;
        uint32_t IC_TAR_W;
    };

    union {
        struct {
            uint32_t IC_SAR:10;
            uint32_t RSVD_IC_SAR:22;
        } IC_SAR;
        uint32_t IC_SAR_W;
    };

    union {
        struct {
            uint32_t IC_HS_MAR:3;
            uint32_t RSVD_IC_HS_MAR:29;
        } IC_HS_MADDR;
        uint32_t IC_HS_MADDR_W;
    };

    union {
        struct {
            uint32_t DAT:8;
            uint32_t CMD:1;
            uint32_t STOP:1;
            uint32_t RESTART:1;
            uint32_t FIRST_DATA_BYTE:1;
            uint32_t RSVD_IC_DATA_CMD:20;
        } IC_DAT_CMD;
        uint32_t IC_DAT_CMD_W;
    };

    union {
        struct {
            uint32_t IC_SS_SCL_HCNT:16;
            uint32_t RSVD_IC_SS_SCL_HIGH_COUNT:16;
        } IC_SS_SCL_HCNT;
        uint32_t IC_SS_SCL_HCNT_W;
    };

    union {
        struct {
            uint32_t IC_SS_SCL_LCNT:16;
            uint32_t RSVD_IC_SS_SCL_LOW_COUNT:16;
        } IC_SS_SCL_LCNT;
        uint32_t IC_SS_SCL_LCNT_W;
    };

    union {
        struct {
            uint32_t IC_FS_SCL_HCNT:16;
            uint32_t RSVD_IC_FS_SCL_HCNT:16;
        } IC_FS_SCL_HCNT;
        uint32_t IC_FS_SCL_HCNT_W;
    };

    union {
        struct {
            uint32_t IC_FS_SCL_LCNT:16;
            uint32_t RSVD_IC_FS_SCL_LCNT:16;
        } IC_FS_SCL_LCNT;
        uint32_t IC_FS_SCL_LCNT_W;
    };

    union {
        struct {
            uint32_t IC_HS_SCL_HCNT:16;
            uint32_t RSVD_IC_HS_SCL_HCNT:16;
        } IC_HS_SCL_HCNT;
        uint32_t IC_HS_SCL_HCNT_W;
    };

    union {
        struct {
            uint32_t IC_HS_SCL_LCNT:16;
            uint32_t RSVD_IC_HS_SCL_LOW_CNT:16;
        } IC_HS_SCL_LCNT;
        uint32_t IC_HS_SCL_LCNT_W;
    };

    union {
        struct {
            uint32_t R_RX_UNDER:1;
            uint32_t R_RX_OVER:1;
            uint32_t R_RX_FULL:1;
            uint32_t R_TX_OVER:1;
            uint32_t R_TX_EMPTY:1;
            uint32_t R_RD_REQ:1;
            uint32_t R_TX_ABRT:1;
            uint32_t R_RX_DONE:1;
            uint32_t R_ACTIVITY:1;
            uint32_t R_STOP_DET:1;
            uint32_t R_START_DET:1;
            uint32_t R_GEN_CALL:1;
            uint32_t R_RESTART_DET:1;
            uint32_t R_MASTER_ON_HOLD:1;
            uint32_t R_SCL_STUCK_AT_LOW:1;
            uint32_t RSVD_IC_INTR_STAT:17;
        } IC_INTR_STAT;
        uint32_t IC_INTR_STAT_W;
    };

    union {
        struct {
            uint32_t M_RX_UNDER:1;
            uint32_t M_RX_OVER:1;
            uint32_t M_RX_FULL:1;
            uint32_t M_TX_OVER:1;
            uint32_t M_TX_EMPTY:1;
            uint32_t M_RD_REQ:1;
            uint32_t M_TX_ABRT:1;
            uint32_t M_RX_DONE:1;
            uint32_t M_ACTIVITY:1;
            uint32_t M_STOP_DET:1;
            uint32_t M_START_DET:1;
            uint32_t M_GEN_CALL:1;
            uint32_t M_RESTART_DET:1;
            uint32_t M_MASTER_ON_HOLD:1;
            uint32_t M_SCL_STUCK_AT_LOW:1;
            uint32_t RSVD_IC_INTR_STAT:17;
        } IC_INTR_MASK;
        uint32_t IC_INTR_MASK_W;
    };

    union {
        struct {
            uint32_t RX_UNDER:1;
            uint32_t RX_OVER:1;
            uint32_t RX_FULL:1;
            uint32_t TX_OVER:1;
            uint32_t TX_EMPTY:1;
            uint32_t RD_REQ:1;
            uint32_t TX_ABRT:1;
            uint32_t RX_DONE:1;
            uint32_t ACTIVITY:1;
            uint32_t STOP_DET:1;
            uint32_t START_DET:1;
            uint32_t GEN_CALL:1;
            uint32_t RESTART_DET:1;
            uint32_t MASTER_ON_HOLD:1;
            uint32_t SCL_STUCK_AT_LOW:1;
            uint32_t RSVD_IC_RAW_INTR_STAT:17;
        } IC_RAW_INTR_STAT;
        uint32_t IC_RAW_INTR_STAT_W;
    };

    union {
        struct {
            uint32_t RX_TL:8;
            uint32_t RSVD_IC_RX_TL:24;
        } IC_RX_TL;
        uint32_t IC_RX_TL_W;
    };

    union {
        struct {
            uint32_t TX_TL:8;
            uint32_t RSVD_IC_TX_TL:24;
        } IC_TX_TL;
        uint32_t IC_TX_TL_W;
    };

    union {
        struct {
            uint32_t CLR_INTR:1;
            uint32_t RSVD_IC_CLR_INTR:31;
        } IC_CLR_INTR;
        uint32_t IC_CLR_INTR_W;
    };

    union {
        struct {
            uint32_t CLR_RX_UNDER:1;
            uint32_t RSVD_IC_CLR_RX_UNDER:31;
        } IC_CLR_RX_UNDER;
        uint32_t IC_CLR_RX_UNDER_W;
    };

    union {
        struct {
            uint32_t CLR_RX_OVER:1;
            uint32_t RSVD_IC_CLR_RX_OVER:31;
        } IC_CLR_RX_OVER;
        uint32_t IC_CLR_RX_OVER_W;
    };

    union {
        struct {
            uint32_t CLR_TX_OVER:1;
            uint32_t RSVD_IC_CLR_TX_OVER:31;
        } IC_CLR_TX_OVER;
        uint32_t IC_CLR_TX_OVER_W;
    };

    union {
        struct {
            uint32_t CLR_RD_REQ:1;
            uint32_t RSVD_IC_CLR_RD_REQ:31;
        } IC_CLR_RD_REQ;
        uint32_t IC_CLR_RD_REQ_W;
    };

    union {
        struct {
            uint32_t CLR_TX_ABRT:1;
            uint32_t RSVD_IC_CLR_TX_ABRT:31;
        } IC_CLR_TX_ABRT;
        uint32_t IC_CLR_TX_ABRT_W;
    };

    union {
        struct {
            uint32_t CLR_RX_DONE:1;
            uint32_t RSVD_IC_CLR_RX_DONE:31;
        } IC_CLR_RX_DONE;
        uint32_t IC_CLR_RX_DONE_W;
    };

    union {
        struct {
            uint32_t CLR_ACTIVITY:1;
            uint32_t RSVD_IC_CLR_ACTIVITY:31;
        } IC_CLR_ACTIVITY;
        uint32_t IC_CLR_ACTIVITY_W;
    };

    union {
        struct {
            uint32_t CLR_STOP_DET:1;
            uint32_t RSVD_IC_CLR_STOP_DET:31;
        } IC_CLR_STOP_DET;
        uint32_t IC_CLR_STOP_DET_W;
    };

    union {
        struct {
            uint32_t CLR_START_DET:1;
            uint32_t RSVD_IC_CLR_START_DET:31;
        } IC_CLR_START_DET;
        uint32_t IC_CLR_START_DET_W;
    };

    union {
        struct {
            uint32_t CLR_GEN_CALL:1;
            uint32_t RSVD_IC_CLR_GEN_CALL:31;
        } IC_CLR_GEN_CALL;
        uint32_t IC_CLR_GEN_CALL_W;
    };

    union {
        struct {
            uint32_t ENABLE:1;
            uint32_t ABORT:1;
            uint32_t TX_CMD_BLOCK:1;
            uint32_t SDA_STUCK_RECOVERY_ENABLE:1;
            uint32_t RSVD_IC_ENABLE_1:12;
            uint32_t SMBUS_CLK_RESET:1;
            uint32_t SMBUS_SUSPEND_EN:1;
            uint32_t SMBUS_ALERT_EN:1;
            uint32_t RSVD_IC_ENABLE_2:13;
        } IC_ENABLE;
        uint32_t IC_ENABLE_W;
    };

    union {
        struct {
            uint32_t ACTIVITY:1;
            uint32_t TFNF:1;
            uint32_t TFE:1;
            uint32_t RFNE:1;
            uint32_t RFF:1;
            uint32_t MST_ACTIVITY:1;
            uint32_t SLV_ACTIVITY:1;
            uint32_t MST_HOLD_TX_FIFO_EMPTY:1;
            uint32_t MST_HOLD_RX_FIFO_FULL:1;
            uint32_t SLV_HOLD_TX_FIFO_EMPTY:1;
            uint32_t SLV_HOLD_RX_FIFO_FULL:1;
            uint32_t SDA_STUCK_NOT_RECOVERED:1;
            uint32_t RSVD_IC_STATUS_1:4;
            uint32_t SMBUS_QUICK_CMD_BIT:1;
            uint32_t SMBUS_SLAVE_ADDR_VALID:1;
            uint32_t SMBUS_SLAVE_ADDR_RESOLVED:1;
            uint32_t SMBUS_SUSPEND_STATUS:1;
            uint32_t SMBUS_ALERT_STATUS:1;
            uint32_t RSVD_IC_STATUS_2:11;
        } IC_STATUS;
        uint32_t IC_STATUS_W;
    };

    union {
        struct {
            uint32_t TXFLR:5;
            uint32_t RSVD_TXFLR:27;
        } IC_TXFLR;
        uint32_t IC_TXFLR_W;
    };

    union {
        struct {
            uint32_t RXFLR:5;
            uint32_t RSVD_RXFLR:27;
        } IC_RXFLR;
        uint32_t IC_RXFLR_W;
    };

    union {
        struct {
            uint32_t IC_SDA_TX_HOLD:16;
            uint32_t IC_SDA_RX_HOLD:8;
            uint32_t RSVD_IC_SDA_HOLD:8;
        } IC_SDA_HOLD;
        uint32_t IC_SDA_HOLD_W;
    };

    union {
        struct {
            uint32_t ABRT_7B_ADDR_NOACK:1;
            uint32_t ABRT_10ADDR1_NOACK:1;
            uint32_t ABRT_10ADDR2_NOACK:1;
            uint32_t ABRT_TXDATA_NOACK:1;
            uint32_t ABRT_GCALL_NOACK:1;
            uint32_t ABRT_GCALL_READ:1;
            uint32_t ABRT_HS_ACKDET:1;
            uint32_t ABRT_SBYTE_ACKDET:1;
            uint32_t ABRT_HS_NORSTRT:1;
            uint32_t ABRT_SBYTE_NORSTRT:1;
            uint32_t ABRT_10B_RD_NORSTRT:1;
            uint32_t ABRT_MASTER_DIS:1;
            uint32_t ARB_LOST:1;
            uint32_t ABRT_SLVFLUSH_TXFIFO:1;
            uint32_t ABRT_SLV_ARBLOST:1;
            uint32_t ABRT_SLVRD_INTX:1;
            uint32_t ABRT_USER_ABRT:1;
            uint32_t ABRT_SDA_STUCK_AT_LOW:1;
            uint32_t ABRT_DEVICE_NOACK:1;
            uint32_t ABRT_DEVICE_SLVADDR_NOACK:1;
            uint32_t ABRT_DEVICE_WRITE:1;
            uint32_t RSVD_IC_TX_ABRT_SOURCE:2;
            uint32_t TX_FLUSH_CNT:9;
        } IC_TX_ABRT_SOURCE;
        uint32_t IC_TX_ABRT_SOURCE_W;
    };

    uint32_t rsvd_0x84[0x8/4];

    union {
        struct {
            uint32_t DMATDL:4;
            uint32_t RSVD_DMA_TDLR:28;
        } IC_DMA_TDLR;
        uint32_t IC_DMA_TDLR_W;
    };

    union {
        struct {
            uint32_t DMARDL:4;
            uint32_t RSVD_DMA_RDLR:28;
        } IC_DMA_RDLR;
        uint32_t IC_DMA_RDLR_W;
    };

    union {
        struct {
            uint32_t SDA_SETUP:8;
            uint32_t RSVD_IC_SDA_SETUP:24;
        } IC_SDA_SETUP;
        uint32_t IC_SDA_SETUP_W;
    };

    union {
        struct {
            uint32_t ACK_GEN_CALL:1;
            uint32_t RSVD_IC_SDA_SETUP:31;
        } IC_ACK_GENERAL_CALL;
        uint32_t IC_ACK_GENERAL_CALL_W;
    };

    union {
        struct {
            uint32_t IC_EN:1;
            uint32_t SLV_DISABLED_WHILE_BUSY:1;
            uint32_t SLV_RX_DATA_LOST:1;
            uint32_t RSVD_IC_ENABLE_STATUS:29;
        } IC_ENABLE_STATUS;
        uint32_t IC_ENABLE_STATUS_W;
    };

    union {
        struct {
            uint32_t IC_FS_SPKLEN:8;
            uint32_t RSVD_IC_FS_SPKLEN:24;
        } IC_FS_SPKLEN;
        uint32_t IC_FS_SPKLEN_W;
    };

    union {
        struct {
            uint32_t IC_HS_SPKLEN:8;
            uint32_t RSVD_IC_HS_SPKLEN:24;
        } IC_HS_SPKLEN;
        uint32_t IC_HS_SPKLEN_W;
    };

    union {
        struct {
            uint32_t CLR_RESTART_DET:1;
            uint32_t RSVD_IC_CLR_RESTART_DET:31;
        } IC_CLR_RESTART_DET;
        uint32_t IC_CLR_RESTART_DET_W;
    };

    uint32_t rsvd_0xac[0x8/4];

    union {
        struct {
            uint32_t CLR_SCL_STUCK_DET:1;
            uint32_t RSVD_CLR_SCL_STUCK_DET:31;
        } IC_CLR_SCL_STUCK_DET;
        uint32_t IC_CLR_SCL_STUCK_DET_W;
    };

    union {
        struct {
            uint32_t DEVICE_ID:24;
            uint32_t RSVD_IC_DEVICE_ID:8;
        } IC_DEVICE_ID;
        uint32_t IC_DEVICE_ID_W;
    };

    uint32_t rsvd_0xbc[0xc/4];

    union {
        struct {
            uint32_t R_SLV_CLOCK_EXTND_TIMEOUT:1;
            uint32_t R_MST_CLOCK_EXTND_TIMEOUT:1;
            uint32_t R_QUICK_CMD_DET:1;
            uint32_t R_HOST_NOTIFY_MST_DET:1;
            uint32_t R_ARP_PREPARE_CMD_DET:1;
            uint32_t R_ARP_RST_CMD_DET:1;
            uint32_t R_ARP_GET_UDID_CMD_DET:1;
            uint32_t R_ARP_ASSGN_ADDR_CMD_DET:1;
            uint32_t R_SLV_RX_PEC_NACK:1;
            uint32_t R_SMBUS_SUSPEND_DET:1;
            uint32_t R_SMBUS_ALERT_DET:1;
            uint32_t RSVD_IC_SMBUS_INTR_STAT:21;
        } IC_SMBUS_INTR_STAT;
        uint32_t IC_SMBUS_INTR_STAT_W;
    };

    uint32_t rsvd_0xcc[0x4/4];

    union {
        struct {
            uint32_t SLV_CLOCK_EXTND_TIMEOUT:1;
            uint32_t MST_CLOCK_EXTND_TIMEOUT:1;
            uint32_t QUICK_CMD_DET:1;
            uint32_t HOST_NTFY_MST_DET:1;
            uint32_t ARP_PREPARE_CMD_DET:1;
            uint32_t ARP_RST_CMD_DET:1;
            uint32_t ARP_GET_UDID_CMD_DET:1;
            uint32_t ARP_ASSGN_ADDR_CMD_DET:1;
            uint32_t SLV_RX_PEC_NACK:1;
            uint32_t SMBUS_SUSPEND_DET:1;
            uint32_t SMBUS_ALERT_DET:1;
            uint32_t RSVD_IC_SMBUS_RAW_INTR_STAT:21;
        } IC_SMBUS_RAW_INTR_STAT;
        uint32_t IC_SMBUS_RAW_INTR_STAT_W;
    };

    union {
        struct {
            uint32_t CLR_SLV_CLOCK_EXTND_TIMEOUT:1;
            uint32_t CLR_MST_CLOCK_EXTND_TIMEOUT:1;
            uint32_t CLR_QUICK_CMD_DET:1;
            uint32_t CLR_HOST_NOTIFY_MST_DET:1;
            uint32_t CLR_ARP_PREPARE_CMD_DET:1;
            uint32_t CLR_ARP_RST_CMD_DET:1;
            uint32_t CLR_ARP_GET_UDID_CMD_DET:1;
            uint32_t CLR_ARP_ASSGN_ADDR_CMD_DET:1;
            uint32_t CLR_SLV_RX_PEC_NACK:1;
            uint32_t CLR_SMBUS_SUSPEND_DET:1;
            uint32_t CLR_SMBUS_ALERT_DET:1;
            uint32_t RSVD_IC_CLR_SMBUS_INTR:21;
        } IC_CLR_SMBUS_INTR;
        uint32_t IC_CLR_SMBUS_INTR_W;
    };

    union {
        struct {
            uint32_t OPTIONAL_SAR:7;
            uint32_t RSVD_IC_OPTIONAL_SAR:25;
        } IC_OPTIONAL_SAR;
        uint32_t IC_OPTIONAL_SAR_W;
    };

    uint32_t rsvd_0xdc[0x4/4];

    union {
        struct {
            uint32_t SMBUS_UDID_WORD1:32;
        } IC_SMBUS_UDID_WORD1;
        uint32_t IC_SMBUS_UDID_WORD1_W;
    };

    uint32_t rsvd_0xe4[0x10/4];

    union {
        struct {
            uint32_t APB_DATA_WIDTH:2;
            uint32_t MAX_SPEED_MODE:2;
            uint32_t HC_COUNT_VALUES:1;
            uint32_t INTR_IO:1;
            uint32_t HAS_DMA:1;
            uint32_t ADD_ENCODED_PARAMS:1;
            uint32_t RX_BUFFER_DEPTH:8;
            uint32_t TX_BUFFER_DEPTH:8;
            uint32_t RSVD_IC_COMP_PARAM_1:8;
        } IC_COMP_PARAM_1;
        uint32_t IC_COMP_PARAM_1_W;
    };

    union {
        struct {
            uint32_t IC_COMP_VERSION:32;
        } IC_COMP_VERSION;
        uint32_t IC_COMP_VERSION_W;
    };

    union {
        struct {
            uint32_t IC_COMP_TYPE:32;
        } IC_COMP_TYPE;
        uint32_t IC_COMP_TYPE_W;
    };

} I2C_Register_Table_s;
#endif
