#ifndef INNO_DDR_PHY_Byte_Register_Table__H
#define INNO_DDR_PHY_Byte_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t reg_a_l_abutslewpd_reg:5;
            uint32_t reg_a_l_dqsbweakpub_reg  :1;
            uint32_t reg_a_l_dqsweakpd_reg  :1;
            uint32_t reg_a_l_enb_lp4mode_reg  :1;
            uint32_t reg_a_l_abutslewpu_reg:5;
            uint32_t reg_a_l_weakpub_reg  :1;
            uint32_t reg_a_l_weakpd_reg  :1;
            uint32_t reg_a_l_vref1_pd_reg  :1;
            uint32_t reg_a_l_dqfbsel_reg  :1;
            uint32_t reg_a_l_dqfben_reg  :1;
            uint32_t reg_a_l_abutdiffampseen_reg  :1;
            uint32_t reg_a_l_abutweakpubdq_reg  :1;
            uint32_t reg_a_l_abutweakpddq_reg  :1;
            uint32_t reg_a_l_dq_drv_zqcali_en  :1;
            uint32_t reg_a_l_dq_odt_zqcali_en  :1;
            uint32_t rsvd_23:1;
            uint32_t reg_a_l_vref1_margsel_reg:8;
        } reg_0x300;
        uint32_t reg_0x300_W;
    };

    union {
        struct {
            uint32_t reg_a_l_abutodtpudq0_reg  :1;
            uint32_t reg_a_l_abutodtpudq1_reg  :1;
            uint32_t reg_a_l_abutodtpudq2_reg  :1;
            uint32_t reg_a_l_abutodtpudq3_reg  :1;
            uint32_t reg_a_l_abutodtpudq4_reg  :1;
            uint32_t rsvd_5:3;
            uint32_t reg_a_l_abutodtpddq0_reg  :1;
            uint32_t reg_a_l_abutodtpddq1_reg  :1;
            uint32_t reg_a_l_abutodtpddq2_reg  :1;
            uint32_t reg_a_l_abutodtpddq3_reg  :1;
            uint32_t reg_a_l_abutodtpddq4_reg  :1;
            uint32_t rsvd_13:3;
            uint32_t reg_a_l_abutprcompdq0_reg  :1;
            uint32_t reg_a_l_abutprcompdq1_reg  :1;
            uint32_t reg_a_l_abutprcompdq2_reg  :1;
            uint32_t reg_a_l_abutprcompdq3_reg  :1;
            uint32_t reg_a_l_abutprcompdq4_reg  :1;
            uint32_t rsvd_21:3;
            uint32_t reg_a_l_abutnrcompdq0_reg  :1;
            uint32_t reg_a_l_abutnrcompdq1_reg  :1;
            uint32_t reg_a_l_abutnrcompdq2_reg  :1;
            uint32_t reg_a_l_abutnrcompdq3_reg  :1;
            uint32_t reg_a_l_abutnrcompdq4_reg  :1;
        } reg_0x304;
        uint32_t reg_0x304_W;
    };

    uint32_t rsvd_0x308[0x18/4];

    union {
        struct {
            uint32_t reg_a_l_rxmen1_sdlltap_bp:6;
            uint32_t reg_a_l_rxmen1_ophsel_bp:3;
            uint32_t reg_a_l_rxmen1_delay_bp:3;
            uint32_t rsvd_12:3;
            uint32_t reg_a_l_rxmen0_sdlltap_bp:6;
            uint32_t reg_a_l_rxmen0_ophsel_bp:3;
            uint32_t reg_a_l_rxmen0_delay_bp:3;
        } reg_0x320;
        uint32_t reg_0x320_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rdodt1_dllsel:5;
            uint32_t reg_a_l_rdodt1_ophsel:3;
            uint32_t reg_a_l_rdodt1_delay:3;
            uint32_t rsvd_11:5;
            uint32_t reg_a_l_rdodt0_dllsel:5;
            uint32_t reg_a_l_rdodt0_ophsel:3;
            uint32_t reg_a_l_rdodt0_delay:3;
        } reg_0x324;
        uint32_t reg_0x324_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rrankdly_4x_cs1:3;
            uint32_t reg_a_l_rrankdly_4x_cs0:3;
            uint32_t reg_a_l_wrankphsel:3;
            uint32_t reg_a_l_rxm4p5en_r2:1;
            uint32_t reg_a_l_odtenb4p5en_r2:1;
            uint32_t reg_a_l_rxpst_bp:1;
            uint32_t reg_a_l_tsm_iobufact_bp:1;
            uint32_t reg_a_l_rxm4p5en:1;
            uint32_t reg_a_l_odtenb4p5en:1;
            uint32_t reg_a_l_abutobsmodeen:1;
            uint32_t reg_a_l_rxm_odiffampen:1;
            uint32_t reg_a_l_wrptrclrb:1;
            uint32_t reg_a_l_selfclren:1;
            uint32_t reg_a_l_rcvdqsmodsel:1;
            uint32_t reg_a_l_dqs_ph90en_bp:1;
            uint32_t reg_a_l_dq_ph90en_bp:1;
            uint32_t reg_a_l_dmout_mux:1;
            uint32_t reg_a_l_dqout_mux:1;
            uint32_t reg_a_l_dqobsmuxsel:4;
            uint32_t reg_a_l_dm_obsdataen:1;
        } reg_0x328;
        uint32_t reg_0x328_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rrank_dlldly_cs1:6;
            uint32_t reg_a_l_rrank_dlldly_cs0:6;
        } reg_0x32c;
        uint32_t reg_0x32c_W;
    };

    uint32_t rsvd_0x330[0x20/4];

    union {
        struct {
            uint32_t reg_a_l_cs0_dm_invdelaysel:6;
        } reg_0x350;
        uint32_t reg_0x350_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_dq3_invdelaysel:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs0_dq2_invdelaysel:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs0_dq1_invdelaysel:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs0_dq0_invdelaysel:6;
        } reg_0x354;
        uint32_t reg_0x354_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_dq7_invdelaysel:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs0_dq6_invdelaysel:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs0_dq5_invdelaysel:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs0_dq4_invdelaysel:6;
        } reg_0x358;
        uint32_t reg_0x358_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_dqsb_invdelaysel:6;
            uint32_t rsvd_14:10;
            uint32_t reg_a_l_cs0_dqs_invdelaysel:6;
        } reg_0x35c;
        uint32_t reg_0x35c_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_dm_invdelayselrx:6;
            uint32_t rsvd_14:10;
            uint32_t reg_a_l_cs0_loop_invdelaysel:5;
        } reg_0x360;
        uint32_t reg_0x360_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_dq3_invdelayselrx:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs0_dq2_invdelayselrx:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs0_dq1_invdelayselrx:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs0_dq0_invdelayselrx:6;
        } reg_0x364;
        uint32_t reg_0x364_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_dq7_invdelayselrx:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs0_dq6_invdelayselrx:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs0_dq5_invdelayselrx:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs0_dq4_invdelayselrx:6;
        } reg_0x368;
        uint32_t reg_0x368_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_dqsb_invdelayselrx:6;
            uint32_t rsvd_14:10;
            uint32_t reg_a_l_cs0_dqs_invdelayselrx:6;
        } reg_0x36c;
        uint32_t reg_0x36c_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dm_invdelaysel:6;
        } reg_0x370;
        uint32_t reg_0x370_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dq3_invdelaysel:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs1_dq2_invdelaysel:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs1_dq1_invdelaysel:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs1_dq0_invdelaysel:6;
        } reg_0x374;
        uint32_t reg_0x374_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dq7_invdelaysel:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs1_dq6_invdelaysel:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs1_dq5_invdelaysel:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs1_dq4_invdelaysel:6;
        } reg_0x378;
        uint32_t reg_0x378_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dqsb_invdelaysel:6;
            uint32_t rsvd_14:10;
            uint32_t reg_a_l_cs1_dqs_invdelaysel:6;
        } reg_0x37c;
        uint32_t reg_0x37c_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dm_invdelayselrx:6;
            uint32_t rsvd_14:10;
            uint32_t reg_a_l_cs1_loop_invdelaysel:5;
        } reg_0x380;
        uint32_t reg_0x380_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dq3_invdelayselrx:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs1_dq2_invdelayselrx:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs1_dq1_invdelayselrx:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs1_dq0_invdelayselrx:6;
        } reg_0x384;
        uint32_t reg_0x384_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dq7_invdelayselrx:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_cs1_dq6_invdelayselrx:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_cs1_dq5_invdelayselrx:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_cs1_dq4_invdelayselrx:6;
        } reg_0x388;
        uint32_t reg_0x388_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_dqsb_invdelayselrx:6;
            uint32_t rsvd_14:10;
            uint32_t reg_a_l_cs1_dqs_invdelayselrx:6;
        } reg_0x38c;
        uint32_t reg_0x38c_W;
    };

    uint32_t rsvd_0x390[0x10/4];

    union {
        struct {
            uint32_t reg_a_l_rd_train_dqs_range_min:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_rd_train_dqs_range_max:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_dqs_default:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_rd_train_dqs_default:6;
        } reg_0x3a0;
        uint32_t reg_0x3a0_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rdtrain_check_wrap1:8;
            uint32_t reg_a_l_rdtrain_check_wrap0:8;
        } reg_0x3a4;
        uint32_t reg_0x3a4_W;
    };

    uint32_t rsvd_0x3a8[0x38/4];

    union {
        struct {
            uint32_t reg_a_l_tdqs_invdelaysel1:6;
            uint32_t rsvd_6:10;
            uint32_t reg_a_l_tdqs_invdelaysel0:6;
            uint32_t rsvd_22:8;
            uint32_t reg_a_l_dqs_idqshigh:1;
        } reg_0x3e0;
        uint32_t reg_0x3e0_W;
    };

    union {
        struct {
            uint32_t reg_a_l_dllsel:6;
            uint32_t reg_a_l_ophsel:3;
            uint32_t reg_a_l_cycsel:3;
        } reg_0x3e4;
        uint32_t reg_0x3e4_W;
    };

    union {
        struct {
            uint32_t reg_a_l_calib_result_cs1:12;
            uint32_t rsvd_12:4;
            uint32_t reg_a_l_calib_result_cs0:12;
        } reg_0x3e8;
        uint32_t reg_0x3e8_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs0_value_dqx_invdelaysel:6;
        } reg_0x3ec;
        uint32_t reg_0x3ec_W;
    };

    union {
        struct {
            uint32_t reg_a_l_cs1_value_dqx_invdelaysel:6;
        } reg_0x3f0;
        uint32_t reg_0x3f0_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_min_for_rd_dq3:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_min_for_rd_dq2:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_min_for_rd_dq1:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_min_for_rd_dq0:6;
        } reg_0x3f4;
        uint32_t reg_0x3f4_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_min_for_rd_dq7:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_min_for_rd_dq6:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_min_for_rd_dq5:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_min_for_rd_dq4:6;
        } reg_0x3f8;
        uint32_t reg_0x3f8_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_min_for_rd_dqs:6;
        } reg_0x3fc;
        uint32_t reg_0x3fc_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_max_for_rd_dq3:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_max_for_rd_dq2:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_max_for_rd_dq1:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_max_for_rd_dq0:6;
        } reg_0x400;
        uint32_t reg_0x400_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_max_for_rd_dq7:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_max_for_rd_dq6:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_max_for_rd_dq5:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_max_for_rd_dq4:6;
        } reg_0x404;
        uint32_t reg_0x404_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_max_for_rd_dqs:6;
        } reg_0x408;
        uint32_t reg_0x408_W;
    };

    union {
        struct {
            uint32_t reg_a_l_right_boundary_overflow_for_rd:1;
            uint32_t reg_a_l_left_boundary_overflow_for_rd:1;
            uint32_t rsvd_4:1;
            uint32_t reg_a_l_change_rd_dqs_default:1;
            uint32_t rsvd_6:12;
            uint32_t reg_a_l_train_result_for_rd_base_dqs:6;
        } reg_0x40c;
        uint32_t reg_0x40c_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rd_train_readback_data_dq1:16;
            uint32_t reg_a_l_rd_train_readback_data_dq0:16;
        } reg_0x410;
        uint32_t reg_0x410_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rd_train_readback_data_dq3:16;
            uint32_t reg_a_l_rd_train_readback_data_dq2:16;
        } reg_0x414;
        uint32_t reg_0x414_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rd_train_readback_data_dq5:16;
            uint32_t reg_a_l_rd_train_readback_data_dq4:16;
        } reg_0x418;
        uint32_t reg_0x418_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rd_train_readback_data_dq7:16;
            uint32_t reg_a_l_rd_train_readback_data_dq6:16;
        } reg_0x41c;
        uint32_t reg_0x41c_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_min_for_dqs:6;
            uint32_t rsvd_6:10;
            uint32_t reg_a_l_change_dqs_default:1;
        } reg_0x420;
        uint32_t reg_0x420_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_min_for_dq3:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_min_for_dq2:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_min_for_dq1:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_min_for_dq0:6;
        } reg_0x424;
        uint32_t reg_0x424_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_min_for_dq7:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_min_for_dq6:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_min_for_dq5:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_min_for_dq4:6;
        } reg_0x428;
        uint32_t reg_0x428_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_max_for_dqs:6;
        } reg_0x42c;
        uint32_t reg_0x42c_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_max_for_dq3:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_max_for_dq2:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_max_for_dq1:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_max_for_dq0:6;
        } reg_0x430;
        uint32_t reg_0x430_W;
    };

    union {
        struct {
            uint32_t reg_a_l_train_max_for_dq7:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a_l_train_max_for_dq6:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a_l_train_max_for_dq5:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a_l_train_max_for_dq4:6;
        } reg_0x434;
        uint32_t reg_0x434_W;
    };

    union {
        struct {
            uint32_t reg_a_l_rdtrain_vref_min:8;
            uint32_t reg_a_l_rdtrain_vref_max:8;
        } reg_0x438;
        uint32_t reg_0x438_W;
    };

} INNO_DDR_PHY_Byte_Register_Table_s;
#endif
