#ifndef INNO_DDR_PHY_Com_Register_Table__H
#define INNO_DDR_PHY_Com_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t soft_reset:1;
            uint32_t soft_reset0:1;
            uint32_t soft_reset1:1;
            uint32_t rsvd_3:1;
            uint32_t mem_select_t:3;
            uint32_t reg_burst_sel:1;
            uint32_t reg_channel_en:4;
        } reg_0x0;
        uint32_t reg_0x0_W;
    };

    union {
        struct {
            uint32_t reg_start_calib:1;
            uint32_t reg_calib_bypass:1;
            uint32_t reg_calcs_sel:2;
            uint32_t reg_wl_enable:1;
            uint32_t reg_wl_bypass:1;
            uint32_t reg_wlcs_sel:2;
            uint32_t rsvd_8:8;
            uint32_t reg_wl_loadmode:16;
        } reg_0x4;
        uint32_t reg_0x4_W;
    };

    union {
        struct {
            uint32_t AL_FRE_OP3:6;
            uint32_t rsvd_6:2;
            uint32_t AL_FRE_OP2:6;
            uint32_t rsvd_14:2;
            uint32_t AL_FRE_OP1:6;
            uint32_t rsvd_22:2;
            uint32_t AL_FRE_OP0:6;
        } reg_0x8;
        uint32_t reg_0x8_W;
    };

    union {
        struct {
            uint32_t CL_FRE_OP3:6;
            uint32_t rsvd_6:2;
            uint32_t CL_FRE_OP2:6;
            uint32_t rsvd_14:2;
            uint32_t CL_FRE_OP1:6;
            uint32_t rsvd_22:2;
            uint32_t CL_FRE_OP0:6;
        } reg_0xc;
        uint32_t reg_0xc_W;
    };

    union {
        struct {
            uint32_t CWL_FRE_OP3:5;
            uint32_t rsvd_5:3;
            uint32_t CWL_FRE_OP2:5;
            uint32_t rsvd_13:3;
            uint32_t CWL_FRE_OP1:5;
            uint32_t rsvd_21:3;
            uint32_t CWL_FRE_OP0:5;
        } reg_0x10;
        uint32_t reg_0x10_W;
    };

    union {
        struct {
            uint32_t reg_h1xclk_invdelaysel_dqcmd:5;
            uint32_t rsvd_5:3;
            uint32_t reg_h4xclkdqs_invdelaysel_dqcmd:5;
            uint32_t rsvd_13:3;
            uint32_t reg_h4xclk_invdelaysel_dqcmd:5;
            uint32_t rsvd_21:3;
            uint32_t reg_fb1xclk_invdelaysel_dqcmd:5;
        } reg_0x14;
        uint32_t reg_0x14_W;
    };

    union {
        struct {
            uint32_t reg_cmd_ph90en_bp:32;
        } reg_0x18;
        uint32_t reg_0x18_W;
    };

    union {
        struct {
            uint32_t reg_rxodt_start_point:4;
            uint32_t reg_rxodt_length:4;
            uint32_t reg_rxodt_stdelay:4;
            uint32_t rsvd_12:1;
            uint32_t reg_rxodt_st_bypass:1;
            uint32_t reg_rdodt_bypass:1;
            uint32_t rsvd_15:1;
            uint32_t reg_rden_delay:3;
            uint32_t reg_rden_bypass:1;
            uint32_t ph90en_bp_dq:1;
            uint32_t ph90en_bp:1;
            uint32_t reg_cmdout_mux:1;
            uint32_t reg_vt_comp_bp:1;
            uint32_t reg_x1clk_div_sel:1;
            uint32_t reg_oscen_t:1;
        } reg_0x1c;
        uint32_t reg_0x1c_W;
    };

    union {
        struct {
            uint32_t reg_cat_enable:1;
            uint32_t reg_cat_start:1;
            uint32_t reg_cat_bp_start:1;
            uint32_t reg_cat_bp_en:1;
            uint32_t reg_cat_bp_mode:1;
            uint32_t reg_cat_bp_cmd_send:1;
            uint32_t reg_cat_bp_rank_sel:2;
            uint32_t reg_clk_div_cnt:4;
            uint32_t reg_cat_channel_num:2;
            uint32_t reg_cat_rank_num:2;
        } reg_0x20;
        uint32_t reg_0x20_W;
    };

    union {
        struct {
            uint32_t reg_tcacd:5;
            uint32_t reg_tmrw:5;
            uint32_t reg_tdstrain:5;
            uint32_t reg_tckelck:5;
            uint32_t reg_tadr:5;
            uint32_t reg_txcbt:5;
        } reg_0x24;
        uint32_t reg_0x24_W;
    };

    union {
        struct {
            uint32_t reg_tfc:8;
            uint32_t reg_tcaent:8;
            uint32_t reg_tvrefca_long:8;
        } reg_0x28;
        uint32_t reg_0x28_W;
    };

    union {
        struct {
            uint32_t reg_mr11:8;
            uint32_t reg_mr3:8;
            uint32_t reg_mr2:8;
            uint32_t reg_mr1:8;
        } reg_0x2c;
        uint32_t reg_0x2c_W;
    };

    union {
        struct {
            uint32_t reg_mr22:8;
            uint32_t reg_mr14:8;
            uint32_t reg_mr13:8;
        } reg_0x30;
        uint32_t reg_0x30_W;
    };

    union {
        struct {
            uint32_t reg_chb_cat_vref_bp_value:7;
            uint32_t rsvd_7:1;
            uint32_t reg_cha_cat_vref_bp_value:7;
            uint32_t rsvd_15:1;
            uint32_t reg_cat_vref_scan_min:6;
            uint32_t rsvd_22:2;
            uint32_t reg_cat_vref_scan_max:6;
            uint32_t reg_cat_vref_scan_disable:1;
            uint32_t reg_ca_vref_update:1;
        } reg_0x34;
        uint32_t reg_0x34_W;
    };

    union {
        struct {
            uint32_t reg_ca_perbit_skew_update:1;
            uint32_t reg_cmd_perbit_skew_bp:1;
            uint32_t reg_cat_skip_cs_train:1;
            uint32_t reg_cat_fc_pd_en:1;
            uint32_t reg_cat_fspy_rank:2;
            uint32_t reg_cat_skip_fspy:1;
            uint32_t reg_cs_pwc_disable:1;
            uint32_t reg_cat_vref_scan_steps:3;
            uint32_t reg_lpddr4_ca_odt_sel:1;
            uint32_t reg_lpddr4_ca_odt:2;
            uint32_t rsvd_14:2;
            uint32_t reg_cs_perbit_skew_offest_fsp3:4;
            uint32_t reg_cs_perbit_skew_offest_fsp2:4;
            uint32_t reg_cs_perbit_skew_offest_fsp1:4;
            uint32_t reg_cs_perbit_skew_offest_fsp0:4;
        } reg_0x38;
        uint32_t reg_0x38_W;
    };

    union {
        struct {
            uint32_t reg_cat_cs_train_value:6;
            uint32_t rsvd_6:2;
            uint32_t reg_cat_ca_train_value:6;
            uint32_t rsvd_14:2;
            uint32_t reg_cat_ca_scan_max:8;
            uint32_t reg_cat_ck_cke_odt_fix_perbit_skew:1;
            uint32_t reg_cat_cke_mode:1;
        } reg_0x3c;
        uint32_t reg_0x3c_W;
    };

    union {
        struct {
            uint32_t reg_chb_cat_ca_check_value:6;
            uint32_t rsvd_6:2;
            uint32_t reg_cha_cat_ca_check_value:6;
            uint32_t rsvd_14:2;
            uint32_t reg_chb_cat_cs_check_value:6;
            uint32_t rsvd_22:2;
            uint32_t reg_cha_cat_cs_check_value:6;
        } reg_0x40;
        uint32_t reg_0x40_W;
    };

    union {
        struct {
            uint32_t reg_scr_cketrirnk0:1;
            uint32_t reg_scr_cmdtrien:1;
            uint32_t reg_scr_csbtrien:1;
            uint32_t reg_scr_odttrien:1;
            uint32_t reg_scr_sdhsclk_pos1neg0sel:1;
            uint32_t reg_scr_sdhsclkb_pos1neg0sel:1;
            uint32_t reg_scr_sckdimm0dis:1;
            uint32_t reg_scr_rcvmodsel:1;
            uint32_t reg_rdptr_delay:1;
            uint32_t reg_sync_en:1;
            uint32_t mux_sync_sel:1;
            uint32_t reg_mch_odt:1;
            uint32_t bist_ck_select:1;
            uint32_t reg_fiford_delay:1;
            uint32_t bist_calibst:1;
            uint32_t reg_b0_obsdataen:1;
            uint32_t reg_b0_cmdobsmuxsel:4;
            uint32_t reg_lpddr4_cmd_gap_for_diff_rank:3;
            uint32_t reg_pwrok_pi:1;
            uint32_t reg_calib_mode_sel:1;
            uint32_t reg_sdram_vref_update:1;
            uint32_t reg_cmd_abutobsmodeen:1;
            uint32_t reg_calib_freq_update:1;
            uint32_t reg_wl_freq_update:1;
            uint32_t reg_lpddr4_rd_preamble:1;
            uint32_t reg_freq_choose_t:2;
        } reg_0x44;
        uint32_t reg_0x44_W;
    };

    union {
        struct {
            uint32_t reg_mpr_cnt:8;
            uint32_t bypassen:4;
            uint32_t reg_ram_vref1_pd:1;
        } reg_0x48;
        uint32_t reg_0x48_W;
    };

    union {
        struct {
            uint32_t reg_calib_timeout:16;
            uint32_t reg_max_rdvalue:8;
        } reg_0x4c;
        uint32_t reg_0x4c_W;
    };

    union {
        struct {
            uint32_t reg_wrrank_1xdly:3;
            uint32_t rsvd_3:1;
            uint32_t reg_rdrank_1xdly:3;
            uint32_t reg_rdrank_delay_bp:1;
            uint32_t reg_rdrank_4xdly:2;
            uint32_t reg_rrankdly_4x_dec:1;
        } reg_0x50;
        uint32_t reg_0x50_W;
    };

    union {
        struct {
            uint32_t reg_cmd3_wrap_sel:5;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd2_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd1_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd0_wrap_sel:5;
        } reg_0x54;
        uint32_t reg_0x54_W;
    };

    union {
        struct {
            uint32_t reg_cmd7_wrap_sel:5;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd6_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd5_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd4_wrap_sel:5;
        } reg_0x58;
        uint32_t reg_0x58_W;
    };

    union {
        struct {
            uint32_t reg_cmd11_wrap_sel:5;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd10_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd9_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd8_wrap_sel:5;
        } reg_0x5c;
        uint32_t reg_0x5c_W;
    };

    union {
        struct {
            uint32_t reg_cmd15_wrap_sel:5;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd14_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd13_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd12_wrap_sel:5;
        } reg_0x60;
        uint32_t reg_0x60_W;
    };

    union {
        struct {
            uint32_t reg_cmd19_wrap_sel:5;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd18_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd17_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd16_wrap_sel:5;
        } reg_0x64;
        uint32_t reg_0x64_W;
    };

    union {
        struct {
            uint32_t reg_cmd23_wrap_sel:5;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd22_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd21_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd20_wrap_sel:5;
        } reg_0x68;
        uint32_t reg_0x68_W;
    };

    union {
        struct {
            uint32_t reg_cmd27_wrap_sel:5;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd26_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd25_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd24_wrap_sel:5;
        } reg_0x6c;
        uint32_t reg_0x6c_W;
    };

    union {
        struct {
            uint32_t reg_cmd30_wrap_sel:5;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd29_wrap_sel:5;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd28_wrap_sel:5;
        } reg_0x70;
        uint32_t reg_0x70_W;
    };

    union {
        struct {
            uint32_t reg_byte3_wrap_sel:2;
            uint32_t reg_byte2_wrap_sel:2;
            uint32_t reg_byte1_wrap_sel:2;
            uint32_t reg_byte0_wrap_sel:2;
        } reg_0x74;
        uint32_t reg_0x74_W;
    };

    union {
        struct {
            uint32_t reg_cke_ck_cmd_pad_t:32;
        } reg_0x78;
        uint32_t reg_0x78_W;
    };

    union {
        struct {
            uint32_t reg_pllpostdiv_dqcmd:3;
            uint32_t reg_pllpostdiven_dqcmd:1;
            uint32_t reg_pllprediv_dqcmd:5;
            uint32_t rsvd_9:7;
            uint32_t reg_pllfbdiv_dqcmd:9;
        } reg_0x7c;
        uint32_t reg_0x7c_W;
    };

    union {
        struct {
            uint32_t reg_pllpd_dqcmd_t:1;
            uint32_t reg_pllclkouten_dqcmd_t:1;
            uint32_t reg_pllincz_dqcmd:1;
            uint32_t reg_ssc_rstn:1;
            uint32_t reg_pllref_clk_byp_dqcmd:1;
            uint32_t reg_pllrstbsel_dqcmd:1;
            uint32_t reg_lockenb_dqcmd:1;
            uint32_t reg_plltestouten_dqcmd:1;
            uint32_t reg_pllcpp_bias_dqcmd:3;
            uint32_t rsvd_11:1;
            uint32_t reg_pllcpi_bias_dqcmd:3;
            uint32_t rsvd_15:1;
            uint32_t reg_pllgvco_bias_dqcmd:2;
            uint32_t reg_plltestsel_dqcmd:2;
        } reg_0x80;
        uint32_t reg_0x80_W;
    };

    union {
        struct {
            uint32_t reg_lp_pllpd_ctrl_en:1;
            uint32_t reg_lp_io_ctrl_en:1;
            uint32_t reg_lp_dig_clk_ctrl_en:1;
            uint32_t reg_lp_spll_clktree_ctrl_en:1;
            uint32_t reg_lp_dig_rst_ctrl_en:1;
            uint32_t reg_lp_dq_clk_ctrl_en:1;
            uint32_t reg_lp_io_dis_ctrl:2;
            uint32_t reg_lp_wakeup_threhold:4;
            uint32_t reg_lp_vref_ctrl_en:1;
            uint32_t reg_lp_wakeup_sel:1;
            uint32_t reg_deep_lp_en:1;
            uint32_t reg_lp_bypass:1;
            uint32_t reg_outclken:1;
            uint32_t reg_dqclken_t:1;
            uint32_t reg_train_reg_update_en:1;
            uint32_t reg_hclk_ca_sel:1;
            uint32_t reg_hclk_byte_sel:1;
            uint32_t reg_hclk_byte3_sel:1;
            uint32_t reg_hclk_byte2_sel:1;
            uint32_t reg_hclk_byte1_sel:1;
            uint32_t reg_hclk_byte0_sel:1;
            uint32_t reg_hclk_zqcalib_sel:1;
            uint32_t reg_hclk_bist_sel:1;
            uint32_t reg_hclk_train_sel:1;
            uint32_t reg_dfi_clk_gate_bp:1;
        } reg_0x84;
        uint32_t reg_0x84_W;
    };

    union {
        struct {
            uint32_t reg_wait_cnt:16;
            uint32_t reg_lp_ackvalue:4;
            uint32_t reg_lp_stvalue:4;
        } reg_0x88;
        uint32_t reg_0x88_W;
    };

    union {
        struct {
            uint32_t reg_zqcali_en:1;
            uint32_t reg_zqcali_bypass:1;
            uint32_t reg_zqcali_clear:1;
            uint32_t reg_pd_zqcali:1;
            uint32_t reg_sel_zqcali:2;
            uint32_t reg_drvpu_zqcalib_sel:2;
            uint32_t reg_odtpu_zqcalib_sel:2;
            uint32_t reg_pu_interval:9;
            uint32_t rsvd_19:1;
            uint32_t reg_zq_chg_interval:9;
        } reg_0x8c;
        uint32_t reg_0x8c_W;
    };

    union {
        struct {
            uint32_t reg_odtlegpb_zqcali:5;
            uint32_t rsvd_5:3;
            uint32_t reg_odtlegn_zqcali:5;
            uint32_t rsvd_13:3;
            uint32_t reg_drvlegpb_zqcali:5;
            uint32_t rsvd_21:3;
            uint32_t reg_drvlegn_zqcali:5;
        } reg_0x90;
        uint32_t reg_0x90_W;
    };

    union {
        struct {
            uint32_t reg_dq_rd_train_en:1;
            uint32_t reg_dqs_rd_train_en:1;
            uint32_t reg_rd_train_freq_update:1;
            uint32_t reg_rd_train_check_value_en:1;
            uint32_t reg_bypass_rd_train_en:1;
            uint32_t reg_bypass_rd_train_cmd_start_en:1;
            uint32_t reg_rd_train_dqs_range_bypass:1;
            uint32_t reg_rx_vref_value_update:1;
            uint32_t reg_rdtrain_cs_sel:2;
            uint32_t reg_ddr4_dbi:1;
            uint32_t reg_train_vref_en:1;
            uint32_t reg_rd_train_perdef_en:1;
            uint32_t rsvd_13:1;
            uint32_t reg_pd_interval:9;
        } reg_0x94;
        uint32_t reg_0x94_W;
    };

    union {
        struct {
            uint32_t reg_lpddr4_mr40_value:8;
            uint32_t reg_lpddr4_mr32_value:8;
            uint32_t reg_lpddr4_mr20_value:8;
            uint32_t reg_lpddr4_mr15_value:8;
        } reg_0x98;
        uint32_t reg_0x98_W;
    };

    union {
        struct {
            uint32_t reg_ddr4_mr3:8;
            uint32_t rsvd_8:8;
            uint32_t reg_ddr4_mr4_value:16;
        } reg_0x9c;
        uint32_t reg_0x9c_W;
    };

    union {
        struct {
            uint32_t reg_dq_wr_train_auto:1;
            uint32_t reg_dq_wr_train_en:1;
            uint32_t reg_wr_train_freq_update:1;
            uint32_t reg_wr_train_dqs_range_bypass:1;
            uint32_t reg_wr_train_dqs_default_bypass:1;
            uint32_t reg_wr_train_rst:1;
            uint32_t reg_wrtrain_cs_sel:2;
            uint32_t reg_wrtrain_check_data_value_random_gen:1;
            uint32_t reg_dqs_wr_train_en:1;
            uint32_t rsvd_10:6;
            uint32_t reg_pbit_deskew_offset_for_lpddr4:6;
            uint32_t reg_wrtrain_lpddr4_vref_range:1;
        } reg_0xa0;
        uint32_t reg_0xa0_W;
    };

    union {
        struct {
            uint32_t reg_wr_train_row_addr:16;
            uint32_t reg_wr_train_col_addr:10;
            uint32_t rsvd_26:2;
            uint32_t reg_wr_train_ba_addr:3;
        } reg_0xa4;
        uint32_t reg_0xa4_W;
    };

    union {
        struct {
            uint32_t reg_phy_refresh_en:1;
            uint32_t rsvd_1:3;
            uint32_t reg_max_refi_cnt:4;
            uint32_t reg_phy_trfc:10;
            uint32_t reg_phy_trefi:14;
        } reg_0xa8;
        uint32_t reg_0xa8_W;
    };

    union {
        struct {
            uint32_t reg_lpddr4_write_postamble_sel:1;
            uint32_t reg_pllpd_bypass:1;
            uint32_t reg_pll_lock_bypass:1;
            uint32_t reg_all_freq_train_finish:1;
            uint32_t reg_freq_choose_bypass:1;
            uint32_t reg_data_path_clk_gate_dly_bp:1;
            uint32_t reg_data_path_clk_gate_dly :6;
            uint32_t reg_ddrphy_trp:8;
        } reg_0xac;
        uint32_t reg_0xac_W;
    };

    union {
        struct {
            uint32_t reg_rd_train_dq_scan_max:6;
            uint32_t rsvd_6:2;
            uint32_t reg_rd_train_dqs_scan_max:6;
            uint32_t rsvd_14:2;
            uint32_t reg_wl_dqs_start_point:6;
            uint32_t reg_wl_dqs_lock_point:6;
        } reg_0xb0;
        uint32_t reg_0xb0_W;
    };

    uint32_t rsvd_0xb4[0x3c/4];

    union {
        struct {
            uint32_t reg_cmd_abutslewpd_reg:5;
            uint32_t reg_cmd_abutweakpd_reg:1;
            uint32_t rsvd_6:2;
            uint32_t reg_cmd_abutslewpu_reg:5;
            uint32_t reg_cmd_abutweakpub_reg:1;
            uint32_t reg_cmd_fben_reg:1;
            uint32_t reg_cmd_fbsel_reg:1;
            uint32_t reg_cmd_drv_zqcalib_en:1;
        } reg_0xf0;
        uint32_t reg_0xf0_W;
    };

    union {
        struct {
            uint32_t reg_cmd_abutprcomp0_ck0_reg:1;
            uint32_t reg_cmd_abutprcomp1_ck0_reg:1;
            uint32_t reg_cmd_abutprcomp2_ck0_reg:1;
            uint32_t reg_cmd_abutprcomp3_ck0_reg:1;
            uint32_t reg_cmd_abutprcomp4_ck0_reg:1;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd_abutnrcomp0_ck0_reg:1;
            uint32_t reg_cmd_abutnrcomp1_ck0_reg:1;
            uint32_t reg_cmd_abutnrcomp2_ck0_reg:1;
            uint32_t reg_cmd_abutnrcomp3_ck0_reg:1;
            uint32_t reg_cmd_abutnrcomp4_ck0_reg:1;
            uint32_t rsvd_13:3;
            uint32_t reg_cmd_abutprcomp0_reg:1;
            uint32_t reg_cmd_abutprcomp1_reg:1;
            uint32_t reg_cmd_abutprcomp2_reg:1;
            uint32_t reg_cmd_abutprcomp3_reg:1;
            uint32_t reg_cmd_abutprcomp4_reg:1;
            uint32_t rsvd_21:3;
            uint32_t reg_cmd_abutnrcomp0_reg:1;
            uint32_t reg_cmd_abutnrcomp1_reg:1;
            uint32_t reg_cmd_abutnrcomp2_reg:1;
            uint32_t reg_cmd_abutnrcomp3_reg:1;
            uint32_t reg_cmd_abutnrcomp4_reg:1;
        } reg_0xf4;
        uint32_t reg_0xf4_W;
    };

    union {
        struct {
            uint32_t reg_cmd_abutprcomp0_special_reg:1;
            uint32_t reg_cmd_abutprcomp1_special_reg:1;
            uint32_t reg_cmd_abutprcomp2_special_reg:1;
            uint32_t reg_cmd_abutprcomp3_special_reg:1;
            uint32_t reg_cmd_abutprcomp4_special_reg:1;
            uint32_t rsvd_5:3;
            uint32_t reg_cmd_abutnrcomp0_special_reg:1;
            uint32_t reg_cmd_abutnrcomp1_special_reg:1;
            uint32_t reg_cmd_abutnrcomp2_special_reg:1;
            uint32_t reg_cmd_abutnrcomp3_special_reg:1;
            uint32_t reg_cmd_abutnrcomp4_special_reg:1;
            uint32_t rsvd_13:3;
            uint32_t reg_ram_vref1_margsel_reg:8;
        } reg_0xf8;
        uint32_t reg_0xf8_W;
    };

    uint32_t rsvd_0xfc[0x8/4];

    union {
        struct {
            uint32_t reg_a3_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a2_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a1_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a0_invdelaysel_bp:6;
        } reg_0x104;
        uint32_t reg_0x104_W;
    };

    union {
        struct {
            uint32_t reg_a7_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a6_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a5_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a4_invdelaysel_bp:6;
        } reg_0x108;
        uint32_t reg_0x108_W;
    };

    union {
        struct {
            uint32_t reg_a11_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a10_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a9_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a8_invdelaysel_bp:6;
        } reg_0x10c;
        uint32_t reg_0x10c_W;
    };

    union {
        struct {
            uint32_t reg_a15_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_a14_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a13_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a12_invdelaysel_bp:6;
        } reg_0x110;
        uint32_t reg_0x110_W;
    };

    union {
        struct {
            uint32_t reg_ba1_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ba0_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_a17_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_a16_invdelaysel_bp:6;
        } reg_0x114;
        uint32_t reg_0x114_W;
    };

    union {
        struct {
            uint32_t reg_cke1_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_cke0_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_bg1_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_bg0_invdelaysel_bp:6;
        } reg_0x118;
        uint32_t reg_0x118_W;
    };

    union {
        struct {
            uint32_t reg_odt1_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_odt0_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ck_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ckb_invdelaysel_bp:6;
        } reg_0x11c;
        uint32_t reg_0x11c_W;
    };

    union {
        struct {
            uint32_t reg_actn_invdelaysel_bp:6;
            uint32_t rsvd_6:2;
            uint32_t reg_resetn_invdelaysel_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_csb1_invdelaysel_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_csb0_invdelaysel_bp:6;
        } reg_0x120;
        uint32_t reg_0x120_W;
    };

    uint32_t rsvd_0x124[0x2c/4];

    union {
        struct {
            uint32_t dq0_train_check_data_value3:8;
            uint32_t dq0_train_check_data_value2:8;
            uint32_t dq0_train_check_data_value1:8;
            uint32_t dq0_train_check_data_value0:8;
        } reg_0x150;
        uint32_t reg_0x150_W;
    };

    union {
        struct {
            uint32_t dq0_train_check_data_value7:8;
            uint32_t dq0_train_check_data_value6:8;
            uint32_t dq0_train_check_data_value5:8;
            uint32_t dq0_train_check_data_value4:8;
        } reg_0x154;
        uint32_t reg_0x154_W;
    };

    union {
        struct {
            uint32_t dq0_train_check_data_value9:8;
            uint32_t dq0_train_check_data_value8:8;
        } reg_0x158;
        uint32_t reg_0x158_W;
    };

    union {
        struct {
            uint32_t dq1_train_check_data_value3:8;
            uint32_t dq1_train_check_data_value2:8;
            uint32_t dq1_train_check_data_value1:8;
            uint32_t dq1_train_check_data_value0:8;
        } reg_0x15c;
        uint32_t reg_0x15c_W;
    };

    union {
        struct {
            uint32_t dq1_train_check_data_value7:8;
            uint32_t dq1_train_check_data_value6:8;
            uint32_t dq1_train_check_data_value5:8;
            uint32_t dq1_train_check_data_value4:8;
        } reg_0x160;
        uint32_t reg_0x160_W;
    };

    union {
        struct {
            uint32_t dq1_train_check_data_value9:8;
            uint32_t dq1_train_check_data_value8:8;
        } reg_0x164;
        uint32_t reg_0x164_W;
    };

    union {
        struct {
            uint32_t dq2_train_check_data_value3:8;
            uint32_t dq2_train_check_data_value2:8;
            uint32_t dq2_train_check_data_value1:8;
            uint32_t dq2_train_check_data_value0:8;
        } reg_0x168;
        uint32_t reg_0x168_W;
    };

    union {
        struct {
            uint32_t dq2_train_check_data_value7:8;
            uint32_t dq2_train_check_data_value6:8;
            uint32_t dq2_train_check_data_value5:8;
            uint32_t dq2_train_check_data_value4:8;
        } reg_0x16c;
        uint32_t reg_0x16c_W;
    };

    union {
        struct {
            uint32_t dq2_train_check_data_value9:8;
            uint32_t dq2_train_check_data_value8:8;
        } reg_0x170;
        uint32_t reg_0x170_W;
    };

    union {
        struct {
            uint32_t dq3_train_check_data_value3:8;
            uint32_t dq3_train_check_data_value2:8;
            uint32_t dq3_train_check_data_value1:8;
            uint32_t dq3_train_check_data_value0:8;
        } reg_0x174;
        uint32_t reg_0x174_W;
    };

    union {
        struct {
            uint32_t dq3_train_check_data_value7:8;
            uint32_t dq3_train_check_data_value6:8;
            uint32_t dq3_train_check_data_value5:8;
            uint32_t dq3_train_check_data_value4:8;
        } reg_0x178;
        uint32_t reg_0x178_W;
    };

    union {
        struct {
            uint32_t dq3_train_check_data_value9:8;
            uint32_t dq3_train_check_data_value8:8;
        } reg_0x17c;
        uint32_t reg_0x17c_W;
    };

    union {
        struct {
            uint32_t dq4_train_check_data_value3:8;
            uint32_t dq4_train_check_data_value2:8;
            uint32_t dq4_train_check_data_value1:8;
            uint32_t dq4_train_check_data_value0:8;
        } reg_0x180;
        uint32_t reg_0x180_W;
    };

    union {
        struct {
            uint32_t dq4_train_check_data_value7:8;
            uint32_t dq4_train_check_data_value6:8;
            uint32_t dq4_train_check_data_value5:8;
            uint32_t dq4_train_check_data_value4:8;
        } reg_0x184;
        uint32_t reg_0x184_W;
    };

    union {
        struct {
            uint32_t dq4_train_check_data_value9:8;
            uint32_t dq4_train_check_data_value8:8;
        } reg_0x188;
        uint32_t reg_0x188_W;
    };

    union {
        struct {
            uint32_t dq5_train_check_data_value3:8;
            uint32_t dq5_train_check_data_value2:8;
            uint32_t dq5_train_check_data_value1:8;
            uint32_t dq5_train_check_data_value0:8;
        } reg_0x18c;
        uint32_t reg_0x18c_W;
    };

    union {
        struct {
            uint32_t dq5_train_check_data_value7:8;
            uint32_t dq5_train_check_data_value6:8;
            uint32_t dq5_train_check_data_value5:8;
            uint32_t dq5_train_check_data_value4:8;
        } reg_0x190;
        uint32_t reg_0x190_W;
    };

    union {
        struct {
            uint32_t dq5_train_check_data_value9:8;
            uint32_t dq5_train_check_data_value8:8;
        } reg_0x194;
        uint32_t reg_0x194_W;
    };

    union {
        struct {
            uint32_t dq6_train_check_data_value3:8;
            uint32_t dq6_train_check_data_value2:8;
            uint32_t dq6_train_check_data_value1:8;
            uint32_t dq6_train_check_data_value0:8;
        } reg_0x198;
        uint32_t reg_0x198_W;
    };

    union {
        struct {
            uint32_t dq6_train_check_data_value7:8;
            uint32_t dq6_train_check_data_value6:8;
            uint32_t dq6_train_check_data_value5:8;
            uint32_t dq6_train_check_data_value4:8;
        } reg_0x19c;
        uint32_t reg_0x19c_W;
    };

    union {
        struct {
            uint32_t dq6_train_check_data_value9:8;
            uint32_t dq6_train_check_data_value8:8;
        } reg_0x1a0;
        uint32_t reg_0x1a0_W;
    };

    union {
        struct {
            uint32_t dq7_train_check_data_value3:8;
            uint32_t dq7_train_check_data_value2:8;
            uint32_t dq7_train_check_data_value1:8;
            uint32_t dq7_train_check_data_value0:8;
        } reg_0x1a4;
        uint32_t reg_0x1a4_W;
    };

    union {
        struct {
            uint32_t dq7_train_check_data_value7:8;
            uint32_t dq7_train_check_data_value6:8;
            uint32_t dq7_train_check_data_value5:8;
            uint32_t dq7_train_check_data_value4:8;
        } reg_0x1a8;
        uint32_t reg_0x1a8_W;
    };

    union {
        struct {
            uint32_t dq7_train_check_data_value9:8;
            uint32_t dq7_train_check_data_value8:8;
            uint32_t reg_wrtrain_odt_keep:3;
            uint32_t reg_wrtrain_odt_advance:1;
        } reg_0x1ac;
        uint32_t reg_0x1ac_W;
    };

    union {
        struct {
            uint32_t reg_rdtrain_wait_vref_valid_cnt:10;
            uint32_t reg_cmd_invdelaysel_sel:6;
            uint32_t reg_train_vref_step_max:5;
            uint32_t reg_train_vref_step_min:3;
            uint32_t reg_wrtrain_vref_wait_vref_cnt_50ns:8;
        } reg_0x1b0;
        uint32_t reg_0x1b0_W;
    };

    uint32_t rsvd_0x1b4[0x3c/4];

    union {
        struct {
            uint32_t train_true_done:1;
            uint32_t train_step3_error:1;
            uint32_t train_step2_error:1;
            uint32_t train_step1_error:1;
            uint32_t train_step3_delay_done:1;
            uint32_t train_step2_vref_done:1;
            uint32_t train_step1_delay_done:1;
            uint32_t train_all_step_done:1;
        } reg_0x1f0;
        uint32_t reg_0x1f0_W;
    };

    union {
        struct {
            uint32_t lock_pll_dqcmd:1;
            uint32_t lock_mpll:1;
            uint32_t pwrokcore:1;
            uint32_t pwrok_reg_po:1;
            uint32_t user_load_mode_busy:1;
        } reg_0x1f4;
        uint32_t reg_0x1f4_W;
    };

    union {
        struct {
            uint32_t odtlegpb_zqcali_2reg:5;
            uint32_t rsvd_5:3;
            uint32_t odtlegn_zqcali_2reg:5;
            uint32_t rsvd_13:3;
            uint32_t drvlegpb_zqcali_2reg:5;
            uint32_t rsvd_21:3;
            uint32_t drvlegn_zqcali_2reg:5;
        } reg_0x1f8;
        uint32_t reg_0x1f8_W;
    };

    union {
        struct {
            uint32_t reg_odtpu_overflow:1;
            uint32_t reg_odtpd_overflow:1;
            uint32_t reg_drvpu_overflow:1;
            uint32_t reg_drvpd_overflow:1;
            uint32_t reg_zqcali_done:1;
            uint32_t rsvd_5:3;
            uint32_t reg_x1clk_ndiv_cnt:11;
        } reg_0x1fc;
        uint32_t reg_0x1fc_W;
    };

    union {
        struct {
            uint32_t bist_complete:1;
            uint32_t dq_error_flag:1;
            uint32_t dm_error_flag:1;
            uint32_t cmd_error_flag:1;
        } reg_0x200;
        uint32_t reg_0x200_W;
    };

    union {
        struct {
            uint32_t bist_error_dq:32;
        } reg_0x204;
        uint32_t reg_0x204_W;
    };

    union {
        struct {
            uint32_t bist_error_cmd:28;
            uint32_t bist_error_dm:4;
        } reg_0x208;
        uint32_t reg_0x208_W;
    };

    union {
        struct {
            uint32_t calib_done_byte:4;
            uint32_t calib_error:1;
            uint32_t calib_end:1;
            uint32_t rsvd_6:2;
            uint32_t wl_done_byte:4;
        } reg_0x20c;
        uint32_t reg_0x20c_W;
    };

    union {
        struct {
            uint32_t ca_check_value:12;
            uint32_t chb_rank_cat_bp_done:2;
            uint32_t cha_rank_cat_bp_done:2;
            uint32_t chb_rank_cat_bp_cmd_send_rdy:2;
            uint32_t cha_rank_cat_bp_cmd_send_rdy:2;
        } reg_0x210;
        uint32_t reg_0x210_W;
    };

    union {
        struct {
            uint32_t chb_cat_bp_cmd_send_done:1;
            uint32_t cha_cat_bp_cmd_send_done:1;
            uint32_t chb_cat_done:1;
            uint32_t cha_cat_done:1;
            uint32_t rsvd_4:4;
            uint32_t chb_cat_auto_cs_train_err:8;
            uint32_t cha_cat_auto_cs_train_err:8;
        } reg_0x214;
        uint32_t reg_0x214_W;
    };

    uint32_t rsvd_0x218[0x18/4];

    union {
        struct {
            uint32_t reg_wrtrain_vref_min_value:6;
            uint32_t rsvd_6:2;
            uint32_t reg_wrtrain_vref_max_value:6;
            uint32_t rsvd_14:2;
            uint32_t reg_cmd_invdelaysel:6;
        } reg_0x230;
        uint32_t reg_0x230_W;
    };

    union {
        struct {
            uint32_t cha_rank0_ca3_min_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank0_ca2_min_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank0_ca1_min_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank0_ca0_min_perbit_skew_pass:6;
        } reg_0x234;
        uint32_t reg_0x234_W;
    };

    union {
        struct {
            uint32_t cha_rank1_ca1_min_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank1_ca0_min_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank0_ca5_min_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank0_ca4_min_perbit_skew_pass:6;
        } reg_0x238;
        uint32_t reg_0x238_W;
    };

    union {
        struct {
            uint32_t cha_rank1_ca5_min_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank1_ca4_min_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank1_ca3_min_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank1_ca2_min_perbit_skew_pass:6;
        } reg_0x23c;
        uint32_t reg_0x23c_W;
    };

    union {
        struct {
            uint32_t cha_rank1_max_cs_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank0_max_cs_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank1_min_cs_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank0_min_cs_perbit_skew_pass:6;
        } reg_0x240;
        uint32_t reg_0x240_W;
    };

    union {
        struct {
            uint32_t cha_rank0_ca3_max_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank0_ca2_max_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank0_ca1_max_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank0_ca0_max_perbit_skew_pass:6;
        } reg_0x244;
        uint32_t reg_0x244_W;
    };

    union {
        struct {
            uint32_t cha_rank1_ca1_max_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank1_ca0_max_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank0_ca5_max_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank0_ca4_max_perbit_skew_pass:6;
        } reg_0x248;
        uint32_t reg_0x248_W;
    };

    union {
        struct {
            uint32_t cha_rank1_ca5_max_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank1_ca4_max_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank1_ca3_max_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank1_ca2_max_perbit_skew_pass:6;
        } reg_0x24c;
        uint32_t reg_0x24c_W;
    };

    union {
        struct {
            uint32_t chb_rank0_ca3_min_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank0_ca2_min_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank0_ca1_min_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank0_ca0_min_perbit_skew_pass:6;
        } reg_0x250;
        uint32_t reg_0x250_W;
    };

    union {
        struct {
            uint32_t chb_rank1_ca1_min_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank1_ca0_min_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank0_ca5_min_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank0_ca4_min_perbit_skew_pass:6;
        } reg_0x254;
        uint32_t reg_0x254_W;
    };

    union {
        struct {
            uint32_t chb_rank1_ca5_min_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank1_ca4_min_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank1_ca3_min_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank1_ca2_min_perbit_skew_pass:6;
        } reg_0x258;
        uint32_t reg_0x258_W;
    };

    union {
        struct {
            uint32_t chb_rank1_max_cs_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank0_max_cs_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank1_min_cs_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank0_min_cs_perbit_skew_pass:6;
        } reg_0x25c;
        uint32_t reg_0x25c_W;
    };

    union {
        struct {
            uint32_t chb_rank0_ca3_max_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank0_ca2_max_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank0_ca1_max_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank0_ca0_max_perbit_skew_pass:6;
        } reg_0x260;
        uint32_t reg_0x260_W;
    };

    union {
        struct {
            uint32_t chb_rank1_ca1_max_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank1_ca0_max_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank0_ca5_max_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank0_ca4_max_perbit_skew_pass:6;
        } reg_0x264;
        uint32_t reg_0x264_W;
    };

    union {
        struct {
            uint32_t chb_rank1_ca5_max_perbit_skew_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank1_ca4_max_perbit_skew_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank1_ca3_max_perbit_skew_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank1_ca2_max_perbit_skew_pass:6;
        } reg_0x268;
        uint32_t reg_0x268_W;
    };

    union {
        struct {
            uint32_t cha_rank1_max_cs_vref_pass:6;
            uint32_t rsvd_6:2;
            uint32_t cha_rank1_min_cs_vref_pass:6;
            uint32_t rsvd_14:2;
            uint32_t cha_rank0_max_cs_vref_pass:6;
            uint32_t rsvd_22:2;
            uint32_t cha_rank0_min_cs_vref_pass:6;
        } reg_0x26c;
        uint32_t reg_0x26c_W;
    };

    union {
        struct {
            uint32_t chb_rank1_max_cs_vref_pass:6;
            uint32_t rsvd_6:2;
            uint32_t chb_rank1_min_cs_vref_pass:6;
            uint32_t rsvd_14:2;
            uint32_t chb_rank0_max_cs_vref_pass:6;
            uint32_t rsvd_22:2;
            uint32_t chb_rank0_min_cs_vref_pass:6;
        } reg_0x270;
        uint32_t reg_0x270_W;
    };

    union {
        struct {
            uint32_t reg_wr_train_error_byte:4;
            uint32_t reg_wr_train_done_byte:4;
            uint32_t reg_train_error_for_rd_byte:4;
            uint32_t reg_train_done_for_rd_to_reg:4;
            uint32_t reg_rd_train_readback_data_valid_byte:4;
        } reg_0x274;
        uint32_t reg_0x274_W;
    };

} INNO_DDR_PHY_Com_Register_Table_s;
#endif
