#ifndef RTC_Register_Table__H
#define RTC_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t Current_Counter_Value:32;
        } RTC_CCVR;
        uint32_t RTC_CCVR_W;
    };

    union {
        struct {
            uint32_t Counter_Match:32;
        } RTC_CMR;
        uint32_t RTC_CMR_W;
    };

    union {
        struct {
            uint32_t Counter_Load:32;
        } RTC_CLR;
        uint32_t RTC_CLR_W;
    };

    union {
        struct {
            uint32_t rtc_ien:1;
            uint32_t rtc_mask:1;
            uint32_t rtc_en:1;
            uint32_t rtc_wen:1;
            uint32_t rtc_psclr_en:1;
            uint32_t rtc_prot_level:3;
            uint32_t RSVD_CCR:24;
        } RTC_CCR;
        uint32_t RTC_CCR_W;
    };

    union {
        struct {
            uint32_t rtc_start:1;
            uint32_t RSVD_RTC_STAT:31;
        } RTC_STAT;
        uint32_t RTC_STAT_W;
    };

    union {
        struct {
            uint32_t rtc_start:1;
            uint32_t RSVD_RC_RSTAT:31;
        } RTC_RSTAT;
        uint32_t RTC_RSTAT_W;
    };

    union {
        struct {
            uint32_t rtc_eoi:1;
            uint32_t RSVD_RTC_EOI:31;
        } RTC_EOI;
        uint32_t RTC_EOI_W;
    };

    union {
        struct {
            uint32_t rtc_comp_version:32;
        } RTC_COMP_VERSION;
        uint32_t RTC_COMP_VERSION_W;
    };

    union {
        struct {
            uint32_t Counter_Prescaler_Value:16;
            uint32_t RSVD_CPSR:16;
        } RTC_CPSR;
        uint32_t RTC_CPSR_W;
    };

    union {
        struct {
            uint32_t Current_Prescaler_Counter_Value:16;
            uint32_t RSVD_CPCVR:16;
        } RTC_CPCVR;
        uint32_t RTC_CPCVR_W;
    };

} RTC_Register_Table_s;
#endif
