#ifndef TPGEN_Register_Table__H
#define TPGEN_Register_Table__H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t FRMH_SIZE_CCHG:13;
            uint32_t padding_15_to_13:3;
            uint32_t FRMV_SIZE_CCHG:12;
        } addr_0x00;
        uint32_t addr_0x00_W;
    };

    union {
        struct {
            uint32_t H_OFFSET_CCHG:4;
            uint32_t padding_15_to_4:12;
            uint32_t V_OFFSET_CCHG:7;
        } addr_0x04;
        uint32_t addr_0x04_W;
    };

    union {
        struct {
            uint32_t V_OFFSET2_CCHG:7;
        } addr_0x08;
        uint32_t addr_0x08_W;
    };

    union {
        struct {
            uint32_t TPH_SIZE_CCHG:12;
            uint32_t padding_15_to_12:4;
            uint32_t TPV_SIZE_CCHG:12;
        } addr_0x0C;
        uint32_t addr_0x0C_W;
    };

    union {
        struct {
            uint32_t GSH_SIZE_CCHG:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_SIZE_CCHG:11;
        } addr_0x10;
        uint32_t addr_0x10_W;
    };

    union {
        struct {
            uint32_t GSH_START_CCHG:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_START_CCHG:9;
        } addr_0x14;
        uint32_t addr_0x14_W;
    };

    union {
        struct {
            uint32_t CG_R_S_CCHG:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_R_E_CCHG:12;
        } addr_0x18;
        uint32_t addr_0x18_W;
    };

    union {
        struct {
            uint32_t CG_G_S_CCHG:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_G_E_CCHG:12;
        } addr_0x1C;
        uint32_t addr_0x1C_W;
    };

    union {
        struct {
            uint32_t CG_B_S_CCHG:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_B_E_CCHG:12;
        } addr_0x20;
        uint32_t addr_0x20_W;
    };

    union {
        struct {
            uint32_t PT_CCHG:2;
            uint32_t padding_15_to_2:14;
            uint32_t PH_CCHG:2;
        } addr_0x24;
        uint32_t addr_0x24_W;
    };

    union {
        struct {
            uint32_t ENABLE_CCHG:1;
        } addr_0x28;
        uint32_t addr_0x28_W;
    };

    uint8_t RSVD_002C[4];

    union {
        struct {
            uint32_t FRMH_SIZE_ISP:13;
            uint32_t padding_15_to_13:3;
            uint32_t FRMV_SIZE_ISP:12;
        } addr_0x30;
        uint32_t addr_0x30_W;
    };

    union {
        struct {
            uint32_t H_OFFSET_ISP:4;
            uint32_t padding_15_to_4:12;
            uint32_t V_OFFSET_ISP:7;
        } addr_0x34;
        uint32_t addr_0x34_W;
    };

    union {
        struct {
            uint32_t V_OFFSET2_ISP:7;
        } addr_0x38;
        uint32_t addr_0x38_W;
    };

    union {
        struct {
            uint32_t TPH_SIZE_ISP:12;
            uint32_t padding_15_to_12:4;
            uint32_t TPV_SIZE_ISP:12;
        } addr_0x3C;
        uint32_t addr_0x3C_W;
    };

    union {
        struct {
            uint32_t GSH_SIZE_ISP:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_SIZE_ISP:11;
        } addr_0x40;
        uint32_t addr_0x40_W;
    };

    union {
        struct {
            uint32_t GSH_START_ISP:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_START_ISP:9;
        } addr_0x44;
        uint32_t addr_0x44_W;
    };

    union {
        struct {
            uint32_t CG_R_S_ISP:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_R_E_ISP:12;
        } addr_0x48;
        uint32_t addr_0x48_W;
    };

    union {
        struct {
            uint32_t CG_G_S_ISP:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_G_E_ISP:12;
        } addr_0x4C;
        uint32_t addr_0x4C_W;
    };

    union {
        struct {
            uint32_t CG_B_S_ISP:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_B_E_ISP:12;
        } addr_0x50;
        uint32_t addr_0x50_W;
    };

    union {
        struct {
            uint32_t PT_ISP:2;
            uint32_t padding_15_to_2:14;
            uint32_t PH_ISP:2;
        } addr_0x54;
        uint32_t addr_0x54_W;
    };

    union {
        struct {
            uint32_t ENABLE_ISP:1;
        } addr_0x58;
        uint32_t addr_0x58_W;
    };

    uint8_t RSVD_005C[4];

    union {
        struct {
            uint32_t FRMH_SIZE_LISR:13;
            uint32_t padding_15_to_13:3;
            uint32_t FRMV_SIZE_LISR:12;
        } addr_0x60;
        uint32_t addr_0x60_W;
    };

    union {
        struct {
            uint32_t HSW_LISR:6;
            uint32_t padding_15_to_6:10;
            uint32_t VSW_LISR:4;
        } addr_0x64;
        uint32_t addr_0x64_W;
    };

    union {
        struct {
            uint32_t HFRBLK_LISR:8;
            uint32_t padding_15_to_8:8;
            uint32_t VFRBLK_LISR:7;
        } addr_0x68;
        uint32_t addr_0x68_W;
    };

    union {
        struct {
            uint32_t TPH_SIZE_LISR:12;
            uint32_t padding_15_to_12:4;
            uint32_t TPV_SIZE_LISR:12;
        } addr_0x6C;
        uint32_t addr_0x6C_W;
    };

    union {
        struct {
            uint32_t GSH_SIZE_LISR:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_SIZE_LISR:11;
        } addr_0x70;
        uint32_t addr_0x70_W;
    };

    union {
        struct {
            uint32_t GSH_START_LISR:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_START_LISR:9;
        } addr_0x74;
        uint32_t addr_0x74_W;
    };

    union {
        struct {
            uint32_t CG_R_S_LISR:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_R_E_LISR:12;
        } addr_0x78;
        uint32_t addr_0x78_W;
    };

    union {
        struct {
            uint32_t CG_G_S_LISR:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_G_E_LISR:12;
        } addr_0x7C;
        uint32_t addr_0x7C_W;
    };

    union {
        struct {
            uint32_t CG_B_S_LISR:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_B_E_LISR:12;
        } addr_0x80;
        uint32_t addr_0x80_W;
    };

    union {
        struct {
            uint32_t PT_LISR:2;
            uint32_t padding_15_to_2:14;
            uint32_t PH_LISR:2;
        } addr_0x84;
        uint32_t addr_0x84_W;
    };

    union {
        struct {
            uint32_t ENABLE_LISR:1;
        } addr_0x88;
        uint32_t addr_0x88_W;
    };

    uint8_t RSVD_008C[4];

    union {
        struct {
            uint32_t FRMH_SIZE_MIPITX:13;
            uint32_t padding_15_to_13:3;
            uint32_t FRMV_SIZE_MIPITX:12;
        } addr_0x90;
        uint32_t addr_0x90_W;
    };

    union {
        struct {
            uint32_t H_OFFSET_MIPITX:4;
            uint32_t padding_15_to_4:12;
            uint32_t V_OFFSET_MIPITX:7;
        } addr_0x94;
        uint32_t addr_0x94_W;
    };

    union {
        struct {
            uint32_t V_OFFSET2_MIPITX:7;
        } addr_0x98;
        uint32_t addr_0x98_W;
    };

    union {
        struct {
            uint32_t TPH_SIZE_MIPITX:12;
            uint32_t padding_15_to_12:4;
            uint32_t TPV_SIZE_MIPITX:12;
        } addr_0x9C;
        uint32_t addr_0x9C_W;
    };

    union {
        struct {
            uint32_t GSH_SIZE_MIPITX:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_SIZE_MIPITX:11;
        } addr_0xA0;
        uint32_t addr_0xA0_W;
    };

    union {
        struct {
            uint32_t GSH_START_MIPITX:8;
            uint32_t padding_15_to_8:8;
            uint32_t GSV_START_MIPITX:9;
        } addr_0xA4;
        uint32_t addr_0xA4_W;
    };

    union {
        struct {
            uint32_t CG_R_S_MIPITX:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_R_E_MIPITX:12;
        } addr_0xA8;
        uint32_t addr_0xA8_W;
    };

    union {
        struct {
            uint32_t CG_G_S_MIPITX:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_G_E_MIPITX:12;
        } addr_0xAC;
        uint32_t addr_0xAC_W;
    };

    union {
        struct {
            uint32_t CG_B_S_MIPITX:12;
            uint32_t padding_15_to_12:4;
            uint32_t CG_B_E_MIPITX:12;
        } addr_0xB0;
        uint32_t addr_0xB0_W;
    };

    union {
        struct {
            uint32_t PT_MIPITX:2;
            uint32_t padding_15_to_2:14;
            uint32_t PH_MIPITX:2;
        } addr_0xB4;
        uint32_t addr_0xB4_W;
    };

    union {
        struct {
            uint32_t ENABLE_MIPITX:1;
            uint32_t padding_15_to_1:15;
            uint32_t RGB_MIPITX:1;
        } addr_0xB8;
        uint32_t addr_0xB8_W;
    };

} TPGEN_Register_Table_s;
#ifdef __cplusplus
}
#endif

#endif /*TPGEN_Register_Table__H*/
