#ifndef UART_Register_Table__H
#define UART_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t THR:9;
            uint32_t RSVD_THR:23;
        } RBR_THR_DLL_a;
        struct {
            uint32_t DLL:8;
            uint32_t RSVD_DLL_31to8:24;
        } RBR_THR_DLL_b;
        struct {
            uint32_t RBR:9;
            uint32_t RSVD_RBR:23;
        } RBR_THR_DLL;
        uint32_t RBR_THR_DLL_W;
    };

    union {
        struct {
            uint32_t ERBFI:1;
            uint32_t ETBEI:1;
            uint32_t ELSI:1;
            uint32_t EDSSI:1;
            uint32_t ELCOLR:1;
            uint32_t RSVD_IER_6to5:2;
            uint32_t PTIME:1;
            uint32_t RSVD_IER_31to8:24;
        } IER_DLH_a;
        struct {
            uint32_t dlh:8;
            uint32_t RSVD_DLH:24;
        } IER_DLH;
        uint32_t IER_DLH_W;
    };

    union {
        struct {
            uint32_t IID:4;
            uint32_t RSVD_IIR_5to4:2;
            uint32_t FIFOSE:2;
            uint32_t RSVD_IIR_31to8:24;
        } IIR_FCR_a;
        struct {
            uint32_t FIFOE:1;
            uint32_t RFIFOR:1;
            uint32_t XFIFOR:1;
            uint32_t DMAM:1;
            uint32_t TET:2;
            uint32_t RT:2;
            uint32_t RSVD_FCR_31to8:24;
        } IIR_FCR;
        uint32_t IIR_FCR_W;
    };

    union {
        struct {
            uint32_t DLS:2;
            uint32_t STOP:1;
            uint32_t PEN:1;
            uint32_t EPS:1;
            uint32_t SP:1;
            uint32_t BC:1;
            uint32_t DLAB:1;
            uint32_t RSVD_LCR_31to8:24;
        } LCR;
        uint32_t LCR_W;
    };

    union {
        struct {
            uint32_t DTR:1;
            uint32_t RTS:1;
            uint32_t OUT1:1;
            uint32_t OUT2:1;
            uint32_t LoopBack:1;
            uint32_t AFCE:1;
            uint32_t SIRE:1;
            uint32_t RSVD_MCR_31to7:25;
        } MCR;
        uint32_t MCR_W;
    };

    union {
        struct {
            uint32_t DR:1;
            uint32_t OE:1;
            uint32_t PE:1;
            uint32_t FE:1;
            uint32_t BI:1;
            uint32_t THRE:1;
            uint32_t TEMT:1;
            uint32_t RFE:1;
            uint32_t ADDR_RCVD:1;
            uint32_t RSVD_LSR_31to9:23;
        } LSR;
        uint32_t LSR_W;
    };

    union {
        struct {
            uint32_t DCTS:1;
            uint32_t DDSR:1;
            uint32_t TERI:1;
            uint32_t DDCD:1;
            uint32_t CTS:1;
            uint32_t DSR:1;
            uint32_t RI:1;
            uint32_t DCD:1;
            uint32_t RSVD_MSR_31to8:24;
        } MSR;
        uint32_t MSR_W;
    };

    union {
        struct {
            uint32_t SCR:8;
            uint32_t RSVD_SCR_31to8:24;
        } SCR;
        uint32_t SCR_W;
    };

    union {
        struct {
            uint32_t LPDLL:8;
            uint32_t RSVD_LPDLL_31to8:24;
        } LPDLL;
        uint32_t LPDLL_W;
    };

    union {
        struct {
            uint32_t LPDLH:8;
            uint32_t RSVD_LPDLH_31to8:24;
        } LPDLH;
        uint32_t LPDLH_W;
    };

    uint32_t rsvd_0x28[0x8/4];

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR0_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR0;
        uint32_t SRBR_STHR0_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR1_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR1;
        uint32_t SRBR_STHR1_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR2_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR2;
        uint32_t SRBR_STHR2_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR3_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR3;
        uint32_t SRBR_STHR3_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR4_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR4;
        uint32_t SRBR_STHR4_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR5_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR5;
        uint32_t SRBR_STHR5_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR6_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR6;
        uint32_t SRBR_STHR6_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR7_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR7;
        uint32_t SRBR_STHR7_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR8_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR8;
        uint32_t SRBR_STHR8_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR9_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR9;
        uint32_t SRBR_STHR9_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR10_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR10;
        uint32_t SRBR_STHR10_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR11_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR11;
        uint32_t SRBR_STHR11_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR12_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR12;
        uint32_t SRBR_STHR12_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR13_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR13;
        uint32_t SRBR_STHR13_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR14_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR14;
        uint32_t SRBR_STHR14_W;
    };

    union {
        struct {
            uint32_t STHRn:9;
            uint32_t RSVD_STHRn:23;
        } SRBR_STHR15_a;
        struct {
            uint32_t SRBRn:9;
            uint32_t RSVD_SRBRn:23;
        } SRBR_STHR15;
        uint32_t SRBR_STHR15_W;
    };

    union {
        struct {
            uint32_t FAR:1;
            uint32_t RSVD_FAR_31to1:31;
        } FIFOAR;
        uint32_t FIFOAR_W;
    };

    union {
        struct {
            uint32_t TFR:8;
            uint32_t RSVD_TFR_31to8:24;
        } TFR;
        uint32_t TFR_W;
    };

    union {
        struct {
            uint32_t RFWD:8;
            uint32_t RFPE:1;
            uint32_t RFFE:1;
            uint32_t RSVD_RFW_31to10:22;
        } RFW;
        uint32_t RFW_W;
    };

    union {
        struct {
            uint32_t BUSY:1;
            uint32_t TFNF:1;
            uint32_t TFE:1;
            uint32_t RFNE:1;
            uint32_t RFF:1;
            uint32_t RSVD_USR_31to5:27;
        } USR;
        uint32_t USR_W;
    };

    union {
        struct {
            uint32_t tfl:5;
            uint32_t RSVD_TFL_31toADDR_WIDTH:27;
        } TFL;
        uint32_t TFL_W;
    };

    union {
        struct {
            uint32_t rfl:5;
            uint32_t RSVD_RFL_31toADDR_WIDTH:27;
        } RFL;
        uint32_t RFL_W;
    };

    union {
        struct {
            uint32_t UR:1;
            uint32_t RFR:1;
            uint32_t XFR:1;
            uint32_t RSVD_SRR_31to3:29;
        } SRR;
        uint32_t SRR_W;
    };

    union {
        struct {
            uint32_t SRTS:1;
            uint32_t RSVD_SRTS_31to1:31;
        } SRTS;
        uint32_t SRTS_W;
    };

    union {
        struct {
            uint32_t SBCB:1;
            uint32_t RSVD_SBCR_31to1:31;
        } SBCR;
        uint32_t SBCR_W;
    };

    union {
        struct {
            uint32_t SDMAM:1;
            uint32_t RSVD_SDMAM_31to1:31;
        } SDMAM;
        uint32_t SDMAM_W;
    };

    union {
        struct {
            uint32_t SFE:1;
            uint32_t RSVD_SFE_31to1:31;
        } SFE;
        uint32_t SFE_W;
    };

    union {
        struct {
            uint32_t SRT:2;
            uint32_t RSVD_SRT_31to2:30;
        } SRT;
        uint32_t SRT_W;
    };

    union {
        struct {
            uint32_t STET:2;
            uint32_t RSVD_STET_31to2:30;
        } STET;
        uint32_t STET_W;
    };

    union {
        struct {
            uint32_t HTX:1;
            uint32_t RSVD_HTX_31to1:31;
        } HTX;
        uint32_t HTX_W;
    };

    union {
        struct {
            uint32_t DMASA:1;
            uint32_t RSVD_DMASA_31to1:31;
        } DMASA;
        uint32_t DMASA_W;
    };

    union {
        struct {
            uint32_t RS485_EN:1;
            uint32_t RE_POL:1;
            uint32_t DE_POL:1;
            uint32_t XFER_MODE:2;
            uint32_t RSVD_TCR_31to5:27;
        } TCR;
        uint32_t TCR_W;
    };

    union {
        struct {
            uint32_t DE_Enable:1;
            uint32_t RSVD_DE_EN_31to1:31;
        } DE_EN;
        uint32_t DE_EN_W;
    };

    union {
        struct {
            uint32_t RE_Enable:1;
            uint32_t RSVD_RE_EN_31to1:31;
        } RE_EN;
        uint32_t RE_EN_W;
    };

    union {
        struct {
            uint32_t DE_Assertion_Time:8;
            uint32_t RSVD_DE_AT_15to8:8;
            uint32_t DE_Deassertion_Time:1;
            uint32_t rsvd_17:7;
            uint32_t RSVD_DE_DEAT_31to24:8;
        } DET;
        uint32_t DET_W;
    };

    union {
        struct {
            uint32_t DE_to_RE:16;
            uint32_t RE_to_DE:16;
        } TAT;
        uint32_t TAT_W;
    };

    union {
        struct {
            uint32_t DLF:4;
            uint32_t RSVD_DLF:28;
        } DLF;
        uint32_t DLF_W;
    };

    union {
        struct {
            uint32_t RAR:8;
            uint32_t RSVD_RAR_31to8:24;
        } RAR;
        uint32_t RAR_W;
    };

    union {
        struct {
            uint32_t TAR:8;
            uint32_t RSVD_TAR_31to8:24;
        } TAR;
        uint32_t TAR_W;
    };

    union {
        struct {
            uint32_t DLS_E:1;
            uint32_t ADDR_MATCH:1;
            uint32_t SEND_ADDR:1;
            uint32_t TRANSMIT_MODE:1;
            uint32_t RSVD_LCR_EXT:28;
        } LCR_EXT;
        uint32_t LCR_EXT_W;
    };

    union {
        struct {
            uint32_t UART_PROT_LEVEL:3;
            uint32_t RSVD_UART_PROT_LEVEL:29;
        } UART_PROT_LEVEL;
        uint32_t UART_PROT_LEVEL_W;
    };

    union {
        struct {
            uint32_t RSVD_REG_TIMEOUT_RST:32;
        } REG_TIMEOUT_RST;
        uint32_t REG_TIMEOUT_RST_W;
    };

    uint32_t rsvd_0xd8[0x1c/4];

    union {
        struct {
            uint32_t APB_DATA_WIDTH:2;
            uint32_t RSVD_CPR_3to2:2;
            uint32_t AFCE_MODE:1;
            uint32_t THRE_MODE:1;
            uint32_t SIR_MODE:1;
            uint32_t SIR_LP_MODE:1;
            uint32_t ADDITIONAL_FEAT:1;
            uint32_t FIFO_ACCESS:1;
            uint32_t FIFO_STAT:1;
            uint32_t SHADOW:1;
            uint32_t UART_ADD_ENCODED_PARAMS:1;
            uint32_t DMA_EXTRA:1;
            uint32_t RSVD_CPR_15to14:2;
            uint32_t FIFO_MODE:8;
            uint32_t RSVD_CPR_31to24:8;
        } CPR;
        uint32_t CPR_W;
    };

    union {
        struct {
            uint32_t UART_Component_Version:32;
        } UCV;
        uint32_t UCV_W;
    };

    union {
        struct {
            uint32_t Peripheral_ID:32;
        } CTR;
        uint32_t CTR_W;
    };

} UART_Register_Table_s;
#endif
