/*
 *-----------------------------------------------------------------------------
 * The confidential and proprietary information contained in this file may
 * only be used by a person authorised under and to the extent permitted
 * by a subsisting licensing agreement from ARM Limited.
 *
 *            (C) COPYRIGHT 2010-2017  ARM Limited.
 *                ALL RIGHTS RESERVED
 *
 * This entire notice must be reproduced on all copies of this file
 * and copies of this file may only be made by a person if such person is
 * permitted to do so under the terms of a subsisting license agreement
 * from ARM Limited.
 *
 *      SVN Information
 *
 *      Checked In          : $Date: 2012-05-28 18:02:02 +0100 (Mon, 28 May 2012) $
 *
 *      Revision            : $Revision: 366156 $
 *
 *      Release Information : SSE050-r0p1-00rel0
 *-----------------------------------------------------------------------------
 */
/*************************************************************************//**
 * @file     SSE050_driver.h
 * @brief    SSE050 Driver Header File
 * @version  $State:$
 * @date     $Date: 2012-05-28 18:02:02 +0100 (Mon, 28 May 2012) $
 *
 ******************************************************************************/


/** @addtogroup CMSIS_SSE050_Driver_definitions SSE050 Driver definitions
  This file defines all SSE050 Driver functions for CMSIS core for the following modules:
    - Timer
    - UART
    - GPIO
    - I2S
    - I2C
  @{
 */

 #include "SSE050.h"


 /*UART Driver Declarations*/

  /**
   * @brief Initializes UART module.
   */

 extern uint32_t SSE050_uart_init(SSE050_UART_TypeDef *SSE050_UART, uint32_t divider, uint32_t tx_en,
                           uint32_t rx_en, uint32_t tx_irq_en, uint32_t rx_irq_en, uint32_t tx_ovrirq_en, uint32_t rx_ovrirq_en);

  /**
   * @brief Returns whether the UART RX Buffer is Full.
   */

 extern uint32_t SSE050_uart_GetRxBufferFull(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Returns whether the UART TX Buffer is Full.
   */

 extern uint32_t SSE050_uart_GetTxBufferFull(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Sends a character to the UART TX Buffer.
   */


 extern void SSE050_uart_SendChar(SSE050_UART_TypeDef *SSE050_UART, char txchar);

  /**
   * @brief Receives a character from the UART RX Buffer.
   */

 extern char SSE050_uart_ReceiveChar(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Returns UART Overrun status.
   */

 extern uint32_t SSE050_uart_GetOverrunStatus(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Clears UART Overrun status Returns new UART Overrun status.
   */

 extern uint32_t SSE050_uart_ClearOverrunStatus(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Returns UART Baud rate Divider value.
   */

 extern uint32_t SSE050_uart_GetBaudDivider(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Return UART TX Interrupt Status.
   */

 extern uint32_t SSE050_uart_GetTxIRQStatus(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Return UART RX Interrupt Status.
   */

 extern uint32_t SSE050_uart_GetRxIRQStatus(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Clear UART TX Interrupt request.
   */

 extern void SSE050_uart_ClearTxIRQ(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Clear UART RX Interrupt request.
   */

 extern void SSE050_uart_ClearRxIRQ(SSE050_UART_TypeDef *SSE050_UART);

  /**
   * @brief Set SSE050 Timer for multi-shoot mode with internal clock
   */

 /*Timer Driver Declarations*/

 extern void SSE050_timer_Init_IntClock(SSE050_TIMER_TypeDef *SSE050_TIMER, uint32_t reload,
 uint32_t irq_en);

  /**
   * @brief Set SSE050 Timer for multi-shoot mode with external enable
   */

 extern void SSE050_timer_Init_ExtClock(SSE050_TIMER_TypeDef *SSE050_TIMER, uint32_t reload,
 uint32_t irq_en);


  /**
   * @brief Set SSE050 Timer for multi-shoot mode with external clock
   */

 extern void SSE050_timer_Init_ExtEnable(SSE050_TIMER_TypeDef *SSE050_TIMER, uint32_t reload,
 uint32_t irq_en);

  /**
   * @brief SSE050 Timer interrupt clear
   */


 extern void SSE050_timer_ClearIRQ(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Returns timer IRQ status
   */

 uint32_t  SSE050_timer_StatusIRQ(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Returns Timer Reload value.
   */

 extern uint32_t SSE050_timer_GetReload(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Sets Timer Reload value.
   */

 extern void SSE050_timer_SetReload(SSE050_TIMER_TypeDef *SSE050_TIMER, uint32_t value);

  /**
   * @brief Returns Timer current value.
   */

 uint32_t SSE050_timer_GetValue(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Sets Timer current value.
   */

 extern void SSE050_timer_SetValue(SSE050_TIMER_TypeDef *SSE050_TIMER, uint32_t value);

  /**
   * @brief Stops SSE050 Timer.
   */

 extern void SSE050_timer_StopTimer(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Starts SSE050 Timer.
   */

 extern void SSE050_timer_StartTimer(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Enables SSE050 Timer Interrupt requests.
   */

 extern void SSE050_timer_EnableIRQ(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Disables SSE050 Timer Interrupt requests.
   */

 extern void SSE050_timer_DisableIRQ(SSE050_TIMER_TypeDef *SSE050_TIMER);

  /**
   * @brief Set SSE050 GPIO Output Enable.
   */

 /*GPIO Driver Declarations*/

 extern void SSE050_gpio_SetOutEnable(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t outenableset);

  /**
   * @brief Clear SSE050 GPIO Output Enable.
   */

 extern void SSE050_gpio_ClrOutEnable(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t outenableclr);

  /**
   * @brief Returns SSE050 GPIO Output Enable.
   */

 extern uint32_t SSE050_gpio_GetOutEnable(SSE050_GPIO_TypeDef *SSE050_GPIO);

  /**
   * @brief Set SSE050 GPIO Alternate function Enable.
   */

 extern void SSE050_gpio_SetAltFunc(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t AltFuncset);

  /**
   * @brief Clear SSE050 GPIO Alternate function Enable.
   */

 extern void SSE050_gpio_ClrAltFunc(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t AltFuncclr);

  /**
   * @brief Returns SSE050 GPIO Alternate function Enable.
   */

 extern uint32_t SSE050_gpio_GetAltFunc(SSE050_GPIO_TypeDef *SSE050_GPIO);

  /**
   * @brief Clear SSE050 GPIO Interrupt request.
   */

 extern uint32_t SSE050_gpio_IntClear(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t Num);

  /**
   * @brief Enable SSE050 GPIO Interrupt request.
   */

 extern uint32_t SSE050_gpio_SetIntEnable(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t Num);

  /**
   * @brief Disable SSE050 GPIO Interrupt request.
   */

 extern uint32_t SSE050_gpio_ClrIntEnable(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t Num);

  /**
   * @brief Setup SSE050 GPIO Interrupt as high level.
   */

 extern void SSE050_gpio_SetIntHighLevel(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t Num);

   /**
   * @brief Setup SSE050 GPIO Interrupt as rising edge.
   */

 extern void SSE050_gpio_SetIntRisingEdge(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t Num);

     /**
   * @brief Setup SSE050 GPIO Interrupt as low level.
   */

 extern void SSE050_gpio_SetIntLowLevel(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t Num);

    /**
   * @brief Setup SSE050 GPIO Interrupt as falling edge.
   */

 extern void SSE050_gpio_SetIntFallingEdge(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t Num);

    /**
   * @brief Setup SSE050 GPIO output value using Masked access.
   */

 extern void SSE050_gpio_MaskedWrite(SSE050_GPIO_TypeDef *SSE050_GPIO, uint32_t value, uint32_t mask);

    /**
   * @brief Setup SSE050 I2S Configuration.
   */

 extern int SSE050_i2s_config(SSE050_I2S_TypeDef *pI2S, uint32_t tx_enable, uint32_t tx_int_enable, uint32_t tx_waterlevel,
                       uint32_t rx_enable, uint32_t rx_int_enable, uint32_t rx_waterlevel);

    /**
   * @brief Setup SSE050 I2S Configuration.
   */

 extern int SSE050_i2s_tx_fifo_empty(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Returns I2S TX buffer empty.
   */

 extern int SSE050_i2s_tx_fifo_full(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Returns I2S TX buffer full.
   */

 extern int SSE050_i2s_rx_fifo_empty(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Returns I2S RX buffer empty.
   */

 extern int SSE050_i2s_rx_fifo_full(SSE050_I2S_TypeDef * pI2S);
    /**
   * @brief Returns I2S RX buffer full.
   */

 extern int SSE050_i2s_rx_irq_alert(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Returns I2S RX buffer alert.
   */

 extern int SSE050_i2s_tx_irq_alert(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Returns I2S TX buffer alert.
   */

 extern int SSE050_i2s_tx_stop(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Disable I2S TX.
   */

 extern int SSE050_i2s_rx_stop(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Disable I2S RX.
   */

 extern int SSE050_i2s_get_tx_error(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Returns I2S TX error status.
   */

 extern int SSE050_i2s_get_rx_error(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Returns I2S RX error status.
   */

 extern void i2s_clear_tx_error(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Clear I2S TX error status.
   */

 extern void i2s_clear_rx_error(SSE050_I2S_TypeDef * pI2S);

    /**
   * @brief Clear I2S RX error status.
   */

 extern void i2s_fifo_reset(SSE050_I2S_TypeDef *pI2S);

    /**
   * @brief I2S buffer reset.
   */

 extern void i2s_codec_reset(SSE050_I2S_TypeDef *pI2S);

    /**
   * @brief I2S codec reset.
   */

 extern int SSE050_i2s_speed_config(SSE050_I2S_TypeDef *pI2S, uint32_t divide_ratio);

    /**
   * @brief Setups I2S divide ratio for left/right clock.
   */

 void SSE050_i2c_send_byte(unsigned char c);

    /**
   * @brief Write 8 bits of data to the serial bus.
   */

 unsigned char SSE050_i2c_receive_byte(void);

    /**
   * @brief Read 8 bits of data from the serial bus.
   */

 int SSE050_i2c_receive_ack(void);

    /**
   * @brief Read the acknowledge bit from the serial bus.
   */

 void SSE050_i2c_send_ack(void);

    /**
   * @brief  Write the acknowledge bit to the serial bus.
   */

 unsigned char SSE050_i2c_read(unsigned char reg_addr, unsigned char sadr);

    /**
   * @brief Write data stream and read one byte from the serial bus.
   */


 void SSE050_i2c_write(unsigned char reg_addr, unsigned char data_byte, unsigned char sadr);

    /**
   * @brief Write data stream and write one byte from the serial bus.
   */

  /*@}*/ /* end of group CMSIS_SSE050_Driver_definitions SSE050 Driver definitions */

