//***********************************************************************************************//
// Description:
//             ddr basic testcase : write data to ddr and read them out to verify ddr access. 
//                                  with switched clock -- rcc setting first.
//                                  Equals to case "cb00_rcc_basic" + case "ca00_ddr_basic".
//                                  ddr 0 and ddr 1 access interleaved.
//***********************************************************************************************//

#include "lisoc_test.h"
#include "ddr_test.h"
#include "ddr4.h"
#include "rcc.h"
#include "uart.h"

#define DDR1_CTL_BASE_ADDR     0x40040000
#define DDR0_CTL_BASE_ADDR     0x40030000
#define DDR1_PHY_BASE_ADDR     0x40020000
#define DDR0_PHY_BASE_ADDR     0x40010000
#define DDR0_DAT_BASE_ADDR     0x60000000
#define DDR1_DAT_BASE_ADDR     0x80000000

#define ctl0_phy_init_complete   (DDR0_CTL_BASE_ADDR + 0x2c4)
#define ctl0_sdram_init_done     (DDR0_CTL_BASE_ADDR + 0x2c4)
#define phy0_calib_end           (DDR0_PHY_BASE_ADDR + 0x20c)
#define phy0_calib_done_byte     (DDR0_PHY_BASE_ADDR + 0x20c)
#define ctl1_phy_init_complete   (DDR1_CTL_BASE_ADDR + 0x2c4)
#define ctl1_sdram_init_done     (DDR1_CTL_BASE_ADDR + 0x2c4)
#define phy1_calib_end           (DDR1_PHY_BASE_ADDR + 0x20c)
#define phy1_calib_done_byte     (DDR1_PHY_BASE_ADDR + 0x20c)

uint32_t r_ddr[128];
uint32_t r1_ddr[128];

uint32_t w_ddr[4] = {
  0x12345678,0x5a5a5a5a,0x55555555,0xa5a5a5a5
};

void ddr_wr_test(uint32_t ddr_data_base,uint32_t size,uint32_t offset)
{
  uint32_t* ddr = (uint32_t*)ddr_data_base;
  uint32_t i;
  uint8_t result = SUCCESS;


  for(i = 0; i < size/4; i++) {
    ddr[i + offset]      = w_ddr[0];
    //delay_us(1);
  }

  for(i = 0; i < size/4; i++) {
    r_ddr[i] = ddr[i + offset];
    //delay_us(1);
    if(r_ddr[i] != w_ddr[0]) result = FAILURE;
  }
  #if 0
  for(i = 0; i < size/4; i++) {
    if(i % 4 == 0)
      printf("%08x:",ddr_data_base + offset + i*4);
    printf(" %08x ",r_ddr[i]);
    if(i % 4 == 3)
      printf("\n");
  }
  #endif
  if(result == SUCCESS){
    if(ddr_data_base == DDR0_DAT_BASE_ADDR)
      printf("DDR0 test \t\t\t\t\tOK.\n");
    else
      printf("DDR1 test \t\t\t\t\tOK.\n");
  }else{
    if(ddr_data_base == DDR0_DAT_BASE_ADDR)
      printf("DDR0 test \t\t\t\t\tNG.\n");
    else
      printf("DDR1 test \t\t\t\t\tNG.\n");
  }
}

void ddr_init(void)
{
#ifdef CFG_SIM
  init_ddr_sim(DDR0_CTL_BASE_ADDR, DDR0_PHY_BASE_ADDR);
  //printf("ddr0 init complete\n");
  
  // 1.2 ddr1 initial
  init_ddr_sim(DDR1_CTL_BASE_ADDR, DDR1_PHY_BASE_ADDR);

#else
  // 1. ddr0 and ddr1 initial
  // 1.1 ddr0 initial
  init_ddr(DDR0_CTL_BASE_ADDR, DDR0_PHY_BASE_ADDR);
  //printf("ddr0 init complete\n");
  
  // 1.2 ddr1 initial
  init_ddr(DDR1_CTL_BASE_ADDR, DDR1_PHY_BASE_ADDR);
  //printf("ddr1 init complete\n");
#endif
}
void ddr_test(void)
{
  #if 0
  int i;
  //printf("ddr test start\n");
  ddr_wr_test(DDR1_DAT_BASE_ADDR,0x100,0);
  ddr_wr_test(DDR0_DAT_BASE_ADDR,0x100,0);
  //printf("ddr test end\n");
  #else

  #if 0
  int i;

  uint32_t* ddr1 = (uint32_t*)DDR1_DAT_BASE_ADDR;
  uint32_t* ddr0 = (uint32_t*)DDR0_DAT_BASE_ADDR;

    ddr0[0] = 0x11111111;
    ddr0[1] = 0x22222222;
    ddr0[2] = 0x33333333;
    ddr0[3] = 0x44444444;
    ddr0[4] = 0x55555555;
    ddr0[5] = 0x66666666;
    ddr0[6] = 0x77777777;
    ddr0[7] = 0x88888888;
    ddr0[8] = 0x99999999;
    ddr0[9] = 0x00000000;
  
  
   // printf("%08x,%08x,%08x,%08x,%08x\n",ddr0[0],ddr0[1],ddr0[2],ddr0[3],ddr0[4]);
  
    r_ddr[0] = ddr0[0];
    r_ddr[1] = ddr0[1];
    r_ddr[2] = ddr0[2];
    r_ddr[3] = ddr0[3];
    r_ddr[4] = ddr0[4];
    r_ddr[5] = ddr0[5];
    r_ddr[6] = ddr0[6];
    r_ddr[7] = ddr0[7];
    r_ddr[8] = ddr0[8];
    r_ddr[9] = ddr0[9];
  
  
    r1_ddr[0] = r_ddr[0];
    r1_ddr[1] = r_ddr[1];
    r1_ddr[2] = r_ddr[2];
    r1_ddr[3] = r_ddr[3];
    r1_ddr[4] = r_ddr[4];
    r1_ddr[5] = r_ddr[5];
    r1_ddr[6] = r_ddr[6];
    r1_ddr[7] = r_ddr[7];
    r1_ddr[8] = r_ddr[8];
    r1_ddr[9] = r_ddr[9];

    #if 0
    reg32_wr(0x400f0010,0x3e);
    for(i = 0;i < 10;i++)
      reg32_wr(0x40000000,r1_ddr[i]);
    reg32_wr(0x400f0010,0x3f);
    #endif
    
    r_ddr[0] = ddr0[0];
    r_ddr[1] = ddr0[1];
    r_ddr[2] = ddr0[2];
    r_ddr[3] = ddr0[3];
    r_ddr[4] = ddr0[4];
    r_ddr[5] = ddr0[5];
    r_ddr[6] = ddr0[6];
    r_ddr[7] = ddr0[7];
    r_ddr[8] = ddr0[8];
    r_ddr[9] = ddr0[9];

  
    printf("%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x\n",r1_ddr[0],r1_ddr[1],r1_ddr[2],r1_ddr[3],r1_ddr[4],r1_ddr[5],r1_ddr[6],r1_ddr[7],r1_ddr[8],r1_ddr[9]);
    printf("%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x\n",r_ddr[0],r_ddr[1],r_ddr[2],r_ddr[3],r_ddr[4],r_ddr[5],r_ddr[6],r_ddr[7],r_ddr[8],r_ddr[9]);
#endif
#if 0
  int i = 0;
  while(i < 50*4){
    reg32_wr(0x60000000 + i, i);
    i += 4;
    delay_us(1);
  }
  printf("write finish.\n");
  for(i = 0;i < 50;i++){
    r_ddr[i] = reg32(0x60000000 + i*4);
    if(i % 3 ==0)
    delay_us(1);
  }

  for(i = 0;i < 50;i++){
    printf("%08x ",r_ddr[i]);
    if(i % 10 == 9)
      printf("\n");
  }
  
#endif

#if 1
#if 0
  reg32_wr(0x60000000,0x11111111);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x100,0x22222222);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x200,0x33333333);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x300,0x44444444);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x400,0x55555555);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x500,0x66666666);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x600,0x77777777);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x700,0x88888888);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x800,0x99999999);
  //delay_us(1);
  reg32_wr(0x60000000 + 0x900,0x00000000);
  //delay_us(1);

#endif
    r_ddr[0] = reg32(0x60000000);
    //delay_us(1);
    r_ddr[1] = reg32(0x60000000 + 0x4);
    //delay_us(1);
    r_ddr[2] = reg32(0x60000000 + 0x8);
    delay_us(1);
    r_ddr[3] = reg32(0x60000000 + 0xc);
    //delay_us(1);
    r_ddr[4] = reg32(0x60000000 + 0x10);
    //delay_us(1);
    r_ddr[5] = reg32(0x60000000 + 0x14);
    //delay_us(1);
    r_ddr[6] = reg32(0x60000000 + 0x18);
    delay_us(1);
    r_ddr[7] = reg32(0x60000000 + 0x1c);
    //delay_us(1);
    r_ddr[8] = reg32(0x60000000 + 0x20);
    //delay_us(1);
    r_ddr[9] = reg32(0x60000000 + 0x24);
    delay_us(1);

    printf("%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x,%08x\n",r_ddr[0],r_ddr[1],r_ddr[2],r_ddr[3],r_ddr[4],r_ddr[5],r_ddr[6],r_ddr[7],r_ddr[8],r_ddr[9]);
#endif

  #endif

}

