/*!
    \file    flash_test.c
    \brief   the flash test file

*/

#include "lisoc_test.h"
#include "qspi.h"
#include "flash.h"
#include "flash_test.h"

#define LISOC_PROG_IMG_SIZ              (1524u + 1u)
#define LISOC_PROG_BUF_SIZ              ((LISOC_PROG_IMG_SIZ + 3u) / 4u * 4u)
#define LISOC_PROG_OFFSET               0//0x10000 //sector 2


uint32_t _aclisoc_buf32[LISOC_PROG_BUF_SIZ / 4u];

const uint8_t _aclisoc_flash[LISOC_PROG_BUF_SIZ] = {
  0x70, 0x90, 0x02, 0x20, 0x99, 0x01, 0x02, 0x20, 0x61, 0x02, 0x02, 0x20, 0x66, 0x02, 0x02, 0x20, 0x65, 0x02, 0x02, 0x20, 0x67, 0x02, 0x02, 0x20, 0x69, 0x02, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6B, 0x02, 0x02, 0x20, 0x6D, 0x02, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x02, 0x02, 0x20, 0x71, 0x02, 0x02, 0x20, 0x75, 0x02, 0x02, 0x20, 0x77, 0x02, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20,
  0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0x79, 0x02, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20,
  0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20,
  0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20,
  0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20, 0xB3, 0x01, 0x02, 0x20,
  0xB3, 0x01, 0x02, 0x20, 0x00, 0xF0, 0x02, 0xF8, 0x00, 0xF0, 0x3F, 0xF8, 0x0A, 0xA0, 0x90, 0xE8, 0x00, 0x0C, 0x82, 0x44, 0x83, 0x44, 0xAA, 0xF1, 0x01, 0x07, 0xDA, 0x45, 0x01, 0xD1, 0x00, 0xF0, 0x34, 0xF8, 0xAF, 0xF2, 0x09, 0x0E, 0xBA, 0xE8,
  0x0F, 0x00, 0x13, 0xF0, 0x01, 0x0F, 0x18, 0xBF, 0xFB, 0x1A, 0x43, 0xF0, 0x01, 0x03, 0x18, 0x47, 0xA0, 0x04, 0x00, 0x00, 0xC0, 0x04, 0x00, 0x00, 0x10, 0x3A, 0x24, 0xBF, 0x78, 0xC8, 0x78, 0xC1, 0xFA, 0xD8, 0x52, 0x07, 0x24, 0xBF, 0x30, 0xC8,
  0x30, 0xC1, 0x44, 0xBF, 0x04, 0x68, 0x0C, 0x60, 0x70, 0x47, 0x00, 0x00, 0x00, 0x23, 0x00, 0x24, 0x00, 0x25, 0x00, 0x26, 0x10, 0x3A, 0x28, 0xBF, 0x78, 0xC1, 0xFB, 0xD8, 0x52, 0x07, 0x28, 0xBF, 0x30, 0xC1, 0x48, 0xBF, 0x0B, 0x60, 0x70, 0x47,
  0x63, 0x29, 0x00, 0xF0, 0xC5, 0x81, 0x00, 0x20, 0x70, 0x47, 0x1F, 0xB5, 0x1F, 0xBD, 0x10, 0xB5, 0x10, 0xBD, 0x00, 0xF0, 0xF3, 0xF9, 0x11, 0x46, 0xFF, 0xF7, 0xF7, 0xFF, 0x00, 0xF0, 0x56, 0xF8, 0x00, 0xF0, 0x11, 0xFA, 0x03, 0xB4, 0xFF, 0xF7,
  0xF2, 0xFF, 0x03, 0xBC, 0x00, 0xF0, 0x30, 0xF8, 0x09, 0x48, 0x80, 0x47, 0x09, 0x48, 0x00, 0x47, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0x04, 0x48, 0x05, 0x49,
  0x05, 0x4A, 0x06, 0x4B, 0x70, 0x47, 0x00, 0x00, 0xBD, 0x02, 0x02, 0x20, 0xF5, 0x00, 0x02, 0x20, 0x70, 0x80, 0x02, 0x20, 0x70, 0x90, 0x02, 0x20, 0x70, 0x8C, 0x02, 0x20, 0x70, 0x8C, 0x02, 0x20, 0xC0, 0xB2, 0x00, 0xF0, 0x16, 0xB8, 0x10, 0xB5,
  0x00, 0xF0, 0x19, 0xF8, 0xBD, 0xE8, 0x10, 0x40, 0x00, 0xF0, 0x0F, 0xB8, 0x4F, 0xF0, 0xFF, 0x30, 0x70, 0x47, 0xC0, 0xB2, 0x00, 0xF0, 0x09, 0xB8, 0xFE, 0xE7, 0x00, 0x00, 0x4F, 0xF0, 0x40, 0x20, 0x10, 0x21, 0x01, 0x61, 0x41, 0x21, 0x81, 0x60,
  0x70, 0x47, 0x10, 0xB5, 0x04, 0x46, 0x00, 0xF0, 0x7F, 0xF8, 0x20, 0x46, 0x10, 0xBD, 0x4F, 0xF0, 0x40, 0x20, 0x00, 0x68, 0xC0, 0xB2, 0x70, 0x47, 0x03, 0x49, 0x02, 0x48, 0xC1, 0xF8, 0xF4, 0x03, 0xFE, 0xE7, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x10, 0x0F, 0x40, 0x04, 0x48, 0x10, 0xB5, 0xC0, 0x68, 0x00, 0xF0, 0x47, 0xF8, 0x03, 0xA0, 0x00, 0xF0, 0xE4, 0xF8, 0x00, 0x20, 0x10, 0xBD, 0x00, 0x10, 0x0F, 0x40, 0x69, 0x20, 0x61, 0x6D, 0x20, 0x61, 0x70, 0x70, 0x2E, 0x28, 0x6E, 0x6F,
  0x58, 0x49, 0x50, 0x29, 0x0A, 0x00, 0x00, 0x00, 0x70, 0x47, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0xFE, 0xE7, 0x70, 0x47, 0x70, 0x47, 0x70, 0x47, 0x00, 0xF0, 0x10, 0xB8, 0x70, 0x47, 0x70, 0x47, 0x70, 0x47, 0x00, 0x00, 0x01, 0xB5, 0x00, 0x98,
  0x41, 0x1E, 0x00, 0x91, 0xFB, 0xD2, 0x08, 0xBD, 0x09, 0x49, 0x08, 0x60, 0x08, 0x68, 0x00, 0x28, 0xFC, 0xD1, 0x70, 0x47, 0x06, 0x48, 0x01, 0x68, 0x00, 0x29, 0x02, 0xD0, 0x01, 0x68, 0x49, 0x1E, 0x01, 0x60, 0x70, 0x47, 0x02, 0x49, 0x08, 0x60,
  0x70, 0x47, 0x01, 0x48, 0x00, 0x68, 0x70, 0x47, 0x04, 0x80, 0x02, 0x20, 0x04, 0x49, 0x03, 0x48, 0x08, 0x60, 0x70, 0x47, 0x02, 0x49, 0x01, 0x48, 0x08, 0x60, 0x70, 0x47, 0x00, 0x5A, 0x62, 0x02, 0x08, 0x80, 0x02, 0x20, 0x70, 0xB5, 0x4F, 0xF0,
  0x80, 0x41, 0x00, 0x20, 0x08, 0x61, 0x48, 0x60, 0x80, 0x24, 0xCC, 0x60, 0x09, 0x23, 0x0B, 0x60, 0x48, 0x60, 0xC8, 0x60, 0x03, 0x25, 0xCD, 0x60, 0x88, 0x60, 0x48, 0x60, 0x37, 0x49, 0x08, 0x60, 0x37, 0x4E, 0x4F, 0xF4, 0xA0, 0x22, 0x72, 0x61,
  0x34, 0x4A, 0x08, 0x32, 0x14, 0x60, 0x0C, 0x1F, 0x23, 0x60, 0x08, 0x60, 0x10, 0x60, 0x15, 0x60, 0x0A, 0x1D, 0x10, 0x60, 0x08, 0x60, 0x70, 0xBD, 0x4F, 0xF0, 0x80, 0x41, 0x4A, 0x69, 0x20, 0x2A, 0xFC, 0xD0, 0x08, 0x60, 0x70, 0x47, 0x4F, 0xF0,
  0x80, 0x40, 0x41, 0x69, 0xC9, 0x07, 0xFC, 0xD0, 0x00, 0x68, 0xC0, 0xB2, 0x70, 0x47, 0x27, 0x49, 0x10, 0x31, 0x0A, 0x68, 0x20, 0x2A, 0xFC, 0xD0, 0x24, 0x49, 0x09, 0x1F, 0x08, 0x60, 0x70, 0x47, 0x22, 0x48, 0x10, 0x30, 0x01, 0x68, 0xC9, 0x07,
  0xFC, 0xD0, 0x20, 0x48, 0x00, 0x1F, 0x00, 0x68, 0xC0, 0xB2, 0x70, 0x47, 0x10, 0xB5, 0xFF, 0xF7, 0xA5, 0xFF, 0x1C, 0x4C, 0x10, 0x34, 0x02, 0xE0, 0xFF, 0xF7, 0xA3, 0xFF, 0x38, 0xB1, 0x20, 0x68, 0xC0, 0x07, 0xF9, 0xD0, 0x17, 0x48, 0x00, 0x1F,
  0x00, 0x68, 0xC0, 0xB2, 0x10, 0xBD, 0x17, 0xA0, 0x00, 0xF0, 0x48, 0xF8, 0x00, 0x20, 0x10, 0xBD, 0x70, 0x47, 0x30, 0xB5, 0x89, 0xB0, 0x18, 0xA3, 0x00, 0x24, 0x6D, 0x46, 0x90, 0xFB, 0xF1, 0xF2, 0x01, 0xFB, 0x12, 0x02, 0x0A, 0x2A, 0x01, 0xDA,
  0x30, 0x32, 0x02, 0xE0, 0x1A, 0x44, 0x12, 0xF8, 0x0A, 0x2C, 0x90, 0xFB, 0xF1, 0xF0, 0x2A, 0x55, 0x64, 0x1C, 0x00, 0x28, 0xEE, 0xDC, 0x00, 0x20, 0x28, 0x55, 0x04, 0xE0, 0x64, 0x1E, 0x13, 0xA0, 0x29, 0x5D, 0x00, 0xF0, 0x27, 0xF8, 0x00, 0x2C,
  0xF8, 0xD1, 0x08, 0xA0, 0x00, 0xF0, 0x22, 0xF8, 0x09, 0xB0, 0x30, 0xBD, 0x04, 0x04, 0x00, 0x40, 0x00, 0x10, 0x0F, 0x40, 0x75, 0x6C, 0x20, 0x73, 0x79, 0x6E, 0x63, 0x20, 0x74, 0x69, 0x6D, 0x65, 0x6F, 0x75, 0x74, 0x2E, 0x0A, 0x00, 0x00, 0x00,
  0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x00, 0x00, 0x25, 0x63, 0x00, 0x00, 0x70, 0x47, 0x00, 0x00, 0x0F, 0xB4, 0x04, 0x49,
  0x10, 0xB5, 0x03, 0xAA, 0x02, 0x98, 0x00, 0xF0, 0x7B, 0xF8, 0x10, 0xBC, 0x5D, 0xF8, 0x14, 0xFB, 0x00, 0x80, 0x02, 0x20, 0x2D, 0xE9, 0xF0, 0x41, 0x0E, 0x46, 0x04, 0x46, 0x00, 0x20, 0x20, 0x62, 0x20, 0x46, 0xE1, 0x68, 0x88, 0x47, 0x30, 0xB3,
  0x25, 0x28, 0x05, 0xD0, 0xD4, 0xE9, 0x01, 0x21, 0x90, 0x47, 0x20, 0x6A, 0x40, 0x1C, 0xF2, 0xE7, 0xE1, 0x68, 0x20, 0x46, 0x00, 0x27, 0x88, 0x47, 0x05, 0x00, 0x18, 0xD0, 0xA5, 0xF1, 0x41, 0x00, 0x19, 0x28, 0x02, 0xD8, 0x20, 0x35, 0x4F, 0xF4,
  0x00, 0x67, 0x32, 0x46, 0x29, 0x46, 0x20, 0x46, 0x27, 0x60, 0xFF, 0xF7, 0x7D, 0xFE, 0x40, 0xB1, 0x01, 0x28, 0x04, 0xD0, 0xF6, 0x1D, 0x26, 0xF0, 0x07, 0x06, 0x08, 0x36, 0xD8, 0xE7, 0x36, 0x1D, 0xD6, 0xE7, 0x28, 0x46, 0xDA, 0xE7, 0x20, 0x6A,
  0xBD, 0xE8, 0xF0, 0x81, 0x70, 0xB5, 0x0C, 0x46, 0x05, 0x46, 0x01, 0x2A, 0x05, 0xD0, 0x28, 0x78, 0x80, 0x06, 0x00, 0xD5, 0xEA, 0x69, 0x00, 0x23, 0x02, 0xE0, 0x01, 0x23, 0x05, 0xE0, 0x5B, 0x1C, 0x93, 0x42, 0x02, 0xD2, 0xE0, 0x5C, 0x00, 0x28,
  0xF9, 0xD1, 0xA8, 0x69, 0xE6, 0x18, 0xC0, 0x1A, 0xA8, 0x61, 0x28, 0x6A, 0x18, 0x44, 0x28, 0x62, 0x28, 0x46, 0xAF, 0xF3, 0x00, 0x80, 0x04, 0xE0, 0xD5, 0xE9, 0x01, 0x21, 0x14, 0xF8, 0x01, 0x0B, 0x90, 0x47, 0xB4, 0x42, 0xF8, 0xD3, 0x28, 0x46,
  0xAF, 0xF3, 0x00, 0x80, 0x70, 0xBD, 0x70, 0x47, 0x70, 0x47, 0x70, 0x47, 0x10, 0xB5, 0x43, 0x69, 0x13, 0xB1, 0xAF, 0xF3, 0x00, 0x80, 0x01, 0xE0, 0xFF, 0xF7, 0xCC, 0xFF, 0x01, 0x20, 0x10, 0xBD, 0x12, 0x78, 0x00, 0xF1, 0x24, 0x01, 0x0A, 0x70,
  0x00, 0x22, 0x4A, 0x70, 0x01, 0x22, 0xED, 0xE7, 0x11, 0x68, 0x4F, 0xF0, 0xFF, 0x32, 0xE9, 0xE7, 0x07, 0x4B, 0x70, 0xB5, 0x0D, 0x46, 0x7B, 0x44, 0x00, 0xF0, 0x11, 0xF8, 0x04, 0x46, 0x28, 0x46, 0xFF, 0xF7, 0x64, 0xFE, 0x10, 0xB1, 0x4F, 0xF0,
  0xFF, 0x30, 0x70, 0xBD, 0x20, 0x46, 0x70, 0xBD, 0xBF, 0xFC, 0xFF, 0xFF, 0x01, 0x69, 0x4A, 0x1C, 0x02, 0x61, 0x08, 0x78, 0x70, 0x47, 0x00, 0xB5, 0x8F, 0xB0, 0xCD, 0xE9, 0x01, 0x31, 0x00, 0x21, 0x05, 0x91, 0x05, 0x49, 0x79, 0x44, 0xCD, 0xE9,
  0x03, 0x10, 0x11, 0x46, 0x68, 0x46, 0xFF, 0xF7, 0x65, 0xFF, 0x0F, 0xB0, 0x00, 0xBD, 0x00, 0x00, 0xE5, 0xFF, 0xFF, 0xFF, 0x75, 0x46, 0x00, 0xF0, 0x2B, 0xF8, 0xAE, 0x46, 0x05, 0x00, 0x69, 0x46, 0x53, 0x46, 0x20, 0xF0, 0x07, 0x00, 0x85, 0x46,
  0x18, 0xB0, 0x20, 0xB5, 0xFF, 0xF7, 0x1A, 0xFE, 0xBD, 0xE8, 0x20, 0x40, 0x4F, 0xF0, 0x00, 0x06, 0x4F, 0xF0, 0x00, 0x07, 0x4F, 0xF0, 0x00, 0x08, 0x4F, 0xF0, 0x00, 0x0B, 0x21, 0xF0, 0x07, 0x01, 0xAC, 0x46, 0xAC, 0xE8, 0xC0, 0x09, 0xAC, 0xE8,
  0xC0, 0x09, 0xAC, 0xE8, 0xC0, 0x09, 0xAC, 0xE8, 0xC0, 0x09, 0x8D, 0x46, 0x70, 0x47, 0x10, 0xB5, 0x04, 0x46, 0xAF, 0xF3, 0x00, 0x80, 0x20, 0x46, 0xBD, 0xE8, 0x10, 0x40, 0xFF, 0xF7, 0xE6, 0xBD, 0x00, 0x48, 0x70, 0x47, 0x0C, 0x80, 0x02, 0x20,
  0xE8, 0x05, 0x02, 0x20, 0x00, 0x80, 0x02, 0x20, 0x0C, 0x00, 0x00, 0x00, 0x30, 0x01, 0x02, 0x20, 0xF4, 0x05, 0x02, 0x20, 0x0C, 0x80, 0x02, 0x20, 0x64, 0x10, 0x00, 0x00, 0x4C, 0x01, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5A, 0x62, 0x02, 0x00
};


void flash_test(void)
{
  uint32_t pgadr;
  uint32_t rdlen;
  uint32_t j;
  uint32_t errflg;
  uint8_t flash_buf1[4];
  uint8_t flash_buf2[4];

  SPIF_init();
  #if 0
  debug("qspi rx delay sample test start!\n");
  /* Read flash JEDEC ID to determine its capacity */
  SPIF_GetDevID(flash_buf1, 3u);
  debug("idbuff:0x%02x, 0x%02x 0x%02x\n", flash_buf1[0u], flash_buf1[1u], flash_buf1[2u]);
	SPIM_SetRXSampleDelayClk(4);
  /* Read flash JEDEC ID to determine its capacity */
  SPIF_GetDevID(flash_buf2, 3u);
  debug("idbuff:0x%02x, 0x%02x 0x%02x\n", flash_buf2[0u], flash_buf2[1u], flash_buf2[2u]);
  
  if( ((uint8_t)(flash_buf1[2]<<2)) == flash_buf2[2])
  {
    debug("qspi rx delay sample test \tOK.\n");
  }
  else
  {
    debug("qspi rx delay sample test ng!\n");
  }

  SPIM_SetRXSampleDelayClk(0);
  #endif
  //debug("flash test start\n");

  /* erase sector #1 (sector size = 64KB) */
  SPIF_BlockErase64K(0u);
  //SPIF_BlockErase64K(1u);

  /* program page #0 (page size = 256B) */
  memcpy((void *)_aclisoc_buf32, (void *)_aclisoc_flash, sizeof(_aclisoc_flash));
  SPIF_Program(0 + LISOC_PROG_OFFSET/SPIF_PAGE_SIZE, (uint8_t *)_aclisoc_buf32, sizeof(_aclisoc_flash));

  /* read address 0x0000 and dump read back data */
  errflg = FALSE;
  for (pgadr = 0 + LISOC_PROG_OFFSET; pgadr < sizeof(_aclisoc_flash); pgadr += SPIF_PAGE_SIZE)
  {
    rdlen = (pgadr + SPIF_PAGE_SIZE > sizeof(_aclisoc_flash)) ?
      sizeof(_aclisoc_flash) - pgadr : SPIF_PAGE_SIZE;
    SPIF_ReadData(pgadr, flash_buff, rdlen);

    for (j = pgadr; j < pgadr + rdlen; j ++)
    {
      if ((errflg == FALSE) && (_aclisoc_flash[j] != flash_buff[j - pgadr]))
      {      
        debug("Read expectation value for index %d:0x%x,actual value:0x%x\n",j,_aclisoc_flash[j],flash_buff[j]);
        //errflg = TRUE;
        //break;
      }
    }
  }
  debug("flast test\t\t\t\t\t%s.\n", errflg ? "NG" : "OK");
}

void xip_test(void)
{
  volatile uint32_t cache_temp;
  uint32_t i,j,k;
  uint32_t errflg;

  SPIF_init();

  SPIF_XIP_Init();

  //debug("xip no cache test start.\n");
  SPIM_SysCacheDisable();

  memcpy(flash_buff, (void*)(SSI0_BASE_ADDR + LISOC_PROG_OFFSET), sizeof(_aclisoc_flash));
  errflg = FALSE;
  for (j = 0; j < sizeof(_aclisoc_flash); j ++)
  {
    if ((errflg == FALSE) && (_aclisoc_flash[j] != flash_buff[j]))
    {
      debug("Read expectation value for index %d:0x%x,actual value:0x%x\n",j,_aclisoc_flash[j],flash_buff[j]);
      errflg = TRUE;
      break;
    }
  }

  j = 10000;
  while(j--){
  for(i = 0;i < 4;i ++)
    cache_temp += *(uint32_t *)(SSI0_BASE_ADDR + LISOC_PROG_OFFSET + i*4);
  }

  if((errflg == FALSE) && (CACHE_CSHR == 0u))
  {
    debug("xip no cache test\t\t\t\tOK.\n");
  }
  else
  {
    debug("xip cache hit count: %d.\n",CACHE_CSHR);
    debug("xip no cache test\t\t\t\tNG.\n");
  }

  //debug("xip cache test start.\n");
  SPIM_SysXIPDisable();
  CACHE_CSHR = 0x00;
  CACHE_CSMR = 0x00;

  SPIM_SysXIPEnable();
  SPIM_SysCacheEnable();
  while((CACHE_SR & 0x03u) != 0x02u);

  memcpy(flash_buff, (void*)(SSI0_BASE_ADDR + LISOC_PROG_OFFSET), sizeof(_aclisoc_flash));
  errflg = FALSE;
  for (j = 0; j < sizeof(_aclisoc_flash); j ++)
  {
    if ((errflg == FALSE) && (_aclisoc_flash[j] != flash_buff[j]))
    {
      debug("Read expectation value for index %d:0x%x,actual value:0x%x\n",j,_aclisoc_flash[j],flash_buff[j]);
      errflg = TRUE;
      break;
    }
  }

  k = 10000;
  while(k--)
  {
    for(j = 0; j < 4; j++)
    {
      cache_temp += *(uint32_t*)(SSI0_BASE_ADDR + LISOC_PROG_OFFSET+j*4);
    }
  }

  if((errflg == FALSE) && (CACHE_CSHR != 0u))
  {
    debug("xip cache test\t\t\t\t\tOK.\n");
  }
  else
  {
    debug("xip cache hit count: %d.\n",CACHE_CSHR);
    debug("xip cache test\t\t\t\t\tNG.\n");
  }
  SPIM_SysXIPDisable();
  SPIM_SysCacheDisable();
}

