#include "lisoc_test.h"
#include "rcc_test.h"
#include "rcc.h"
 /*!
    \brief      rcc test
    \param[in]  none
    \param[out] none
    \retval     none
*/
void rcc_rst_test(void)
{
  uint32_t rdata;
  uint8_t test_result = SUCCESS;

  rcc_RST(CACHE_RCC_RSTn);
  rdata = CACHE_CR;
  CACHE_CR = 0xFFFFFFFF;
  rcc_RST(CACHE_RCC_RSTn);
  if(rdata != CACHE_CR){
    test_result = FAILURE;
    debug("cache ng.\n");
  }

  rcc_RST(UART1_RCC_RSTn);
  rdata = UART1_DLH;
  UART1_DLH = 0xFFFFFFFF;
  rcc_RST(UART1_RCC_RSTn);
  if(rdata != UART1_DLH){
    test_result = FAILURE;
    debug("uart1 ng.\n");
  }

  rcc_RST(TIMER0_RCC_RSTn);
  rdata = TIMER0_LOADCOUNT;
  TIMER0_LOADCOUNT = 0xFFFFFFFF;
  rcc_RST(TIMER0_RCC_RSTn);
  if(rdata != TIMER0_LOADCOUNT){
    test_result = FAILURE;
    debug("timer0 ng.\n");
  }

  rcc_RST(TIMER1_RCC_RSTn);
  rdata = TIMER1_LOADCOUNT;
  TIMER1_LOADCOUNT = 0xFFFFFFFF;
  rcc_RST(TIMER1_RCC_RSTn);
  if(rdata != TIMER1_LOADCOUNT){
    test_result = FAILURE;
    debug("timer1 ng.\n");
  }

  rcc_RST(TIMER2_RCC_RSTn);
  rdata = TIMER2_LOADCOUNT;
  TIMER2_LOADCOUNT = 0xFFFFFFFF;
  rcc_RST(TIMER2_RCC_RSTn);
  if(rdata != TIMER2_LOADCOUNT){
    test_result = FAILURE;
    debug("timer2 ng.\n");
  }

  rcc_RST(I2C0_RCC_RSTn);
  rdata = I2C0_CON;
  I2C0_CON = 0xFFFFFFFF;
  rcc_RST(I2C0_RCC_RSTn);
  if(rdata != I2C0_CON){
    test_result = FAILURE;
    debug("i2c0 ng.\n");
  }

  rcc_RST(I2C1_RCC_RSTn);
  rdata = I2C1_CON;
  I2C1_CON = 0xFFFFFFFF;
  rcc_RST(I2C1_RCC_RSTn);
  if(rdata != I2C1_CON){
    test_result = FAILURE;
    debug("i2c1 ng.\n");
  }

  rcc_RST(I2C2_RCC_RSTn);
  rdata = I2C2_CON;
  I2C2_CON = 0xFFFFFFFF;
  rcc_RST(I2C2_RCC_RSTn);
  if(rdata != I2C2_CON){
    test_result = FAILURE;
    debug("i2c2 ng.\n");
  }

  rcc_RST(GPIOA_RCC_RSTn);
  rdata = GPIOA_PADR;
  GPIOA_PADR = 0xFFFFFFFF;
  rcc_RST(GPIOA_RCC_RSTn);
  if(rdata != GPIOA_PADR){
    test_result = FAILURE;
    debug("gpioa ng.\n");
  }

  rcc_RST(GPIOB_RCC_RSTn);
  rdata = GPIOB_PADR;
  GPIOB_PADR = 0xFFFFFFFF;
  rcc_RST(GPIOB_RCC_RSTn);
  if(rdata != GPIOB_PADR){
    test_result = FAILURE;
    debug("gpiob ng.\n");
  }

  rcc_RST(WDT_RCC_RSTn);
  rdata = WDT_CR;
  WDT_CR = 0xFFFFFFFF;
  rcc_RST(WDT_RCC_RSTn);
  if(rdata != WDT_CR){
    test_result = FAILURE;
    debug("wdt ng.\n");
  }

  rcc_RST(SPIM_RCC_RSTn);
  rdata = SPI0_MST_CTRLR0;
  SPI0_MST_CTRLR0 = 0xFFFFFFFF;
  rcc_RST(SPIM_RCC_RSTn);
  
  if(rdata != SPI0_MST_CTRLR0){
    test_result = FAILURE;
    debug("spim ng.\n");
  }

  rcc_RST(SPIS_RCC_RSTn);
  rdata = SPI0_SLV_CTRLR0;
  SPI0_SLV_CTRLR0 = 0xFFFFFFFF;
  rcc_RST(SPIS_RCC_RSTn);
  if(rdata != SPI0_SLV_CTRLR0){
    test_result = FAILURE;
    debug("spis ng.\n");
  }

  if(test_result == SUCCESS){
    debug("rcc rst test \t\t\t\t\tOK.\n");
  }else{
    debug("rcc rst test \t\t\t\t\tNG.\n");
  }

}

void rcc_mco_test(void)
{
  rcc_MCOSEL(CPU_CLK);
  delay_ms(1000);
  rcc_MCOSEL(AXI_CLK);
  delay_ms(1000);
  rcc_MCOSEL(MRX_BYTE_CLK);
  delay_ms(1000);
  rcc_MCOSEL(MRX_PIX_CLK);
  delay_ms(1000);
  rcc_MCOSEL(VIDEO_CLK1);
  delay_ms(1000);
  rcc_MCOSEL(VIDEO_CLK2);
  delay_ms(1000);
}

void rcc_gate_test(void)
{
  uint8_t i;

  for(i = 0; i <= UART0_RCC_PERn; i++){
    rcc_PerDisable((RCC_PERn_Type)i);
    delay_ms(100);
    rcc_PerDisable((RCC_PERn_Type)i);
    delay_ms(100);
  }

}

void sys_reset_test(void)
{
  rcc_SYS_RESET();
}

