/*
 * AXCUtils.cpp
 */

#include "AXCUtils.hpp"

std::vector<std::string> AXCUtils::split(const std::string &str,
                                         const std::string &delim) {
  std::vector<std::string> res;
  size_t current = 0, found, delimlen = delim.size();
  while ((found = str.find(delim, current)) != std::string::npos) {
    res.push_back(std::string(str, current, found - current));
    current = found + delimlen;
  }
  res.push_back(std::string(str, current, str.size() - current));
  return res;
}

