/**
 * @file   AXFCommRingBufInternal.hpp
 * @brief  AXFCommRingBufInternalクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFCOMMRINGBUFINTERNAL_HPP_
#define AXFCOMMRINGBUFINTERNAL_HPP_

#include "AXCCommRingBufFreeRTOS.hpp"
#include "AXFMutex.hpp"

/**
 * @class AXFCommRingBufInternal
 * @brief AXFログ送受信スレッドクラス(AXFLogTask)に対し、
 *        CPU間通信用リング・バッファ機能を提供する
 *
 */
class AXFCommRingBufInternal : 
	public AXCCommRingBufFreeRTOS
{
 public:
  /**
   * @brief AXFCommRingBufInternalコンストラクタ
   */
  AXFCommRingBufInternal(
    char* buf = (char *)(COM_MEM_LOG + 4*2),
    int size = COM_MEM_LOG_SIZE - 4*2,
    volatile int* rp = (volatile int *)(COM_MEM_LOG + 0),
    volatile int* wp = (volatile int *)(COM_MEM_LOG + 4))
    : AXCCommRingBufFreeRTOS(buf, size, rp, wp)
  {
  }
};

#endif /* AXFCOMMRINGBUFINTERNAL_HPP_ */
