/*
 * AXFLog.cpp
 */

#include "AXFLog.hpp"
#include "AXFRingBufInternal.hpp"
#include "AXFCommRingBufInternal.hpp"
#include "AXFLogTaskInternal.hpp"
#include "AX.hpp"

#include <string.h>

#include "AXFStage.hpp"
#include "AXFCommSendInternal.hpp"
#include "AXFStdioInternal.hpp"

#ifdef USE_OUTPUT_RESULT_XML
#include "AXFScenarioTestInternal.hpp"
#endif /* USE_OUTPUT_RESULT_XML */

#include <new>

AXFLog::AXFLog(AXFObjectName& name)
    : m_name(name) {
}

AXFLog::~AXFLog() {
}

void AXFLog::write(AXFLOG_LEVEL level, const std::string& message) {
  if (false == isEnable) {
    return;
  }
  if (m_level > level) {
    return;
  }
  std::string buf = m_name.getFullActorName() + ": " + message;

  bool fin = false;
  if (isTrans && AXFStage::isRW == AXFStage::LOG_WRITE) {
    AXFStage* stage = AXFStage::getInstance();
    if (stage && stage->m_logTask) {
      const char* cstr = buf.c_str();
      int sz = strlen(cstr) + 1;
      fin = (stage->m_logTask->write((char *)cstr, sz) == sz);
      if (!fin) buf = std::string("drop! ") + buf;
    }
  }
  if (fin) return;

	AXFStdioInternal stdio;
	std::cout << buf.c_str() << axstdio::endl;
}
