/**
 * @file   AXFLog.hpp
 * @brief  AXFLogクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFLOG_HPP_
#define AXFLOG_HPP_

#include "AXFObjectName.hpp"
#include <string>

/**
 * @enum  AXFLOG_LEVEL
 * @brief AXFLOGレベル指定
 */
enum AXFLOG_LEVEL {
  AXFLOG_DEBUG,  ///< デバッグ情報
  AXFLOG_INFO,   ///< 情報
  AXFLOG_NOTICE,  ///< 通知
  AXFLOG_WARN,   ///< 警告
  AXFLOG_ERR,    ///< 一般的なエラー
  AXFLOG_CRIT,   ///< 致命的なエラー
  AXFLOG_ALERT,  ///< 緊急に対処すべきエラー
  AXFLOG_EMERG,  ///< システムが落ちるような状態
};

/**
 * @class AXFLog
 * @brief アクタに対し、ログサービスを提供する
 *
 * @n     AXConfigの指定で、ログ出力レベル指定や他Stageへのログ転送指定を行う。
 */
class AXFLog {
  AXFObjectName& m_name;

 public:
  static bool isEnable;         ///< AXFLog 出力有無指定
  static AXFLOG_LEVEL m_level;  ///< AXFLog 出力レベル指定
  static bool isTrans;          ///< AXFlog 転送有無指定

  /**
   * @brief AXFLogコンストラクタ
   * @param [in] name アクタ名
   */
  AXFLog(AXFObjectName& name);

  /**
   * @brief AXFLogデストラクタ
   */
  virtual ~AXFLog();

  /**
   * @brief AXFLog出力
   * @param [in] level AXFLog出力レベル指定
   * @param [in] message ログ情報
   */
  void write(AXFLOG_LEVEL level, const std::string& message);

  // インスタンスのコピーは想定しない(Klockwork指摘対応:CL.FFM.COPY)
  AXFLog(const AXFLog& obj)
      : m_name(obj.m_name) {
  }

 private:
  // インスタンスのコピーは想定しない(Klockwork指摘対応:CL.FFM.ASSIGN)
  AXFLog& operator=(const AXFLog&) {
    return *this;
  }
};

#endif /* AXFLOG_HPP_ */
