/*
 * AXFMailbox.cpp
 */

#include "AXFMailboxInternal.hpp"
#include "AXFObjectName.hpp"

#include "AXFConditionVariableInternal.hpp"
#include "AXFMutex.hpp"

AXFMailboxInternal::AXFMailboxInternal()
    : m_queue(NULL) {
}

AXFMailboxInternal::~AXFMailboxInternal() {
  deleteQueue(&m_queue);
}

AXFMailboxInternal::queueStatus AXFMailboxInternal::create(int maxCount, int maxSize) {
  return createQueue(maxCount, maxSize, &m_queue,
    new (std::nothrow) AXFConditionVariableInternal(),
    new (std::nothrow) AXFMutex());
}

int AXFMailboxInternal::send(AXFEvent_t eventId, void* data, int size) {
  queuePacket_t wpkt;

  wpkt.eventId = eventId;
  wpkt.data = (UINT8_t*) data;
  wpkt.size = size;
  return writeQueue(m_queue, &wpkt);
}

int AXFMailboxInternal::receive(AXFEvent_t* eventId, void* data, int size) {
  int stat;
  queuePacket_t rpkt;

  rpkt.data = (UINT8_t*) data;
  rpkt.size = size;
  stat = readQueue(m_queue, &rpkt);
  *eventId = rpkt.eventId;

  return stat;
}

int AXFMailboxInternal::peek() {
  return peekQueue(m_queue);
}

int AXFMailboxInternal::npeek() {
  return npeekQueue(m_queue);
}

