/*
 * AXFObjectName.cpp
 */

#include "AXFObjectName.hpp"
#include "AXConfig.hpp"
#include "AXCUtils.hpp"

using namespace std;

AXFObjectName::AXFObjectName(string actor, string stage, string module,
                             string unit, string node, string site,
                             string world) {
  std::vector<std::string> name = AXCUtils::split(actor, ".");
  int size = name.size();

  if (1 == size) {
    m_actor = actor;
    m_stage = stage;
    m_module = module;
    m_unit = unit;
    m_node = node;
    m_site = site;
    m_world = world;
  } else {
    std::string *field;
    int j = size - 1;
    for (int i = 0; i < 7; i++, j--) {
      field = NULL;
      switch (i) {
        case 0:
          field = &m_actor;
          break;
        case 1:
          field = &m_stage;
          break;
        case 2:
          field = &m_module;
          break;
        case 3:
          field = &m_unit;
          break;
        case 4:
          field = &m_node;
          break;
        case 5:
          field = &m_site;
          break;
        case 6:
        default:
          field = &m_world;
          break;
      }
      if (NULL != field) {
        *field = (j >= 0) ? name[j] : "";
      }
    }
  }

#ifdef NEVER
  // @ToDo アクタ間通信ネットワーク対応時に見直す
  m_full = m_world + "." + m_site + "." + m_node + "." + m_unit + "." + m_module
      + "." + m_stage + "." + m_actor;
#else
  m_full = "." + m_stage + "." + m_actor;
#endif
}

AXFObjectName::~AXFObjectName() {
}

bool AXFObjectName::isCurrentStage() {
  if ("" == m_stage) {
    return true;
  }

  if (0 == m_stage.compare(AXConfig.getStageNameObject().m_stage)) {
    return true;
  }

  return false;
}

bool AXFObjectName::isCurrentModule() {
  return true;
}
bool AXFObjectName::isCurrentUnit() {
  return true;
}

bool AXFObjectName::isCurrentNode() {
  return true;
}

bool AXFObjectName::isCurrentSite() {
  return true;
}

bool AXFObjectName::isCurrentWorld() {
  return true;
}

const string& AXFObjectName::getFullActorName() {
  return m_full;
}

const string& AXFObjectName::getActorName() {
  return m_actor;
}

const string& AXFObjectName::getStageName() {
  return m_stage;
}

bool AXFObjectName::isMatch(const AXFObjectName& name) {
  int retValue;

  retValue = m_actor.compare(name.m_actor);
  if (0 != retValue) {
    return false;
  }

  if ("" == m_stage) {
    return true;
  }
  retValue = m_stage.compare(name.m_stage);
  if (0 != retValue) {
    return false;
  }

  if ("" == m_module) {
    return true;
  }
  retValue = m_module.compare(name.m_module);
  if (0 != retValue) {
    return false;
  }

  if ("" == m_unit) {
    return true;
  }
  retValue = m_unit.compare(name.m_unit);
  if (0 != retValue) {
    return false;
  }

  if ("" == m_node) {
    return true;
  }
  retValue = m_node.compare(name.m_node);
  if (0 != retValue) {
    return false;
  }

  if ("" == m_site) {
    return true;
  }
  retValue = m_site.compare(name.m_site);
  if (0 != retValue) {
    return false;
  }

  if ("" == m_world) {
    return true;
  }
  retValue = m_world.compare(name.m_world);
  if (0 != retValue) {
    return false;
  }

  return true;
}
