/**
 * @file   AXFPtrList.hpp
 * @brief  AXFPtrListクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFPTRLIST_HPP_
#define AXFPTRLIST_HPP_

#include <list>

#include "AXFMutex.hpp"

/**
 * @class AXFPtrList
 * @brief ポインタを保持するリストの機能を提供する
 *
 */
class AXFPtrList : public std::list<void*> {
  typedef void (*ListFunc)(AXFPtrList* obj, void** args);

  AXFMutex m_listMutex;
  bool m_listMutexInited;
  AXFMutex* m_listMutexPtr;

 public:

  /**
   * @enum
   * @brief PtrListメソッド実行完了状態
   */
  enum {
    PTR_LIST_SUCCESS = 0,
    PTR_LIST_ERROR = -1,
    PTR_LIST_ERROR_NOT_FOUND = -2,
  };

  /**
   * @brief AXFPtrListコンストラクタ
   * @n     引数指定はテスト時のみ指定し、通常は指定しない
   * @n
   * @param [in] listMutexPtr リスト排他処理用のMutexクラス
   */
  AXFPtrList(AXFMutex* listMutexPtr = NULL);

  /**
   * @brief AXFPtrListデストラクタ
   */
  virtual ~AXFPtrList();

  /**
   * @brief init
   * @n     初期化
   * @n
   * @return 設定可否
   */
  virtual int init();

  virtual int lock();
  virtual int unlock();

  virtual int add(void* ptr, bool onlyOnce = false);
  virtual int del(void* ptr);
  virtual int delAll();

  int listWork(ListFunc func, void **args);

 private:

  static void listFuncAdd(AXFPtrList* obj, void** args);
  static void listFuncDel(AXFPtrList* obj, void** args);
  static void listFuncDelAll(AXFPtrList* obj, void** args);

};

#endif /* AXFPTRLIST_HPP_ */
