/**
 * @file   AXFRingBufInternal.hpp
 * @brief  AXFRingBufInternalクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFRINGBUFINTERNAL_HPP_
#define AXFRINGBUFINTERNAL_HPP_

#include "AXCRingBuf.hpp"
#include "AXFMutex.hpp"

class AXFConditionVariableInternal;

/**
 * @class AXFRingBufInternal
 * @brief AXFログ送受信スレッドクラス(AXFLogTask)に対し、
 *        リング・バッファ機能を提供する
 *
 */
class AXFRingBufInternal : public AXCRingBuf {
  AXFMutex* m_mutex[ RINGBUF_RW_NUM ];
  AXFConditionVariableInternal* m_cond[ RINGBUF_RW_NUM ];

 public:
  /**
   * @brief AXFRingBufInternalコンストラクタ
   */
  AXFRingBufInternal(
    char* buf = NULL,
    int size = 0,
    AXFMutex* mutex_r = NULL,
    AXFMutex* mutex_w = NULL,
    AXFConditionVariableInternal* cond_r = NULL,
    AXFConditionVariableInternal* cond_w = NULL);

  /**
   * @brief AXFRingBufInternalデストラクタ
   */
  virtual ~AXFRingBufInternal();

  /**
   * @brief 初期化
   * @return AXFRingBufInternal初期化状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus init();

  /**
   * @brief ロック
   * @param [in] rw リード・ライト指定
   * @return ロック状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus lock(ringBufRW rw);

  /**
   * @brief アンロック
   * @param [in] rw リード・ライト指定
   * @return アンロック状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus unlock(ringBufRW rw);

  /**
   * @brief ウエイト
   * @param [in] rw リード・ライト指定
   * @return ウエイト状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus waitFor(ringBufRW rw);

  /**
   * @brief シグナル発行
   * @param [in] rw リード・ライト指定
   * @return シグナル発行状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus signalTo(ringBufRW rw);
};

#endif /* AXFRINGBUFINTERNAL_HPP_ */
