/**
 * @file   AXScript.hpp
 * @brief  AXScriptクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXScript_HPP_
#define AXScript_HPP_

#include "AXFEvent.hpp"
#include "AXFStatus.hpp" //for ax::actorFuncStatus
#include "AXFActor.hpp"  // for AXFActor::actorState

/**
 * @struct axScriptCommand_t
 * @brief AXスクリプト・コマンド定義構造体
 */
struct axScriptCommand_t {
  INT32_t time;         ///< 時刻  @ToDo: AXFChrono で定義できるようにする
  const char* name;     ///< 対象アクタ名
  AXFEvent_t eventId;   ///< 対象イベントID
  void* pParam;         ///< 対象データ
  int size;             ///< 対象データサイズ
};

/**
 * @struct axScriptResult_t
 * @brief AXスクリプト・コマンド結果定義構造体
 */
struct axScriptResult_t {
  ax::actorFuncStatus handlerStatus;    ///< ハンドラ戻り値
  AXFActor::actorState lifeSycleStatus; ///< LifeCycle状態値
  INT32_t stateMachineStatus;           ///< StateMachine状態値
  // @ToDo 副作用
};

/**
 * @struct axScript_t
 * @brief AXスクリプト定義構造体
 */
struct axScript_t {
  struct axScriptCommand_t command; ///< コマンド
  struct axScriptResult_t result;   ///< 結果
};

#endif /* AXScript_HPP_ */
