/**
 * @file   AXHAperture.hpp
 * @brief  Header file of Aperture Class.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_APERTURE_H_
#define A_X_H_APERTURE_H_

/**
 * @class AXHAperture
 * @brief AXHAperture Class
 */
class AXHAperture {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 */
	AXHAperture();
	/**
	 * @brief  オブジェクトを開放する
	 */
	virtual ~AXHAperture();
private:
	const int			  REG_DATA_SIZE;
	const int			  TOTAL_GAIN_SHIFT;
	const int			  LIMIT_POSITIVE_SHIFT;
	const int			  HIGH_RANGE_GAIN_RATIO_SHIFT;
	const int			  LUT_3B_ON_SHIFT;
	const int			  CORING_TH_SHIFT;
	const unsigned int TOTAL_GAIN_CLEAR_MASK;
	const unsigned int LIMIT_POSITIVE_CLEAR_MASK;
	const unsigned int GAIN_RATIO_CLEAR_MASK;
	const unsigned int LUT_ACS_EDITON_VALUE;
	const unsigned int LUT_ACS_EDITOFF_VALUE;
	const unsigned int LUT_3B_CLEAR_MASK;
	const unsigned int CORING_TH_CLEAR_MASK;

public:
	/**
	 * @brief  トータルゲイン調整の設定を行う
	 *
	 * @param  [in]  totalgain                 トータルゲイン調整
	 */
	void			set_aperture_totalgain(unsigned char totalgain);
	/**
	 * @brief  正側・負側リミットの設定を行う
	 *
	 * @param  [in]  limitPositive             正側リミット
	 * @param  [in]  limitNegative             負側リミット
	 */
	void			set_aperture_plus_minus_limit(unsigned short limitPositive, unsigned short limitNegative);
	/**
	 * @brief  高域・中域ゲイン比率の設定を行う
	 *
	 * @param  [in]  highRangeRatio            高域ゲイン比率
	 * @param  [in]  midRangeRatio             中域ゲイン比率
	 */
	void			set_aperture_overmidrange_gainratio(unsigned char highRangeRatio, unsigned char midRangeRatio);
	/**
	 * @brief  lutの設定を行う
	 *
	 * @param  [in]  lut                       アパーチャ補正後変調ゲインLUT
	 * @param  [in]  size                      データ数
	 */
	void			set_aperture_lut(unsigned char* lut, int size);
	/**
	 * @brief  コアリングの設定を行う
	 *
	 * @param  [in]  coringTh                  コアリングしきい値
	 */
	void			set_aperture_coring(unsigned char coringTh);

#ifdef PARASOFT_CPPTEST
	unsigned int	CPPTEST_val;
#endif
};

#endif /* A_X_H_APERTURE_H_ */
