/*
 * @file   AXHChromaSuppress.cpp
 * @brief  Source file of ChromaSuppress settings.
 * @par    Programming Language
 *         C++
 */
#include "AXHChromaSuppress.hpp"
//#define CONNECT_TEST
#ifdef CONNECT_TEST
#include <iostream>
#endif
#include "AXHRegAddr.hpp"

const unsigned int SAC_C10_C1G2SL2_ON = (1<<14);
const unsigned int SAC_C20_C2G2SL2_ON = (1<<15);
const unsigned int LUT_3A_LPF_LL_ON   = (1<<7);

AXHChromaSuppress::AXHChromaSuppress() :
	  SAC_C10_C1G0SL_LUT3A_SHIFT (5)
	, SAC_C20_C2G0SL_LUT3A_SHIFT (6)
	, SAC_VAL10_C1G1_SHIFT       (8)
	, SAC_VAL20_C2G1_SHIFT       (8)
	, SAC_LUT3A_ON_VALUE         (3)
	, LUT_ACS_EDIT_ON_VALUE      (0x00000FFF)
	, LUT_ACS_EDIT_OFF_VALUE     (0x00000000)
	, LUT_3A_CLEAR_MASK          (0xFFFFFF1F)
	, SAC_C10_C1G0SL_CLEAR_MASK  (0xFFFDFF1F)	// 5:7&17bit目をクリア
	, SAC_C20_C2G0SL_CLEAR_MASK  (0xFFFBFE3F)	// 6:8&18bit目をクリア
	, SAC_VAL10_C1G1_CLEAR_MASK  (0xFFFF00FF)	// 8:15bit目をクリア
	, SAC_VAL20_C2G1_CLEAR_MASK  (0xFFFF00FF)	// 8:15bit目をクリア
{
	// TODO 自動生成されたコンストラクター・スタブ
	init();
}

void AXHChromaSuppress::init() {
	// 現状ハードとは異なるため不要
	/*
	p_RegSAC_C10   = (unsigned int*)AXH_SAC_C10;
	p_RegSAC_C20   = (unsigned int*)AXH_SAC_C20;
	p_RegSAC_C30   = (unsigned int*)AXH_SAC_C30;
	p_RegSAC_VAL10 = (unsigned int*)AXH_SAC_VAL10;
	p_RegSAC_VAL20 = (unsigned int*)AXH_SAC_VAL20;
	p_RegLUT_ACS   = (unsigned int*)AXH_LUT_ACS;
	p_RegLUT_H1    = (unsigned int*)AXH_LUT_H1_000;
	p_RegLUT_3A    = (unsigned int*)AXH_LUT_3A_000;
	*/
}

AXHChromaSuppress::~AXHChromaSuppress() {
	// TODO Auto-generated destructor stub
}

bool AXHChromaSuppress::set_chroma_lut(unsigned char* lut, int size) {
	// 現状ハードとは異なるため不要
	/*

	bool ret = false;
	unsigned int val = 0;
	if (lut == 0 || size <= 0) {
		return ret;
	}

	*p_RegLUT_ACS = LUT_ACS_EDIT_ON_VALUE;
#ifdef PARASOFT_CPPTEST
	CPPTEST_val1 = *p_RegLUT_ACS;
#endif

	for (int i = 0; i < size; i++) {
		p_RegLUT_3A[i] = (unsigned int)lut[i];
	}

	*p_RegLUT_ACS = LUT_ACS_EDIT_OFF_VALUE;

	val = *p_RegSAC_C30;

#ifdef PARASOFT_CPPTEST
	val = 0xFFFFFFFF;
#endif
	val &= LUT_3A_CLEAR_MASK;                  // bit(0start):5-7 clear
	val |= LUT_3A_LPF_LL_ON;                   // bit(0start):5-7 set "100"

	*p_RegSAC_C30 = val;

#ifdef CONNECT_TEST
	std::cout << "setLut:" << std::endl;
	for (int i = 0; i < size; i++) {
		std::cout << (unsigned int)lut[i] << std::endl;
	}
#endif
	*/

	return true;
}

void AXHChromaSuppress::set_chroma_luminanceModulation_signal_flow() {
	// 現状ハードとは異なるため不要
	/*

	unsigned int val = 0;

	val = *p_RegSAC_C10;
#ifdef PARASOFT_CPPTEST
	val = 0xFFFFFFFF;
#endif

	val &= SAC_C10_C1G0SL_CLEAR_MASK;
	val |= (SAC_LUT3A_ON_VALUE << SAC_C10_C1G0SL_LUT3A_SHIFT);

	*p_RegSAC_C10 = val;

	val = *p_RegSAC_C20;
#ifdef PARASOFT_CPPTEST
	val = 0xFFFFFFFF;
#endif

	val &= SAC_C20_C2G0SL_CLEAR_MASK;
	val |= (SAC_LUT3A_ON_VALUE << SAC_C20_C2G0SL_LUT3A_SHIFT);

	*p_RegSAC_C20 = val;
	*/

}

void AXHChromaSuppress::set_chroma_lowLuminance_gain_signal_flow(unsigned char gain) {
	// 現状ハードとは異なるため不要
	/*
	unsigned int val = 0;

	val = *p_RegSAC_VAL10;
#ifdef PARASOFT_CPPTEST
	val = 0xFFFFFFFF;
#endif

	val &= SAC_VAL10_C1G1_CLEAR_MASK;
	val |= (gain << SAC_VAL10_C1G1_SHIFT);

	*p_RegSAC_VAL10 = val;

	val = *p_RegSAC_VAL20;
	#ifdef PARASOFT_CPPTEST
	val = 0xFFFFFFFF;
#endif

	val &= SAC_VAL20_C2G1_CLEAR_MASK;
	val |= (gain << SAC_VAL20_C2G1_SHIFT);

	*p_RegSAC_VAL20 = val;
	*/
}

void AXHChromaSuppress::set_chroma_edge_signal_flow() {
	// 現状ハードとは異なるため不要
	/*

	unsigned int val = 0;

	val = *p_RegSAC_C10;
#ifdef PARASOFT_CPPTEST
	val = 0xFFFFBFFFul;
#endif

	val |= SAC_C10_C1G2SL2_ON;

	*p_RegSAC_C10 = val;

	val = *p_RegSAC_C20;
#ifdef PARASOFT_CPPTEST
	val = 0xFFFF7FFF;
#endif

	val |= SAC_C20_C2G2SL2_ON;

	*p_RegSAC_C20 = val;
	*/
}

bool AXHChromaSuppress::set_chroma_edge_lut(unsigned char* lut) {
	// 現状ハードとは異なるため不要
	/*

	bool ret = false;

	if (lut == 0) {
		return ret;
	}

	*p_RegLUT_ACS = LUT_ACS_EDIT_ON_VALUE;
#ifdef PARASOFT_CPPTEST
	CPPTEST_val1 = *p_RegLUT_ACS;
#endif

	for (int i = 0; i < 128; i++) {
		p_RegLUT_H1[i] = (unsigned int)lut[i];
	}

	*p_RegLUT_ACS = LUT_ACS_EDIT_OFF_VALUE;
#ifdef CONNECT_TEST
	std::cout << "setEdgeLut:" << std::endl;
	for (int i = 0; i < 128; i++) {
		std::cout << (unsigned int)lut[i] << std::endl;
	}
#endif
	*/

	return true;
}

