/**
 * @file   AXHMatrixGain.hpp
 * @brief  Header file of Matrix Gain Class
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_COMMON_PARAM_H
#define A_X_H_COMMON_PARAM_H

#include "AXHRegDefine.hpp"

const unsigned int AXHMatrixGainMax = 4;                    ///<  Matrixゲイン象限数
const unsigned int AXHMatrixOffsetMax = 3;                  ///<  Matrixオフセット数

//  [SPU_C]B18:DMAW0 out sel, B19:direct out sel
//const unsigned int AXH_RegSPU_C_MIX_CONTROL = 0x00080400ul;
//  [SPU_C]B18:DMAW0 out sel, B19:direct out sel
//const unsigned int AXH_RegSPU_C_SPU_CONTROL = 0x00040400ul;

//  [MIX_ACT]B31:Double buffer, B1:Direct入力画像設定 1: 長時間露光画像, B0:MIX動作の制御 1:ON
const unsigned int AXH_RegMIX_ACT_MIX_CONTROL_WDR    = 0x80000003ul;
//  [MIX_ACT]B31:Double buffer, B1:Direct入力画像設定 0: 短時間露光画像, B0:MIX動作の制御 1:ON
const unsigned int AXH_RegMIX_ACT_MIX_CONTROL_NORMAL = 0x80000001ul;
//  [MIX_ACT]B31:Double buffer, B1:Direct入力画像設定 1: 長時間露光画像, B0:MIX動作の制御 0:OFF
const unsigned int AXH_RegMIX_ACT_SPU_CONTROL        = 0x80000002ul;

const unsigned int PTN_SPU_DMAW0_FMT = 0x80000000ul;        ///<  Bayer 14bit出力
const unsigned int AXH_Image_Width_Init  = 1920;            ///<  入力画像サイズ初期値
const unsigned int AXH_Image_Height_Init = 1080;            ///<  出力画像サイズ初期値
const unsigned int AXH_Image_Len_Init    = AXH_Image_Width_Init * AXH_Image_Height_Init;


const unsigned short AXHMatrixGain_CSOS1 = 0x0080u;
const unsigned short AXHMatrixGain_CSOS2 = 0x0080u;
const unsigned int   AXHMatrixGain_CSBC  = 0x00300555ul;

const unsigned int    AXHMatrixGain_Error_Param = 0xFFFFFFFFul;
const unsigned short  AXH_RGBMatrix_Error_Param = 0xFFFFu;
const unsigned int    AXHLensShade_Error_Param  = 0xFFFFFFFFul;
const unsigned char   AXHNR_Error_Param         = 0xFFu;

//  レンズシェーディング補正初期値
const unsigned int AXHLensShade_RPU_C0        = 0xC0104084ul;
const unsigned int AXHLensShade_RPU_ID4       = 0x000040F7ul;
const unsigned int AXHLensShade_SPP_C         = 0x00001004ul;
const unsigned int AXHLensShade_SPP_C2        = 0x00000000ul;
const unsigned int AXHLensShade_RPU_DMAR1_FMT = 0x00018C00ul;
const unsigned int AXHLensShade_RPU_DMA_ACT   = 0x00000001ul;

//  Iridix初期値
const unsigned int AXHIridix_IrLen        = 1920ul | (1080ul << 16);
const unsigned int AXHIridix_IrDither     = 0x00000002ul;
const unsigned int AXHIridix_IrSlope      = 0x14404066ul;
const unsigned int AXHIridix_IrLevel      = 0x0000fffful;
const unsigned int AXHIridix_IrControl    = 0x00000607ul;
const unsigned int AXHIridix_IrStrength   = 0x00000303ul;
const unsigned int AXHIridix_IrRGGBStart  = 0x00000000ul;
const unsigned int AXHIridix_IrWBGain0    = 0x01000100ul;
const unsigned int AXHIridix_IrWBGain1    = 0x01000100ul;
const unsigned int AXHIridix_IrIFControl  = 0x00000000ul;
//  LUT_FI 初期値
const unsigned int AXHIridix_IrLutFiAdr = 0x00000000ul;
// WDRの再測定用にIRIDIXのLUT変更 Start
const unsigned int AXHIridix_IrLutFiData[] = {
    0x00000000ul, 0x00004BF0ul, 0x00006BF0ul, 0x000082E0ul,
    0x000092F0ul, 0x00009EC0ul, 0x0000A7C0ul, 0x0000AE60ul,
    0x0000B450ul, 0x0000B9B0ul, 0x0000BEA0ul, 0x0000C340ul,
    0x0000C780ul, 0x0000CB90ul, 0x0000CF60ul, 0x0000D300ul,
    0x0000D660ul, 0x0000D9B0ul, 0x0000DCD0ul, 0x0000DFD0ul,
    0x0000E2B0ul, 0x0000E580ul, 0x0000E830ul, 0x0000EAC0ul,
    0x0000ED50ul, 0x0000EFB0ul, 0x0000F210ul, 0x0000F460ul,
    0x0000F6A0ul, 0x0000F8C0ul, 0x0000FAE0ul, 0x0000FCF0ul,
    0x0000FF00ul,
  };
// WDRの再測定用にIRIDIXのLUT変更 End
const int AXHIridix_IrLutFiData_Num = 33;
//  FWD_PERCEPT_LUT 初期値
const unsigned int AXHIridix_IrFwdPerceptLutEn = 0x00000001ul;
const unsigned int AXHIridix_IrFwdPerceptLutAdr = 0x00000000ul;
const unsigned int AXHIridix_IrFwdPerceptLutData[] = {
    0x00000000ul, 0x00000400ul, 0x00000800ul, 0x00000C00ul,
    0x00001000ul, 0x00001400ul, 0x00001800ul, 0x00001C00ul,
    0x00002000ul, 0x00002400ul, 0x00002800ul, 0x00002C00ul,
    0x00003000ul, 0x00003400ul, 0x00003800ul, 0x00003C00ul,
    0x00004000ul, 0x00004400ul, 0x00004800ul, 0x00004C00ul,
    0x00005000ul, 0x00005400ul, 0x00005800ul, 0x00005C00ul,
    0x00006000ul, 0x00006400ul, 0x00006800ul, 0x00006C00ul,
    0x00007000ul, 0x00007400ul, 0x00007800ul, 0x00007C00ul,
    0x00008000ul, 0x00008400ul, 0x00008800ul, 0x00008C00ul,
    0x00009000ul, 0x00009400ul, 0x00009800ul, 0x00009C00ul,
    0x0000A000ul, 0x0000A400ul, 0x0000A800ul, 0x0000AC00ul,
    0x0000B000ul, 0x0000B400ul, 0x0000B800ul, 0x0000BC00ul,
    0x0000C000ul, 0x0000C400ul, 0x0000C800ul, 0x0000CC00ul,
    0x0000D000ul, 0x0000D400ul, 0x0000D800ul, 0x0000DC00ul,
    0x0000E000ul, 0x0000E400ul, 0x0000E800ul, 0x0000EC00ul,
    0x0000F000ul, 0x0000F400ul, 0x0000F800ul, 0x0000FC00ul,
    0x0000FFFFul,
  };
const int AXHIridix_IrFwdPerceptLutData_Num = 65;
//  REV_PERCEPT_LUT 初期値
const unsigned int AXHIridix_IrRevPerceptLutEn = 0x00000001ul;
const unsigned int AXHIridix_IrRevPerceptLutAdr = 0x00000000ul;
const unsigned int AXHIridix_IrRevPerceptLutData[] = {
    0x00000000ul, 0x00000400ul, 0x00000800ul, 0x00000C00ul,
    0x00001000ul, 0x00001400ul, 0x00001800ul, 0x00001C00ul,
    0x00002000ul, 0x00002400ul, 0x00002800ul, 0x00002C00ul,
    0x00003000ul, 0x00003400ul, 0x00003800ul, 0x00003C00ul,
    0x00004000ul, 0x00004400ul, 0x00004800ul, 0x00004C00ul,
    0x00005000ul, 0x00005400ul, 0x00005800ul, 0x00005C00ul,
    0x00006000ul, 0x00006400ul, 0x00006800ul, 0x00006C00ul,
    0x00007000ul, 0x00007400ul, 0x00007800ul, 0x00007C00ul,
    0x00008000ul, 0x00008400ul, 0x00008800ul, 0x00008C00ul,
    0x00009000ul, 0x00009400ul, 0x00009800ul, 0x00009C00ul,
    0x0000A000ul, 0x0000A400ul, 0x0000A800ul, 0x0000AC00ul,
    0x0000B000ul, 0x0000B400ul, 0x0000B800ul, 0x0000BC00ul,
    0x0000C000ul, 0x0000C400ul, 0x0000C800ul, 0x0000CC00ul,
    0x0000D000ul, 0x0000D400ul, 0x0000D800ul, 0x0000DC00ul,
    0x0000E000ul, 0x0000E400ul, 0x0000E800ul, 0x0000EC00ul,
    0x0000F000ul, 0x0000F400ul, 0x0000F800ul, 0x0000FC00ul,
    0x0000FFFFul,
  };
const int AXHIridix_IrRevPerceptLutData_Num = 65;

//  3DNR
const unsigned int AXHNR_HLen  = 0x00000000ul;
const unsigned int AXHNR_VLen  = 0x00020000ul;
const unsigned int AXHNR_Blank = 0x00000000ul;

const unsigned int AXH_AUDIO_HOST_RES_ID_GDU_CMD           = 0x00000001ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG0_GDU_START       = 0x00000001ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG1_GDU_START       = 0x00000000ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG2_GDU_START       = 0x00000000ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG3_GDU_START       = 0x00000000ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG0_GDU_BANK_SWITCH = 0x00000003ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG1_GDU_BANK_SWITCH = 0x00000000ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG2_GDU_BANK_SWITCH = 0x00000000ul;
const unsigned int AXH_AUDIO_HOST_RES_ARG3_GDU_BANK_SWITCH = 0x00000000ul;

#endif  //  A_X_H_COMMON_PARAM_H
