/*
 * @file   AXHIridix.cpp
 * @brief  Source file of Iridix Class
 * @par    Programming Language
 *         C++
 */

#include "AXHIridix.hpp"
#include "AXHRegAddr.hpp"
#include "AXHCommonParam.hpp"


#define MASK_STRENGTH 0x000000FFul
#define MASK_MINSLOPE 0x00FF0000ul
#define MASK_MAXSLOPE 0x0000FF00ul
#define MASK_VARIANCE 0xFF000000ul
#define MASK_UCHAR    0x000000FFul

#define SFT_MINSLOPE  16ul
#define SFT_MAXSLOPE  8ul
#define SFT_VARIANCE  24ul

AXHIridix::AXHIridix() {
	// 現状ハードとは異なるため不要
	/*
  p_IrLen               = (unsigned int *)AXH_IR_LEN;
  p_IrDither            = (unsigned int *)AXH_IR_DITHER;
  p_IrSlope             = (unsigned int *)AXH_IR_SLOPE;
  p_IrLevel             = (unsigned int *)AXH_IR_LEVEL;
  p_IrControl           = (unsigned int *)AXH_IR_CONTROL;
  p_IrStrength          = (unsigned int *)AXH_IR_STRENGTH;
  p_IrLutFiAdr          = (unsigned int *)AXH_IR_LUT_FI_ADR;
  p_IrLutFiData         = (unsigned int *)AXH_IR_LUT_FI_DATA;
  p_IrFwdPerceptLutEn   = (unsigned int *)AXH_IR_FWD_PERCEPT_LUT_EN;
  p_IrFwdPerceptLutAdr  = (unsigned int *)AXH_IR_FWD_PERCEPT_LUT_ADR;
  p_IrFwdPerceptLutData = (unsigned int *)AXH_IR_FWD_PERCEPT_LUT_DATA;
  p_IrRevPerceptLutEn   = (unsigned int *)AXH_IR_REV_PERCEPT_LUT_EN;
  p_IrRevPerceptLutAdr  = (unsigned int *)AXH_IR_REV_PERCEPT_LUT_ADR;
  p_IrRevPerceptLutData = (unsigned int *)AXH_IR_REV_PERCEPT_LUT_DATA;
  p_IrRGGBStart         = (unsigned int *)AXH_IR_RGGB_START;
  p_IrWBGain0           = (unsigned int *)AXH_IR_WBGAIN0;
  p_IrWBGain1           = (unsigned int *)AXH_IR_WBGAIN1;
  p_IrIFControl         = (unsigned int *)AXH_IR_IFCONTROL;

  Strength = (*p_IrStrength & MASK_STRENGTH);
  MinSlope = ((*p_IrSlope >> SFT_MINSLOPE) & MASK_UCHAR);
  MaxSlope = ((*p_IrSlope >> SFT_MAXSLOPE) & MASK_UCHAR);
  Variance = ((*p_IrSlope >> SFT_VARIANCE) & MASK_UCHAR);
	*/
}

AXHIridix::~AXHIridix() {
}

unsigned char AXHIridix::getStrength() {
	// 現状ハードとは異なるため不要
	/*
  return (unsigned char)Strength;
	*/
	return 0;
}

void AXHIridix::setStrength(unsigned char strength) {
	// 現状ハードとは異なるため不要
	/*
  Strength = (unsigned int)strength;
	*/
}

unsigned char AXHIridix::getMinSlope() {
	// 現状ハードとは異なるため不要
	/*
  return (unsigned char)MinSlope;
	*/
	return 0;
}

void AXHIridix::setMinSlope(unsigned char minSlope) {
	// 現状ハードとは異なるため不要
	/*
  MinSlope = (unsigned int)minSlope;
	*/
}

unsigned char AXHIridix::getMaxSlope() {
	// 現状ハードとは異なるため不要
	/*
  return (unsigned char)MaxSlope;
	*/
	return 0;
}

void AXHIridix::setMaxSlope(unsigned char maxSlope) {
	// 現状ハードとは異なるため不要
	/*
  MaxSlope = (unsigned int)maxSlope;
	*/
}

unsigned char AXHIridix::getVariance() {
	// 現状ハードとは異なるため不要
	/*
  return Variance;
	*/
	return 0;
}

void AXHIridix::setVariance(unsigned char variance) {
	// 現状ハードとは異なるため不要
	/*
  Variance = variance;
	*/
}

void AXHIridix::Execute(AXH_IRIDIX_MODE mode, unsigned short width, unsigned short height) {
	// 現状ハードとは異なるため不要
	/*
  unsigned int tmp;

  *p_IrLen       = ((unsigned int)width) | (((unsigned int)height) << 16);
  *p_IrDither    = AXHIridix_IrDither;
  tmp            = (AXHIridix_IrSlope & ~(MASK_VARIANCE | MASK_MINSLOPE | MASK_MAXSLOPE));
  tmp           |= (Variance << SFT_VARIANCE) | (MinSlope << SFT_MINSLOPE) | (MaxSlope << SFT_MAXSLOPE);
  *p_IrSlope     = tmp;
  *p_IrLevel     = AXHIridix_IrLevel;
  *p_IrControl   = AXHIridix_IrControl;
  *p_IrStrength  = (AXHIridix_IrStrength & ~MASK_STRENGTH) | Strength;
  *p_IrRGGBStart = AXHIridix_IrRGGBStart;
  *p_IrWBGain0   = AXHIridix_IrWBGain0;
  *p_IrWBGain1   = AXHIridix_IrWBGain1;
  *p_IrIFControl = AXHIridix_IrIFControl;
  //  ルックアップテーブルの設定は起動時のみ行う
  if(mode == ::AXH_Iridix_Mode_Init) {
    //  LUT_FI 設定
    *p_IrLutFiAdr  = AXHIridix_IrLutFiAdr;
    for(int i = 0; i < AXHIridix_IrLutFiData_Num; i++) {
      *p_IrLutFiData  = AXHIridix_IrLutFiData[i];
    }
    //  FWD_PERCEPT_LUT 設定
    *p_IrFwdPerceptLutEn = AXHIridix_IrFwdPerceptLutEn;
    *p_IrFwdPerceptLutAdr = AXHIridix_IrFwdPerceptLutAdr;
    for(int i = 0; i < AXHIridix_IrFwdPerceptLutData_Num; i++) {
      *p_IrFwdPerceptLutData = AXHIridix_IrFwdPerceptLutData[i];
    }
    //  REV_PERCEPT_LUT 設定
    *p_IrRevPerceptLutEn = AXHIridix_IrRevPerceptLutEn;
    *p_IrRevPerceptLutAdr = AXHIridix_IrRevPerceptLutAdr;
    for(int i = 0; i < AXHIridix_IrRevPerceptLutData_Num; i++) {
      *p_IrRevPerceptLutData = AXHIridix_IrRevPerceptLutData[i];
    }
  }
	*/
}
