/*
 * @file   AXHOpdConfigBase.cpp
 * @brief  Source file of base class of OPD Config class.
 * @par    Programming Language
 *         C++
 */

#include "AXHCommonParam.hpp"
#include "AXHOpdConfigBase.hpp"
#include "AXHOpdCommon.hpp"
#include "AXHRegAddr.hpp"
#include "AXHRegDefine.hpp"
#include "AXHPixcessorMemConfig.hpp"
//#define CONNECT_TEST
#ifdef CONNECT_TEST
#include <iostream>
#endif


const unsigned char AXH_OpdConfig_DMAW0_SEL_SPU  = 0x01u;
const unsigned char AXH_OpdConfig_DRAM_SEL_IMG_1 = 0x02u;

extern unsigned char g_picNum;
//static unsigned char g_PicNum = 0;
static unsigned int  g_ImgAddr = 0;                         //  画像出力先アドレス
static unsigned int  g_ImgAddr_Prev = 0;                    //  画像出力先アドレス(前回値)

AXHOpdConfigBase::AXHOpdConfigBase() {
	// 現状ハードとは異なるため不要
	/*
  OpdMode = 0;
  VerDiv = 0;
  HorDiv = 0;
  VerWSize = 0;
  HorWSize = 0;
  Init();
	*/
}

AXHOpdConfigBase::AXHOpdConfigBase(int opdMode, int horDiv, int verDiv, int horWSize, int verWSize){
	// 現状ハードとは異なるため不要
	/*
  this->OpdMode = opdMode;
  this->HorDiv = horDiv;
  this->VerDiv = verDiv;
  this->HorWSize = horWSize;
  this->VerWSize = verWSize;
  Init();
	*/
}

AXHOpdConfigBase::~AXHOpdConfigBase() {
}

void AXHOpdConfigBase::Init() {
	// 現状ハードとは異なるため不要
	/*
  Width = 0;
  Height = 0;
  m_linearMode = 1;
  m_shadeMode  = false;
  p_RegAVEVER_MODE_SEL = (unsigned int *)AXH_RegAVEVER_MODE_SEL;
  p_RegAVEVER_W_NUM    = (unsigned int *)AXH_RegAVEVER_W_NUM;
  p_RegAVEVER_W_SIZE   = (unsigned int *)AXH_RegAVEVER_W_SIZE;
  p_RegSPU_C           = (unsigned int *)AXH_RegSPU_C;
  p_RegSPU_DMAW0_LEN   = (unsigned int *)AXH_RegSPU_DMAW0_LEN;
  p_RegSPU_DMAW1_LEN   = (unsigned int *)AXH_RegSPU_DMAW1_LEN;
  p_RegSPU_DMAW0_OFS   = (unsigned int *)AXH_RegSPU_DMAW0_OFS;
  p_RegSPU_DMAW1_OFS   = (unsigned int *)AXH_RegSPU_DMAW1_OFS;
  p_RegMIX_ACT         = (unsigned int *)AXH_RegMIX_ACT;
	*/
}

void AXHOpdConfigBase::setImageWidth(unsigned int width) {
	// 現状ハードとは異なるため不要
	/*
  Width = width;
	*/
}

void AXHOpdConfigBase::setImageHeight(unsigned int height) {
	// 現状ハードとは異なるため不要
	/*
  Height = height;
	*/
}

void AXHOpdConfigBase::setImageSize(bool shadeMode) {
	// 現状ハードとは異なるため不要
	/*
  if(shadeMode == false) {
    if (m_linearMode == 1) {
      *p_RegSPU_DMAW0_LEN = (PTN_SPU_DMAW0_FMT | (Width * Height));
    }
    else {
      *p_RegSPU_DMAW0_LEN = (Width * Height);
    }
    //*p_RegSPU_DMAW0_LEN = (Width * Height);
  }
  else {
    *p_RegSPU_DMAW0_LEN = (PTN_SPU_DMAW0_FMT | (Width * Height));
  }
  m_shadeMode = shadeMode;
	*/
}

void AXHOpdConfigBase::setImageSize(unsigned int width, unsigned int height, bool shadeMode) {
	// 現状ハードとは異なるため不要
	/*
  setImageWidth(width);
  setImageHeight(height);
  setImageSize(shadeMode);
	*/
}

void AXHOpdConfigBase::setOpdMode(int opdMode) {
	// 現状ハードとは異なるため不要
	/*
  this->OpdMode = opdMode;
	*/
}

int AXHOpdConfigBase::getOpdMode() {
	// 現状ハードとは異なるため不要
	/*
  return this->OpdMode;
	*/
	return 0;
}

void AXHOpdConfigBase::setVerDiv(int verDiv) {
	// 現状ハードとは異なるため不要
	/*
  this->VerDiv = verDiv;
	*/
}

int AXHOpdConfigBase::getVerDiv() {
	// 現状ハードとは異なるため不要
	/*
  return this->VerDiv;
	*/
	return 0;
}

void AXHOpdConfigBase::setHorDiv(int horDiv) {
	// 現状ハードとは異なるため不要
	/*
  this->HorDiv = horDiv;
	*/
}

int AXHOpdConfigBase::getHorDiv() {
	// 現状ハードとは異なるため不要
	/*
  return this->HorDiv;
	*/
	return 0;
}

void AXHOpdConfigBase::setVerWSize(int verWSize) {
	// 現状ハードとは異なるため不要
	/*
  this->VerWSize = verWSize;
	*/
}

int AXHOpdConfigBase::getVerWSize() {
	// 現状ハードとは異なるため不要
	/*
  return this->VerWSize;
	*/
	return 0;
}

void AXHOpdConfigBase::setHorWSize(int horWSize) {
	// 現状ハードとは異なるため不要
	/*
  this->HorWSize = horWSize;
	*/
}

int AXHOpdConfigBase::getHorWSize() {
	// 現状ハードとは異なるため不要
	/*
  return this->HorWSize;
	*/
	return 0;
}

void AXHOpdConfigBase::setOpdConfig(int cmd) {
	// 現状ハードとは異なるため不要
	/*
  *p_RegAVEVER_MODE_SEL = OpdMode;
  *p_RegAVEVER_W_NUM = (VerDiv << 8) | HorDiv;
  *p_RegAVEVER_W_SIZE = (VerWSize << 16) | HorWSize;
  *p_RegSPU_DMAW1_LEN = (VerDiv * HorDiv * 6); // spu_dmaw1_len_r
  switch(cmd) {
    case AXH_Cmd_Get_Opd_AWB_0:         //  AWB 短時間画像用格納先アドレス設定
      *p_RegSPU_DMAW1_OFS = AXH_SPAD_OFST_IMG_AWB_0; // spu_dmaw1_ofs_r (*)
      break;
    case AXH_Cmd_Get_Opd_AWB_1:         //  AWB 長時間画像用格納先アドレス設定
      *p_RegSPU_DMAW1_OFS = AXH_SPAD_OFST_IMG_AWB_1; // spu_dmaw1_ofs_r (*)
      break;
    case AXH_Cmd_Get_Opd_AE0_0:         //  AE 短時間画像0用格納先アドレス設定
      *p_RegSPU_DMAW1_OFS = AXH_SPAD_OFST_IMG_AE0_0; // spu_dmaw1_ofs_r (*)
      break;
    case AXH_Cmd_Get_Opd_AE0_1:         //  AE 短時間画像1用格納先アドレス設定
      *p_RegSPU_DMAW1_OFS = AXH_SPAD_OFST_IMG_AE0_1; // spu_dmaw1_ofs_r (*)
      break;
    case AXH_Cmd_Get_Opd_AE1_0:         //  AE 長時間画像0用格納先アドレス設定
      *p_RegSPU_DMAW1_OFS = AXH_SPAD_OFST_IMG_AE1_0; // spu_dmaw1_ofs_r (*)
      break;
    case AXH_Cmd_Get_Opd_AE1_1:         //  AE 長時間画像1用格納先アドレス設定
      *p_RegSPU_DMAW1_OFS = AXH_SPAD_OFST_IMG_AE1_1; // spu_dmaw1_ofs_r (*)
      break;
    default:                            //  AE 短時間画像0用格納先アドレス設定
      *p_RegSPU_DMAW1_OFS = AXH_SPAD_OFST_IMG_AE0_0; // spu_dmaw1_ofs_r (*)
      break;
  }
	*/
}

void AXHOpdConfigBase::setLinearMode(unsigned char linearMode) {
	// 現状ハードとは異なるため不要
	/*
  if (m_linearMode == linearMode) {
	  return;
  }
  m_linearMode = linearMode;
  if (m_linearMode == 1) {
//    g_PicNum = IMAGE_IF_LINEAR_INIT_PIC_NUM;
    *p_RegMIX_ACT = 0;
    *p_RegSPU_DMAW0_LEN |= PTN_SPU_DMAW0_FMT;
  }
  else {
//    g_PicNum = IMAGE_IF_WDR_INIT_PIC_NUM;
    if (m_shadeMode == false) {
      *p_RegSPU_DMAW0_LEN &= ~PTN_SPU_DMAW0_FMT;
    }
  }
	*/
}

void AXHOpdConfigBase::setOpdConfig(int cmd, int wdrMode) {
	// 現状ハードとは異なるため不要
	/*
  setOpdConfig(cmd);

  g_ImgAddr_Prev = g_ImgAddr;
  //  OPDの設定に同期して画像出力設定するように、
  //  カウンタ値のみオブジェクト内でカウントし
  //  サンプルプログラムのimageif_enc_pic_start()関数の処理をそのまま利用
//  g_PicNum++;
  // バンク切り替えカウンタ値を取得
  unsigned char PicNum = g_picNum;
#ifdef PARASOFT_CPPTEST
  CPPTEST_checkValue = PicNum;
#endif // PARASOFT_CPPTEST
#ifdef CONNECT_TEST
	std::cout << "AXHOpdConfigBase:" << (int)PicNum << std::endl;
#endif


  if (m_linearMode == 0) {
    //  WDR mode
    if((PicNum & AXH_OpdConfig_DMAW0_SEL_SPU) == AXH_OpdConfig_DMAW0_SEL_SPU) {
      //  SPU Control
      *p_RegSPU_C &= ~AXH_BIT_SPU_C_RPULNKEN;
      *p_RegSPU_C |= (AXH_BIT_SPU_C_DMAW0SEL | AXH_BIT_SPU_C_CPEN);               //  0x00040400

      g_ImgAddr = AXH_DRAM_OFST_IMG_SPU_0;
      *p_RegSPU_DMAW0_OFS = g_ImgAddr;

      *p_RegMIX_ACT = AXH_RegMIX_ACT_SPU_CONTROL;
    }
    else {
      //  MIX Control
      *p_RegSPU_C &= ~AXH_BIT_SPU_C_DMAW0SEL;
      *p_RegSPU_C |= (AXH_BIT_SPU_C_RPULNKEN | AXH_BIT_SPU_C_CPEN);               //  0x0080400
      if((PicNum & AXH_OpdConfig_DRAM_SEL_IMG_1) == AXH_OpdConfig_DRAM_SEL_IMG_1) {
        g_ImgAddr = AXH_DRAM_OFST_IMG_MIX_1;
      }
      else {
        g_ImgAddr = AXH_DRAM_OFST_IMG_MIX_0;
      }
      *p_RegSPU_DMAW0_OFS = g_ImgAddr;

      if(wdrMode) {
        *p_RegMIX_ACT = AXH_RegMIX_ACT_MIX_CONTROL_WDR;
      } else {
        *p_RegMIX_ACT = AXH_RegMIX_ACT_MIX_CONTROL_NORMAL;
      }
    }
  }
  else {
    //  Linear mode
    *p_RegSPU_C = (AXH_BIT_SPU_C_DMAW0SEL | AXH_BIT_SPU_C_CPEN);
    if (PicNum & 0x01) {
      g_ImgAddr = AXH_DRAM_OFST_IMG_SPU_0;
    }
    else {
      g_ImgAddr = AXH_DRAM_OFST_IMG_SPU_1;
    }
    *p_RegSPU_DMAW0_OFS = g_ImgAddr;
  }
	*/
}

unsigned char* AXHOpdConfigBase::getImageAddr() {
	// 現状ハードとは異なるため不要
	/*
  return (unsigned char*)g_ImgAddr_Prev;                    //  更新済み画像データアドレスをリターン
	*/
	return 0;
}
