/*
 * @file   AXHRegDummy.hpp
 * @brief  Header file of Dummy Register
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_REGDUMMY_H
#define A_X_H_REGDUMMY_H

#include "AXHSpecParam.hpp"

/*
 * @brief RegSPU_DMAR1_OFS
 * @n SPU/MIXデータオフセット設定(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegSPU_DMAR1_OFS;
/*
 * @brief RegSPU_DMAW0_OFS
 * @n SPU/MIXデータオフセット設定(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegSPU_DMAW0_OFS;
/*
 * @brief RegSPU_DMAW1_OFS
 * @n 3Aデータオフセット設定(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegSPU_DMAW1_OFS;
/*
 * @brief RegSPU_DMAW0_LEN
 * @n センサ画像データ長設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegSPU_DMAW0_LEN;
/*
 * @brief RegSPU_DMAW1_LEN
 * @n 3Aデータ長設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegSPU_DMAW1_LEN;
/*
 * @brief RegAVEVER_MODE_SEL
 * @n モード設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegAVEVER_MODE_SEL;
/*
 * @brief RegAVEVER_W_NUM
 * @n 分割画素数設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegAVEVER_W_NUM;
/*
 * @brief RegAVEVER_W_SIZE
 * @n 分割画素サイズ設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegAVEVER_W_SIZE;
/*
 * @brief RegMIX_ACT
 * @n MIX画像設定(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegMIX_ACT;
/*
 * @brief RegSPU_C
 * @n SPUコントロールレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegSPU_C;
/*
 * @brief RegC0CS_L
 * @n Color Select Timing Lowレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegC0CS_L;
/*
 * @brief RegC0CS_H
 * @n Color Select Timing Highレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegC0CS_H;
/*
 * @brief DL0-7
 * @n 黒レベル補正値(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegDL[8];
/*
 * @brief REG_WB0
 * @n WB Rゲイン設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int REG_WB0;
/*
 * @brief REG_WB2
 * @n WB Bゲイン設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int REG_WB2;
/*
 * @brief RegCOLOR_TMG
 * @n WB Color Select Timingレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegCOLOR_TMG;
/*
 * @brief RegDEFCT_C
 * @n 欠陥補正制御レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegDEFCT_C;
/*
 * @brief RegCDEF
 * @n 欠陥画素設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegCDEF[AXH_Defect_IntAddr_Max];
/*
 * @brief RegOBEAH
 * @n OBサンプリング領域幅レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegOBEAH;
/*
 * @brief RegOBEAV
 * @n OBサンプリング領域高さレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegOBEAV;
/*
 * @brief RegOBCRR0
 * @n OB積算値0(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegOBCRR0;
/*
 * @brief RegOBCRR1
 * @n OB積算値1(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegOBCRR1;
/*
 * @brief RegOBCRR2
 * @n OB積算値2(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegOBCRR2;
/*
 * @brief RegOBCRR3
 * @n OB積算値3(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegOBCRR3;
/*
 * @brief RegADFCTTH_H
 * @n 白点画素検出しきい値設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegADFCTTH_H;
/*
 * @brief RegADFCTTH_L
 * @n 黒点画素検出しきい値設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegADFCTTH_L;
/*
 * @brief RegADFOFS
 * @n 輝度信号レベル変調設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RegADFOFS[AXH_Defect_ADFOFS_Max];
/*
 * @brief RPU_C0
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int RPU_C0;
/*
 * @brief RPU_ID4
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int RPU_ID4;
/*
 * @brief SPP_C
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SPP_C;
/*
 * @brief SPP_C2
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SPP_C2;
/*
 * @brief SPP_SHT1
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SPP_SHT1;
/*
 * @brief LMCF00
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF00;
/*
 * @brief LMCF01
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF01;
/*
 * @brief LMCF02
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF02;
/*
 * @brief LMCF03
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF03;
/*
 * @brief LMCF10
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF10;
/*
 * @brief LMCF11
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF11;
/*
 * @brief LMCF12
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF12;
/*
 * @brief LMCF13
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF13;
/*
 * @brief LMCF20
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF20;
/*
 * @brief LMCF21
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF21;
/*
 * @brief LMCF22
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF22;
/*
 * @brief LMCF23
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF23;
/*
 * @brief LMCF30
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF30;
/*
 * @brief LMCF31
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF31;
/*
 * @brief LMCF32
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF32;
/*
 * @brief LMCF33
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMCF33;
/*
 * @brief LMOF0
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMOF0;
/*
 * @brief LMOF1
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMOF1;
/*
 * @brief LMOF2
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMOF2;
/*
 * @brief LMOF3
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMOF3;
/*
 * @brief LMCF03
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LMBC;
/*
 * @brief SAC_C10
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SAC_C10;
/*
 * @brief SAC_C20
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SAC_C20;
/*
 * @brief SAC_C30
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SAC_C30;
/*
 * @brief SAC_VAL10
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SAC_VAL10;
/*
 * @brief SAC_VAL20
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SAC_VAL20;
/*
 * @brief SAC_VAL30
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int SAC_VAL30;
/*
 * @brief LUT_ACS
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int LUT_ACS;
/*
 * @brief RSZ_C0
 * @n C0設定レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RSZ_C0;
/*
 * @brief RG_RZ_CSCF22
 * @n Crゲイン設定(第一象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCF22;
/*
 * @brief RG_RZ_CSCFB22
 * @n Crゲイン設定(第二象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFB22;
/*
 * @brief RG_RZ_CSCFC22
 * @n Crゲイン設定(第三象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFC22;
/*
 * @brief RG_RZ_CSCFD22
 * @n Crゲイン設定(第四象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFD22;
/*
 * @brief RG_RZ_CSCF11
 * @n Cbゲイン設定(第一象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCF11;
/*
 * @brief　RG_RZ_CSCFB11
 * @n Cbゲイン設定(第二象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFB11;
/*
 * @brief RG_RZ_CSCFC11
 * @n Cbゲイン設定(第三象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFC11;
/*
 * @brief RG_RZ_CSCFD11
 * @n Cbゲイン設定(第四象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFD11;
/*
 * @brief RG_RZ_CSCF21
 * @n Crゲイン設定(第一象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCF21;
/*
 * @brief RG_RZ_CSCFB21
 * @n Crゲイン設定(第二象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFB21;
/*
 * @brief RG_RZ_CSCFB21
 * @n Crゲイン設定(第三象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFC21;
/*
 * @brief RG_RZ_CSCFD21
 * @n Crゲイン設定(第四象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFD21;
/*
 * @brief RG_RZ_CSCF12
 * @n Cbゲイン設定(第一象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCF12;
/*
 * @brief RG_RZ_CSCFB12
 * @n Cbゲイン設定(第二象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFB12;
/*
 * @brief RG_RZ_CSCFC12
 * @n Cbゲイン設定(第三象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFC12;
/*
 * @brief RG_RZ_CSCFD12
 * @n Cbゲイン設定(第四象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFD12;
/*
 * @brief RG_RZ_CSCF00
 * @n CSCゲイン(Yゲイン, 第一象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCF00;
/*
 * @brief RG_RZ_CSCFB00
 * @n CSCゲイン(Yゲイン, 第二象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFB00;
/*
 * @brief RG_RZ_CSCFC00
 * @n CSCゲイン(Yゲイン, 第三象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFC00;
/*
 * @brief RG_RZ_CSCFD00
 * @n CSCゲイン(Yゲイン, 第四象限)レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSCFD00;
/*
 * @brief RG_RZ_CSOS0
 * @n CSCオフセットレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSOS0;
/*
 * @brief RG_RZ_CSOS1
 * @n CSCオフセットレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSOS1;
/*
 * @brief RG_RZ_CSOS2
 * @n CSCオフセットレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSOS2;
/*
 * @brief RG_RZ_CSBC
 * @n CSCビットコントロールレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int RG_RZ_CSBC;
/*
 * @brief LUT_H1レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int LUT_H1[128];
/*
 * @brief LUT_3Aレジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int LUT_3A[256];
/*
 * @brief REG_ISP_SCL_CTLレジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_CTL;
/*
 * @brief REG_ISP_SCL_SATD8X8レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_SATD8X8;
/*
 * @brief REG_ISP_SCL_SRC0レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_SRC0;
/*
 * @brief REG_ISP_SCL_DST0レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DST0;
/*
 * @brief REG_ISP_SCL_DMA0レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DMA0;
/*
 * @brief REG_ISP_SCL_NEG_FLIP0レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_NEG_FLIP0;
/*
 * @brief REG_ISP_SCL_CLIP0レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_CLIP0;
/*
 * @brief REG_ISP_SCL_SRC1レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_SRC1;
/*
 * @brief REG_ISP_SCL_DST1レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DST1;
/*
 * @brief REG_ISP_SCL_DMA1レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DMA1;
/*
 * @brief REG_ISP_SCL_NEG_FLIP1レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_NEG_FLIP1;
/*
 * @brief REG_ISP_SCL_CLIP1レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_CLIP1;
/*
 * @brief REG_ISP_SCL_SRC2レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_SRC2;
/*
 * @brief REG_ISP_SCL_DST2レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DST2;
/*
 * @brief REG_ISP_SCL_DMA2レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DMA2;
/*
 * @brief REG_ISP_SCL_NEG_FLIP2レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_NEG_FLIP2;
/*
 * @brief REG_ISP_SCL_CLIP2レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_CLIP2;
/*
 * @brief REG_ISP_SCL_SRC3レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_SRC3;
/*
 * @brief REG_ISP_SCL_DMA3レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DMA3;
/*
 * @brief REG_ISP_SCL_NEG_FLIP3レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_NEG_FLIP3;
/*
 * @brief REG_ISP_SCL_CLIP3レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_CLIP3;
/*
 * @brief REG_ISP_SCL_SRC4レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_SRC4;
/*
 * @brief REG_ISP_SCL_DMA4レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DMA4;
/*
 * @brief REG_ISP_SCL_NEG_FLIP4レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_NEG_FLIP4;
/*
 * @brief REG_ISP_SCL_CLIP4レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_CLIP4;
/*
 * @brief REG_ISP_SCL_SRC5レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_SRC5;
/*
 * @brief REG_ISP_SCL_DST5レジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_DST5;
/*
 * @brief REG_ISP_SCL_IMGRAMレジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_IMGRAM;
/*
 * @brief REG_ISP_SCL_IMG_IDレジスタ(シミュレーター用ダミー変数)
 */
EXTERN unsigned int REG_ISP_SCL_IMG_ID;
/*
 * @brief IR_LEN
 * @n Frame Widthレジスタ
 * @n Frame Heightレジスタ
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_LEN;
/*
 * @brief IR_DITHER
 * @n Ditheringレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_DITHER;
/*
 * @brief IR_SLOPE
 * @n Variance controlレジスタ
 * @n Slope Min Limitレジスタ
 * @n Slope Max Limitレジスタ
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_SLOPE;
/*
 * @brief IR_LEVEL
 * @n Black Level/White Levelレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_LEVEL;
/*
 * @brief IR_CONTROL
 * @n iridix Control0/iridix Control1レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_CONTROL;
/*
 * @brief　IR_STRENGTH
 * @n iridix Strengthレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_STRENGTH;
/*
 * @brief　IR_LUT_FI_ADR
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_LUT_FI_ADR;
/*
 * @brief　IR_LUT_FI_DATA
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_LUT_FI_DATA;
/*
 * @brief　IR_FWD_PERCEPT_LUT_EN
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_FWD_PERCEPT_LUT_EN;
/*
 * @brief　IR_FWD_PERCEPT_LUT_ADR
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_FWD_PERCEPT_LUT_ADR;
/*
 * @brief　IR_FWD_PERCEPT_LUT_DATA
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_FWD_PERCEPT_LUT_DATA;
/*
 * @brief　IR_REV_PERCEPT_LUT_EN
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_REV_PERCEPT_LUT_EN;
/*
 * @brief　IR_REV_PERCEPT_LUT_ADR
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_REV_PERCEPT_LUT_ADR;
/*
 * @brief　IR_REV_PERCEPT_LUT_DATA
 * @n ルックアップテーブル(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_REV_PERCEPT_LUT_DATA;
/*
 * @brief IR_RGGB_START
 * @n xxxxレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_RGGB_START;
/*
 * @brief IR_WBGAIN0
 * @n xxxxレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_WBGAIN0;
/*
 * @brief IR_WBGAIN1
 * @n xxxxレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_WBGAIN1;
/*
 * @brief IR_IFCONTROL
 * @n xxxxレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int IR_IFCONTROL;
/*
 * @brief NR_HLEN
 * @n NR_HLENレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_HLEN;
/*
 * @brief NR_VLEN
 * @n NR_VLENレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_VLEN;
/*
 * @brief NR_BLANK
 * @n NR_BLANKレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_BLANK;
/*
 * @brief NR_EN
 * @n NR_ENレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_EN;
/*
 * @brief NR_MAIN_YTH0
 * @n NR_MAIN_YTH0レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YTH0;
/*
 * @brief NR_MAIN_YTH1
 * @n NR_MAIN_YTH1レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YTH1;
/*
 * @brief NR_MAIN_YTH2
 * @n NR_MAIN_YTH2レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YTH2;
/*
 * @brief NR_MAIN_YTH3
 * @n NR_MAIN_YTH3レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YTH3;
/*
 * @brief NR_MAIN_CTH0
 * @n NR_MAIN_CTH0レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CTH0;
/*
 * @brief　NR_MAIN_CTH1
 * @n NR_MAIN_CTH1レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CTH1;
/*
 * @brief　NR_MAIN_CTH2
 * @n NR_MAIN_CTH2レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CTH2;
/*
 * @brief　NR_MAIN_CTH3
 * @n NR_MAIN_CTH3レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CTH3;
/*
 * @brief　NR_MAIN_YIN0
 * @n NR_MAIN_YIN0レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YIN0;
/*
 * @brief　NR_MAIN_YIN1
 * @n NR_MAIN_YIN1レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YIN1;
/*
 * @brief　NR_MAIN_YIN2
 * @n NR_MAIN_YIN2レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YIN2;
/*
 * @brief　NR_MAIN_YIN3
 * @n NR_MAIN_YIN3レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YIN3;
/*
 * @brief　NR_MAIN_CIN0
 * @n NR_MAIN_CIN0レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CIN0;
/*
 * @brief　NR_MAIN_CIN1
 * @n NR_MAIN_CIN1レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CIN1;
/*
 * @brief　NR_MAIN_CIN2
 * @n NR_MAIN_CIN2レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CIN2;
/*
 * @brief　NR_MAIN_CIN3
 * @n NR_MAIN_CIN3レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CIN3;
/*
 * @brief　NR_SUB_YTH
 * @n NR_SUB_YTHレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_SUB_YTH;
/*
 * @brief　NR_SUB_CTH
 * @n NR_SUB_CTHレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_SUB_CTH;
/*
 * @brief　NR_SUB_YIN
 * @n NR_SUB_YIN(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_SUB_YIN;
/*
 * @brief　NR_SUB_CIN
 * @n NR_SUB_CIN(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_SUB_CIN;
/*
 * @brief　NR_MAIN_YLV0
 * @n NR_MAIN_YLV0レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YLV0;
/*
 * @brief　NR_MAIN_YLV1
 * @n NR_MAIN_YLV1レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YLV1;
/*
 * @brief　NR_MAIN_YLV2
 * @n NR_MAIN_YLV2レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YLV2;
/*
 * @brief　NR_MAIN_YLV3
 * @n NR_MAIN_YLV3レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_YLV3;
/*
 * @brief　NR_MAIN_CLV0
 * @n NR_MAIN_CLV0レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CLV0;
/*
 * @brief　NR_MAIN_CLV1
 * @n NR_MAIN_CLV1レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CLV1;
/*
 * @brief　NR_MAIN_CLV2
 * @n NR_MAIN_CLV2レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CLV2;
/*
 * @brief　NR_MAIN_CLV3
 * @n NR_MAIN_CLV3レジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_MAIN_CLV3;
  /*
   * @brief　NR_SUB_YLV
   * @n NR_SUB_YLVレジスタ(シミュレータ用ダミー変数)
   */
EXTERN unsigned int NR_SUB_YLV;
/*
 * @brief　NR_SUB_CLV
 * @n NR_SUB_CLVレジスタ(シミュレータ用ダミー変数)
 */
EXTERN unsigned int NR_SUB_CLV;
/*
 * @brief RPU_DMAR1_FMT
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int RPU_DMAR1_FMT;
/*
 * @brief　RPU_DMA_ACT
 * @n (シミュレータ用ダミー変数)
 */
EXTERN unsigned int RPU_DMA_ACT;

/*
 * @brief NR_DMAR_OFSシミュレーター用定義
 */
EXTERN unsigned int  NR_DMAR_OFS;
/*
 * @brief NR_ISP_MODEシミュレーター用定義
 */
EXTERN unsigned int  NR_ISP_MODE;
/*
 * @brief RPU_DMAR0_OFSシミュレーター用定義
 */
EXTERN unsigned int  RPU_DMAR0_OFS;
/*
 * @brief RPU_DMAW1_OFSシミュレーター用定義
 */
EXTERN unsigned int  RPU_DMAW1_OFS;
/*
 * @brief REG_AUDIO_HOST_RES_ID_REQシミュレーター用定義
 */
EXTERN unsigned int  REG_AUDIO_HOST_RES_ID_REQ;
/*
 * @brief REG_AUDIO_HOST_RES_ARG00シミュレーター用定義
 */
EXTERN unsigned int  REG_AUDIO_HOST_RES_ARG00;
/*
 * @brief REG_AUDIO_HOST_RES_ARG01シミュレーター用定義
 */
EXTERN unsigned int  REG_AUDIO_HOST_RES_ARG01;
/*
 * @brief REG_AUDIO_HOST_RES_ARG02シミュレーター用定義
 */
EXTERN unsigned int  REG_AUDIO_HOST_RES_ARG02;
/*
 * @brief REG_AUDIO_HOST_RES_ARG03シミュレーター用定義
 */
EXTERN unsigned int  REG_AUDIO_HOST_RES_ARG03;


#define AXH_RegMIX_ACT          &RegMIX_ACT

#define AXH_RegSPU_DMAR1_OFS    &RegSPU_DMAR1_OFS
#define AXH_RegSPU_DMAW0_OFS    &RegSPU_DMAW0_OFS
#define AXH_RegSPU_DMAW1_OFS    &RegSPU_DMAW1_OFS
#define AXH_RegSPU_DMAW0_LEN    &RegSPU_DMAW0_LEN
#define AXH_RegSPU_DMAW1_LEN    &RegSPU_DMAW1_LEN
#define AXH_RegAVEVER_MODE_SEL  &RegAVEVER_MODE_SEL
#define AXH_RegAVEVER_W_NUM     &RegAVEVER_W_NUM
#define AXH_RegAVEVER_W_SIZE    &RegAVEVER_W_SIZE

#define AXH_RegSPU_C            &RegSPU_C
#define AXH_RegC0CS_L           (&RegC0CS_L)
#define AXH_RegC0CS_H           (&RegC0CS_H)
#define AXH_RegDL0              (&RegDL[0])
#define AXH_RegDL1              (&RegDL[1])
#define AXH_RegDL2              (&RegDL[2])
#define AXH_RegDL3              (&RegDL[3])
#define AXH_RegDL4              (&RegDL[4])
#define AXH_RegDL5              (&RegDL[5])
#define AXH_RegDL6              (&RegDL[6])
#define AXH_RegDL7              (&RegDL[7])
#define AXH_REG_WB0             &REG_WB0
#define AXH_REG_WB2             &REG_WB2
#define AXH_RegCOLOR_TMG        (&RegCOLOR_TMG)

#define AXH_RegCDEF0            &RegCDEF[0]
#define AXH_RegCDEF1            &RegCDEF[1]
#define AXH_RegCDEF2            &RegCDEF[2]
#define AXH_RegCDEF3            &RegCDEF[3]
#define AXH_RegCDEF4            &RegCDEF[4]
#define AXH_RegCDEF5            &RegCDEF[5]
#define AXH_RegCDEF6            &RegCDEF[6]
#define AXH_RegCDEF7            &RegCDEF[7]
#define AXH_RegCDEF8            &RegCDEF[8]
#define AXH_RegCDEF9            &RegCDEF[9]
#define AXH_RegCDEF10           &RegCDEF[10]
#define AXH_RegCDEF11           &RegCDEF[11]
#define AXH_RegCDEF12           &RegCDEF[12]
#define AXH_RegCDEF13           &RegCDEF[13]
#define AXH_RegCDEF14           &RegCDEF[14]
#define AXH_RegCDEF15           &RegCDEF[15]
#define AXH_RegOBEAH            (&RegOBEAH)
#define AXH_RegOBEAV            (&RegOBEAV)
#define AXH_RegOBCRR0           (&RegOBCRR0)
#define AXH_RegOBCRR1           (&RegOBCRR1)
#define AXH_RegOBCRR2           (&RegOBCRR2)
#define AXH_RegOBCRR3           (&RegOBCRR3)
#define AXH_RegDEFCT_C          &RegDEFCT_C
#define AXH_RegADFOFS_1A        &RegADFOFS[0]
#define AXH_RegADFOFS_2A        &RegADFOFS[1]
#define AXH_RegADFOFS_3A        &RegADFOFS[2]
#define AXH_RegADFOFS_4A        &RegADFOFS[3]
#define AXH_RegADFOFS_5A        &RegADFOFS[4]
#define AXH_RegADFOFS_6A        &RegADFOFS[5]
#define AXH_RegADFOFS_7A        &RegADFOFS[6]
#define AXH_RegADFOFS_8A        &RegADFOFS[7]
#define AXH_RegADFOFSZ          &RegADFOFSZ
#define AXH_RegADFCTTH          &RegADFCTTH
#define AXH_RegADFCTTH_H        &RegADFCTTH_H
#define AXH_RegADFCTTH_L        &RegADFCTTH_L
#define AXH_RegADFCTEGTH        &RegADFCTEGTH
#define AXH_RegADFCT_CT         &RegADFCT_CT

#define AXH_RPU_C0              &RPU_C0
#define AXH_RPU_ID4             &RPU_ID4
#define AXH_SPP_C               &SPP_C
#define AXH_SPP_C2              &SPP_C2
#define AXH_SPP_SHT1            &SPP_SHT1

#define AXH_LMCF00              &LMCF00
#define AXH_LMCF01              &LMCF01
#define AXH_LMCF02              &LMCF02
#define AXH_LMCF03              &LMCF03
#define AXH_LMCF10              &LMCF10
#define AXH_LMCF11              &LMCF11
#define AXH_LMCF12              &LMCF12
#define AXH_LMCF13              &LMCF13
#define AXH_LMCF20              &LMCF20
#define AXH_LMCF21              &LMCF21
#define AXH_LMCF22              &LMCF22
#define AXH_LMCF23              &LMCF23
#define AXH_LMCF30              &LMCF30
#define AXH_LMCF31              &LMCF31
#define AXH_LMCF32              &LMCF32
#define AXH_LMCF33              &LMCF33
#define AXH_LMOF0               &LMOF0
#define AXH_LMOF1               &LMOF1
#define AXH_LMOF2               &LMOF2
#define AXH_LMOF3               &LMOF3
#define AXH_LMBC                &LMBC
#define AXH_SAC_C10             (&SAC_C10)
#define AXH_SAC_C20             (&SAC_C20)
#define AXH_SAC_C30             (&SAC_C30)

#define AXH_SAC_VAL10           (&SAC_VAL10)
#define AXH_SAC_VAL20           (&SAC_VAL20)
#define AXH_SAC_VAL30           (&SAC_VAL30)

#define AXH_LUT_ACS             (&LUT_ACS)

#define AXH_RSZ_C0              &RSZ_C0
#define AXH_RG_RZ_CSCF00        &RG_RZ_CSCF00
#define AXH_RG_RZ_CSCF11        &RG_RZ_CSCF11
#define AXH_RG_RZ_CSCF12        &RG_RZ_CSCF12
#define AXH_RG_RZ_CSCF21        &RG_RZ_CSCF21
#define AXH_RG_RZ_CSCF22        &RG_RZ_CSCF22
#define AXH_RG_RZ_CSOS0         &RG_RZ_CSOS0
#define AXH_RG_RZ_CSOS1         &RG_RZ_CSOS1
#define AXH_RG_RZ_CSOS2         &RG_RZ_CSOS2
#define AXH_RG_RZ_CSBC          &RG_RZ_CSBC
#define AXH_RG_RZ_CSCFB00       &RG_RZ_CSCFB00
#define AXH_RG_RZ_CSCFB11       &RG_RZ_CSCFB11
#define AXH_RG_RZ_CSCFB12       &RG_RZ_CSCFB12
#define AXH_RG_RZ_CSCFB21       &RG_RZ_CSCFB21
#define AXH_RG_RZ_CSCFB22       &RG_RZ_CSCFB22
#define AXH_RG_RZ_CSCFC00       &RG_RZ_CSCFC00
#define AXH_RG_RZ_CSCFC11       &RG_RZ_CSCFC11
#define AXH_RG_RZ_CSCFC12       &RG_RZ_CSCFC12
#define AXH_RG_RZ_CSCFC21       &RG_RZ_CSCFC21
#define AXH_RG_RZ_CSCFC22       &RG_RZ_CSCFC22
#define AXH_RG_RZ_CSCFD00       &RG_RZ_CSCFD00
#define AXH_RG_RZ_CSCFD11       &RG_RZ_CSCFD11
#define AXH_RG_RZ_CSCFD12       &RG_RZ_CSCFD12
#define AXH_RG_RZ_CSCFD21       &RG_RZ_CSCFD21
#define AXH_RG_RZ_CSCFD22       &RG_RZ_CSCFD22

#define AXH_LUT_H1_000          (&LUT_H1[0])
#define AXH_LUT_3A_000          (&LUT_3A[0])

#define AXH_REG_ISP_SCL_CTL             (&REG_ISP_SCL_CTL)
#define AXH_REG_ISP_SCL_SATD8X8         (&REG_ISP_SCL_SATD8X8)
#define AXH_REG_ISP_SCL_SRC0            (&REG_ISP_SCL_SRC0)
#define AXH_REG_ISP_SCL_DST0            (&REG_ISP_SCL_DST0)
#define AXH_REG_ISP_SCL_DMA0            (&REG_ISP_SCL_DMA0)
#define AXH_REG_ISP_SCL_NEG_FLIP0       (&REG_ISP_SCL_NEG_FLIP0)
#define AXH_REG_ISP_SCL_CLIP0           (&REG_ISP_SCL_CLIP0)
#define AXH_REG_ISP_SCL_SRC1            (&REG_ISP_SCL_SRC1)
#define AXH_REG_ISP_SCL_DST1            (&REG_ISP_SCL_DST1)
#define AXH_REG_ISP_SCL_DMA1            (&REG_ISP_SCL_DMA1)
#define AXH_REG_ISP_SCL_NEG_FLIP1       (&REG_ISP_SCL_NEG_FLIP1)
#define AXH_REG_ISP_SCL_CLIP1           (&REG_ISP_SCL_CLIP1)
#define AXH_REG_ISP_SCL_SRC2            (&REG_ISP_SCL_SRC2)
#define AXH_REG_ISP_SCL_DST2            (&REG_ISP_SCL_DST2)
#define AXH_REG_ISP_SCL_DMA2            (&REG_ISP_SCL_DMA2)
#define AXH_REG_ISP_SCL_NEG_FLIP2       (&REG_ISP_SCL_NEG_FLIP2)
#define AXH_REG_ISP_SCL_CLIP2           (&REG_ISP_SCL_CLIP2)
#define AXH_REG_ISP_SCL_SRC3            (&REG_ISP_SCL_SRC3)
#define AXH_REG_ISP_SCL_DMA3            (&REG_ISP_SCL_DMA3)
#define AXH_REG_ISP_SCL_NEG_FLIP3       (&REG_ISP_SCL_NEG_FLIP3)
#define AXH_REG_ISP_SCL_CLIP3           (&REG_ISP_SCL_CLIP3)
#define AXH_REG_ISP_SCL_SRC4            (&REG_ISP_SCL_SRC4)
#define AXH_REG_ISP_SCL_DMA4            (&REG_ISP_SCL_DMA4)
#define AXH_REG_ISP_SCL_NEG_FLIP4       (&REG_ISP_SCL_NEG_FLIP4)
#define AXH_REG_ISP_SCL_CLIP4           (&REG_ISP_SCL_CLIP4)
#define AXH_REG_ISP_SCL_SRC5            (&REG_ISP_SCL_SRC5)
#define AXH_REG_ISP_SCL_DST5            (&REG_ISP_SCL_DST5)
#define AXH_REG_ISP_SCL_IMGRAM          (&REG_ISP_SCL_IMGRAM)
#define AXH_REG_ISP_SCL_IMG_ID          (&REG_ISP_SCL_IMG_ID)

#define AXH_IR_LEN                      &IR_LEN
#define AXH_IR_DITHER                   &IR_DITHER
#define AXH_IR_SLOPE                    &IR_SLOPE
#define AXH_IR_LEVEL                    &IR_LEVEL
#define AXH_IR_CONTROL                  &IR_CONTROL
#define AXH_IR_STRENGTH                 &IR_STRENGTH
#define AXH_IR_LUT_FI_ADR               &IR_LUT_FI_ADR
#define AXH_IR_LUT_FI_DATA              &IR_LUT_FI_DATA
#define AXH_IR_FWD_PERCEPT_LUT_ADR      &IR_FWD_PERCEPT_LUT_ADR
#define AXH_IR_FWD_PERCEPT_LUT_DATA     &IR_FWD_PERCEPT_LUT_DATA
#define AXH_IR_FWD_PERCEPT_LUT_EN       &IR_FWD_PERCEPT_LUT_EN
#define AXH_IR_REV_PERCEPT_LUT_ADR      &IR_REV_PERCEPT_LUT_ADR
#define AXH_IR_REV_PERCEPT_LUT_DATA     &IR_REV_PERCEPT_LUT_DATA
#define AXH_IR_REV_PERCEPT_LUT_EN       &IR_REV_PERCEPT_LUT_EN
#define AXH_IR_RGGB_START               &IR_RGGB_START
#define AXH_IR_WBGAIN0                  &IR_WBGAIN0
#define AXH_IR_WBGAIN1                  &IR_WBGAIN1
#define AXH_IR_IFCONTROL                &IR_IFCONTROL

#define AXH_NR_HLEN             &NR_HLEN
#define AXH_NR_VLEN             &NR_VLEN
#define AXH_NR_BLANK            &NR_BLANK
#define AXH_NR_EN               &NR_EN
#define AXH_NR_MAIN_YTH0        &NR_MAIN_YTH0
#define AXH_NR_MAIN_YTH1        &NR_MAIN_YTH1
#define AXH_NR_MAIN_YTH2        &NR_MAIN_YTH2
#define AXH_NR_MAIN_YTH3        &NR_MAIN_YTH3
#define AXH_NR_MAIN_CTH0        &NR_MAIN_CTH0
#define AXH_NR_MAIN_CTH1        &NR_MAIN_CTH1
#define AXH_NR_MAIN_CTH2        &NR_MAIN_CTH2
#define AXH_NR_MAIN_CTH3        &NR_MAIN_CTH3
#define AXH_NR_MAIN_YIN0        &NR_MAIN_YIN0
#define AXH_NR_MAIN_YIN1        &NR_MAIN_YIN1
#define AXH_NR_MAIN_YIN2        &NR_MAIN_YIN2
#define AXH_NR_MAIN_YIN3        &NR_MAIN_YIN3
#define AXH_NR_MAIN_CIN0        &NR_MAIN_CIN0
#define AXH_NR_MAIN_CIN1        &NR_MAIN_CIN1
#define AXH_NR_MAIN_CIN2        &NR_MAIN_CIN2
#define AXH_NR_MAIN_CIN3        &NR_MAIN_CIN3
#define AXH_NR_SUB_YTH          &NR_SUB_YTH
#define AXH_NR_SUB_CTH          &NR_SUB_CTH
#define AXH_NR_SUB_YIN          &NR_SUB_YIN
#define AXH_NR_SUB_CIN          &NR_SUB_CIN
#define AXH_NR_MAIN_YLV0        &NR_MAIN_YLV0
#define AXH_NR_MAIN_YLV1        &NR_MAIN_YLV1
#define AXH_NR_MAIN_YLV2        &NR_MAIN_YLV2
#define AXH_NR_MAIN_YLV3        &NR_MAIN_YLV3
#define AXH_NR_MAIN_CLV0        &NR_MAIN_CLV0
#define AXH_NR_MAIN_CLV1        &NR_MAIN_CLV1
#define AXH_NR_MAIN_CLV2        &NR_MAIN_CLV2
#define AXH_NR_MAIN_CLV3        &NR_MAIN_CLV3
#define AXH_NR_SUB_YLV          &NR_SUB_YLV
#define AXH_NR_SUB_CLV          &NR_SUB_CLV

#define AXH_RPU_DMA_ACT         &RPU_DMA_ACT
#define AXH_RPU_DMAR0_OFS       (&RPU_DMAR0_OFS)
#define AXH_RPU_DMAR1_FMT       (&RPU_DMAR1_FMT)
#define AXH_RPU_DMAW1_OFS       (&RPU_DMAW1_OFS)
#define AXH_NR_DMAR_OFS         (&NR_DMAR_OFS)
#define AXH_NR_ISP_MODE         (&NR_ISP_MODE)
//#define AXH_RPU_DMAR1_FMT       &RPU_DMAR1_FMT

#define AXH_REG_AUDIO_HOST_RES_ID_REQ (&REG_AUDIO_HOST_RES_ID_REQ)
#define AXH_REG_AUDIO_HOST_RES_ARG00  (&REG_AUDIO_HOST_RES_ARG00)
#define AXH_REG_AUDIO_HOST_RES_ARG01  (&REG_AUDIO_HOST_RES_ARG01)
#define AXH_REG_AUDIO_HOST_RES_ARG02  (&REG_AUDIO_HOST_RES_ARG02)
#define AXH_REG_AUDIO_HOST_RES_ARG03  (&REG_AUDIO_HOST_RES_ARG03)


#endif  //  A_X_H_REGDUMMY_H
