/**
 * @file   AXHScaler.hpp
 * @brief  Header file of Scaler setting.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_SCALER_H_
#define A_X_H_SCALER_H_

/**
 * @class AXHScaler
 * @brief AXHScaler Class
 */
class AXHScaler {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 */
	AXHScaler();
	/**
	 * @brief  オブジェクトを開放する
	 */
	virtual ~AXHScaler();
private:
	const unsigned int   SCL_DIO_SATD8X8_CLEAR_MASK;
	const unsigned int   IMAGE_DST_SIZE_MAX;
	const unsigned int   IMAGE_SRC_SIZE_MAX;
public:
	/**
	 * @brief  入力画像のサイズ設定を行う
	 *
	 * @param  [in]  ch                        設定ch番号
	 * @param  [in]  width                     入力画像幅
	 * @param  [in]  height                    入力画像高さ
	 */
	void			set_scaler_src_img_size(unsigned char ch, unsigned short width, unsigned short height);
	/**
	 * @brief  出力画像のサイズ設定を行う
	 *
	 * @param  [in]  ch                        設定ch番号
	 * @param  [in]  width                     入力画像幅
	 * @param  [in]  height                    入力画像高さ
	 */
	void			set_scaler_dst_img_size(unsigned char ch, unsigned short width, unsigned short height);
	/**
	 * @brief  上下・左右反転/ネガポジ反転を行う
	 *
	 * @param  [in]  ch                        設定ch番号
	 * @param  [in]  vflip                     0:上下反転しない\n
	 * @n                                      1:上下反転する
	 * @param  [in]  hflip                     0:左右反転しない\n
	 * @n                                      1:左右反転する
	 * @param  [in]  neg                       0:ネガポジ反転しない\n
	 * @n                                      1:ネガポジ反転する
	 */
	void			set_scaler_neg_flip(unsigned char ch, unsigned char vflip, unsigned char hflip, unsigned char neg);
	/**
	 * @brief  画像の複雑度を取得する
	 *
	 * @param  [out] satd                      複雑度
	 */
	void			get_scaler_satd(unsigned int* satd);

#ifdef PARASOFT_CPPTEST
	unsigned int	CPPTEST_val1;
	unsigned int	CPPTEST_val2;
#endif
};

#endif /* A_X_H_SCALER_H_ */
