/*
 * AXHSpecAwbParam.hpp
 */

#ifndef AXH_SPEC_AWB_PARAM_HPP_
#define AXH_SPEC_AWB_PARAM_HPP_

const int OnePushPointMax = 2;                              ///<  全引き込み時OPDエリア座標数 : 2
const int AWB_LightSourcePnt = 4;                           ///<  光源枠点数 : 4
const int AWB_OPDMaskSetMax = 100;                          ///<  OPDマスク最大設定数
const int AWB_ColorMatrixMax = 4;                           ///<  カラーマトリックス象限数


/**
 * @enum  AWBMode
 * @brief [AWB-1]AWBモード選択定義
 */
typedef enum
{
  AWBMode_ATWMode = 0,                                      ///<  0. ATWモード
  AWBMode_ATWSceaneMode,                                    ///<  1. ATWシーンモード
  AWBMode_TempManuMode,                                     ///<  2. 色温度指定マニュアルモード
  AWBMode_LightManuMode,                                    ///<  3. 照明指定マニュアルモード
  AWBMode_OnePushMode,                                      ///<  4. 全引込みモード
  AWBMode_GainManuMode = 5,                                 ///<  5. ゲイン指定マニュアルモード
  AWBMode_HoldMode,                                         ///<  6. ホールドモード

  AWBMode_Max,                                              ///<  AWBモード選択数
} AWBMode;


/**
 * @enum	AWBOnePushPnt
 * @brief	[AWB-5]全引込み時OPDエリア座標定義
 */
typedef enum
{
  AWBOnePushPnt_Start = 0,                                  ///<  開始座標
  AWBOnePushPnt_End,                                        ///<  終了座標

  AWBOnePushPnt_Max,                                        ///<  座標点数
} AWBOnePushPnt;

/**
 * @enum	AWBOnePushRange
 * @brief	[AWB-5]全引込み時光源引込み範囲定義
 */
typedef enum
{
  AWBOnePushRange_ALL = 0,                                  ///< 全範囲
  AWBOnePushRange_ATW,                                      ///< ATW標準

  AWBOnePushRange_Max,                                      ///< 光源引込み範囲定義数
} AWBOnePushRange;

/**
 * @enum	AWB_LightRange
 * @brief	[AWB-6]光源引込み範囲定義
 */
typedef enum
{
  AWB_LightRange_LowTemp = 0,                               ///< 低色温度側
  AWB_LightRange_HighTemp,                                  ///< 高色温度側

  AWB_LightRange_Num,                                       ///< 光源引込み範囲定義数
} AWB_LightRange;


/**
 * @enum	AWBLightSource
 * @brief	光源枠定義
 */
typedef enum
{
  AWBLightSource_None = -1,                                 ///<  -1.未定義
  AWBLightSource_A = 0,                                     ///<  0.白熱灯
  AWBLightSource_EBulbF,                                    ///<  1.電球色蛍光灯
  AWBLightSource_CWF,                                       ///<  2.白色蛍光灯
  AWBLightSource_DayWF,                                     ///<  3.昼白色蛍光灯
  AWBLightSource_DayF,                                      ///<  4.昼光色蛍光灯
  AWBLightSource_Day = 5,                                   ///<  5.昼光
  AWBLightSource_Cloudy,                                    ///<  6.雲天/日陰
  AWBLightSource_Merculy,                                   ///<  7.水銀灯
  AWBLightSource_NaLamp,                                    ///<  8.高圧ナトリウムランプ
  AWBLightSource_EBulbLED,                                  ///<  9.電球色LED
  AWBLightSource_WhiteLED = 10,                             ///<  10.白色LED
  AWBLightSource_DayLED,                                    ///<  11.昼光色LED

  AWBLightSource_Max,                                       ///<  光源数(ローリングは除く)

  AWBLightSource_CWFRolling = AWBLightSource_Max,           ///<  12.白色蛍光灯(カラーローリング時)
  AWBLightSource_DayWFRolling,                              ///<  13.昼白色蛍光灯(カラーローリング時)
  AWBLightSource_DayFRolling,                               ///<  14.昼光色蛍光灯(カラーローリング時)

  AWBLightSource_Rolling_Max,                               ///<  光源数(ローリングを含む)
} AWBLightSource;


/**
 * @enum	AWBLightDefault
 * @brief	光源デフォルト座標定義
 */
typedef enum
{
  AWBLightDefault_None = -1,                                ///<  -1.デフォルト座標未選択
  AWBLightDefault_EBulbF = 0,                               ///<  0.電球色蛍光灯デフォルト座標
  AWBLightDefault_CWF,                                      ///<  1.白色蛍光灯デフォルト座標
  AWBLightDefault_DayWF,                                    ///<  2.昼白色蛍光灯デフォルト座標
  AWBLightDefault_DayF,                                     ///<  3.昼光色蛍光灯デフォルト座標
  AWBLightDefault_Merculy,                                  ///<  4.水銀灯デフォルト座標
  AWBLightDefault_NaLamp,                                   ///<  5.高圧ナトリウムランプデフォルト座標
  AWBLightDefault_EBulbLED,                                 ///<  6.電球色LEDデフォルト座標
  AWBLightDefault_WhiteLED,                                 ///<  7.白色LEDデフォルト座標
  AWBLightDefault_DayLED,                                   ///<  8.昼光色LEDデフォルト座標
  AWBLightDefault_1800K,                                    ///<  9.黒体放射 1800Kポイント座標
  AWBLightDefault_3200K,                                    ///<  10.低色温度側調整(3200K)ポイント座標
  AWBLightDefault_4200K,                                    ///<  11.黒体放射 4200Kポイント座標
  AWBLightDefault_5200K,                                    ///<  12.黒体放射 5200Kポイント座標
  AWBLightDefault_5800K,                                    ///<  13.高色温度側調整(5800K)ポイント座標
  AWBLightDefault_7000K,                                    ///<  14.黒体放射 7000Kデフォルト座標
  AWBLightDefault_10000K,                                   ///<  15.黒体放射10000Kデフォルト座標

  AWBLightDefault_Max,                                      ///<  光源デフォルト座標数
} AWBLightDefault;


//
//	[AWB-14]OPD重み付け関連定義
//

/**
 * @enum	AWB_OPDArea
 * @brief	[AWB-14]OPD重み付け エリア定義
 */
typedef enum
{
  AWB_OPDArea_Idx_0 = 0,                                    ///<  OPD重み付けエリア0
  AWB_OPDArea_Idx_1,                                        ///<  OPD重み付けエリア1
  AWB_OPDArea_Idx_2,                                        ///<  OPD重み付けエリア2
  AWB_OPDArea_Idx_3,                                        ///<  OPD重み付けエリア3
  AWB_OPDArea_Idx_4,                                        ///<  OPD重み付けエリア4

  AWB_OPDArea_Idx_Max = 5,                                  ///<  OPD重み付けエリア数
} AWB_OPDArea;

/**
 * @enum	AWBWeightMode
 * @brief	[AWB-14]OPD重み付け 重み指定定義
 */
typedef enum
{
  AWBWeightMode_0 = 0,                                      ///<  重み0指定
  AWBWeightMode_1_16,                                       ///<  重み1/16指定
  AWBWeightMode_1_4,                                        ///<  重み1/4指定
  AWBWeightMode_1,                                          ///<  重み1指定

  AWBWeightMode_Max,                                        ///<  重み定義数
} AWBWeightMode;


//
//	OPD信頼性判定関連定義
//

/**
 * @enum	AWBLowTrust
 * @brief	低信頼性時処理選択定義
 */
typedef enum
{
  AWBLowTrust_Hold = 0,                                     ///<  0.ホールド
  AWBLowTrust_Default,                                      ///<  1.一番近い光源デフォルト値

  AWBLowTrust_Max,                                          ///<  低信頼性時処理選択数
} AWBLowTrust;


#endif /* AXH_SPEC_AWB_PARAM_HPP_ */
