/*
 * AXHSpecAwbStruct.hpp
 */

#ifndef AXH_SPEC_AWB_STRUCT_HPP_
#define AXH_SPEC_AWB_STRUCT_HPP_

#include "AXHSpecAwbParam.hpp"

/**
 * @struct  ST_POINT
 * @n   オリジナル画像座標格納用構造体
 */
typedef struct st_point
{
  short h;                                                  //  水平座標
  short v;                                                  //  垂直座標
} ST_POINT;

/**
 * @struct  ST_POINT
 * @n   オリジナル画像座標格納用構造体
 */
typedef struct st_opd_point
{
  unsigned char h;                                          //  水平座標
  unsigned char v;                                          //  垂直座標
} ST_OPD_POINT;

/**
 * @struct  ST_COL_POINT
 * @n   色座標データ格納用構造体
 */
typedef struct st_col_point
{
  short Bg;                                                 //  B/G座標
  short Rg;                                                 //  R/G座標
} ST_COL_POINT;

/**
 * @struct  ST_AERA
 * @n   光源枠座標構造体
 */
typedef struct st_area
{
  ST_COL_POINT  Area[AWB_LightSourcePnt];                   //  枠座標
} ST_AREA;

/**
 * @struct  ST_ONE_PUSH
 * @n   [AWB-5]全引き込み実行レジスタ構造体
 */
typedef struct st_one_push
{
  unsigned char Start;                                      //  全引き込み実行レジスタ
  ST_POINT      Area[OnePushPointMax];                      //  全引き込み実行時OPDエリア
  unsigned char Range;                                      //  全引き込み範囲
  unsigned char Speed;                                      //  全引込み時引込み速度
} ST_ONE_PUSH;

/**
 * @struct  ST_LIGHT_RANGE
 * @n   ［AWB-6］AWB光源枠引込み範囲設定値構造体
 */
typedef struct st_light_range
{
  unsigned short LTempAdjust;                               //  低色温度側引込み範囲
  unsigned short HTempAdjust;                               //  高色温度側引込み範囲
  ST_COL_POINT   CPnt[AWB_LightRange_Num];                  //  引込みポイント座標
  unsigned short MgDirAdjust;                               //  Mg方向引込み範囲
  unsigned short GDirAdjust;                                //  G方向引込み範囲

} ST_LIGHT_RANGE;

/**
 * @struct  ST_OFFSET
 * @n   ［AWB-7］WBオフセット調整設定値構造体
 */
typedef struct st_offset
{
  ST_COL_POINT Pnt[AWBLightSource_Max];
} ST_OFFSET;

/**
 * @struct  ST_A_MATRIX
 * @n   カラーマトリックス調整係数構造体
 */
typedef struct st_a_matrix
{
  unsigned short AJCF11;                                    //  Cbクロマゲイン調整係数
  unsigned short AJCF12;                                    //  Cbマトリックスゲイン調整係数
  unsigned short AJCF21;                                    //  Crマトリックスゲイン調整係数
  unsigned short AJCF22;                                    //  Crクロマゲイン調整係数
} ST_A_MATRIX;

/**
 * @struct  ST_ADJUST_MATRIX
 * @n   ［AWB-8］各光源枠カラーマトリックス調整設定値構造体
 */
typedef struct st_adjust_matrix
{
  ST_A_MATRIX Matrix[AWBLightSource_Max];
} ST_ADJUST_MATRIX;

/**
 * @struct  ST_WB_GAIN
 * @n   ［AWB-9］マニュアルモード時ゲイン指定設定値構造体
 */
typedef struct st_wb_gain
{
  unsigned short rGain;                                     // Rホワイトバランス
  unsigned short bGain;                                     // Bホワイトバランス
} ST_WB_GAIN;

/**
 * @struct  ST_CONVERGENCE
 * @n	［AWB-10］AWB遷移特性構造体
 */
typedef struct st_convergence
{
  unsigned short Speed;                                     //  引込み速度 : フレーム数
  unsigned short LightTH;                                   //  照明変化検知閾値 : lx
  unsigned short StableTH;                                  //  安定性確認閾値 : lx
  unsigned short StableTerm;                                //  安定性確認期間 : フレーム数
} ST_CONVERGENCE;

/**
 * @struct  ST_WEIGHT
 * @n   光源枠格納用構造体
 */
typedef struct st_weight
{
  unsigned char  WeightL;                                   //  低輝度判定重み
  unsigned char  WeightH;                                   //  高輝度判定重み
  unsigned short LimitL;                                    //  低輝度判定上限
  unsigned short LimitH;                                    //  高輝度判定下限
} ST_WEIGHT;

/**
 * @struct  ST_LIGHT_WEIGHT
 * @n   ［AWB-11］光源別光源枠重み付け設定構造体
 */
typedef struct st_light_weight
{
  ST_WEIGHT Weight[AWBLightSource_Max];
} ST_LIGHT_WEIGHT;

/**
 * @struct  ST_OPD_SET
 * @n	［AWB-13］OPD設定値構造体
 */
typedef struct st_opd_set
{
  unsigned char   HDiv;                                     //  水平分割数
  unsigned char   VDiv;                                     //  垂直分割数
  unsigned short  HLimit;                                   //  積算対象信号上限
  unsigned short  LLimit;                                   //  積算対象信号下限
} ST_OPD_SET;

/**
 * @struct  ST_OPD_WEIGHT
 * @n   ［AWB-14］OPD枠重み付け設定値構造体
 */
typedef struct st_opd_weight
{
  unsigned char V1;                                         //  エリア座標v1
  unsigned char H2;                                         //  エリア座標h2
  unsigned char H3;                                         //  エリア座標h3
  unsigned char V4;                                         //  エリア座標v4
  unsigned char WeightMode[AWB_OPDArea_Idx_Max];            //  重み
} ST_OPD_WEIGHT;

/**
 * @struct  ST_OPD_MASK
 * @n   ［AWB-15］OPD枠AWBマスク領域設定構造体
 */
typedef struct st_opd_mask
{
  ST_OPD_POINT Pnt[AWB_OPDMaskSetMax];
} ST_OPD_MASK;

/**
 * @struct  ST_SPECTRUM_ADJUST
 * @n   [AWB-16]バラつき調整用レジスタ構造体
 */
typedef struct st_spectrum_adjust
{
  unsigned char regLowTempStart;                            //  低色温度側調整起動レジスタ
  unsigned char regHighTempStart;                           //  高色温度側調整起動レジスタ
  ST_COL_POINT  pntLowTemp;                                 //  低色温度側基準点座標
  ST_COL_POINT  pntHighTemp;                                //  高色温度側基準点座標
} ST_SPECTRUM_ADJUST;

/**
 * @struct  ST_AREA_POINT
 * @n   光源座標構造体
 */
typedef struct st_area_point
{
  ST_COL_POINT CPnt[AWB_LightSourcePnt];                    //  光源枠座標
} ST_AREA_POINT;

/**
 * @struct  ST_LIGHT_SOURCE
 * @n   ［AWB-17］光源枠詳細調整設定構造体
 */
typedef struct st_light_source
{
  ST_AREA_POINT Area[AWBLightSource_Rolling_Max];           //  光源枠座標
} ST_LIGHT_SOURCE;

/**
 * @struct  ST_LIGHT_DEFAULT
 * @n   ［AWB-18］光源デフォルト位置設定構造体
 */
typedef struct st_light_default
{
  ST_COL_POINT CPnt[AWBLightDefault_Max];                   //  光源デフォルト座標
} ST_LIGHT_DEFAULT;

/**
 * @struct  ST_OPD_TRUST
 * @n   ［AWB-19］OPD信頼性判定レベル設定構造体
 */
typedef struct st_opd_trust
{
  unsigned short TH;                                        //  信頼性閾値
  unsigned char  Sel;                                       //  低信頼性時の処理選択
  unsigned char  Zero;                                      //  OPDデータゼロ時処理選択
} ST_OPD_TRUST;

/**
 * @struct  ST_C_MATRIX
 * @brief	カラーマトリックス係数格納用クラス
 */
typedef struct st_c_matrix
{
  unsigned short CC22;                                      //  Cbクロマゲイン
  unsigned short CC23;                                      //  Cbマトリックスゲイン
  unsigned short CC33;                                      //  Crクロマゲイン
  unsigned short CC32;                                      //  Crマトリックスゲイン
} ST_C_MATRIX;

/**
 * @struct  ST_COLOR_MATRIX
 * @n	［Img-5.2.2］ カラーマトリックス設定構造体
 */
typedef struct st_color_matrix
{
  unsigned char  Mode;                                      //  独立モードON/OFF
  ST_C_MATRIX    Matrix[AWB_ColorMatrixMax];                //	クロマ/マトリックスゲイン
  unsigned short CC11;                                      //  Yゲイン
  unsigned short COF1;                                      //  Yオフセット

} ST_COLOR_MATRIX;

/**
 * @struct  ST_AWB
 * @n   AWB用設定値格納用構造体
 */
typedef struct st_awb {
  unsigned char       AWBMode;                              //  [AWB-1]AWBモード選択
  unsigned char       ATWSceaneMode;                        //  [AWB-2]ATWシーンモード選択
  unsigned short      ManuModeColorTemp;                    //  [AWB-3]マニュアルモード時色温度指定
  unsigned char       ManuModeLightSelect;                  //  [AWB-4]マニュアルモード時照明指定
  ST_ONE_PUSH         OnePush;                              //  [AWB-5]全引き込み
  ST_LIGHT_RANGE      LightRange;                           //  [AWB-6]光源枠引き込み範囲設定
  ST_OFFSET           Offset;                               //  [AWB-7]WBオフセット調整
  ST_ADJUST_MATRIX    AdjustMatrix;                         //  [AWB-8]各光源枠カラーマトリックス調整
  ST_WB_GAIN          WBGain;                               //  [AWB-9]マニュアルモード時WBゲイン
  ST_CONVERGENCE      Convergence;                          //  [AWB-10]AWB遷移特性
  ST_LIGHT_WEIGHT     LightWeight;                          //  [AWB-11]光源枠重み付け設定
  unsigned short      stopLowBrightTH;                      //  [AWB-12]低輝度ATW停止しきい値
  ST_OPD_SET          OPDSet;                               //  [AWB-13]OPD設定
  ST_OPD_WEIGHT       OPDWeight;                            //  [AWB-14]OPD枠重み付け設定
  ST_OPD_MASK         OPDMask;                              //  [AWB-15]OPDマスク領域設定
  ST_SPECTRUM_ADJUST  SpectrumAdjust;                       //  [AWB-16]分光バラつき調整
  ST_AREA             LightSource[AWBLightSource_Rolling_Max];
                                                            //  [AWB-17]光源枠座標
  ST_COL_POINT        LightDefault[AWBLightDefault_Max];    //  [AWB-18]光源デフォルト座標
  ST_OPD_TRUST        OPDTrust;                             //  [AWB-19]OPD信頼性判定レベル設定
  ST_COLOR_MATRIX     ColorMatrix;                          //  [Img-5.2.2]カラーマトリックス設定
} ST_AWB;


#endif /* AXH_SPEC_AWB_STRUCT_HPP_ */
