/*
 * AXHSpecDefectStruct.hpp
 */

#ifndef AXH_SPEC_DEFECT_STRUCT_HPP_
#define AXH_SPEC_DEFECT_STRUCT_HPP_

/**
 * @struct  ST_CDEF
 * @n   画素欠陥補正用画素データ格納用構造体(レジスタ:CDEF)
 */
typedef struct st_cdef
{
  unsigned int CDEF_H   : 13;
  unsigned int CDEF_V   : 13;
  unsigned int Reserved :  4;
  unsigned int CDEF_CLS :  2;
} ST_CDEF;

/**
 * @struct  ST_DEFECT_ADDRESS
 * @n   画素欠陥補正用 画素データ格納用構造体(アドレス指定内部モード時)
 */
typedef struct st_defect_address {
  unsigned short  H;                                      //  水平方向座標
  unsigned short  V;                                      //  垂直方向座標
  unsigned char   CLS;                                    //  補正方法
} ST_DEFECT_ADDRESS;

/**
 * @struct  ST_DEFECT
 * @n   [Img-7.1]画素欠陥補正(キズ補正)設定値格納用構造体
 */
typedef struct st_defect
{
  struct {                                                  //  モード設定
    unsigned char External;                                 //  アドレス指定モード 内部/外部切替
    unsigned char AutoCorrect;                              //  自動補正 ON/OFF
  } Mode;
  ST_DEFECT_ADDRESS Address[AXH_Defect_IntAddr_Max];        //  アドレス設定(アドレス指定内部モード時)
  struct {                                                  //  自動補正機能設定
    unsigned char   CLS;                                    //  補正方法
    unsigned char   Ave;                                    //  参照ピクセル設定
    unsigned long   TH_H;                                   //  白点検出用閾値
    unsigned long   TH_L;                                   //  黒点検出用閾値
    unsigned short  OFST[AXH_Defect_IntAddr_Max];           //  輝度信号レベル変調設定
  } AutoCorrect;
  struct {
    unsigned char regStart;                                 //  検出開始レジスタ
    struct {
//      unsigned char  ShutterSpeed;                          //  AE:シャッタースピード
      unsigned long  ShutterSpeed;                          //  AE:シャッタースピード K.Kawachi modified
      unsigned short Gain;                                  //  AE:ゲイン
      unsigned char  IrisCloseMode;                         //  AE:アイリスクローズモード
    } AE;
    unsigned short TH;                                      //  白点検出しきい値
    unsigned char  CLS;                                     //  補正方法
    unsigned char  Priority;                                //  補正優先順位設定
  } DetectSet;
} ST_DEFECT;

#endif /* AXH_SPEC_DEFECT_STRUCT_HPP_ */
