/*
 * AXHSpecAwbInit.hpp
 */

#ifndef AXH_SPEC_INIT_HPP_
#define AXH_SPEC_INIT_HPP_

const int AXH_AWB_OPD_H_Div_Max = 40;                       ///< 水平分割数最大値
const int AXH_AWB_OPD_V_Div_Max = 22;                       ///< 垂直分割数最大値

const int AXH_AWB_OPD_H_Div = 40;                           ///< 水平分割数
const int AXH_AWB_OPD_V_Div = 22;                           ///< 垂直分割数

const unsigned short  AXH_AWB_WB_RGain_Init = 0x018e;       ///< ホワイトバランス初期値
const unsigned short  AXH_AWB_WB_BGain_Init = 0x0198;       ///< ホワイトバランス初期値

const unsigned short  AXH_DEFECT_CDEF_H_Init   = 0x1FFFu;   ///<  画素欠陥補正 アドレス設定 水平座標初期値
const unsigned short  AXH_DEFECT_CDEF_V_Init   = 0x1FFFu;   ///<  画素欠陥補正 アドレス設定 垂直座標初期値
const unsigned char   AXH_DEFECT_CDEF_CLS_Init = 0;         ///<  画素欠陥補正 アドレス設定 垂直座標初期値

const unsigned int    AXH_OB_SAMPLING_WIDTH    = 1920;      ///<  OB調整 サンプリング領域デフォルト幅
const unsigned int    AXH_OB_SAMPLING_HEIGHT   = 8;         ///<  OB調整 サンプリング領域デフォルト高さ
const unsigned int    AXH_OB_DARK_LEVEL_FLOOR  = 11;        ///<  OB調整 黒レベル床値
const unsigned int    AXH_SCL_DEF_IMG_WIDTH    = 1920;      ///<  SCL調整 画像デフォルト幅
const unsigned int    AXH_SCL_DEF_IMG_HEIGHT   = 1080;      ///<  SCK調整 画像デフォルト高さ

#endif /* AXH_SPEC_INIT_HPP_ */
