/**
 * @file   AXHWhiteBalanceGain.hpp
 * @brief  Header file of White Balance Gain Class.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_WHITE_BALANCE_GAIN_H
#define A_X_H_WHITE_BALANCE_GAIN_H

/**
 * @class WbgRegCtrl
 * @brief White Balance Gain Register Control
 */
class WbgRegCtrl {
 private:
  /**
   * @brief Rゲイン設定変更フラグ
   */
  bool rChgFlg;
 
  /**
   * @brief Bゲイン設定変更フラグ
   */
  bool bChgFlg;
 
  /**
   * @brief Rゲイン設定値
   */
  unsigned int rGain;
 
  /**
   * @brief Bゲイン設定値
   */
  unsigned int bGain;
 
  /**
   * @brief WB R,Bゲイン設定値([31,28]Reserved / [27,16]bGain / [15,12]Reserved / [11,0]rGain)
   */
  unsigned int *p_rbGain;
 
 public:
  /**
   * @brief  オブジェクトを初期化する
   */
  WbgRegCtrl();

  /**
   * @brief  オブジェクトを開放する
   */
  ~WbgRegCtrl();
 
  /**
   * @brief WB Rゲイン設定値をレジスタから取得する
   *
   * @return WB Rゲイン
   */
  unsigned int getRegRGain();

  /**
   * @brief WB Rゲインをレジスタへ設定する
   *
   * @param [in] rgain WB Rゲイン
   */
  void setRegRGain(void);

  /**
   * @brief WB Rゲインを一時保存先へ設定する
   *
   * @param [in] rgain WB Rゲイン
   */
  void setTmpRGain(unsigned int rgain);

  /**
   * @brief WB Bゲイン設定値をレジスタから取得する
   *
   * @return WB Bゲイン設定値
   */
  unsigned int getRegBGain();

  /**
   * @brief WB Bゲインをレジスタへ設定する
   *
   * @param [in] bgain WB Bゲイン
   */
  void setRegBGain(void);

  /**
   * @brief WB Bゲインを一時保存先へ設定する
   *
   * @param [in] bgain WB Bゲイン
   */
  void setTmpBGain(unsigned int bgain);
};


/**
 * @class AXHWhiteBalanceGain
 * @brief White Balance Gain Class
 * 
 */
class AXHWhiteBalanceGain {
 private:
  /**
   * @brief WB Rゲイン設定値
   */
  unsigned int rgain;
 
  /**
   * @brief WB Bゲイン設定値
   */
  unsigned int bgain;
 
  /**
   * @brief WB R,Bゲイン設定値([31,28]Reserved / [27,16]bGain / [15,12]Reserved / [11,0]rGain)
   */
  unsigned int *p_rbGain;
  

 public:
  /**
   * @brief  オブジェクトを初期化する
   */
  AXHWhiteBalanceGain();

  /**
   * @brief  オブジェクトを開放する
   */
  ~AXHWhiteBalanceGain();

  /**
   * @brief WB Rゲイン設定値を取得する
   *
   * @return WB Rゲイン
   */
  unsigned int getRGain();

  /**
   * @brief WB Rゲインを設定する
   *
   * @param [in] rgain WB Rゲイン
   */
  void setRGain(unsigned int rgain);

  /**
   * @brief WB Bゲイン設定値を取得する
   *
   * @return WB Bゲイン設定値
   */
  unsigned int getBGain();

  /**
   * @brief WB Bゲインを設定する
   *
   * @param [in] bgain WB Bゲイン
   */
  void setBGain(unsigned int bgain);

};
#endif
