/**
 * @file   LisocInit.c
 * @brief  Source file of LISOC Initalization
 * @par    Programming Language
 *         C
 */
#include "LisocInit.h"
#include "rcc.h"
#include "spi.h"
#include "timer.h"
#include "ddr_test.h"
#include "sensor.h"
#include "AdjTask.h"

#define reg32_wr(addr, wdata)           (*(volatile uint32_t *)(uint32_t)(addr)) = (uint32_t)(wdata)

//
//	LISOC初期化
//
BaseType_t lisocInit()
{
	BaseType_t xRet = pdFAIL;
	
  (void)SysTick_Config(SYS_NUM_TICKS_PER_MSEC);
  rcc_init();
  rcc_switch();


  NVIC_EnableIRQ(WDT_IRQn);   //wdt irq enable
  NVIC_EnableIRQ(ISP_IRQn);
  
  CPU_TIM_Init();
  spi_slave_init();
  spis_isr_init();
  ddr_init();
  //ddr_test();

  datapath_init();
#ifdef IMX412
	imx412_init();
#elif IMX415
	imx415_init();
#else
	imx662_init();
#endif

	// AX停止フラグ初期化（0x20059500固定）
	reg32_wr(AX_FRM_ISR_STOP_ADDR, 0x00000000);

	// 調整用タスク初期化
	xRet = adjTaskInit();
	if (xRet != pdPASS) {
		return xRet;
	}
	
	return xRet;
}