/**
 * LisocInit.h
 */
#ifndef _LISOCINIT_H_
#define _LISOCINIT_H_

#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "timers.h"

#include "SSE050.h"
#include "lisoc.h"
#include "systick.h"
#include "register_top.h"

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

/***************************************************************
* Constants
***************************************************************/
#define LISOC_ARM_SYS_CLK               (133333333UL)
#define AX_FRM_ISR_STOP_ADDR			(0x20059500)	// AXフレーム割り込み停止（AX停止）フラグ（0:動作 / 1:停止）

/**
 * @brief LISOCを初期化する
 *
 * @retval pdPASS	正常終了
 * @retval pdFAIL	異常終了
 */
BaseType_t lisocInit(void);
	
#ifdef __cplusplus
}
#endif	/* __cplusplus */
	
#endif /* _LISOCINIT_H_ */
