/**
 * @file   AXModelActor.hpp
 * @brief  AXModelActorクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXMODELACTOR_HPP_
#define AXMODELACTOR_HPP_

#include "AXFActor.hpp"

/**
 * @class AXModelActor
 * @brief AXM層のアクタ基底クラス
 *
 * @n     AXM層へアクタ基底クラスを提供する
 */
class AXModelActor : public AXFActor {
 public:

  /**
   * @brief AXModelActorコンストラクタ
   *
   * @n     本メソッドで失敗する可能性のある処理を実装してはならない。
   * @n     失敗する可能性のある処理は、onCreateメソッドで実装する。
   * @n
   * @param [in] name アクタ名
   */
  AXModelActor(AXFObjectName& name);

  /**
   * @brief AXModelActorデストラクタ
   *
   * @n     本メソッドで失敗する可能性のある処理を実装してはならない。
   * @n     失敗する可能性のある処理は、onDestroyメソッドで実装する。
   */
  virtual ~AXModelActor();
};

#endif /* AXMODELACTOR_HPP_ */
