/*
 * AXMCommonConfig.hpp
 */

#ifndef AXMCOMMONCONFIG_HPP_
#define AXMCOMMONCONFIG_HPP_

//  ARM側からISPパラメータを設定するときは、次の行の定義を有効化してください
//#define DISABLE_SET_DEFAULT_ISP_PARAM   //  ISPデフォルト値 無効

//#define AXM_ISP_SIMULATOR               //  シミュレータ動作

//#define DISABLE_AE2PACK                 //  AE2パッケージ無効化
//#define DISABLE_AE_PROC                 //  AE演算処理無効化
//#define DISABLE_OB_PROC					//  OB演算処理無効化
//#define DISABLE_GAMMA_PROC              //  Gamma演算処理無効化
//#define DISABLE_APERTURE_PROC	           //  Aperture補正演算処理無効化
//#define DISABLE_CHROMA_PROC             //  ChromaSuppress処理無効化
//#define DISABLE_SCALER_PROC             //  スケーラー機能処理無効化
//#define DISABLE_LINEAR_MODE             //  Linear動作モード無効化

//#define ENABLE_PIXCESSOR_MEM_BANK_6     //  6バンク構成有効化

#ifdef PARASOFT_CPPTEST
#undef DISABLE_OB_PROC
#undef DISABLE_GAMMA_PROC
#undef DISABLE_APERTURE_PROC
#undef DISABLE_CHROMA_PROC
#undef DISABLE_SCALER_PROC
#endif


//#define USE_AXFTEST_COMMAND             //  フレームワークテスト用拡張コマンド有効化(Makefileで定義)
//#define USE_AXFTEST_COMMAND_COMPLOG     //  シナリオテストログ出力有効化(Makefileで定義)
//#define AXM_ISP_CT_AWB
//#define AXM_ISP_CT_AE

#define ENABLE_OPD_CONFIG_ISP_TO_AXH    //  OPD設定をAXH使用してISPで直接設定する(AXMPixcessorを介さない)

#define ENABLE_OPD_DATA_ISP_TO_AXH      //  OPDデータをAXH使用してISPで直接取得する(AXMPixcessorを介さない)

#define ENABLE_IMAGE_ADDR_ISP_TO_AXH    //  画像データ出力先をAXHを使用して直接取得する(AXMIspPixcessorを介さない)

//#define ENABLE_DEFECT_CORRECT_LIMITED   //  画素欠陥補正 検出上限有効

//#define DISABLE_CONV_LOG                //  AWB収束制御ログ出力無効

#ifndef PARASOFT_CPPTEST
// 今回はキャリブレーションが効かなくなるため無効化
////  C++TEST実行時は無効にすること
//#define ENABLE_AWB_ADJUST_AF_LENS_DATA  //  分光調整時 AFレンズデータ有効
#endif  //  PARASOFT_CPPTEST

//  2015/2/18：仕様変更
//    蛍光灯枠判定時には、Mg-G方向調整演算を行わない
//    条件コンパイルにて無効にするようにし、蛍光灯枠判定時でもMg-G方向調整演算を行うことができるように変更
#define DISABLE_MG_G_ADJ_FLU_FRAME      //  蛍光灯枠判定時は、Mg-G方向調整演算を行わない

#define DISABLE_AWB_CONV_LOG            //  AWB 収束制御ログを出力しない

#endif /* AXMCOMMONCONFIG_HPP_ */
