/*
 * AXMCommonParam.hpp
 */

#ifndef AXMCOMMONPARAM_HPP_
#define AXMCOMMONPARAM_HPP_


const bool AXM_wdrMode_Init = false;                        //  WDRモード初期値
const unsigned char AXM_linearMode_Init = 0;                //  Linearモード初期値

const unsigned short Reg_Start = 0x0001u;                   //  レジスタ : スタートフラグ

const unsigned short Cmd_Adjust_AWB_Low  = 0x0100u;         //  調整モード : バラつき調整 低色温度側調整起動
const unsigned short Cmd_Adjust_AWB_High = 0x0200u;         //  調整モード : バラつき調整 高色温度側調整起動

const unsigned short Cmd_Get_OPD_Mask    = 0x00FFu;         //  OPDデータ取得コマンドマスク

const unsigned short Cmd_Get_OPD_AWB     = 0x0001u;         //  AWB OPDデータ取得 : ３A
const unsigned short Cmd_Get_OPD_AWB_L   = 0x0002u;         //  AWB OPDデータ取得 : ３A L

const unsigned short Cmd_Get_OPD_AE_0    = 0x0001u;         //  AE OPDデータ取得 : ３A 0
const unsigned short Cmd_Get_OPD_AE_1    = 0x0002u;         //  AE OPDデータ取得 : ３A 1
const unsigned short Cmd_Get_OPD_AE_L_0  = 0x0003u;         //  AE OPDデータ取得 : ３A L_0
const unsigned short Cmd_Get_OPD_AE_L_1  = 0x0004u;         //  AE OPDデータ取得 : ３A L_1

const int Cmd_Frame_1st       = 0x00000100;                 //  1st Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_2nd       = 0x00000200;                 //  2nd Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_3rd       = 0x00000300;                 //  3rd Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_4th       = 0x00000400;                 //  4th Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_5th       = 0x00000500;                 //  5th Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_6th       = 0x00000600;                 //  6th Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_7th       = 0x00000700;                 //  7th Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_8th       = 0x00000800;                 //  8th Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_9th       = 0x00000900;                 //  9th Frame （OPDデータ取得コマンドマスクでマスクされる）
const int Cmd_Frame_10th      = 0x00000A00;                 //  10th Frame （OPDデータ取得コマンドマスクでマスクされる）

const unsigned short Cmd_Adjust_LensShade_Init    = 0x0000u;//  レンズシェーディング補正設定 初期化モード
const unsigned short Cmd_Adjust_LensShade_Enabled = 0x0001u;//  レンズシェーディング補正設定 有効・無効変更モード
const unsigned short Cmd_Adjust_LensShade_Pitch   = 0x0002u;//  レンズシェーディング補正設定 ピッチ変更モード
const unsigned short Cmd_Adjust_LensShade_Shift   = 0x0004u;//  レンズシェーディング補正設定 シフト量変更モード
const unsigned short Cmd_Adjust_LensShade_All     = 0x0007u;//  レンズシェーディング補正設定 全変更モード

const unsigned short Cmd_Adjust_Iridix_Init = 0x0000u;      //  IRIDIX設定 初期化モード
const unsigned short Cmd_Adjust_Iridix_Run  = 0x0001u;      //  IRIDIX設定 通常モード

const int Sts_AWB_ATWMode    = 0x00000001;                  //  AWB ATWモード
const int Sts_AWB_ManuMode   = 0x00000002;                  //  AWB マニュアルモード
const int Sts_AWB_OnePush    = 0x00000004;                  //  AWB OnePushモード
const int Sts_AWB_AdjustMode = 0x00000008;                  //  AWB 調整モード

const unsigned char SID_AXMIsp          = 0x01;             //  送信元ID:AXMIsp
//const unsigned char SID_AXMIspAf        = 0x02;             //  送信元ID:AXMIspAf
const unsigned char SID_AXMIspAe        = 0x03;             //  送信元ID:AXMIspAe
const unsigned char SID_AXMIspAwb       = 0x04;             //  送信元ID:AXMIspAwb
const unsigned char SID_AXMPixcessor    = 0x05;             //  送信元ID:AXMPixcessor
const unsigned char SID_AXMPixcessorInt = 0x06;             //  送信元ID:AXMPixcessorInt
const unsigned char SID_AXMImageSensor  = 0x07;             //  送信元ID:AXMImageSensor
const unsigned char SID_AXMImageSensorDrv = 0x08;           //  送信元ID:AXMImageSensorDrv

const unsigned char RID_AXMIsp          = 0x01;             //  受信先ID:AXMIsp
//const unsigned char RID_AXMIspAf        = 0x02;             //  受信先ID:AXMIspAf
const unsigned char RID_AXMIspAe        = 0x03;             //  受信先ID:AXMIspAe
const unsigned char RID_AXMIspAwb       = 0x04;             //  受信先ID:AXMIspAwb
const unsigned char RID_AXMPixcessor    = 0x05;             //  受信先ID:AXMPixcessor
const unsigned char RID_AXMPixcessorInt = 0x06;             //  受信先ID:AXMPixcessorInt
const unsigned char RID_AXMImageSensor  = 0x07;             //  受信先ID:AXMImageSensor
const unsigned char RID_AXMImageSensorDrv = 0x08;           //  受信先ID:AXMImageSensorDrv


const unsigned int g_opd_mode_raw  = 1;
const unsigned int g_opd_mode_yrgb = 2;

const unsigned int g_opd_h_div_awb = 40;
const unsigned int g_opd_v_div_awb = 36;
const unsigned int g_avever_w_size_h_awb = 48;
const unsigned int g_avever_w_size_v_awb = 30;

const unsigned int g_opd_h_div_ae = 10;
const unsigned int g_opd_v_div_ae = 10;
const unsigned int g_avever_w_size_h_ae = 192;
const unsigned int g_avever_w_size_v_ae = 108;

const unsigned int g_avesize = 1;



#endif /* AXMCOMMONPARAM_HPP_ */
