/*
 * AXMImageSensor.cpp
 */

#include "AXMImageSensor.hpp"
#include "AXFEvent.hpp"
#include "AXFStage.hpp"
#include "AXMIsp/AXMIsp.hpp"
#include "AXMCommon/AXMCommonParam.hpp"
#ifndef BB_TMP_PASS	/* 一旦コンパイルを通す用 */
#include "AXMIspConfig.hpp"
#endif
#include "imageSensorDrv.h"
#include "AXMIspAe/AXMIspAeAlgorithm.hpp"

AXMImageSensor::AXMImageSensor(AXFObjectName& name)
    : AXModelActor(name),
      m_log(name),
      m_name(name),
      m_timerID(0) {
  m_log.write(AXFLOG_DEBUG, "ImageSensor Constractor");
  p_spec = 0;			//  設定値格納先アドレス初期化
  irisContStop = IRIS_CONT_STOP;			// 停止電圧
  irisContCloseSlow = IRIS_CONT_CLOSE_SLOW;	// ③ アイリス閉低速電圧
  irisContCloseFast = IRIS_CONT_CLOSE_FAST;	// ④ アイリス閉高速電圧
  irisContOpenSlow = IRIS_CONT_OPEN_SLOW;  	// ⑤ アイリス開低速電圧
  irisContOpenFast = IRIS_CONT_OPEN_FAST;  	// ⑥ アイリス開高速電圧
      state = 0;

}

AXMImageSensor::~AXMImageSensor() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor Destractor");

}

ax::actorFuncStatus AXMImageSensor::onCreate() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor onCreate()");

  // StateMachine に必要な情報を登録する
  //      自オブジェクト,
  //      初期状態,
  //      状態の最大数
  if (0 > setStateInfo(this, STATE_WAITING, STATE_MAX)) {
#ifndef PARASOFT_CPPTEST
    m_log.write(AXFLOG_ERR, "fail registHandle");
    return ax::AXFACTOR_ERROR;
#endif  //  PARASOFT_CPPTEST
  }

  // STATE_0状態の状態テーブルを登録する
  //      状態テーブルで登録する状態,
  //      状態テーブルのポインタ,
  setStateTable(STATE_WAITING, state_waiting);
  setStateTable(STATE_RUNNING, state_running);

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMImageSensor::onStart() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor onStart()");
//  	setSpecParameter();	// Spec 初期値

  Init();

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMImageSensor::onStop() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor onStop()");

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMImageSensor::onDestroy() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor onDestroy()");

  return ax::AXFACTOR_SUCCESS;
}


#if 0
ax::actorFuncStatus AXMImageSensor::onPause() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor onPause()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMImageSensor::onResume() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor onResume()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMImageSensor::onRestart() {
  m_log.write(AXFLOG_DEBUG, "ImageSensor onRestart()");
  return ax::AXFACTOR_SUCCESS;
}
#endif


//  以下、サンプルプログラムより作成
#include  "../AXMIspTest/DSPCommon.h"
#include  "../AXMIspTest/proc_def_isp_eval.h"
#include  "../AXMIspTest/proc_def_imageif_eval.h"
#include  "../AXMIspTest/proc_def_cmos_eval.h"

void AXMImageSensor::Init() {

#ifndef  PARASOFT_CPPTEST
  //init_isp_enc(1920, 1080, 640, 360, 320, 180, 1024, 768, 0x0000001B);
  //init_imageif_sony_imx136_dsp(2200, 1125, 1920, 1080);

  //init_cmos_sony_imx136(LVDS_MODE_1920x1080);
  //start_cmos();
#endif  //  PARASOFT_CPPTEST
}

void AXMImageSensor::setSpecParameter(void) {
	if(p_spec != NULL) {
		p_spec->ImageSensor.lensKind = E_IRISCONT_DC;
	}
}

void AXMImageSensor::checkComm(void) {
	
	if(p_spec != NULL) {
		if( p_spec->changeStatus[1] & SPEC_CHG_IMGS ) {
			set_iris_control( p_spec->ImageSensor.lensKind );
			p_spec->changeStatus[1] &= ~SPEC_CHG_IMGS;
		}
		if( p_spec->changeStatus[0] & SPEC_CHG_AE009 ) {
#ifdef MECHA_IRIS
			if( (p_spec->AE.mechaIrisAdjust.irisCloseFast > p_spec->AE.mechaIrisAdjust.irisCloseSlow) && 
				(p_spec->AE.mechaIrisAdjust.irisCloseSlow > p_spec->AE.mechaIrisAdjust.irisStopUpper) &&
				(p_spec->AE.mechaIrisAdjust.irisStopUpper >= p_spec->AE.mechaIrisAdjust.irisStopLower) &&
			    (p_spec->AE.mechaIrisAdjust.irisStopLower > 0) ) {
				irisContStop = (p_spec->AE.mechaIrisAdjust.irisStopUpper + p_spec->AE.mechaIrisAdjust.irisStopLower) >> 1;
				irisContCloseSlow = p_spec->AE.mechaIrisAdjust.irisCloseSlow;
				irisContCloseFast = p_spec->AE.mechaIrisAdjust.irisCloseFast;
				irisContOpenSlow = p_spec->AE.mechaIrisAdjust.irisOpenSlow;
				irisContOpenFast = p_spec->AE.mechaIrisAdjust.irisOpenFast;
		    }
#endif
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE009;
	    }
	}
}
