/*
 * AXMIspState.cpp
 */

//#define ADJUST_TEST

#include "../AXMCommon/AXMCommonConfig.hpp"
#include "AXMIsp.hpp"
#include    <iostream>
#include <sstream>
#include <string>
#include    <iomanip>

#include "../../project/refkit/AXMIspConfig.hpp"
#include "../AXMPixcessor/AXMPixcessor.hpp"
#include "../AXMIspAe/AXMIspAe.hpp"
#include "../AXMIspAwb/AXMIspAwb.hpp"
#include "../AXMIspAdjust/AXMIspAdjust.hpp"
#include "../AXMIspAwb/AXMIspAwbCommon.hpp"
#include "../AXMIspAssist/AXMIspAssist.hpp"
#include "../AXMCommon/AXMCommonParam.hpp"

#include "AXMCommon/AXMCommonBridgeParam.hpp"
#include "AXFStage.hpp"
#include "AXMPixcessor/AXMPixcessorInt/AXMPixcessorInt.hpp"

#ifdef USE_AXFTEST_COMMAND
//#include "../AXMIspAf/AXMIspAf.hpp"
#include "../AXMIspAe/AXMIspAe.hpp"
#include "../AXMIspAwb/AXMIspAwb.hpp"
#endif /* USE_AXFTEST_COMMAND */

#include "AXHSpecParam.hpp"

#include "AXMIspTest/proc_def_imageif_eval.h"

#include "AXMIspAe/AXMISPtype.hpp"

#include "AXMIspTest/DSPCommon.h"
#include "AXMIspTest/reg_isp.h"

extern "C" {
extern 
	unsigned long getImgPicCt(void);
	extern void audio_reset_isp_mode(void);

}

const unsigned char ShadeCorrectFrame1 = 0x01;
#if 0 // baba 存在しない
static unsigned char g_AperExMode = 0;
#endif
static unsigned long g_sav_sac_val00 = 0;

// 3rdリリースから、「モデルイベント」と「デバイスイベント」の
// 登録が可能となる。
//
// 状態テーブルは、状態ごとに定義し、イベントIDとメンバ関数の紐付けを行う。
// ※状態テーブルの最後は、必ず{0,NULL}で終了する必要がある。

// STATE_0状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIsp::StateTable AXMIsp::state_0[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    {AXMIsp::EVENT_SPEC_ADDR,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcSpecAddr},
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameIsr0},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},
#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_1[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  1フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0100},
    //  1フレーム目 AE周期演算終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0101},
    //  1フレーム目 AWB(短時間) 色データ計算処理終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0102},
    //  1フレーム目 OB周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0103},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},
#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_2[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  2フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0200},
    //  2フレーム目 AE周期演算終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0201},
    //  2フレーム目 AWB(短時間) OPDマスク処理(ATWmode),ゲイン/マトリックス設定処理(manu mode),光源枠判定処理(one push)終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0202},
     //  2フレーム目 OB周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0203},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_3[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  3フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0300},
    //  3フレーム目 AE周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0301},
    //  3フレーム目 AWB(短時間) 光源枠判定処理(ATWmode),重心計算処理(one push)終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0302},
    //  3フレーム目 OB周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0303},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_4[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  4フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0400},
    //  4フレーム目 AE 周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0401},
    //  4フレーム目 AWB(短時間) 重み付け処理(AWBmode),調整/収束制御処理(one push)終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0402},
    //  4フレーム目 OB 周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0403},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_5[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  5フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0500},
    //  5フレーム目 AE 周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0501},
    //  5フレーム目 AWB(短時間) 重心計算処理・調整/収束制御処理終了(ATWmode),ゲイン/マトリックス設定処理(one push)終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0502},
    //  5フレーム目 OB 周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0503},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_6[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  6フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0600},
    //  6フレーム目 AE 周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0601},
    //  6フレーム目 AWB(長時間) 色データ計算処理終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0602},
    //  6フレーム目 OB 周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0603},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_7[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  7フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0700},
    //  7フレーム目 AE 周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0701},
    //  7フレーム目 AWB(長時間) OPDマスク処理(ATWmode)
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0702},
    //  7フレーム目 OB 周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0703},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_8[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  8フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0800},
    //  8フレーム目 AE 周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0801},
    //  8フレーム目 AWB(長時間) 光源枠判定処理(ATWmode)終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0802},
    //  8フレーム目 OB 周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0803},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_9[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  9フレーム目 VD割込
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0900},
    //  9フレーム目 AE 周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0901},
    //  9フレーム目 AWB(長時間) 重み付け処理(AWBmode)終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0902},
    //  9フレーム目 OB 周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0903},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

const AXMIsp::StateTable AXMIsp::state_10[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    //  10フレーム目
	{AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A00},
    //  10フレーム目 AE 周期演算処理終了
    {AXMIsp::EVENT_AE_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A01},
    //  10フレーム目 AWB(長時間) 重心計算処理/調整・収束制御処理(ATWmode)終了
    {AXMIsp::EVENT_AWB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A02},
    //  10フレーム目 OB 周期処理終了
    {AXMIsp::EVENT_OB_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A03},
    {AXMIsp::EVENT_AE_MODE_CHANGE,                          //  AEモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A08},
    {AXMIsp::EVENT_AWB_MODE_CHANGE,                         //  AWBモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A09},
    {AXMIsp::CORRECTEVENT_SHADE_MODE_CHANGE,                //  シェーディング補正モード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A0A},
    {AXMIsp::CORRECTEVENT_KIZU_MODE_CHANGE,                 //  キズ補正モード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix0A0B},
    {AXMIsp::EVENT_NOTIFY_LENS,
     (AXMIsp::StateFuncPtr) &AXMIsp::recvLenzInfo},

#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

// STATE_100状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
//const AXMIsp::StateTable AXMIsp::state_100[] = {
//    {AXFEVENT_DEVICE_FRAME_ISR,
//     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameIsr100},
//    {0,NULL}
//};

//  調整モード : WB調整
// STATE_1000状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIsp::StateTable AXMIsp::state_1000[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1000},
    {AXMIsp::EVENT_AWB_ADJUST_END,                          //  AWBバラつき調整終了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1001},
    {AXMIsp::EVENT_AE_MODE_CHANGE,                          //  AEモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1008},
    {AXMIsp::EVENT_AWB_MODE_CHANGE,                         //  AWBモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1009},
    {AXMIsp::CORRECTEVENT_SHADE_MODE_CHANGE,                //  シェーディング補正モード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix100A},
    {AXMIsp::CORRECTEVENT_KIZU_MODE_CHANGE,                //  キズ補正モード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix100B},
#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

//  調整モード : アイリス調整
// STATE_1100状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIsp::StateTable AXMIsp::state_1100[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1100},
    {AXMIsp::EVENT_AE_END,                                  //  AE アイリス調整処理終了
	 (AXMIsp::StateFuncPtr) &AXMIsp::matrix1101},
    {AXMIsp::EVENT_AE_MODE_CHANGE,                          //  AEモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1108},
    {AXMIsp::EVENT_AWB_MODE_CHANGE,                         //  AWBモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1109},
    {AXMIsp::CORRECTEVENT_SHADE_MODE_CHANGE,                //  シェーディング補正モード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix110A},
    {AXMIsp::CORRECTEVENT_KIZU_MODE_CHANGE,                 //  キズ補正モード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix110B},
#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

//  調整モード : シェーディング補正
// STATE_1200状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIsp::StateTable AXMIsp::state_1200[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1200},
    {AXMIsp::EVENT_AE_END,                                  //  AE シャッター制御処理終了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1201},
    {AXMIsp::EVENT_SHADE_END,                               //  シェーディング補正演算終了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1202},
    {AXMIsp::EVENT_AE_MODE_CHANGE,                          //  AEモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1208},
    {AXMIsp::EVENT_AWB_MODE_CHANGE,                         //  AWBモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1209},
    {AXMIsp::CORRECTEVENT_WAIT_MODE_CHANGE,                 //  Correct 待機中 変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix120A},
    {AXMIsp::CORRECTEVENT_KIZU_MODE_CHANGE,                 //  Correct キズ補正モード 変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix120B},
#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

//  調整モード : キズ補正
// STATE_1300状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIsp::StateTable AXMIsp::state_1300[] = {
    //フレーム生成完了通知(DSP->ARM)
    {AXMIsp::EVENT_IRQ_FRAMEGEN,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcFrameGen},
    {AXFEVENT_DEVICE_FRAME_ISR,
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1300},
    {AXMIsp::EVENT_KIZU_END,                                //  キズ補正演算終了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1301},
// キズ補正モード変更時にWDRモードのままになっている不具合に対応 Start
    {AXMIsp::EVENT_AE_END,                                  //  AE シャッター制御処理終了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1302},
// キズ補正モード変更時にWDRモードのままになっている不具合に対応 End
    {AXMIsp::EVENT_AE_MODE_CHANGE,                          //  AEモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1308},
    {AXMIsp::EVENT_AWB_MODE_CHANGE,                         //  AWBモード変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix1309},
    {AXMIsp::CORRECTEVENT_SHADE_MODE_CHANGE,                //  Correct シェーディング補正モード 変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix130A},
    {AXMIsp::CORRECTEVENT_WAIT_MODE_CHANGE,                 //  Correct 待機中 変更完了
     (AXMIsp::StateFuncPtr) &AXMIsp::matrix130B},
#ifdef USE_AXFTEST_COMMAND
    {AXMIsp::EVENT_PRISCHED_TEST,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedTest },
    {AXMIsp::EVENT_PRISCHED_END,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcPriSchedEnd },
#endif /* USE_AXFTEST_COMMAND */
#ifdef USE_AXBRIDGE_DEMO
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp1,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp1 },
    {AXMIsp::EVENT_AXBRIDGE_TEST_NvrToIsp2,
     (AXMIsp::StateFuncPtr) &AXMIsp::funcNvrToIsp2 },
#endif /* USE_AXBRIDGE_DEMO */
    {0,NULL}
};

//フレーム生成完了通知(DSP->ARM)
ax::actorFuncStatus AXMIsp::funcFrameGen(const void *pParam, int size) {
  //送信先ステージ設定
  AXFObjectName nameARMNvr("codec", "nvrStage");

  //送信パラメータ取得
  struct IspToNvrParam_FrameGen_Control_t* p = NULL;
  AXMPixcessorInt *obj = NULL;
#ifndef PARASOFT_CPPTEST
  AXFStage::getInstance()->getActorInfo(namePixessorInt, (AXFActor**)&obj);
  p = (IspToNvrParam_FrameGen_Control_t*)obj->getGenParam();
#else
  p = (IspToNvrParam_FrameGen_Control_t*)pParam;
#endif  //  PARASOFT_CPPTEST

  if(p != NULL) {
    //送信パラメータ設定
    struct IspToNvrParam_FrameGen_Control_t sendParam;
    sendParam = *((IspToNvrParam_FrameGen_Control_t*)p);
    int axfEvent = sendParam.cmd;

    //フレーム生成完了通知(DSP->ARM)
#ifndef PARASOFT_CPPTEST
    if (0 > send(nameARMNvr, AXFEVENT_MODEL(axfEvent), &sendParam, sizeof(sendParam))){
			;
    }
#else
    CPPTest_Param[0] = sendParam.cmd;
    CPPTest_Param[1] = sendParam.bankno;
    CPPTest_Param[2] = sendParam.complex;
    CPPTest_WORK = sizeof(sendParam);
#endif  //  PARASOFT_CPPTEST
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::funcSpecAddr(const void *pParam, int size) {
  if((0 < size) && (pParam != 0x00000000ul)) {
    ST_MSG *msg = (ST_MSG*)pParam;
    p_spec = (ST_SPEC *)msg->data;

		// LISRに設定が無いため不要
//#ifdef  ENABLE_OPD_CONFIG_ISP_TO_AXH
//    //  SPU出力画像データフォーマット設定
//    unsigned int width = p_spec->Scaler.scaling.InImgSize.Width;
//    unsigned int height = p_spec->Scaler.scaling.InImgSize.Height;
//
//    opdConfigAE.setImageSize(width, height, false);
//#endif

    f_init = true;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::funcFrameIsr0(const void *pParam, int size) {
  if(f_init == true) {
#ifdef USE_AXBRIDGE_DEMO
    sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

    setPixcessorMemBank();

		// LISRに設定が無いため不要
    ////  １フレーム目OPD設定(AWB)
    //setOpdConfigAwb(ISP_FRAME_AWB_3A);

    chkOBChange();

    state = STATE_FRAME_1ST;
#ifndef PARASOFT_CPPTEST
    setNextState(state);
#endif  //  PARASOFT_CPPTEST
    status = Status_Waiting;
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0100(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();

		// LISRに設定が無いため不要
    //if(isWdrMode == True) {
    //  //  2フレーム目OPD設定(AWB:WDRモード時)
    //  setOpdConfigAwb(ISP_FRAME_AWB_3A_L);
    //}
    //else {
    //  //  2フレーム目OPD設定(AE:通常モード時)
    //  setOpdConfigAe(ISP_FRAME_AE_3A_0);	// normal
    //}

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == True) {
	    msg.cmd = Cmd_Get_OPD_AE_L_1;	
    } else {
#endif
	    msg.cmd = Cmd_Get_OPD_AE_0;	
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_1st;	// frame No.追加

#ifdef AXM_ISP_CT_AWB
    AXMIspCTAwb::CreateTestData();
#endif

    getOpdDataForAe(msg);
		// 今回AFは非対応のため不要
    //getEvalDataForAf();		//AF評価値取得要求

    execObProc();

    chkScalerChange();
    chkApertureChange();
    chkChromaChange();
    chkApertureChangeEx();	// アパーチャ補正信号を出力

#ifndef PARASOFT_CPPTEST
    //  AXMIspAdjustへ画質調整設定値確認要求
    if (0 > send(nameIspAdjust, AXFEVENT_MODEL(AXMIspAdjust::EVENT_CHECK_SETTINGS), 0, 0)) {
      ////m_log.write(AXFLOG_ERR, "fail send Adjust EVENT_CHECK_SETTINGS");
    }
#endif  //  PARASOFT_CPPTEST
#ifdef ADJUST_TEST
  	funcTest();	// for debug
#endif
    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0101(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {


    if(ispAWBMode != AWBMode_HoldMode) {
      //  AWB 色データ計算処理(AWB:ATWMode/ManuMode/OnePush各モード共通)
      //    ホールドモードのときは演算を実行しない
      //  AXMPixessorへAWB用画像データ取得イベントを送信する
      static ST_MSG msg;
      msg.sid = SID_AXMIsp;
      msg.rid = RID_AXMPixcessor;
      msg.cmd = Cmd_Get_OPD_AWB;
      getOpdDataForAwb(msg);
    }
    else {
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
        //  OB演算終了時処理 : 次ステータスに移行する
			*/
        state = STATE_FRAME_2ND;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時処理 : OB演算の終了を待ってから、次ステータスに移行する
			*/
    }

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

    status |= Status_AeEnd;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0102(const void *pParam, int size) {
  state = STATE_FRAME_2ND;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0103(const void *pParam, int size) {
	if(ispAWBMode == AWBMode_HoldMode) {
		if((status & Status_AeEnd) == Status_AeEnd) {
			//  AE演算終了時処理 : 次ステータスに移行する
			state = STATE_FRAME_2ND;
#ifndef PARASOFT_CPPTEST
			setNextState(state);
#endif  //  PARASOFT_CPPTEST
			status = Status_Waiting;
		}
		else {
			//  AE演算未終了時処理 : AE演算の終了を待ってから、次ステータスに移行する
			status |= Status_ObEnd;
		}
	}
	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0200(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();
#ifdef WDR
    if(isWdrMode == true) {
      //  3フレーム目OPD設定(AE:WDRモード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_0);	// WDR
    }
    else {
#endif
      //  3フレーム目OPD設定(AE:通常モード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_1);	// normal
#ifdef WDR
    }
#endif

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == True) {
	    msg.cmd = Cmd_Get_OPD_AE_1;
    } else {
#endif
	    msg.cmd = Cmd_Get_OPD_AE_1;	
      getEvalDataForAf();		//AF評価値取得要求
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_2nd;	// frame No.追加

    getOpdDataForAe(msg);

    // AWB, OB開始前からOB処理を行う
    execObProc();

    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0201(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end
  if((status & Status_AeEnd) != Status_AeEnd) {
    if(ispAWBMode == AWBMode_HoldMode) {
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
         //  OB演算終了時処理
			*/
        state = STATE_FRAME_3RD;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時 : OB演算の終了を待ってから、次ステータスに移行する
			*/
    }
    else if((ispAWBMode == AWBMode_ATWMode) ||              //  ATW標準モード
            (ispAWBMode == AWBMode_ATWSceaneMode)) {        //  ATWシーンモード
      //  AWB OPDマスク処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_OPD_MASK), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if((ispAWBMode == AWBMode_TempManuMode ) ||        //  色温度指定マニュアルモード
            (ispAWBMode == AWBMode_LightManuMode) ||        //  照明指定マニュアルモード
            (ispAWBMode == AWBMode_GainManuMode)) {         //  ゲイン指定マニュアルモード
#ifndef PARASOFT_CPPTEST
      //  AWB ゲイン/マトリックス設定処理 スタート
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_CONTROL), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if(ispAWBMode == AWBMode_OnePushMode) {            //  ワンプッシュモード
      //  AWB 光源枠判定処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_LIGHT_SOURCE), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

  }
  status |= Status_AeEnd;

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0202(const void *pParam, int size) {
  state = STATE_FRAME_3RD;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0203(const void *pParam, int size) {
	if(ispAWBMode == AWBMode_HoldMode) {
		if((status & Status_AeEnd) == Status_AeEnd) {
			//  AE演算終了時処理 : 次ステータスに移行する
			state = STATE_FRAME_3RD;
#ifndef PARASOFT_CPPTEST
			setNextState(state);
#endif  //  PARASOFT_CPPTEST
			status = Status_Waiting;
		}
		else {
			//  AE演算未終了時処理 : AEの演算が終了してから、次ステータスに移行する
			status |= Status_ObEnd;
		}
	}
	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0300(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();
#ifdef WDR
    if(isWdrMode == true) {
      //  4フレーム目OPD設定(AE:WDRモード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_L_0);	// WDR K.Kawachi add
    }
    else {
#endif
      //  4フレーム目OPD設定(AE:通常モード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_0);	// normal
#ifdef WDR
    }
#endif
    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == true) {
      msg.cmd = Cmd_Get_OPD_AE_L_1;
    }
    else {
#endif
      msg.cmd = Cmd_Get_OPD_AE_0;
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_3rd;	// frame No.追加

    getOpdDataForAe(msg);
      getEvalDataForAf();		//AF評価値取得要求

    execObProc();

  status |= Status_FrameIsr;
 }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0301(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

    if((ispAWBMode == AWBMode_ATWMode      ) ||             //  ATW標準モード
       (ispAWBMode == AWBMode_ATWSceaneMode)) {             //  ATWシーンモード
      //  AWB 光源枠判定処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_LIGHT_SOURCE), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if((ispAWBMode == AWBMode_TempManuMode ) ||        //  色温度指定マニュアルモード
            (ispAWBMode == AWBMode_LightManuMode) ||        //  照明指定マニュアルモード
            (ispAWBMode == AWBMode_GainManuMode)  ||        //  ゲイン指定マニュアルモード
            (ispAWBMode == AWBMode_HoldMode)) {             //  ホールドモード
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
        //  OB演算終了時処理 : 次ステータスに移行する
			*/
        state = STATE_FRAME_4TH;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = ::Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時処理 : OB演算が終了してから、次ステータスに移行する
			*/
    }
    else if(ispAWBMode == AWBMode_OnePushMode) {            //  ワンプッシュモード
      //  AWB 重心計算処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_BALANCE_CENTER), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

  }
  status |= Status_AeEnd;

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0302(const void *pParam, int size) {
  state = STATE_FRAME_4TH;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0303(const void *pParam, int size) {
	if((ispAWBMode == AWBMode_TempManuMode)  ||             //  色温度指定マニュアルモード
	   (ispAWBMode == AWBMode_LightManuMode) ||             //  照明指定マニュアルモード
	   (ispAWBMode == AWBMode_GainManuMode)  ||             //  ゲイン指定マニュアルモード
	   (ispAWBMode == AWBMode_HoldMode)) {                  //  ホールドモード
		if((status & Status_AeEnd) == Status_AeEnd) {
			//  AE演算終了時処理 : 次ステータスに移行する
			state = STATE_FRAME_4TH;
#ifndef PARASOFT_CPPTEST
			setNextState(state);
#endif  //  PARASOFT_CPPTEST
			status = Status_Waiting;
		}
		else {
			//  AE演算未終了時処理 : AE演算が終了してから、次ステータス
			status |= Status_ObEnd;
		}
	}
	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0400(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();
#ifdef WDR
    if(isWdrMode == true) {
	    //  5フレーム目OPD設定(AE)
	    setOpdConfigAe(ISP_FRAME_AE_3A_1);	// WDR 
    } else {
#endif
	    //  5フレーム目OPD設定(AE)
	    setOpdConfigAe(ISP_FRAME_AE_3A_1);	//  normal
#ifdef WDR
    }
#endif
		
    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == true) {
      msg.cmd = Cmd_Get_OPD_AE_0;
    }
    else {
#endif
      msg.cmd = Cmd_Get_OPD_AE_1;
      getEvalDataForAf();		//AF評価値取得要求
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_4th;	// frame No.追加

    getOpdDataForAe(msg);

    execObProc();

    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0401(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

    if((ispAWBMode == AWBMode_ATWMode      ) ||             //  ATW標準モード
       (ispAWBMode == AWBMode_ATWSceaneMode)) {             //  ATWシーンモード
      //  AWB 重み付け/調整・収束制御/ゲイン・マトリックス設定処理 スタート
      static ST_AWB_CALC  calc;
      calc.Luminance = Luminance;
      static ST_MSG msg;
      msg.data = (void *)&calc;
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WEIGHT_DATA), &msg, sizeof(ST_MSG))) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if((ispAWBMode == AWBMode_TempManuMode ) ||        //  色温度指定マニュアルモード
            (ispAWBMode == AWBMode_LightManuMode) ||        //  照明指定マニュアルモード
            (ispAWBMode == AWBMode_GainManuMode)  ||        //  ゲイン指定マニュアルモード
            (ispAWBMode == AWBMode_HoldMode)) {             //  ホールドモード
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
			*/
        state = STATE_FRAME_5TH;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時処理 : OBの演算が終了してから、次ステータスに移行する
			*/
    }
    else if(ispAWBMode == AWBMode_OnePushMode) {            //  ワンプッシュモード
      //  AWB 調整/収束制御処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_TARGET), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

  }
  status |= Status_AeEnd;

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0402(const void *pParam, int size) {
  state = STATE_FRAME_5TH;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0403(const void *pParam, int size) {
	if((ispAWBMode == AWBMode_TempManuMode)  ||             //  色温度指定マニュアルモード
	   (ispAWBMode == AWBMode_LightManuMode) ||             //  照明指定マニュアルモード
	   (ispAWBMode == AWBMode_GainManuMode)  ||             //  ゲイン指定マニュアルモード
	   (ispAWBMode == AWBMode_HoldMode)) {                  //  ホールドモード
		if((status & Status_AeEnd) == Status_AeEnd) {
			//  AE演算終了時処理 : 次ステータスに移行する
			state = STATE_FRAME_5TH;
#ifndef PARASOFT_CPPTEST
			setNextState(state);
#endif  //  PARASOFT_CPPTEST
			status = Status_Waiting;
		}
		else {
			//  AE演算未終了時処理 : AE演算が終了してから、次ステータスに移行する
			status |= Status_ObEnd;
		}
	}
	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0500(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();
#ifdef WDR
    if(isWdrMode == true) {
      //  6フレーム目OPD設定(AE:WDRモード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_L_1);	// WDR
    }
    else {
#endif
      //  6フレーム目OPD設定(AE:通常モード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_0);	// normal
#ifdef WDR
    }
#endif

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == true) {
	    msg.cmd = Cmd_Get_OPD_AE_L_0;		// 通常モード/WDR共に Cmd_Get_OPD_AE_1
    } else {
#endif
	    msg.cmd = Cmd_Get_OPD_AE_0;		// 通常モード/WDR共に Cmd_Get_OPD_AE_1
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_5th;	// frame No.追加

    getOpdDataForAe(msg);
      getEvalDataForAf();		//AF評価値取得要求

    execObProc();

    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0501(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

    if((ispAWBMode == AWBMode_ATWMode      ) ||             //  ATW標準モード
       (ispAWBMode == AWBMode_ATWSceaneMode)) {             //  ATWシーンモード
      //  AWB 重心計算処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_TARGET_CONTROL), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if((ispAWBMode == AWBMode_TempManuMode ) ||        //  色温度指定マニュアルモード
            (ispAWBMode == AWBMode_LightManuMode) ||        //  照明指定マニュアルモード
            (ispAWBMode == AWBMode_GainManuMode)  ||        //  ゲイン指定マニュアルモード
            (ispAWBMode == AWBMode_HoldMode)) {             //  ホールドモード
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
        //  OB演算終了時処理 : 次ステータスに移行する
			*/
        state = STATE_FRAME_6TH;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時 : OB演算が終了してから、次ステータスに移行する
			*/
    }
    else if(ispAWBMode == AWBMode_OnePushMode)                //  ワンプッシュモード
    {
    //  AWB ゲイン/マトリックス設定処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_CONTROL), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

  }
  status |= Status_AeEnd;

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0502(const void *pParam, int size) {
  state = STATE_FRAME_6TH;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0503(const void *pParam, int size) {
	if((ispAWBMode == AWBMode_TempManuMode)  ||             //  色温度指定マニュアルモード
	   (ispAWBMode == AWBMode_LightManuMode) ||             //  照明指定マニュアルモード
	   (ispAWBMode == AWBMode_GainManuMode)  ||             //  ゲイン指定マニュアルモード
	   (ispAWBMode == AWBMode_HoldMode)) {                  //  ホールドモード
		if((status & Status_AeEnd) == Status_AeEnd) {
			//  AE演算終了時処理 : 次ステータスに移行する
			state = STATE_FRAME_6TH;
#ifndef PARASOFT_CPPTEST
			setNextState(state);
#endif  //  PARASOFT_CPPTEST
			status = Status_Waiting;
		}
		else {
			//  AE演算未終了時処理 : AEの演算が終了してから、次ステータスに移行する
			status |= Status_ObEnd;
		}
	}
return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0600(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();

    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == true) {
      //  7フレーム目OPD設定(AE:WDRモード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_0);	// WDR
      msg.cmd = Cmd_Get_OPD_AE_1;
    }
    else {
#endif
      //  7フレーム目OPD設定(AE:通常モード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_1);	// normal
      msg.cmd = Cmd_Get_OPD_AE_1;
    	      getEvalDataForAf();		//AF評価値取得要求
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_6th;	// frame No.追加

#ifdef AXM_ISP_CT_AWB
	if((isWdrMode == true) && (ispAWBMode != AWBMode_HoldMode)) {
		AXMIspCTAwb::CreateTestData();
	}
#endif

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    getOpdDataForAe(msg);

    execObProc();

    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0601(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

#ifdef WDR
    if((isWdrMode == true) && (ispAWBMode != AWBMode_HoldMode)) {
      //  WDRモード時処理(ホールドモードを除く)
      //  WDRモード時:長時間の演算を行う
      //  AWB 色データ計算処理(AWB:ATWMode/ManuMode/OnePush各モード共通)
      //  AXMPixessorへAWB用画像データ取得イベントを送信する
      static ST_MSG msg;
      msg.sid = SID_AXMIsp;
      msg.rid = RID_AXMPixcessor;
      msg.cmd = Cmd_Get_OPD_AWB_L;
      getOpdDataForAwb(msg);
      status |= Status_AeEnd;
    }
    else  {
#endif
      //  ホールドモードおよびWDRモード以外時処理
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
        //  OB演算終了時処理 : 次ステータスに移行する
			*/
        state = STATE_FRAME_7TH;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時 : OB演算の終了を待って、次ステータスに移行する
			*/
#ifdef WDR
    }
#endif
  }
  status |= Status_AeEnd;

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0602(const void *pParam, int size) {
  state = STATE_FRAME_7TH;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0603(const void *pParam, int size) {
  if((isWdrMode == false) || (ispAWBMode == AWBMode_HoldMode)) {
    if((status & Status_AeEnd) == Status_AeEnd) {
      //  AE演算終了時処理 : 次ステータスに移行する
      state = STATE_FRAME_7TH;
#ifndef PARASOFT_CPPTEST
      setNextState(state);
#endif  //  PARASOFT_CPPTEST
      status = Status_Waiting;          //  演算終了フラグクリア
    }
    else {
      //  AE演算未終了時処理 : AE演算の終了を待って、次ステータスに移行する
      status |= Status_ObEnd;           //  OB演算終了フラグセット
    }
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0700(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */


  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();

    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == true) {
      //  8フレーム目OPD設定(AE:WDRモード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_L_0);	// WDR
      msg.cmd = Cmd_Get_OPD_AE_L_1;
    }
    else {
#endif
      //  8フレーム目OPD設定(AE:通常モード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_0);	// normal
      msg.cmd = Cmd_Get_OPD_AE_0;
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_7th;	// frame No.追加

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    getOpdDataForAe(msg);

    execObProc();
      getEvalDataForAf();		//AF評価値取得要求

    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0701(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

    if((isWdrMode == true) && (ispAWBMode != AWBMode_HoldMode)) {
      //  WDRモード時(ホールドモードを除く)
      if((ispAWBMode == AWBMode_ATWMode      ) ||           //  ATW標準モード
         (ispAWBMode == AWBMode_ATWSceaneMode)) {           //  ATWシーンモード
        //  AWB OPDマスク処理 スタート
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_OPD_MASK), 0, 0)) {
					;
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAwb::EVENT_OPD_MASK;
#endif  //  PARASOFT_CPPTEST
      }
      else if((ispAWBMode == AWBMode_TempManuMode ) ||      //  色温度指定マニュアルモード
              (ispAWBMode == AWBMode_LightManuMode) ||      //  照明指定マニュアルモード
              (ispAWBMode == AWBMode_GainManuMode)) {       //  ゲイン指定マニュアルモード
#ifndef PARASOFT_CPPTEST
        //  AWB ゲイン/マトリックス設定処理 スタート
        if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_CONTROL), 0, 0)) {
					;
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAwb::EVENT_CONTROL;
#endif  //  PARASOFT_CPPTEST
      }
      else if(ispAWBMode == AWBMode_OnePushMode) {          //  ワンプッシュモード
        //  AWB 光源枠判定処理 スタート
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_LIGHT_SOURCE), 0, 0)) {
					;
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAwb::EVENT_LIGHT_SOURCE;
#endif  //  PARASOFT_CPPTEST
      }
      status |= Status_AeEnd;
    }
    else {
      //  ホールドモードおよびWDRモード以外時処理
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
        //  OB演算終了時処理 : 次ステータスに移行する
			*/
        state = STATE_FRAME_8TH;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
			// OBは今回使用しないため終了は見ない
			/*
      }
      else {
        //  OB演算未終了時処理 : OB演算の終了を待って、次ステータスに移行する
        status |= Status_AeEnd;
      }
			*/
    }
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0702(const void *pParam, int size) {
  state = STATE_FRAME_8TH;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0703(const void *pParam, int size) {
  if((isWdrMode == false) || (ispAWBMode == AWBMode_HoldMode)) {
    if((status & Status_AeEnd) == Status_AeEnd) {
      //  AE演算終了時処理 : 次ステータスに移行する
      state = STATE_FRAME_8TH;
#ifndef PARASOFT_CPPTEST
      setNextState(state);
#endif  //  PARASOFT_CPPTEST
      status = Status_Waiting;
    }
    else {
      //  AE演算未終了時処理 : AE演算が終了してから、次ステータスに移行する
      status |= Status_ObEnd;
    }
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0800(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();

    //  9フレーム目OPD設定
    if(isWdrMode == true) {
	    setOpdConfigAe(ISP_FRAME_AE_3A_1);	// WDR normal
    } else {
	    setOpdConfigAe(ISP_FRAME_AE_3A_1);	// WDR normal
    }

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == true) {
      msg.cmd = Cmd_Get_OPD_AE_0;
    }
    else {
#endif
      msg.cmd = Cmd_Get_OPD_AE_1;
      getEvalDataForAf();		//AF評価値取得要求
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_8th;	// frame No.追加

    getOpdDataForAe(msg);

    execObProc();

    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0801(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

    if((isWdrMode == false) ||                              //  ISP通常モード時
       (ispAWBMode == ::AWBMode_TempManuMode)  ||           //  色温度指定マニュアルモード
       (ispAWBMode == ::AWBMode_LightManuMode) ||           //  照明指定マニュアルモード
       (ispAWBMode == ::AWBMode_GainManuMode)  ||           //  ゲイン指定マニュアルモード
       (ispAWBMode == ::AWBMode_HoldMode)) {                //  ホールドモード
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
        //  OB演算終了時処理 : 次ステータスに移行する
			*/
        state = STATE_FRAME_9TH;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時処理 : OB演算の終了を待ってから、次ステータスに移行する
			*/
    }
    //  以降、WDRモード時処理(マニュアルモード、ホールドモードを除く)
    else if((ispAWBMode == AWBMode_ATWMode      ) ||        //  ATW標準モード
            (ispAWBMode == AWBMode_ATWSceaneMode)) {        //  ATWシーンモード
      //  AWB 光源枠判定処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_LIGHT_SOURCE), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if(ispAWBMode == AWBMode_OnePushMode) {          //  ワンプッシュモード
      //  AWB 重心計算処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_BALANCE_CENTER), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    status |= ::Status_AeEnd;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0802(const void *pParam, int size) {
  state = STATE_FRAME_9TH;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0803(const void *pParam, int size) {
  if((isWdrMode == false) ||
     (ispAWBMode == ::AWBMode_TempManuMode)  ||             //  色温度指定マニュアルモード
     (ispAWBMode == ::AWBMode_LightManuMode) ||             //  照明指定マニュアルモード
     (ispAWBMode == ::AWBMode_GainManuMode)  ||             //  ゲイン指定マニュアルモード
     (ispAWBMode == ::AWBMode_HoldMode)) {                  //  ホールドモード
    if((status & Status_AeEnd) == Status_AeEnd) {
      //  AE演算終了時処理 : 次ステータスに移行する
      state = STATE_FRAME_9TH;
#ifndef PARASOFT_CPPTEST
      setNextState(state);
#endif  //  PARASOFT_CPPTEST
      status = Status_Waiting;
    }
    else {
      //  AE演算未終了時処理 : AE演算の終了を待って、次ステータスに移行する
      status |= Status_ObEnd;
    }
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0900(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();

    // フレーム割り込みのカウンタをリセット　WDRで画面が暗くなる不具合に対応
#ifdef WDR
  	if(isWdrMode == true) {
      //  10フレーム目OPD設定(WDRモード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_L_1);	// WDR
    }
    else {
#endif
      //  10フレーム目OPD設定(WDRモード時)
      setOpdConfigAe(ISP_FRAME_AE_3A_0);	// normal
#ifdef WDR
    }
#endif
	   	getEvalDataForAf();		//AF評価値取得要求

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
  	if(isWdrMode == true) {
	  	msg.cmd = Cmd_Get_OPD_AE_L_0;	// 通常モード/WDR共に Cmd_Get_OPD_AE_1
  	} else {
#endif
	  	msg.cmd = Cmd_Get_OPD_AE_0;	// 通常モード Cmd_Get_OPD_AE_1
#ifdef WDR
  	}
#endif
    msg.cmd |= Cmd_Frame_9th;	// frame No.追加

	getOpdDataForAe(msg);

	execObProc();

    status |= Status_FrameIsr;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0901(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
#ifdef WDR
  	bool wdrMode = fromAeToIsp->is_wdr_mode;
  	if(wdrMode != isWdrMode) {
  	  isWdrMode = wdrMode;
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
  	  setImgWDRMode(isWdrMode);
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
  	}
#endif
  	// WDRモード変更確認と同じタイミングでLinearモードのチェック
  	setImageIFOpeMode();
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

    if((isWdrMode == false) ||                              //  ISP通常モード
       (ispAWBMode == ::AWBMode_TempManuMode)  ||           //  色温度指定マニュアルモード
       (ispAWBMode == ::AWBMode_LightManuMode) ||           //  照明指定マニュアルモード
       (ispAWBMode == ::AWBMode_GainManuMode)  ||           //  ゲイン指定マニュアルモード
       (ispAWBMode == ::AWBMode_HoldMode)) {                //  ホールドモード
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
    	//  OB演算終了時処理：次ステータスに移行する
			*/
        state = STATE_FRAME_10TH;
#ifndef PARASOFT_CPPTEST
        setNextState(state);
#endif  //  PARASOFT_CPPTEST
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時処理：OB演算の終了を待ってから、次ステータスに移行する
			*/
    }
    //  以降、WDRモード時処理(マニュアルモード、ホールドモードを除く)
    else if((ispAWBMode == AWBMode_ATWMode      ) ||        //  ATW標準モード
            (ispAWBMode == AWBMode_ATWSceaneMode)) {        //  ATWシーンモード
      //  AWB 重み付け/調整・収束制御/ゲイン・マトリックス設定処理 スタート
      static ST_AWB_CALC  calc;
      calc.Luminance = Luminance;
      static ST_MSG msg;
      msg.data = (void *)&calc;
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WEIGHT_DATA), &msg, sizeof(ST_MSG))) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WEIGHT_DATA");
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if(ispAWBMode == AWBMode_OnePushMode) {          //  ワンプッシュモード
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_TARGET), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_TARGET");
      }
#endif  //  PARASOFT_CPPTEST
    }
    status |= ::Status_AeEnd;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0902(const void *pParam, int size) {
  state = STATE_FRAME_10TH;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0903(const void *pParam, int size) {
  if((isWdrMode == false) ||
     (ispAWBMode == ::AWBMode_TempManuMode)  ||             //  色温度指定マニュアルモード
     (ispAWBMode == ::AWBMode_LightManuMode) ||             //  照明指定マニュアルモード
     (ispAWBMode == ::AWBMode_GainManuMode)  ||             //  ゲイン指定マニュアルモード
     (ispAWBMode == ::AWBMode_HoldMode)) {                  //  ホールドモード
    //  AE演算終了時処理 : 次ステータスに移行する
    if((status & Status_AeEnd) == Status_AeEnd) {
      state = STATE_FRAME_10TH;
#ifndef PARASOFT_CPPTEST
      setNextState(state);
#endif  //  PARASOFT_CPPTEST
      status = Status_Waiting;
    }
    else {
      //  AE演算未終了時処理 : AEの演算処理を待って、次ステータスに移行する
      status |= Status_ObEnd;
    }
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A00(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();

    //  1フレーム目OPD設定
    setOpdConfigAwb(ISP_FRAME_AWB_3A);

    //  AE 演算処理 スタート
    //  AXMPixessorへAE用画像データ取得イベントを送信する
    static ST_MSG msg;
#ifdef WDR
    if(isWdrMode == true) {
      msg.cmd = Cmd_Get_OPD_AE_1;	// K.Kawachi modified Cmd_Get_OPD_AE_L_0 => Cmd_Get_OPD_AE_L_1
    }
    else {
#endif
      msg.cmd = Cmd_Get_OPD_AE_1;
	   	getEvalDataForAf();		//AF評価値取得要求
#ifdef WDR
    }
#endif
    msg.cmd |= Cmd_Frame_10th;	// frame No.追加

    getOpdDataForAe(msg);

    execObProc();

    status |= Status_FrameIsr;
   }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A01(const void *pParam, int size) {
// 明るさ情報取得 start
#if 1	//明るさ情報が不要なステートでは0にすること
  if((pParam != 0x00000000ul) && (0 < size)) {
    static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
    Luminance = fromAeToIsp->luminance;
  }
#endif
// 明るさ情報取得 end

  if((status & Status_AeEnd) != Status_AeEnd) {

#ifdef AXM_ISP_CT_AE
    AXMIspCTAe::CheckResult();
#endif

    if((isWdrMode == false) ||                              //  ISP通常モード
       (ispAWBMode == ::AWBMode_TempManuMode)  ||           //  色温度指定マニュアルモード
       (ispAWBMode == ::AWBMode_LightManuMode) ||           //  照明指定マニュアルモード
       (ispAWBMode == ::AWBMode_GainManuMode)  ||           //  ゲイン指定マニュアルモード
       (ispAWBMode == ::AWBMode_HoldMode)) {                //  ホールドモード
			// OBは今回使用しないため終了は見ない
			/*
      if((status & Status_ObEnd) == Status_ObEnd) {
    	//  OB演算終了時処理：モードの変更確認後に次ステータスに移行する
			*/
        //  モード確認・変更
        matrix0Axx_checkModeStatus();
        status = Status_Waiting;
        return ax::AXFACTOR_SUCCESS;
			// OBは今回使用しないため終了は見ない
			/*
      }
      //  OB演算未終了時処理：OB演算の終了を待ってから、モード変更確認後に次ステータスに移行する
			*/
    }
    //  以降、WDRモード時処理(マニュアルモード、ホールドモードを除く)
    else if((ispAWBMode == AWBMode_ATWMode      ) ||        //  ATW標準モード
            (ispAWBMode == AWBMode_ATWSceaneMode)) {        //  ATWシーンモード
      //  AWB 重心計算処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_TARGET_CONTROL), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    else if(ispAWBMode == AWBMode_OnePushMode) {          //  ワンプッシュモード
      //  AWB ゲイン/マトリックス設定処理 スタート
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_CONTROL), 0, 0)) {
				;
      }
#endif  //  PARASOFT_CPPTEST
    }
    status |= Status_AeEnd;
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A02(const void *pParam, int size) {
  //  モード確認・変更
  matrix0Axx_checkModeStatus();
  status = Status_Waiting;
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A03(const void *pParam, int size) {
	chkOBChange();

    if((isWdrMode == false) ||
       (ispAWBMode == ::AWBMode_TempManuMode)  ||           //  色温度指定マニュアルモード
       (ispAWBMode == ::AWBMode_LightManuMode) ||           //  照明指定マニュアルモード
       (ispAWBMode == ::AWBMode_GainManuMode)  ||           //  ゲイン指定マニュアルモード
       (ispAWBMode == AWBMode_HoldMode)) {                  //  ホールドモード
	  if((status & Status_AeEnd) == Status_AeEnd) {
	    //  AE演算終了時処理 : 次ステータスに移行する
	    matrix0Axx_checkModeStatus();
	    status = Status_Waiting;
	  }
	  else {
	    //  AE演算未終了時処理 : AE演算の終了を待って、次ステータスに移行する
	    status |= ::Status_ObEnd;
	  }
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A08(const void *pParam, int size) {
  switch(p_spec->Mode)
  {
    case ISP_Mode_Adjust_WB:                                //  WB調整モード
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ADJUST), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ADJUST");
      }
#endif  //  PARASOFT_CPPTEST
// WB調整モードに変更時WDRモードのままである不具合に対応 start
#ifdef WDR
	  {
		 bool wdrMode = false;		// WDRモードをOFFにする
		 if(wdrMode != isWdrMode) {
			isWdrMode = wdrMode;
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
			setImgWDRMode(isWdrMode);
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
			// WDRモード変更確認と同じタイミングでLinearモードのチェック
			setImageIFOpeMode();
		 }
	  }
#endif
// WB調整モードに変更時WDRモードのままである不具合に対応 end
      break;
    case ISP_Mode_Adjust_IRIS:                              //  IRIS調整モード
			// 該当処理なしのため不要
			/*
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
      }
#endif  //  PARASOFT_CPPTEST
			*/
      break;
    case ISP_Mode_Adjust_SHADE:                             //  シェーディング補正モード
			// 該当処理なしのため不要
			/*
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
      }
#endif  //  PARASOFT_CPPTEST
			*/
      break;
    case ISP_Mode_Adjust_KIZU:                              //  キズ補正モード
			// 該当処理なしのため不要
			/*
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
      }
#endif  //  PARASOFT_CPPTEST
			*/
      break;
    case ISP_Mode_Run:                                      //  通常モード
      //  AWBモード変更の時は、このmatrixを経由しない
      state = STATE_FRAME_1ST;
      break;
    default:
      state = STATE_FRAME_1ST;
      break;
  }
  status = ::Status_Waiting;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A09(const void *pParam, int size) {
  switch(p_spec->Mode)
  {
    case ISP_Mode_Adjust_WB:                                //  WB調整モード
      state = STATE_ADJUST_WB;
      break;
    case ISP_Mode_Adjust_IRIS:                              //  IRIS調整モード
      state = STATE_ADJUST_IRIS;
      break;
    case ISP_Mode_Adjust_SHADE:                             //  シェーディング補正モード
      break;
    case ISP_Mode_Adjust_KIZU:                              //  キズ補正モード
      break;
    case ISP_Mode_Run:                                      //  通常モード
    default:
      state = STATE_FRAME_1ST;
      break;
  }
  status = ::Status_Waiting;
  ispMode = p_spec->Mode;
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A0A(const void *pParam, int size) {
  state = STATE_ADJUST_SHADE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix0A0B(const void *pParam, int size) {
  state = STATE_ADJUST_KIZU;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1000(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */
// WB調整モードに変更時WDRモードのままである不具合に対応 start
#ifdef WDR
	  {
		 bool wdrMode = false;		// WDRモードをOFFにする
		 if(wdrMode != isWdrMode) {
			isWdrMode = wdrMode;
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
			setImgWDRMode(isWdrMode);
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
			// WDRモード変更確認と同じタイミングでLinearモードのチェック
			setImageIFOpeMode();
		 }
	  }
#endif
// WB調整モードに変更時WDRモードのままである不具合に対応 end

  unsigned short cmd;

  setPixcessorMemBank();

  if((ispCorrect.frameCnt & ShadeCorrectFrame1) == ShadeCorrectFrame1) {
    //  OPD設定
    setOpdConfigAwb(ISP_FRAME_AWB_3A);
    cmd = Cmd_Get_OPD_AWB_L;
  }
  else {
    //  OPD設定
    setOpdConfigAwb(ISP_FRAME_AWB_3A_L);
    cmd = Cmd_Get_OPD_AWB;
  }

  //  フレームカウンタ更新
  ispCorrect.frameCnt ^= ShadeCorrectFrame1;

  static ST_MSG msg;
  msg.cmd = cmd;
  if(( p_spec->AWB.SpectrumAdjust.regLowTempStart & Reg_Start) == Reg_Start)
  {
    msg.cmd |= Cmd_Adjust_AWB_Low;
    //  バラつき調整実行 : 低色温度側調整実行
    getOpdDataForAwb(msg);
    //  フラグクリア
    p_spec->AWB.SpectrumAdjust.regLowTempStart &= ~Reg_Start;
  }
  else if((p_spec->AWB.SpectrumAdjust.regHighTempStart & Reg_Start) == Reg_Start)
  {
    msg.cmd |= Cmd_Adjust_AWB_High;
    //  バラつき調整実行 : 高色温度側調整実行
    getOpdDataForAwb(msg);
    //  フラグクリア
    p_spec->AWB.SpectrumAdjust.regHighTempStart &= ~Reg_Start;
  }
  else
  {
    if((ispCorrect.frameCnt & ShadeCorrectFrame1) == ShadeCorrectFrame1) {
      //  偶数回実行していなければ、モード変更不可とする
      return ax::AXFACTOR_SUCCESS;
    }

    if(ispMode ^ p_spec->Mode)
    {
      switch(p_spec->Mode)
      {
        case ISP_Mode_Run:                //  通常モードへ移行(matrix1008/matrix1009経由で移行)
#ifndef PARASOFT_CPPTEST
          if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_RUNNING), 0, 0)) {
            //m_log.write(AXFLOG_ERR, "fail send AE EVENT_RUNNING");
          }
#else   //  PARASOFT_CPPTEST
          event = AXMIspAe::EVENT_RUNNING;
#endif  //  PARASOFT_CPPTEST
          break;
        case ISP_Mode_Adjust_IRIS:        //  IRIS調整モードへ移行(matrix1008/matrix1009経由で移行)
					// アイリス使用しないため不要
					/*
          //  AEは調整モードに、AWBは待機中に移行させる
#ifndef PARASOFT_CPPTEST
          if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_ADJUST), 0, 0)) {
            //m_log.write(AXFLOG_ERR, "fail send AE EVENT_ADJUST");
          }
#else   //  PARASOFT_CPPTEST
          event = AXMIspAe::EVENT_ADJUST;
#endif  //  PARASOFT_CPPTEST
					*/
        break;
        case ISP_Mode_Adjust_SHADE:       //  シェーディング補正モードへ移行(matrix1008/matrix1009経由で移行)
          //  AWBのみ待機中に移行させる
#ifndef PARASOFT_CPPTEST
          if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_SPEC_AEMODE), 0, 0)) {
            //m_log.write(AXFLOG_ERR, "fail send AE EVENT_SPEC_AEMODE");
          }
#else   //  PARASOFT_CPPTEST
          event = AXMIspAe::EVENT_SPEC_AEMODE;
#endif  //  PARASOFT_CPPTEST
          break;
        case ISP_Mode_Adjust_KIZU:        //  キズ補正モードへ移行(matrix1008/matrix1009経由で移行)
					// 欠陥モードなしのため不要
					/*
          //  AWBのみ待機中に移行させる
#ifndef PARASOFT_CPPTEST
          if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_DEFECT_MODE), 0, 0)) {
            //m_log.write(AXFLOG_ERR, "fail send AE EVENT_DEFECT_MODE");
          }
#else   //  PARASOFT_CPPTEST
          event = AXMIspAe::EVENT_DEFECT_MODE;
#endif  //  PARASOFT_CPPTEST
					*/
          break;
        case ISP_Mode_Adjust_WB:          //  モード変更なし(WB調整モード)
        default:
          state = STATE_ADJUST_WB;
          break;
      }
    }
  }

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
#ifdef ADJUST_TEST
	  	funcTest();	// for debug
#endif
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1001(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size))
  {
    //  受信データをSRAM共有メモリに展開(デフォルト座標、光源枠座標)
    ST_MSG *msg = (ST_MSG*)pParam;
    ST_AWB_ADJUST *AdjData = (ST_AWB_ADJUST*)msg->data;
    //  光源枠座標コピー
    for(int i = 0; i < AWBLightSource_Max; i++)
    {
      p_spec->AWB.LightSource[i] = AdjData->LightSource[i];
    }
    //  光源デフォルト座標
    for(int i = 0; i < AWBLightDefault_Max; i++)
    {
      p_spec->AWB.LightDefault[i] = AdjData->LightDefault[i];
    }
  }

  state = STATE_ADJUST_WB;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1008(const void *pParam, int size) {
	if(p_spec){
	  switch(p_spec->Mode)
	  {
	    case ISP_Mode_Run:                  //  通常モード
	      //  AWBはモード別に移行させる
	      checkAWBMode_IspModeRun();
	      break;
	    case ISP_Mode_Adjust_IRIS:          //  IRIS調整モード
				// 該当処理なしのため不要
				/*
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
	      }
	#endif  //  PARASOFT_CPPTEST
				*/
	      break;
	    case ISP_Mode_Adjust_SHADE:         //  シェーディング補正モード
				// 該当処理なしのため不要
				/*
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
	      }
	#endif  //  PARASOFT_CPPTEST
				*/
	      break;
	    case ISP_Mode_Adjust_KIZU:          //  キズ補正モード
				// 該当処理なしのため不要
				/*
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
	      }
	#endif  //  PARASOFT_CPPTEST
				*/
	      break;
	    case ISP_Mode_Adjust_WB:            //  WB調整モード
	    default:
	      state = STATE_ADJUST_WB;
	      break;
	  }
	}
  status = ::Status_Waiting;

  #ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1009(const void *pParam, int size) {
  switch(p_spec->Mode)
  {
    case ISP_Mode_Run:                                      //  通常モード
      state = STATE_FRAME_1ST;
      setBankCounterAtFirstFrame();
      break;
    case ISP_Mode_Adjust_IRIS:                              //  IRIS調整モード
      state = STATE_ADJUST_IRIS;
      break;
    case ISP_Mode_Adjust_SHADE:                             //  シェーディング補正モード
      break;
    case ISP_Mode_Adjust_WB:                                //  WB調整モード
    default:
      state = STATE_ADJUST_WB;
      break;
  }
  status = ::Status_Waiting;
  ispMode = p_spec->Mode;
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix100A(const void *pParam, int size) {
  state = STATE_ADJUST_SHADE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix100B(const void *pParam, int size) {
  state = STATE_ADJUST_KIZU;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1100(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

	static ST_MSG msg;

  setPixcessorMemBank();
  if((ispCorrect.frameCnt & ShadeCorrectFrame1) == ShadeCorrectFrame1) {
    //  OPD設定
    setOpdConfigAe(ISP_FRAME_AE_3A_0);
	  //  AE演算処理開始設定
	  msg.cmd = Cmd_Get_OPD_AE_1;
  }
  else {
    //  OPD設定
    setOpdConfigAe(ISP_FRAME_AE_3A_1);
	  //  AE演算処理開始設定
	  msg.cmd = Cmd_Get_OPD_AE_0;
  }

  //  フレームカウンタ更新
  ispCorrect.frameCnt ^= ShadeCorrectFrame1;

	//  AE演算開始要求
	getOpdDataForAe(msg);
#ifdef ADJUST_TEST
	  	funcTest();	// for debug
#endif
	  return ax::AXFACTOR_SUCCESS;

}

ax::actorFuncStatus AXMIsp::matrix1101(const void *pParam, int size) {
// IRIS調整モードに変更時WDRモードのままである不具合に対応 start
	if((pParam != NULL) && (0 < size)) {
	  static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
#ifdef WDR
	  bool wdrMode = fromAeToIsp->is_wdr_mode;
	  if(wdrMode != isWdrMode) {
	    isWdrMode = wdrMode;
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
	    setImgWDRMode(isWdrMode);
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
	    // WDRモード変更確認と同じタイミングでLinearモードのチェック
	    setImageIFOpeMode();
	  }
#endif
	}
// IRIS調整モードに変更時WDRモードのままである不具合に対応 end

  if(ispMode ^ p_spec->Mode)
  {
    switch(p_spec->Mode)
    {
      case ISP_Mode_Run:                //  通常モードに移行
        //  AEとAWBは通常モードに移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_RUNNING), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_RUNNING");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_RUNNING;
#endif  //  PARASOFT_CPPTEST
        break;
      case ISP_Mode_Adjust_WB:          //  WB調整モードに移行(matrix1108/matrix1109経由で移行)
				// 該当処理は無いため不要
				/*
        //  AEは待機中に、AWBは調整モードに移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_WAITING), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_WAITING");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_WAITING;
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_SHADE:       //  シェーディング補正モードへ移行(matrix1108/matrrix1109経由で移行)
        //  AWBのみ待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_SPEC_AEMODE), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_SPEC_AEMODE");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_SPEC_AEMODE;
#endif  //  PARASOFT_CPPTEST
        break;
      case ISP_Mode_Adjust_KIZU:        //  キズ補正モードに移行(matrix1108/matrix1109経由で移行)
				// 欠陥モードなしのため不要
				/*
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_DEFECT_MODE), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_WAITING");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_DEFECT_MODE;
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_IRIS:        //  モード変更なし(IRIS調整モード)
      default:
        state = STATE_ADJUST_IRIS;
        break;
    }
  }

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;

}

ax::actorFuncStatus AXMIsp::matrix1108(const void *pParam, int size) {
	if(p_spec){
	  switch(p_spec->Mode)
	  {
	    case ISP_Mode_Run:                  //  通常モード
	      checkAWBMode_IspModeRun();
	      break;
	    case ISP_Mode_Adjust_WB:            //  WB調整モード
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ADJUST), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ADJUST");
	      }
	#endif  //  PARASOFT_CPPTEST
	      break;
	    case ISP_Mode_Adjust_SHADE:         //  シェーディング補正モード
				// 該当処理なしのため不要
				/*
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
	      }
	#endif  //  PARASOFT_CPPTEST
				*/
	      break;
	    case ISP_Mode_Adjust_KIZU:          //  キズ補正モード
				// 該当処理なしのため不要
				/*
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
	      }
	#endif  //  PARASOFT_CPPTEST
				*/
	      break;
	    case ISP_Mode_Adjust_IRIS:          //  モード変更なし(IRIS調整モード)
	    default:
	      state = STATE_ADJUST_IRIS;
	      break;
	  }
	}
  status = ::Status_Waiting;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1109(const void *pParam, int size) {
  switch(p_spec->Mode)
  {
    case ISP_Mode_Run:                                      //  通常モード
      state = STATE_FRAME_1ST;
      setBankCounterAtFirstFrame();
      break;
    case ISP_Mode_Adjust_WB:                                //  WB調整モード
      state = STATE_ADJUST_WB;
      break;
    case ISP_Mode_Adjust_SHADE:                             //  シェーディング補正モード
      break;
    case ISP_Mode_Adjust_IRIS:                              //  モード変更なし(IRIS調整モード)
    default:
      state = STATE_ADJUST_IRIS;
      break;
  }
  status = ::Status_Waiting;
  ispMode = p_spec->Mode;
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix110A(const void *pParam, int size) {
  //  AEの状態を変更：シャッター制御モード、スローシャッターOFF
  state = STATE_ADJUST_SHADE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix110B(const void *pParam, int size) {
  //  AEの状態を変更：マニュアルモード、メカアイリス調整(調整モード:OFF, アイリス制御値:0xFFu)
  state = STATE_ADJUST_KIZU;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1200(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  if((status & Status_FrameIsr) != Status_FrameIsr) {
    setPixcessorMemBank();

#ifndef  PARASOFT_CPPTEST
    static ST_MSG msg;
#endif  //  PARASOFT_CPPTEST
    if((ispCorrect.frameCnt & ShadeCorrectFrame1) == ShadeCorrectFrame1) {
      //  OPD設定
      setOpdConfigAe(ISP_FRAME_AE_3A_0);
      //  AE演算処理開始設定
      msg.cmd = Cmd_Get_OPD_AE_1;
    }
    else {
      //  OPD設定
      setOpdConfigAe(ISP_FRAME_AE_3A_1);
      //  AE演算処理開始設定
      msg.cmd = Cmd_Get_OPD_AE_0;
    }

    //  AE演算開始要求
    getOpdDataForAe(msg);

#ifndef PARASOFT_CPPTEST
    //  AXMIspAdjustへ画質調整設定値確認要求
    if (0 > send(nameIspAdjust, AXFEVENT_MODEL(AXMIspAdjust::EVENT_CHECK_SETTINGS), 0, 0)) {
      //m_log.write(AXFLOG_ERR, "fail send Adjust EVENT_CHECK_SETTINGS");
    }
#endif  //  PARASOFT_CPPTEST

    //  ステータスフラグセット
    status |= Status_FrameIsr;
  }

#ifdef ADJUST_TEST
	funcTest();
#endif
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1201(const void *pParam, int size) {
  if((status & Status_AeEnd) != Status_AeEnd) {
    if((pParam != NULL) && (0 < size)) {
      static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
      Luminance = fromAeToIsp->luminance;
#ifdef WDR
      bool wdrMode = fromAeToIsp->is_wdr_mode;
      if(wdrMode != isWdrMode) {
        isWdrMode = wdrMode;
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
        setImgWDRMode(isWdrMode);
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
		// WDRモード変更確認と同じタイミングでLinearモードのチェック
		setImageIFOpeMode();
      }
#endif
      //  AXMIspCorrectへ演算開始要求
      getImageDataForShading();
      //  フレームカウンタ更新
      ispCorrect.frameCnt ^= ShadeCorrectFrame1;
      status |= Status_AeEnd;
    }
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1202(const void *pParam, int size) {
  status = Status_Waiting;

  if((ispCorrect.frameCnt & ShadeCorrectFrame1) == ShadeCorrectFrame1) {
    //  偶数回実行していなければ、モード変更不可とする
    return ax::AXFACTOR_SUCCESS;
  }

  if(ispMode ^ p_spec->Mode)
  {
    switch(p_spec->Mode)
    {
      case ISP_Mode_Run:                //  通常モードに移行(matrix1208/matrix1209経由で移行)
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_RUNNING), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_RUNNING");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_RUNNING;
#endif  //  PARASOFT_CPPTEST
        break;
      case ISP_Mode_Adjust_WB:          //  WB調整モードに移行(matrix1208/matrix1209経由で移行)
				// 該当処理は無いため不要
				/*
        //  AEは待機中に、AWBは調整モードに移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_WAITING), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_WAITING");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_WAITING;
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_IRIS:        //  IRIS調整モードに移行(matrix1208/matrix1209経由で移行)
				// アイリス使用しないため不要
				/*
        //  AEは調整モードに、AWBは待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_ADJUST), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_ADJUST");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_ADJUST;
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_KIZU:        //  キズ補正モードへ移行(matrix1208/matrix1209経由で移行)
				// 欠陥モードなしのため不要
				/*
        //  AWBのみ待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_DEFECT_MODE), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_DEFECT_MODE");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_DEFECT_MODE;
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_SHADE:       //  モード変更なし(シェーディング補正モード)
      default:
        state = STATE_ADJUST_SHADE;
        break;
    }
  }

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1208(const void *pParam, int size) {
  switch(p_spec->Mode)
  {
    case ISP_Mode_Run:                  //  通常モード
      switch(p_spec->AWB.AWBMode)
      {
        case AWBMode_TempManuMode:                          //  色温度指定マニュアルモード
        case AWBMode_LightManuMode:                         //  照明指定マニュアルモード
        case AWBMode_GainManuMode:                          //  ゲイン指定マニュアルモード
          //  マニュアルモードに移行
#ifndef PARASOFT_CPPTEST
          if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_MANU_MODE), 0, 0)) {
            //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_MANU_MODE");
          }
#endif  //  PARASOFT_CPPTEST
          break;
        case AWBMode_OnePushMode:                           //  ワンプッシュモード
          //  ワンプッシュモードに移行
#ifndef PARASOFT_CPPTEST
          if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ONE_PUSH), 0, 0)) {
            //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ONE_PUSH");
          }
#endif  //  PARASOFT_CPPTEST
          break;
        case AWBMode_ATWMode:                               //  ATWモード
        case AWBMode_ATWSceaneMode:                         //  ATWシーンモード
        default:
          //  ATWモードに移行
#ifndef PARASOFT_CPPTEST
          if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ATW_MODE), 0, 0)) {
            //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ATW_MODE");
          }
#endif  //  PARASOFT_CPPTEST
          break;
      }
      break;
    case ISP_Mode_Adjust_WB:            //  WB調整モード
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ADJUST), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ADJUST");
      }
#endif  //  PARASOFT_CPPTEST
      break;
    case ISP_Mode_Adjust_IRIS:          //  IRIS調整モード
			// 該当処理なしのため不要
			/*
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
      }
#endif  //  PARASOFT_CPPTEST
			*/
      break;
    case ISP_Mode_Adjust_KIZU:          //  キズ補正モード
			// 該当処理なしのため不要
			/*
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
      }
#endif  //  PARASOFT_CPPTEST
			*/
      break;
    case ISP_Mode_Adjust_SHADE:         //  モード変更なし(シェーディング補正モード)
    default:
      state = STATE_ADJUST_SHADE;
      break;
  }

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1209(const void *pParam, int size) {
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix120A(const void *pParam, int size) {
  switch(p_spec->Mode)
  {
    case ISP_Mode_Run:                                      //  通常モード
      //  AEの状態を元の状態に戻す
      state = STATE_FRAME_1ST;
      setBankCounterAtFirstFrame();
      break;
    case ISP_Mode_Adjust_WB:                                //  WB調整モード
    	//  AEの状態を元の状態に戻す
      state = STATE_ADJUST_WB;
      break;
    case ISP_Mode_Adjust_IRIS:                              //  IRIS調整モード
    	//  AEの状態を元の状態に戻す
      state = STATE_ADJUST_IRIS;
      break;
    case ISP_Mode_Adjust_KIZU:                              //  キズ補正モード
    	//  AEの状態を元の状態に戻す
      state = STATE_ADJUST_KIZU;
      break;
    case ISP_Mode_Adjust_SHADE:                             //  モード変更なし(シェーディング補正モード)
    default:
      state = STATE_ADJUST_SHADE;
      break;
  }
  status = ::Status_Waiting;
  ispMode = p_spec->Mode;
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix120B(const void *pParam, int size) {
  state = STATE_ADJUST_KIZU;

  status = ::Status_Waiting;
  ispMode = p_spec->Mode;
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1300(const void *pParam, int size) {
#ifdef USE_AXBRIDGE_DEMO
  sendNvrTest();
#endif /* USE_AXBRIDGE_DEMO */

  setPixcessorMemBank();

  static ST_MSG msg;

  if((ispCorrect.frameCnt & ShadeCorrectFrame1) == ShadeCorrectFrame1) {
    //  OPD設定
    setOpdConfigAe(ISP_FRAME_AE_3A_0);
    msg.cmd = Cmd_Get_OPD_AE_1;
  }
  else {
    //  OPD設定
    setOpdConfigAe(ISP_FRAME_AE_3A_1);
    msg.cmd = Cmd_Get_OPD_AE_0;
  }

  //  AE演算開始要求
  getOpdDataForAe(msg);

  //  キズ補正用画像データ取得
  getImageDataForKizu();

  //  フレームカウンタ更新(シェーディング補正用カウンタを共用)
  ispCorrect.frameCnt ^= ShadeCorrectFrame1;
#ifdef ADJUST_TEST
	funcTest();	// for debug
#endif
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1301(const void *pParam, int size) {
  //  モード変更チェック
  if((ispCorrect.frameCnt & ShadeCorrectFrame1) == ShadeCorrectFrame1) {
    //  偶数回実行していなければ、モード変更不可とする
    return ax::AXFACTOR_SUCCESS;
  }

  //  設定値変更チェックおよびモード変更
  if(ispMode ^ p_spec->Mode)
  {
    switch(p_spec->Mode)
    {
      case ISP_Mode_Run:                //  通常モードに移行(matrix1308/matrix1309経由で移行)
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_RUNNING), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_RUNNING");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_RUNNING;
#endif  //  PARASOFT_CPPTEST
        break;
      case ISP_Mode_Adjust_WB:          //  WB調整モードに移行(matrix1308/matrix1309経由で移行)
				// 該当処理は無いため不要
				/*
        //  AEは待機中に、AWB調整モードに移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_WAITING), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_WAITING");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_WAITING;
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_IRIS:        //  IRIS調整モードに移行(matrix1308/matrix1309経由で移行)
				// アイリス使用しないため不要
				/*
        //  AEは調整モードに、AWBは待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_ADJUST), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_ADJUST");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_ADJUST;
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_SHADE:       //  シェーディング補正モードに移行(matrix1308経由で移行)
    	//  AWBのみ待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_SPEC_AEMODE), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_SPEC_AEMODE");
        }
#else   //  PARASOFT_CPPTEST
        event = AXMIspAe::EVENT_SPEC_AEMODE;
#endif  //  PARASOFT_CPPTEST
        break;
      case ISP_Mode_Adjust_KIZU:        //  モード変更なし(キズ補正モード)
      default:
        state = STATE_ADJUST_KIZU;
        break;
    }
  }

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

// キズ補正モード変更時にWDRモードのままになっている不具合に対応 Start
ax::actorFuncStatus AXMIsp::matrix1302(const void *pParam, int size) {

  if((status & Status_AeEnd) != Status_AeEnd) {
    if((pParam != NULL) && (0 < size)) {
      static ST_FROM_AE_TO_ISP *fromAeToIsp = (ST_FROM_AE_TO_ISP *)pParam;
      Luminance = fromAeToIsp->luminance;
#ifdef WDR
      bool wdrMode = fromAeToIsp->is_wdr_mode;
      if(wdrMode != isWdrMode) {
        isWdrMode = wdrMode;
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
        setImgWDRMode(isWdrMode);
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
		// WDRモード変更確認と同じタイミングでLinearモードのチェック
		setImageIFOpeMode();
      }
#endif
      status |= Status_AeEnd;
    }
  }

  return ax::AXFACTOR_SUCCESS;
}
// キズ補正モード変更時にWDRモードのままになっている不具合に対応 End

ax::actorFuncStatus AXMIsp::matrix1308(const void *pParam, int size) {
	if(p_spec){
	  switch(p_spec->Mode)
	  {
	    case ISP_Mode_Run:                                      //  通常モード
	      checkAWBMode_IspModeRun();
	      break;
	    case ISP_Mode_Adjust_WB:                                //  WB調整モード
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ADJUST), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ADJUST");
	      }
	#endif  //  PARASOFT_CPPTEST
	      break;
	    case ISP_Mode_Adjust_IRIS:                              //  IRIS調整モード
				// 該当処理なしのため不要
				/*
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
	      }
	#endif  //  PARASOFT_CPPTEST
				*/
	      break;
	    case ISP_Mode_Adjust_SHADE:                             //  シェーディング補正モード
				// 該当処理なしのため不要
				/*
	#ifndef PARASOFT_CPPTEST
	      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_WAITING), 0, 0)) {
	        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
	      }
	#endif  //  PARASOFT_CPPTEST
				*/
	      break;
	    case ISP_Mode_Adjust_KIZU:                              //  モード変更なし(キズ補正モード)
	    default:
	      state = STATE_ADJUST_KIZU;
	      break;
	  }
	}
  status = ::Status_Waiting;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix1309(const void *pParam, int size) {
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix130A(const void *pParam, int size) {
  state = STATE_ADJUST_SHADE;

  status = ::Status_Waiting;
  ispMode = p_spec->Mode;
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::matrix130B(const void *pParam, int size) {
  switch(p_spec->Mode)
  {
    case ISP_Mode_Run:                                      //  通常モード
      //  AEの状態を元の状態に戻す
      state = STATE_FRAME_1ST;
      setBankCounterAtFirstFrame();
      break;
    case ISP_Mode_Adjust_WB:                                //  WB調整モード
      //  AEの状態を元の状態に戻す
      state = STATE_ADJUST_WB;
      break;
    case ISP_Mode_Adjust_IRIS:                              //  IRIS調整モード
      //  AEの状態を元の状態に戻す
      state = STATE_ADJUST_IRIS;
      break;
    case ISP_Mode_Adjust_SHADE:                             //  シェーディング補正モード
      //  AEの状態を元の状態に戻す
      state = STATE_ADJUST_SHADE;
      break;
    case ISP_Mode_Adjust_KIZU:                              //  モード変更なし(キズ補正モード)
    default:
      state = STATE_ADJUST_KIZU;
      break;
  }
  status = ::Status_Waiting;
  ispMode = p_spec->Mode;
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;

#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::funcFrameIsr100(const void *pParam, int size) {
  return ax::AXFACTOR_SUCCESS;
}

/*
 * AXMPixcessorへAWB用OPD設定を要求する
 */
void AXMIsp::setOpdConfigAwb(IspFrameAwb mode)
{
  static UCHAR frameID;
  frameID = (UCHAR)mode;

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH

  static ST_MSG msg;

  msg.sid = SID_AXMIsp;
  msg.rid = RID_AXMPixcessor;
  msg.data = (void *)&frameID;

#ifndef PARASOFT_CPPTEST
  if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::ISP_EVENT_AWB_OPD_SET), &msg, sizeof(ST_MSG))) {
    //m_log.write(AXFLOG_ERR, "fail send Pixcessor ISP_EVENT_AWB_OPD_SET");
  }
#endif  //  PARASOFT_CPPTEST

#else   //  ENABLE_OPD_CONFIG_ISP_TO_AXH

  opdConfigAWB.setOpdMode(g_opd_mode_raw);
  opdConfigAWB.setVerDiv(g_opd_v_div_awb);
  opdConfigAWB.setHorDiv(g_opd_h_div_awb);
  opdConfigAWB.setVerWSize(g_avever_w_size_v_awb);
  opdConfigAWB.setHorWSize(g_avever_w_size_h_awb);
  switch(frameID) {
    case AXMIsp::ISP_FRAME_AWB_3A:      //  AWB 短時間画像設定
      opdConfigAWB.setOpdConfig(AXH_Cmd_Get_Opd_AWB_0, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AWB_3A_L:    //  AWB 長時間画像設定
    default:
      opdConfigAWB.setOpdConfig(AXH_Cmd_Get_Opd_AWB_1, isWdrMode);
      break;
  }

#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
}

/*
 * AXMPixcessorへAE用OPD設定を要求する
 */
void AXMIsp::setOpdConfigAe(IspFrameAe mode)
{
  static UCHAR frameID;
  frameID = (UCHAR)mode;

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH

  static ST_MSG msg;

  msg.sid = SID_AXMIsp;
  msg.rid = RID_AXMPixcessor;
  msg.data = (void *)&frameID;

#ifndef PARASOFT_CPPTEST
  if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::ISP_EVENT_AE_OPD_SET), &msg, sizeof(ST_MSG))) {
    //m_log.write(AXFLOG_ERR, "fail send Pixcessor ISP_EVENT_AE_OPD_SET");
  }
#endif  //  PARASOFT_CPPTEST

#else   //  ENABLE_OPD_CONFIG_ISP_TO_AXH

  opdConfigAE.setOpdMode(g_opd_mode_yrgb);
  opdConfigAE.setVerDiv(g_opd_v_div_ae);
  opdConfigAE.setHorDiv(g_opd_h_div_ae);
  opdConfigAE.setVerWSize(g_avever_w_size_v_ae);
  opdConfigAE.setHorWSize(g_avever_w_size_h_ae);
  switch(frameID) {
    case AXMIsp::ISP_FRAME_AE_3A_0:     //  AE 短時間0画像設定
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE0_0, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AE_3A_1:     //  AE 短時間1画像設定
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE0_1, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AE_3A_L_0:   //  AE 長時間0画像設定
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE1_0, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AE_3A_L_1:   //  AE 長時間1画像設定
    default:
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE1_1, isWdrMode);
      break;
  }

#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
}

void AXMIsp::chkOBChange() {
#ifdef PARASOFT_CPPTEST
	CPPTest_WORK = 0;
#endif
	unsigned int changeStatus = p_spec->changeStatus[AXH_Index_SPEC_CHK_OB];

	if ((changeStatus & SPEC_CHG_OB) == SPEC_CHG_OB) {
#ifndef PARASOFT_CPPTEST
		// 今回Assistは使用しないため不要
		/*
		// OBモード変更チェック
		// OBサンプリング領域変更チェック
		// OB黒レベル床値変更チェック
		if (0 > send(nameIspAssist, AXFEVENT_MODEL(AXMIspAssist::EVENT_SET_OB_PARAM), 0, 0)) {
			//m_log.write(AXFLOG_ERR, "fail send AXMIspAssist EVENT_SET_OB_PARAM");
		}
		*/
#else
		CPPTest_WORK = 1;
#endif  //  PARASOFT_CPPTEST
	}
}
void AXMIsp::chkApertureChange() {
#ifdef PARASOFT_CPPTEST
	CPPTest_WORK = 0;
#endif

	unsigned int changeStatus = p_spec->changeStatus[AXH_Index_SPEC_CHK_APERTURE];
	if ((changeStatus & SPEC_CHG_APER) == SPEC_CHG_APER || (changeStatus & SPEC_CHG_APER_ADP) == SPEC_CHG_APER_ADP) {
#ifndef PARASOFT_CPPTEST
		// 変更がある場合のみ処理を行う
		if (0 > send(nameIspAdjust, AXFEVENT_MODEL(AXMIspAdjust::EVENT_PROC_APERTURE), 0, 0)) {
			//m_log.write(AXFLOG_ERR, "fail send AXMIspAdjust EVENT_PROC_APERTURE");
		}
#else
		CPPTest_WORK = 1;
#endif  //  PARASOFT_CPPTEST
	}
}

void AXMIsp::chkApertureChangeEx() {

	unsigned int changeStatus = p_spec->changeStatus[AXH_Index_SPEC_CHK_APERTURE];
	if ((changeStatus & SPEC_CHG_APER_EX) == SPEC_CHG_APER_EX) {
#if 0 // 今回存在しない
		g_AperExMode = p_spec->ApertureEx.aperExEnable;
#endif
		p_spec->changeStatus[AXH_Index_SPEC_CHK_APERTURE] &= ~SPEC_CHG_APER_EX;
	}
#if 0 // 今回存在しない
	if(g_AperExMode) {
		unsigned long sac_c01 = GetReg32(SAC_C01);
		sac_c01 = sac_c01 & ~0x00000002;		// C0COMSL[1]フィールドをクリア
		SetReg32(SAC_C01, sac_c01);				// C0COMSL[1]フィールド=0 C0COMを選択
		unsigned long sac_val03 = GetReg32(SAC_VAL03);
		sac_val03 = sac_val03 & ~0x1FFF0000;	// C0COM[28:16]フィールドをクリア
		sac_val03 = sac_val03 | p_spec->ApertureEx.sac_val03_C0COM << 16;
		SetReg32(SAC_VAL03, sac_val03);
		unsigned long sac_val00 = GetReg32(SAC_VAL00);
		unsigned long temp_sac_val00 = sac_val00 & 0x00FF0000;
		if(temp_sac_val00 != 0) {
			g_sav_sac_val00 = temp_sac_val00;
		}
		sac_val00 = sac_val00 & ~0x00FF0000;	// RATCNT[23:16]フィールドをクリア
		SetReg32(SAC_VAL00, sac_val00);
		
	} else {
#endif
	// 今回存在しないため不要
	/*
		unsigned long sac_c01 = GetReg32(SAC_C01);
		sac_c01 = sac_c01 & ~0x00000002;		// C0COMSL[1]フィールドをクリア
		SetReg32(SAC_C01, sac_c01);				// C0COMSL[1]フィールド=0 C0COMを選択
		unsigned long sac_val03 = GetReg32(SAC_VAL03);
		sac_val03 = sac_val03 & ~0x1FFF0000;	// C0COM[28:16]フィールドをクリア
		SetReg32(SAC_VAL03, sac_val03);
		unsigned long sac_val00 = GetReg32(SAC_VAL00);
		unsigned long temp_sac_val00 = sac_val00 & 0x00FF0000;
		if(temp_sac_val00 != 0) {
			g_sav_sac_val00 = temp_sac_val00;
		}
		sac_val00 = (sac_val00 & ~0x00FF0000) | g_sav_sac_val00;	// RATCNT[23:16]フィールドをクリア
		SetReg32(SAC_VAL00, sac_val00);
	*/
#if 0 // baba 存在しない
	}
#endif
}

void AXMIsp::chkChromaChange() {
#ifdef PARASOFT_CPPTEST
	CPPTest_WORK = 0;
#endif  //  PARASOFT_CPPTEST

	// デバッグ確認用
//	static int frame = 0;
//	static int framegoal = 10;
//	if (frame == framegoal) {
//		frame = 0;
//		framegoal++;
//		if (framegoal == 20) {
//			framegoal = 10;
//		}
//		if ((framegoal & 0x01) == 0x01) {
//			p_spec->CHROMA.edgeTh = 100;
//			p_spec->CHROMA.edgeSuppressStrong = 0xFF;
//		}
//		else {
//			p_spec->CHROMA.edgeTh = 0;
//			p_spec->CHROMA.edgeSuppressStrong = 0xFF;
//		}
//		p_spec->changeStatus[AXH_Index_SPEC_CHK_CHROMA] = 0xffffffff;
//	}
//	frame++;

	unsigned int changeStatus = p_spec->changeStatus[AXH_Index_SPEC_CHK_CHROMA];
	if ((changeStatus & SPEC_CHG_CHRO) == SPEC_CHG_CHRO || (changeStatus & SPEC_CHG_EDGE_CHRO) == SPEC_CHG_EDGE_CHRO) {
#ifndef PARASOFT_CPPTEST
		// 変更がある場合のみ処理を行う
		if (0 > send(nameIspAdjust, AXFEVENT_MODEL(AXMIspAdjust::EVENT_PROC_CHROMA), 0, 0)) {
			//m_log.write(AXFLOG_ERR, "fail send AXMIspAdjust EVENT_PROC_CHROMA");
		}
#else
		// bit0をON(変更あり)
		CPPTest_WORK |= 0x01;
#endif  //  PARASOFT_CPPTEST
	}

	if ((p_spec->changeStatus[AXH_Index_SPEC_CHK_CHROMA] & SPEC_CHG_LOW_CHRO) == SPEC_CHG_LOW_CHRO) {
#ifndef PARASOFT_CPPTEST
		// 今回Assistは使用しないため不要
		/*
		if (0 > send(nameIspAssist, AXFEVENT_MODEL(AXMIspAssist::EVENT_PROC_PARAM_SETTINGS), 0, 0)) {
			//m_log.write(AXFLOG_ERR, "fail send AXMIspAssist EVENT_PROC_PARAM_SETTINGS");
		}
		*/
#else
		// bit1をON(変更あり)
		CPPTest_WORK |= 0x02;
#endif  //  PARASOFT_CPPTEST
	}
}

void AXMIsp::chkScalerChange() {

	if (p_spec == 0) {
		return;
	}
#ifndef DISABLE_SCALER_PROC
	// 前回ISP処理画像の複雑度読み込み
	AXMPixcessorInt::setScalerEnabled(p_spec->Scaler.scaling.enabled[0], p_spec->Scaler.scaling.enabled[1], p_spec->Scaler.scaling.enabled[2]);

#ifndef PARASOFT_CPPTEST
	// ネガポジ、上下左右反転
	if ((p_spec->changeStatus[AXH_Index_SPEC_CHK_SCALER] & SPEC_CHG_SCAL_REVERSE) == SPEC_CHG_SCAL_REVERSE) {
		if (0 > send(nameIspAdjust, AXMIspAdjust::EVENT_PROC_SCALER_SETTINGS, 0, 0)) {
			//m_log.write(AXFLOG_ERR, "fail send AXMIspAdjust::EVENT_PROC_SCALER_SETTINGS");
		}
	}
#endif  //  PARASOFT_CPPTEST

#ifdef PARASOFT_CPPTEST
	CPPTest_execSclCtrl = p_spec->Scaler;
#endif  //  PARASOFT_CPPTEST
#endif  //  DISABLE_SCALER_PROC
}

void AXMIsp::setImageIFOpeMode() {
#ifndef DISABLE_LINEAR_MODE
//  // デバッグ機能(擬似切り替え)
//	static unsigned char frame = 0;
//	static unsigned char frameGoal = 0;
//	if (frame == frameGoal) {
//		frameGoal = frame + 1;
//		frame = 0;
//		p_spec->imageIFOpeMode = ((p_spec->imageIFOpeMode + 1) & 0x01);
//	}
//	frame++;
	unsigned char opeMode = 0;
	static unsigned char opeModeOld = -1;

	if (isWdrMode == false) {
		opeMode = 	(unsigned char)p_spec->imageIFOpeMode;
	}
	if (opeModeOld != opeMode) {
		opeMode = AXMPixcessorInt::setImageIFOpeMode(opeMode);
#ifdef ENABLE_OPD_CONFIG_ISP_TO_AXH
		m_pixMemConfig.setLinearMode(opeMode);
		opdConfigAWB.setLinearMode(opeMode);
		opdConfigAE.setLinearMode (opeMode);
#else
#ifndef PARASOFT_CPPTEST
		//  モード変更時のみ、送信する
		ST_MSG msg;
		msg.data = &opeMode;
		//  AXMPixcessorへモード変更要求
		if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::PIXCESSOR_EVENT_NOTIFY_LINEAR_MODE), &msg, sizeof(ST_MSG))) {
			//m_log.write(AXFLOG_ERR, "fail send Pixcessor PIXCESSORINT_EVENT_NOTIFY_LINEAR_MODE");
		}
#endif  //  PARASOFT_CPPTEST
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
		isLinearMode = opeMode;
		opeModeOld = opeMode;
	}
#endif  //  DISABLE_LINEAR_MODE
}

void AXMIsp::setBankCounterAtFirstFrame() {
	// pixcessorMemConfigに通常モードへの復帰を通知する
    if (state == STATE_FRAME_1ST) {
    	if (ispMode != ISP_Mode_Run) {
    		m_pixMemConfig.setBankCounterAtFirstFrame(true);
    	}
    }
    else {
    	m_pixMemConfig.setBankCounterAtFirstFrame(false);
    }
}

void AXMIsp::setPixcessorMemBank() {
	int bankno = m_pixMemConfig.switch_pixcessor_mem_bank();
	if (-1 != bankno) {
#ifndef ENABLE_PIXCESSOR_MEM_BANK_6
		// 2バンク構成時
		// 次にGDUに送るバンク番号は、１つ前のフレームのバンク番号なので、反転させる
		bankno = (bankno + 1) & 0x01;
#else
		// 6バンク構成時
		// バンク番号は1つ前のフレームのバンク番号を指定するので、-1する。
		// 結果がマイナスになる場合は最大バンク番号を設定する。
		bankno--;
		if (bankno < 0) {
			bankno = 5;
		}
#endif
	}

	// バンク番号をAXMPixcessorIntに退避
	AXMPixcessorInt::setGduBankno(bankno);
}

/*
 * AXMPixcessorへAWB用並べ替え後画像データを要求する
 */
void AXMIsp::getOpdDataForAwb(ST_MSG msg)
{
#ifndef ENABLE_OPD_DATA_ISP_TO_AXH

  msg.sid = SID_AXMIsp;
  msg.rid = RID_AXMPixcessor;
#ifndef PARASOFT_CPPTEST
  if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::ISP_EVENT_AWB_IMAGE), &msg, sizeof(ST_MSG))) {
    //m_log.write(AXFLOG_ERR, "fail send Pixcessor ISP_EVENT_AWB_IMAGE");
  }
#endif  //  PARASOFT_CPPTEST

#else   //  ENABLE_OPD_DATA_ISP_TO_AXH

  msg.sid = SID_AXMIsp;
  msg.rid = RID_AXMIspAwb;

  switch(msg.cmd & Cmd_Get_OPD_Mask) {
    case Cmd_Get_OPD_AWB:
      msg.data = (void *)opdDataAWB.getOpdData(AXH_Cmd_Get_Opd_AWB_0);
      break;
    case Cmd_Get_OPD_AWB_L:
    default:
      msg.data = (void *)opdDataAWB.getOpdData(AXH_Cmd_Get_Opd_AWB_1);
      break;
  }
#ifdef AXM_ISP_CT_AWB
  msg.data = AXMIspCTAwb::GetImagePtr();
#endif  //  AXM_ISP_CT_AWB

#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAwb, AXMIspAwb::EVENT_COLOR_DATA, &msg, sizeof(ST_MSG))) {
    //m_log.write(AXFLOG_ERR, "fail send AXMIspAwb::EVENT_COLOR_DATA");
  }
#endif  //  PARASOFT_CPPTEST

#endif  //  ENABLE_OPD_DATA_ISP_TO_AXH
}

/*
 * AXMPixcessorへAE用並び替え後画像データを要求する
 */
void AXMIsp::getOpdDataForAe(ST_MSG msg)
{
#ifndef ENABLE_OPD_DATA_ISP_TO_AXH

#ifndef PARASOFT_CPPTEST
  if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::ISP_EVENT_AE_IMAGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send Pixcessor ISP_EVENT_AE_IMAGE");
  }
#endif  //  PARASOFT_CPPTEST

#else   //  ENABLE_OPD_DATA_ISP_TO_AXH

  msg.sid = SID_AXMIsp;
  msg.rid = RID_AXMIspAe;

  switch(msg.cmd & Cmd_Get_OPD_Mask) {
    case Cmd_Get_OPD_AE_0:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE0_0);
      break;
    case Cmd_Get_OPD_AE_1:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE0_1);
      break;
    case Cmd_Get_OPD_AE_L_0:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE1_0);
      break;
    case Cmd_Get_OPD_AE_L_1:
    default:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE1_1);
      break;
  }
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAe, AXMIspAe::EVENT_START, &msg, sizeof(ST_MSG))) {
    //m_log.write(AXFLOG_ERR, "fail send AXMIspAe::EVENT_START");
  }
#endif  //  PARASOFT_CPPTEST

#endif  //  ENABLE_OPD_DATA_ISP_TO_AXH
}

/*
 * AXMPixcessorへシェーディング補正用画像データを要求する
 */
void AXMIsp::getImageDataForShading()
{
#ifndef ENABLE_IMAGE_ADDR_ISP_TO_AXH

#ifndef PARASOFT_CPPTEST
  if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::ISP_EVENT_SHADE_IMAGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send Pixcessor ISP_EVENT_SHADE_IMAGE");
  }
#else   //  PARASOFT_CPPTEST
  event = AXMPixcessor::ISP_EVENT_SHADE_IMAGE;
#endif  //  PARASOFT_CPPTEST

#endif  //  ENABLE_IMAGE_ADDR_ISP_TO_AXH
}

/*
 * AXMPixcessorへシェーディング補正用画像データを要求する
 */
void AXMIsp::getImageDataForKizu()
{
#ifndef ENABLE_IMAGE_ADDR_ISP_TO_AXH

#ifndef PARASOFT_CPPTEST
  if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::ISP_EVENT_KIZU_IMAGE), 0, 0)) {
    //m_log.write(AXFLOG_ERR, "fail send Pixcessor ISP_EVENT_KIZU_IMAGE");
  }
#else   //  PARASOFT_CPPTEST
  event = AXMPixcessor::ISP_EVENT_KIZU_IMAGE;
#endif  //  PARASOFT_CPPTEST

#endif  //  ENABLE_IMAGE_ADDR_ISP_TO_AXH
}

void AXMIsp::execObProc()
{
	static ST_MSG msg;
	// 今回Assistは使用しないため不要
	/*
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAssist, AXFEVENT_MODEL(AXMIspAssist::EVENT_PROC_OB_START), &msg, sizeof(ST_MSG))) {
    //m_log.write(AXFLOG_ERR, "fail send AXMIspAssist EVENT_PROC_OB_START");
  }
#endif  //  PARASOFT_CPPTEST
	*/
}

/*
 * モードの確認および変更
 */
void AXMIsp::matrix0Axx_checkModeStatus()
{
  //  モード/AWBモード変更確認
  if((ispMode    ^ p_spec->Mode   ) ||                      //  動作モード変更確認
     (ispAWBMode ^ p_spec->AWB.AWBMode) ||                  //  AWBモード変更確認
     ((ispAWBMode == ::AWBMode_ATWSceaneMode) &&
      (ispATWSceaneMode ^ p_spec->AWB.ATWSceaneMode))) {    //  ATWシーンモード変更確認
    //  モード変更あり
    switch(p_spec->Mode) {
      case ISP_Mode_Run:                //  通常モード
    	//  AEはモード変更を行わないので、AWBのモード変更を行う
        {
          bool ret = checkAWBMode_IspModeRun();
          if(ret == true) {
            state = STATE_FRAME_1ST;
#ifndef PARASOFT_CPPTEST
            setNextState(state);
#endif  //  PARASOFT_CPPTEST
          }
        }
        break;
      case ISP_Mode_Adjust_WB:          //  WB調整モードに移行(matrix0A08/matrix0A09経由で移行)
        //  AEは待機中に移行させ、AWBは調整モードに移行する
#ifndef PARASOFT_CPPTEST
	    if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_WAITING), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_WAITING");
        }
#endif  //  PARASOFT_CPPTEST
        break;
      case ISP_Mode_Adjust_IRIS:        //  IRIS調整モードに移行(matrix0A08/matrix0A09経由で移行)
				// アイリス使用しないため不要
				/*
        //  AEは調整モードに移行し、AWBは待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_ADJUST), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_ADJUST");
        }
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      case ISP_Mode_Adjust_SHADE:       //  シェーディング補正モードに移行(matrix0A08/matrix0A09経由で移行)
        //  AWBのみ待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_SPEC_AEMODE), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_WAITING");
        }
#endif  //  PARASOFT_CPPTEST
        break;
      case ISP_Mode_Adjust_KIZU:        //  キズ補正モードに移行(matrix0A08/matrix0A09経由で移行)
				// 欠陥モードなしのため不要
				/*
        //  AEとAWBは待機中に移行させる
#ifndef PARASOFT_CPPTEST
        if (0 > send(nameIspAe, AXFEVENT_MODEL(AXMIspAe::EVENT_DEFECT_MODE), 0, 0)) {
          //m_log.write(AXFLOG_ERR, "fail send AE EVENT_WAITING");
        }
#endif  //  PARASOFT_CPPTEST
				*/
        break;
      default:                          //  1フレーム目へ移行
        state = STATE_FRAME_1ST;
        break;
    }
  }
  else
  {
    //  モード変更なし : 次ステータスに移行
    state = STATE_FRAME_1ST;
  }
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
}

bool AXMIsp::checkAWBMode_IspModeRun()
{
  bool result = false;

  switch(p_spec->AWB.AWBMode)
  {
    case AWBMode_TempManuMode:          //  色温度指定マニュアルモード
    case AWBMode_LightManuMode:         //  照明指定マニュアルモード
    case AWBMode_GainManuMode:          //  ゲイン指定マニュアルモード
      //  AWB マニュアルモードに変更
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_MANU_MODE), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_MANU_MODE");
      }
#else   //  PARASOFT_CPPTEST
      //   c++testでのパスの確認用にイベントをstatusに格納する
      event = AXMIspAwb::EVENT_MANU_MODE;
#endif  //  PARASOFT_CPPTEST
      break;
    case AWBMode_OnePushMode:           //  ワンプッシュモード
      //  AWB ワンプッシュモードに変更
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ONE_PUSH), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ONE_PUSH");
      }
#else   //  PARASOFT_CPPTEST
      //  c++testでのパスの確認用にイベントをstatusに格納する
      event = AXMIspAwb::EVENT_ONE_PUSH;
#endif  //  PARASOFT_CPPTEST
      break;
    case AWBMode_ATWMode:               //  ATWモード
    case AWBMode_ATWSceaneMode:         //  ATWシーンモード
      //  AWB ATWモードに変更
#ifndef PARASOFT_CPPTEST
      if (0 > send(nameIspAwb, AXFEVENT_MODEL(AXMIspAwb::EVENT_ATW_MODE), 0, 0)) {
        //m_log.write(AXFLOG_ERR, "fail send AWB EVENT_ATW_MODE");
      }
#else   //  PARASOFT_CPPTEST
      //  c++testでのパスの確認用にイベントをstatusに格納する
      event = AXMIspAwb::EVENT_ATW_MODE;
#endif  //  PARASOFT_CPPTEST
      break;
    case AWBMode_HoldMode:              //  ホールドモード
    default:
      result = true;
      break;
  }
  ispAWBMode = p_spec->AWB.AWBMode;
  ispATWSceaneMode = p_spec->AWB.ATWSceaneMode;
  return(result);
}

#ifdef USE_AXFTEST_COMMAND
ax::actorFuncStatus AXMIsp::funcPriSchedTest(const void *pParam, int size) {
  //m_log.write(AXFLOG_SCENARIO, "@ISP PriSchedTest");

  if (isUsedPriorityCheck) {
#ifdef USE_AXFTEST_COMMAND_COMPLOG
    //テスト開始を設定
    AXMScenarioTest::getInstance()->setTestCase(AXMScenarioTest::TEST_PRISCHED);
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
    m_prischecSuccess = 0; // 試験成功数
    m_prischecCount = 0;   // 試験総数
    int count = 1;
    for (int i = 0; i < 3; i++) {
      // 優先度 低 [1, 4, 7]
//      if (0 > send(nameIspAf, AXMIspAf::EVENT_PRIORITY_TEST, (void *)&count, sizeof(count))) {
//        //m_log.write(AXFLOG_ERR, "fail send AXMIspAf EVENT_PRIORITY_TEST");
//      }
      count++;

      // 優先度 中 [2, 5, 8]
      if (0 > send(nameIspAwb, AXMIspAwb::EVENT_PRIORITY_TEST, (void *)&count, sizeof(count))) {
        //m_log.write(AXFLOG_ERR, "fail send AXMIspAwb EVENT_PRIORITY_TEST");
      }
      count++;

      // 優先度 高 [3, 6, 9]
      if (0 > send(nameIspAe, AXMIspAe::EVENT_PRIORITY_TEST, (void *)&count, sizeof(count))) {
        //m_log.write(AXFLOG_ERR, "fail send AXMIspAe EVENT_PRIORITY_TEST");
      }
      count++;
    }
  }

  return ax::AXFACTOR_SUCCESS;
}
ax::actorFuncStatus AXMIsp::funcPriSchedEnd(const void *pParam, int size) {
  const int checkVal[9] = {3, 6, 9, 2, 5, 8, 1, 4, 7};
  
  //受信データからカウンタ値を取得
  int count = 0;
  if(pParam != NULL){
    count = *((int*)pParam);
  }

  //優先順位順にカウンタ値が送信されているかをチェック
  if(count == checkVal[m_prischecCount]){
    m_prischecSuccess++;
  }
  m_prischecCount++;

  //全て送信完了したらテスト終了
  if(m_prischecCount >= 9){
#ifdef USE_AXFTEST_COMMAND_COMPLOG
    int result = AXMScenarioTest::RESULT_FAILED;
    int ercode = AXMScenarioTest::E_PRIORITYCHECK;
    if(m_prischecSuccess == 9){
      result = AXMScenarioTest::RESULT_SUCCESS;
    }
    AXMScenarioTest::getInstance()->writeLog(&m_log, result, ercode);
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
  }
  return ax::AXFACTOR_SUCCESS;
}
#endif /* USE_AXFTEST_COMMAND */

#ifdef USE_AXBRIDGE_DEMO
ax::actorFuncStatus AXMIsp::funcNvrToIsp1(const void *pParam, int size) {
  //m_log.write(AXFLOG_DEBUG, "@ISP funcNvrToIsp1");

  if (size != sizeof(struct AXBridgeDemoParam_NvrToIsp1_t)) {
    //m_log.write(AXFLOG_INFO, "@illegal parameter");
    return ax::AXFACTOR_SUCCESS;
  }

  struct AXBridgeDemoParam_NvrToIsp1_t* p =
      (AXBridgeDemoParam_NvrToIsp1_t*)pParam;
  std::ostringstream p1Str;
  p1Str << p->param1;
  //m_log.write(AXFLOG_INFO, "@  p1=" + p1Str.str());

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIsp::funcNvrToIsp2(const void *pParam, int size) {
  //m_log.write(AXFLOG_DEBUG, "@ISP funcNvrToIsp2");

  if (size != sizeof(struct AXBridgeDemoParam_NvrToIsp2_t)) {
    //m_log.write(AXFLOG_INFO, "@illegal parameter");
    return ax::AXFACTOR_SUCCESS;
  }

  struct AXBridgeDemoParam_NvrToIsp2_t* p =
      (AXBridgeDemoParam_NvrToIsp2_t*)pParam;
  std::ostringstream p1Str;
  p1Str << p->param1;
  std::ostringstream p2Str;
  p2Str << p->param2;
  //m_log.write(AXFLOG_INFO, "@  p1=" + p1Str.str() + " p2=" + p2Str.str());

  return ax::AXFACTOR_SUCCESS;
}

void AXMIsp::sendNvrTest() {
  std::ostringstream countStr;
  countStr << m_count;
  AXFObjectName nameNvr("codec", "nvrStage");

  if (m_count % 2) {
    struct AXBridgeDemoParam_IspToNvr1_t nvrSendData1;
    nvrSendData1.param1 = m_count;
    send(nameNvr, AXFEVENT_MODEL(AXBRIDGE_DEMO_EVENT_IspToNvr_1), &nvrSendData1, sizeof(nvrSendData1));
  } else {
    struct AXBridgeDemoParam_IspToNvr2_t nvrSendData2;
    nvrSendData2.param1 = m_count;
    nvrSendData2.param2 = AXBRIDGE_DEMO_EVENT_IspToNvr_2;
    send(nameNvr, AXFEVENT_MODEL(AXBRIDGE_DEMO_EVENT_IspToNvr_2), &nvrSendData2, sizeof(nvrSendData2));
  }
  m_count++;
}
#endif /* USE_AXBRIDGE_DEMO */

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
void AXMIsp::setImgWDRMode(bool isWdrMode) {
#ifndef PARASOFT_CPPTEST
  static ST_MSG msg;
#endif  //  PARASOFT_CPPTEST
  static bool wdrMode;
  wdrMode = isWdrMode;
  msg.data = &wdrMode;

  //  AXMPixcessorへモード変更要求
#ifndef PARASOFT_CPPTEST
  if (0 > send(namePixessor, AXFEVENT_MODEL(AXMPixcessor::PIXCESSOR_EVENT_NOTIFY_WDR_MODE), &msg, sizeof(ST_MSG))) {
    //m_log.write(AXFLOG_ERR, "fail send Pixcessor PIXCESSORINT_EVENT_NOTIFY_WDR_MODE");
  }
#endif  //  PARASOFT_CPPTEST
}
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

/*
 * AXMPixcessorIntへAF用評価値データを要求する→AFに評価データを送信する
 */
void AXMIsp::getEvalDataForAf(void)
{
	if(ispLensKind & 0x04) {
	  if (0 > send(namePixessorInt, AXFEVENT_MODEL(AXMPixcessorInt::PIXCESSORINT_EVENT_GET_AF_EVAL), 0, 0)) {
    	//m_log.write(AXFLOG_ERR, "fail send PixcessorInt PIXCESSORINT_EVENT_GET_AF_EVAL");
  	  }
	}
}

	// レンズ情報通知受信
ax::actorFuncStatus AXMIsp::recvLenzInfo(const void *pParam, int size) {
	ST_MSG *p_msg = (ST_MSG *)pParam;

	ispLensKind = p_msg->cmd;

	return ax::AXFACTOR_SUCCESS;
}


#ifdef ADJUST_TEST
const int testCase[] = {
		4 ,		// 1
		5 ,		// 2
		3 ,		// 3
		5 ,		// 4
		2 ,		// 5
		5 ,		// 6
		1 ,		// 7
		5 ,		// 8
		4 ,		// 9
		3 ,		// 10
		2 ,		// 11
		1 ,		// 12
		2 ,		// 13
		3 ,		// 14
		4 ,		// 15
		2 ,		// 16
		4 ,		// 17
		1 ,		// 18
        4 ,		// 19
        3 ,		// 20
        1 ,		// 21
        3 ,		// 22
		1 ,		// 23
		2		// 24
};
void AXMIsp:: funcTest(void) {
		int stat=0;
		int testNo;
		static int testNoSave = 0;
#if 1
		static int testcount = 0;
		if(testcount > (24 << 5)){
			testcount = 0;
		}
		if((testcount & 0x001F) == 0) {
			testNo = testCase[(testcount >> 5)];
		} else {
			testNo = 0;
		}
		testcount++;
#else
		testNo = p_spec->AE.aeConvAdj.deadZoneOut;
#endif

		switch(testNo) 
		{
		case 0:
		default:
			break;
		case 1:
			p_spec->Mode = ::AXMIsp::ISP_Mode_Adjust_WB;
			p_spec->AE.aeConvAdj.deadZoneOut = 0;
			break;
		case 2:	// シャッター制御モード
			p_spec->Mode = ::AXMIsp::ISP_Mode_Adjust_SHADE;
			p_spec->AE.aeConvAdj.deadZoneOut = 0;
			break;
		case 3:	//アイリス閉じる
			p_spec->Mode = ::AXMIsp::ISP_Mode_Adjust_KIZU;
			p_spec->Defect.DetectSet.AE.ShutterSpeed = 4369;
	    	p_spec->Defect.DetectSet.AE.Gain = 10;
	    	p_spec->Defect.DetectSet.AE.IrisCloseMode = 1;

			p_spec->AE.aeConvAdj.deadZoneOut = 0;
			break;
		case 4:	// アイリス調整モード
			p_spec->Mode = ::AXMIsp::ISP_Mode_Adjust_IRIS;
			p_spec->AE.mechaIrisAdjust.flagIrisRegion = 1;
			p_spec->AE.mechaIrisAdjust.roughIrisValue = 255;
			p_spec->changeStatus[0] |= SPEC_CHG_AE007;
			p_spec->AE.aeConvAdj.deadZoneOut = 0;
			break;
		case 5:	//通常モード
			p_spec->Mode = ::AXMIsp::ISP_Mode_Run;
			p_spec->ImageSensor.lensKind = 1;	// DC-IRIS
			p_spec->ImageSensor.lensKind |= 4;	// FOCUS ZOOM
			p_spec->changeStatus[1] |= SPEC_CHG_IMGS;
			p_spec->AE.aeConvAdj.deadZoneOut = 0;
			break;
		}
		if (0 > stat) {
			//m_log.write(AXFLOG_ERR, "fail send AE Event Test Data");
		}
}
#endif

