/**
 * @file			AXMIspAperture.hpp
 * @brief			AXMIspAperture計算クラス群ヘッダ
 *
 * @par			言語
 * 					C++
 */

#ifndef AXMISPAPERTURE_HPP_
#define AXMISPAPERTURE_HPP_
#include "AXMIspApertureAlgorithm.hpp"

/**
 * @class		AXMIspApertureCalc
 * @brief		アパーチャ補正計算クラス
 *
 * @n			アパーチャ補正アルゴリズムを使用し、アパーチャ補正計算を行う
 */
class AXMIspApertureCalc {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 */
	AXMIspApertureCalc();
	/**
	 * @brief  オブジェクトを開放する
	 */
	virtual ~AXMIspApertureCalc();
public:
	/**
	 * @brief	高域・中域ゲイン比率計算
	 *
	 * @param	[in]  midRatio                 高域に対する中域比率
	 * @param	[out] highRangeRatio           高域ゲイン比率
	 * @param	[out] midRangeRatio            中域ゲイン比率
	 */
	void 					CalcOverMidRangeGainRatio(BYTE midRatio, BYTE* highRangeRatio, BYTE* midRangeRatio);

	/**
	 * @brief	輝度変調LUT計算
	 *
	 * @param	[in]  startSupresLuminance     暗部アパーチャ抑制開始輝度
	 * @param	[in]  startStrongLuminance     高輝度側アパーチャ補正強化開始輝度
	 * @param	[in]  correctSupressInc        暗部アパーチャ補正抑圧傾き
	 * @param	[in]  correctStrongInc         高輝度側アパーチャ補正強化傾き
	 * @param	[in]  correctStrongLimit       高輝度側アパーチャ補正強化リミット
	 * @param	[out] lut                      出力ゲインLUTテーブル
	 */
	void					CalcLuminanceModulationLUT(BYTE startSupresLuminance, BYTE startStrongLuminance, BYTE correctSupressInc, BYTE correctStrongInc, BYTE correctStrongLimit, BYTE* lut);
private:
	AXMIspApAlgorithm		m_apertureAlgorithm;
};

#endif /* AXMISPAPERTURE_HPP_ */
