/**
 * @file			AXMIspApertureSettings.hpp
 * @brief			AXMIspApertureSettingsクラスヘッダ
 *
 * @par			言語
 * 					C++
 */

#ifndef AXMISPAPERTURESETTINGS_HPP_
#define AXMISPAPERTURESETTINGS_HPP_
#include "AXMIspAdjustType.hpp"

/**
 * LUTテーブル分解能
 */
const int				AP_LUT_DATA_CNT = 128;
/**
 * 輝度変調ゲイン基準値
 */
const int				AP_MODULATION_GAIN_BASE = 0x40;
/**
 * 暗部アパーチャ抑制開始輝度デフォルト
 */
const BYTE				AP_START_SUPRES_LUMINANCE = 31;
/**
 * 高輝度側アパーチャ補正強化開始輝度デフォルト
 */
const BYTE				AP_START_STRONG_LUMINANCE = 205;
/**
 * 暗部アパーチャ補正抑制傾きデフォルト
 */
const BYTE				AP_SUPRES_INC = 0x10;
/**
 * 高輝度側アパーチャ補正強化傾きデフォルト
 */
const BYTE				AP_STRONG_INC = 0x20;
/**
 * 高輝度側アパーチャ補正強化リミットデフォルト
 */
const BYTE				AP_STRONG_LIMIT = 0x80;
/**
 * トータルゲインデフォルト
 */
const BYTE				AP_TOTAL_GAIN = 0x60;
/**
 * 正側リミット設定デフォルト
 */
const SHORT			AP_LIMIT_POSITIVE = 4095;
/**
 * 負側リミット設定デフォルト
 */
const SHORT			AP_LIMIT_NEGATIVE = -4096;
/**
 * コアリングしきい値デフォルト
 */
const BYTE				AP_CORING_TH = 0;
/**
 * 高域に対する中域比率デフォルト
 */
const BYTE				AP_MID_RANGE_RATIO = 0x40;
/**
 * 高域に対する中域比率最大値
 */
const BYTE				AP_HIGH_MID_RANGE_GAIN_MAX = 0x40;

/**
 * @class     ApertureCorrectStrong
 * @brief     アパーチャ補正強度パラメータ格納用クラス
 *
 * @n         出力ゲインテーブルの計算パラメータを格納する
 */
typedef class ApertureCorrectStrong {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	ApertureCorrectStrong();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~ApertureCorrectStrong();
public:
	/**
	 * @brief	アパーチャ補正強度パラメータ設定
	 *
	 * @param	[in]  startSupresLuminance     暗部アパーチャ抑制開始輝度
	 * @param	[in]  startStrongLuminance     高輝度側アパーチャ補正強化開始輝度
	 * @param	[in]  correctSupressInc        暗部アパーチャ補正抑圧傾き
	 * @param	[in]  correctStrongInc         高輝度側アパーチャ補正強化傾き
	 * @param	[in]  correctStrongLimit       高輝度側アパーチャ補正強化リミット
	 * @return	      パラメータ変更の有無
	 */
	bool				Set(BYTE startSupresLuminance, BYTE startStrongLuminance, BYTE correctSupressInc, BYTE correctStrongInc, BYTE correctStrongLimit);
public:
	BYTE				darkSupressStartLuminance;			//!< 暗部アパーチャ抑制開始輝度
	BYTE				highCorrectStartStrongLuminance;	//!< 高輝度側アパーチャ補正強化開始輝度
	BYTE				darkCorrectSupressInc;				//!< 暗部アパーチャ補正抑圧傾き
	BYTE				highCorrectStrongInc;				//!< 高輝度側アパーチャ補正強化傾き
	BYTE				highCorrectStrongLimit;				//!< 高輝度側アパーチャ補正強化リミット
} APCorrectStrong;

/**
 * @class		AXMIspApertureSettings
 * @brief		アパーチャ補正設定パラメータ格納用クラス
 *
 * @n         アパーチャ補正の計算パラメータと、計算結果を格納する
 */
typedef class AXMIspApertureSettings {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspApertureSettings();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspApertureSettings();
public:
	BYTE				totalGain;								//!< トータルゲイン
	SHORT				limitPositive;						//!< 正側リミット設定
	SHORT				limitNegative;						//!< 負側リミット設定
	APCorrectStrong	correctStrong;						//!< アパーチャ補正強度
	BYTE				coringTh;								//!< コアリングしきい値
	BYTE				midRangeRatio;						//!< 高域に対する中域比率
	BYTE				lut[AP_LUT_DATA_CNT];				//!< 出力ゲインテーブル
} AXMIspApSettings;

#endif /* AXMISPAPERTURESETTINGS_HPP_ */
