/**
 * @file			AXMIspChromaSuppress.hpp
 * @brief			AXMIspChromaSuppress計算クラス群ヘッダ
 *
 * @par			言語
 * 					C++
 */
#ifndef AXMISPCHROMASUPPRESS_HPP_
#define AXMISPCHROMASUPPRESS_HPP_
#include "AXMIspChromaSuppressAlgorithm.hpp"

/**
 * @class		AXMIspChromaSuppressCalc
 * @brief		クロマサプレス計算クラス
 *
 * @n			クロマサプレスアルゴリズムを使用し、クロマサプレス計算を行う
 */
typedef class AXMIspChromaSuppressCalc {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspChromaSuppressCalc();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspChromaSuppressCalc();
public:
	/**
	 * @brief	クロマサプレス輝度変調LUT計算
	 *
	 * @param	[in]  darkStartLuminance       暗部クロマプレス開始輝度
	 * @param	[in]  darkInc                  暗部クロマサプレス傾き
	 * @param	[in]  highColorStartLuminance  高輝度側色強化開始輝度
	 * @param	[in]  highColorInc             高輝度側色強化傾き
	 * @param	[in]  highColorLimit           高輝度側色強化リミット
	 * @param	[in]  highLightStartLuminance  ハイライトクロマサプレス開始輝度
	 * @param	[in]  highLightInc             ハイライトクロマサプレス傾き
	 * @param	[out] lut                      出力ゲインLUTテーブル
	 */
	void 				CalcLuminanceModulationLUT(BYTE darkStartLuminance, BYTE darkInc, BYTE highColorStartLuminance, BYTE highColorInc, BYTE highColorLimit, BYTE highLightStartLuminance, BYTE highLightInc, BYTE* lut);

	/**
	 * @brief	エッジクロマサプレス輝度変調LUT計算
	 *
	 * @param	[in]  startTh                  エッジしきい値
	 * @param	[in]  supprStr                 サプレス強度
	 * @param	[out] lut                      出力ゲインLUTテーブル
	 */
	void				CalcEdgeLuminanceModulationLUT(BYTE startTh, BYTE supprStr, BYTE* lut);
private:
	AXMIspChromaAlgorithm		m_chromaAlgorithm;
} AXMIspChromaCalc;

#endif /* AXMISPCHROMASUPPRESS_HPP_ */
