/*
 * AXMIspGamma.cpp
 */

#include "AXMIspGamma.hpp"
#include "../AXMCommon/AXMCommonStruct.hpp"
#include <cstring>
#include <string.h>

AXMIspGammaCalc::AXMIspGammaCalc() : m_gammaSettings(0) {
	// TODO 自動生成されたコンストラクター・スタブ

}

AXMIspGammaCalc::~AXMIspGammaCalc() {
	// TODO Auto-generated destructor stub
}

void AXMIspGammaCalc::NotifySettings(AXMIspGammaSettings* gammaSettings) {
	m_gammaSettings = gammaSettings;
}

/*
 * デフォルトガンマ補正カーブ生成
 */
bool AXMIspGammaCalc::CreateDefGammaCurve() {
	bool ret = false;
	if (m_gammaSettings == 0) {
		return ret;
	}
	SHORT gammaCurveSelect = m_gammaSettings->gammaCurveSelect;
	if (GAMMA_CURVE_MAX <= gammaCurveSelect) {
		return ret;
	}
	USHORT  gammaValue = GammaCurveTable[gammaCurveSelect];
	USHORT* defGammaCurve = &m_gammaSettings->defGammaCurvePoint[0];
	USHORT* setGammaCurve = &m_gammaSettings->setGammaCurvePoint[0];
	m_gammaAlgorithm.CreateDefaultGammaCurve(
		  GAMMA_CURVE_POI_CNT
		, DEF_KNEE_X
		, DEF_KNEE_Y
		, PIXEL_MAX
		, gammaValue
		, &defGammaCurve[0]
	);

	for (int i = 0; i < GAMMA_DARK_CORRECT_COUNT; i++) {
		int val = defGammaCurve[i] - GAMMA_DARK_CORRECT_TABLE[gammaCurveSelect][i];
		// 1.0〜2.6までのガンマカーブ値に対して、手直し値を減算してもマイナスになることはないので削除(手直し値によっては、下記コードを復帰する必要あり)
//		if (val < 0) {
//			val = 0;
//		}
		defGammaCurve[i] = (USHORT)val;
	}

	memcpy(&setGammaCurve[0], &defGammaCurve[0], sizeof(USHORT) * GAMMA_CURVE_POI_CNT);

	return true;
}

/*
 * ガンマ補正カーブ変換
 */
bool AXMIspGammaCalc::ConvertGammaCurve() {
	bool ret = false;
	if (m_gammaSettings == 0) {
		return ret;
	}
	SHORT   dRange = m_gammaSettings->kneeSettings.dRange;
	SHORT   hRange = m_gammaSettings->kneeSettings.hRange;
	USHORT* defGammaCurve = &m_gammaSettings->defGammaCurvePoint[0];
	USHORT* setGammaCurve = &m_gammaSettings->setGammaCurvePoint[0];

	m_gammaAlgorithm.ConvertGammaCurve(
		  GAMMA_CURVE_POI_CNT
		, &defGammaCurve[0]
		, DEF_KNEE_X
		, DEF_KNEE_Y
		, dRange
		, hRange
		, PIXEL_MAX
		, &setGammaCurve[0]
	);
	return true;
}

/*
 * ユーザー設定のガンマ補正カーブを格納
 */
bool AXMIspGammaCalc::SetUserGammaCurve(USHORT* usrGammaCurve) {
	bool ret = false;
	if (m_gammaSettings == 0) {
		return ret;
	}
	memcpy(&m_gammaSettings->usrGammaCurvePoint[0], &usrGammaCurve[0], sizeof(USHORT) * GAMMA_CURVE_POI_CNT);
	return true;
}
