/**
 * @file       	AXMISPtype.hpp
 * @brief      	AXMIspAE共通Type＆定数ヘッダ
 *
 * @par			言語
 *              C++
 */

#ifndef AXMISPTYPE_HPP_
#define AXMISPTYPE_HPP_

#ifndef PARASOFT_CPPTEST
//#define AE_DEBUG
#endif
#define COUT_DEBUG

/**
 * @def       	
 * @brief      	AE型定義
 */
typedef unsigned char UCHAR;
typedef unsigned short USHORT;
typedef unsigned long ULONG;
typedef char CHAR;
typedef short SHORT;
typedef long LONG;
typedef void (*FP)();

#define GAIN_TUNE	// gain × 10

/**
 * @enum        ConstNum
 * @brief       定数定義
 */
enum ConstNum {  // 定数定義
  _ZERO             =         0 ,	   //           0
  _ONE              =         1 ,   //           １
  _TWO              =         2 ,   //           2の値
  _THREE            =         3 ,   //           3
  _NINE             =         9 ,   //           9
  _TEN              =        10 ,	   //          10
  _FOUR             =         4 ,	   //           4bit
  _TWELVE           =        12 ,   //          12
  _HUNDRED          =       100 ,   //         100
  _THOUSAND         =      1000L,   //       1,000
  _FIVE_THOUSAND    =      5000L,   //       5,000
  _TEN_THOUSAND     =     10000L,   //      10,000
  _HUNDRED_THOUSAND =    100000L,   //     100,000
  _MILLION          =   1000000L,   //   1,000,000
  _TEN_MILLION      =  10000000L,   //  10,000,000
  _HUNDRED_MILLION  = 100000000L,   // 100,000,000

  MASK_4BIT = 0x000F,
  MASK_8BIT = 0x00FF,
// 非線形処理係数
  NONLINEAR_COEFF_ONE = 40,    // ①目標値以上 係数4を10倍した値
  NONLINEAR_COEFF_TWO = 15,    // ②目標値より小さく、且つ目標値の1/4以上 係数1.5を10倍した値
  NONLINEAR_COEFF_THREE = 7,   // ③目標値の1/4より小さい 係数0.7を10倍した値
  COEFF_GAIN_CHANGE = 7,    //  係数7
	
  LONG_ZERO = 0L,  //     0
  IRIS_MAX = 160,       // 暫定的に設定 後で調整のこと
  PHOTOMET_ROW = 5,			// 今回行は22行のため約1/4の5に設定する
  PHOTOMET_COLUMN = 10,
  PHOTOMET_MAX = (PHOTOMET_ROW * PHOTOMET_COLUMN)
};

/**
 * @enum        eAXMIspPhotometModes
 * @brief       測光パターンモードID定義
 */
enum eAXMIspPhotometModes {
  E_PhotometCenter,		// 中央重点
  E_PhotometUnderCent,  // 中央下重点
  E_PhotometRight,			// 右重点
  E_PhotometLeft,			// 左重点
  E_PhotometUser 			// ユーザー指定重点
};

typedef unsigned char AXMIspPhotometModes;

/**
 * @enum     	eAXMIspAeModes
 * @brief     AEモードID定義
 */
enum eAXMIspAeModes {
  E_AeNone       = 0,             			// AE 制御なし
  E_AeManualMode ,             				// マニュアルモード

  E_AeUsualProgMode,              			// 通常プログラムモード
  E_AeShutterControlMode,         			// シャッター制御モード
  E_AeShutterAndGainControlMode,  			// シャッター＆ゲイン制御AEモード
#ifdef WDR
  E_AeExposureRatioWDRMode,       			// 露光比指定WDRモード
  E_AeAutoWDRMode,                 			// オートWDRモード
#endif
  E_AeUsualProg_MainObjMode,              	// 主要被写体 通常プログラムモード
  E_AeShutterControl_MainObjMode,         	// 主要被写体 シャッター制御モード
  E_AeShutterAndGainControl_MainObjMode,  	// 主要被写体 シャッター＆ゲイン制御AEモード

  E_AeUsualProg_HistogramMode,              // ヒストグラム 通常プログラムモード
  E_AeShutterControl_HistogramMode,         // ヒストグラム シャッター制御モード
  E_AeShutterAndGainControl_HistogramMode,  // ヒストグラム シャッター＆ゲイン制御AEモード

  E_AEMODE_MAX
};
typedef unsigned char AXMIspAeModes;

enum eAutoCompMode {
  E_AutoCompHist = 0,             			// ヒストグラム分割モード
  E_AutoCompMain                  			// 主要被写体指定モード
};

typedef unsigned char AutoCompMode;

/**
 * @enum     	eAXMIspAeImgSensControl
 * @brief     AEイメージセンサー制御ID定義
 */
enum eAXMIspAeImgSensControl {
  E_ISC_None 			= 0x00,             // 制御なし
  E_ISC_ShutterSpeed 	= 0x01,             // シャッタースピード制御
  E_ISC_Gain 			= 0x02,             // ゲイン制御
  E_ISC_SlowShutter 	= 0x04,             // スローシャッター制御
  E_ISC_Iris         	= 0x08,             // アイリス制御
  E_ISC_Focus         	= 0x10,             // フォーカス制御
  E_ISC_Zoom         	= 0x20              // ズーム制御
};

typedef unsigned char AXMIspAeImgSensControl;

/**
 * @class AXMIspAeControlExposure
 * @brief イメージセンサ制御情報クラス
 *
 * @n
 */
class AXMIspAeControlExposure {
public:
  AXMIspAeImgSensControl doControlExposure;
  unsigned int contShutter;
  unsigned int contGain;
  unsigned int contIris;
  unsigned int frame;				// long or short Exposure
  unsigned int contFocus;
  unsigned char chromaOff;
};

/**
 * @struct  ST_SPECTRUM_ADJUST
 *
 * @n   [AWB-16]バラつき調整用レジスタ構造体
 */
typedef struct st_from_ae_to_isp
{
  unsigned short  luminance;                         //  明るさ情報
  bool  is_wdr_mode;                       //  wdrモードフラグ
} ST_FROM_AE_TO_ISP;

// Shutter Speed
enum SHUTTSPEED {
     Exposure1S         = (0x3FFFF),         // 露光時間最大値
     Exposure1PER2S     = ((Exposure1S+1)/2),    // 露光時間1/2ｓ
     Exposure1PER4S     = ((Exposure1S+2)/4),    // 露光時間1/4ｓ
     Exposure1PER8S     = ((Exposure1S+4)/8),    // 露光時間1/8ｓ
     Exposure1PER15S    = ((Exposure1S+7)/15),   // 露光時間1/15ｓ
     Exposure1PER30S    = ((Exposure1S+15)/30),   // 露光時間1/30ｓ
     Exposure1PER60S    = ((Exposure1S+30)/60),   // 露光時間1/60ｓ4369
     Exposure1PER100S   = ((Exposure1S+50)/100),  // 露光時間1/100ｓ2621
     Exposure1PER125S   = ((Exposure1S+62)/125),  // 露光時間1/125ｓ2097
     Exposure1PER250S   = ((Exposure1S+125)/250),  // 露光時間1/250ｓ1048
     Exposure1PER500S   = ((Exposure1S+250)/500),  // 露光時間1/500ｓ524
     Exposure1PER1000S  = ((Exposure1S+500)/1000), // 露光時間1/1000ｓ262
     Exposure1PER2000S  = ((Exposure1S+1000)/2000), // 露光時間1/2000ｓ131
     Exposure1PER4000S  = ((Exposure1S+2000)/4000), // 露光時間1/4000ｓ65
     Exposure1PER8000S  = ((Exposure1S+4000)/8000), // 露光時間1/8000ｓ32
     Exposure1PER16000S = ((Exposure1S+8000)/16000),// 露光時間1/16000ｓ16
     Exposure1PER32000S = ((Exposure1S+16000)/32000),// 露光時間1/32000ｓ8
};

// スローシャッターとゲインの優先順位
enum PrioSlowShutterGain {
   PRIO_GAIN = false,
	   PRIO_SLOW_SHUTTER = true
};

enum _recv_comm_ {
	 RECV_AEMODE_USUAL = 1,
	 RECV_AEMODE_WDR,
	 RECV_MIX_MODE,
	 RECV_MIX_EXP_RATIO,
	 RECV_MIX_THR_SHORT,
	 RECV_AE_TARGET
};

enum DayNightEnable {
	DAYNIGHT_OFF = 0,
	DAYNIGHT_ON
};

enum DayNightMode {
	DAYNIGHT_MODE_NIGHT = 0,
	DAYNIGHT_MODE_DAY
};

enum DayNightJudge {
	DAYNIGHT_JUDGE_LUMIX = 0,
	DAYNIGHT_JUDGE_GAIN
};

#endif /* AXMISPTYPE_HPP_ */
