/*
 * AXMIspAe.cpp
 */

#include "../AXMCommon/AXMCommonConfig.hpp"
#include "AXMIspAe.hpp"
#include "AXFEvent.hpp"
#include "AXFStage.hpp"
#ifndef DISABLE_AE2PACK_PROC
#include "AXMISPtype.hpp"
#endif  //  DISABLE_AE2PACK_PROC
#ifdef AXM_ISP_CT_AE
#include "AXMIspCT/AXMIspCTAe.hpp"
#endif

#include "AXHSpec.hpp"

#ifdef USE_AXFTEST_COMMAND
const std::string aeSampleData("abcdefghijelmnopqrstuvwxyz");
#endif /* USE_AXFTEST_COMMAND */

AXMIspAe::AXMIspAe(AXFObjectName& name)
    : AXModelActor(name),
      m_log(name),
      m_name(name),
      m_count(0) {
  m_log.write(AXFLOG_DEBUG, "AE Constractor");
  // スタックサイズ確認用
    static int memSize = 0;

    memSize  = sizeof(AXFLog);
    memSize += sizeof(AXFObjectName);
    memSize += sizeof(int);
    memSize += sizeof(AXMIspAeExecCalcBase);
    memSize += sizeof(AXMIspAeSetting);
    memSize += sizeof(AXMIspAeModes);
    opdData = NULL;
  #ifndef DISABLE_AE2PACK_PROC
    aeCalc = NULL;
    aeSetting = NULL;	
    AeModeSave = static_cast<AXMIspAeModes>(0);		// ※コンパイラ都合によりenumから数値に変更（_ZERO -> 0）
	sequencer = NULL;
  #endif  //  DISALBE_AE2PACK_PROC
    state = 0;
    aeSetteingSav = NULL;
    modeChangeReq = MODCHG_NONE;
    fromAeToIsp.luminance = 0;	// for Coverity
    fromAeToIsp.is_wdr_mode = false;
	p_spec = NULL;

#ifdef PARASOFT_CPPTEST
  flag_newStub = false;
#endif
}

AXMIspAe::~AXMIspAe() {
  m_log.write(AXFLOG_DEBUG, "AE Destractor");
}

ax::actorFuncStatus AXMIspAe::onCreate() {
  m_log.write(AXFLOG_DEBUG, "AE onCreate()");
  // StateMachine に必要な情報を登録する
  //      自オブジェクト,
  //      初期状態,
  //      状態の最大数
  if (0 > setStateInfo(this, STATE_WAITING, STATE_MAX)) {
    m_log.write(AXFLOG_ERR, "AE fail registHandle");
    return ax::AXFACTOR_ERROR;
  }

  // STATE_SAMPLE_DATA状態の状態テーブルを登録する
  //      状態テーブルで登録する状態,
  //      状態テーブルのポインタ,
  setStateTable(STATE_WAITING, state_wating);
  setStateTable(STATE_RUNNING, state_running);
  setStateTable(STATE_ADJUST, state_adjust);
  setStateTable(STATE_SHUTT_AEMODE, state_shutt_aemode);
  setStateTable(STATE_DEFECT_MODE, state_defect_mode);

  return ax::AXFACTOR_SUCCESS;
}


ax::actorFuncStatus AXMIspAe::onStart() {
  m_log.write(AXFLOG_DEBUG, "AE onStart()");

#ifndef DISABLE_AE2PACK_PROC
  AeModeSave = static_cast<AXMIspAeModes>(0);		// ※コンパイラ都合によりenumから数値に変更（_ZERO -> 0）
	sequencer = new AXMIspAeSequencer();
    AXMIspAeSetting *debugAeSetting = new AXMIspAeSetting();

#ifdef PARASOFT_CPPTEST
  if(flag_newStub) {
		  debugAeSetting = NULL;
  }
#endif
	  if (debugAeSetting != NULL) {
#ifdef AE_DEBUG
	    m_log.write(AXFLOG_DEBUG, "debugAeSetting != NULL");
	    debugAeSetting->AeMode = E_AeUsualProgMode;
	    debugAeSetting->objAeChara.PhotometryPatternNo = E_PhotometCenter;		// E_PhotometRight;
	    debugAeSetting->objAeChara.SelectBL_CorFLCEnable = false;		// 自動逆光／過順光補正ＯＮ／ＯＦＦ
	    debugAeSetting->objAeChara.SelectBL_CorFLC = 0;				// 逆光補正／過順光補正切り替え
	    debugAeSetting->objAeChara.SelectHISTorMAIN = E_AutoCompHist;	//E_AutoCompMain; // 主要被写体指定モード;			// 自動補正モード選択  
	    										// E_AutoCompHist = 0,             // ヒストグラム分割モード
	    debugAeSetting->objAeWDRChara.ExposureRatio = 0x400;	// 露光比率16倍
		debugAeSetting->objAeWDRChara.adjustExposureRatio = debugAeSetting->objAeWDRChara.ExposureRatio;
		debugAeSetting->objAeWDRChara.adjustThrLong = 0xC00;
		debugAeSetting->objAeWDRChara.adjustThrShort = 0xF00;

	    
	    debugAeSetting->objAeConvAdj.AeSpeed = 30;   // 30frame
	    // Manual モード時に有効　ｖ ｖ ｖ
	    debugAeSetting->objAeManual.ShutterSpeed = Exposure1PER30S;
	    debugAeSetting->objAeManual.Gain = 0;
	    debugAeSetting->objAeMechaIris.FlagIrisRegion = 1;
	    debugAeSetting->objAeMechaIris.RoughIrisValue = 0x00;
	    // Manual モード時に有効　^ ^ ^
#ifdef IMX662
	  	debugAeSetting->objAeChara.RangeExposureTimeLower = Exposure1PER60S;		// 1/60fps
#elif IMX415	// IMX662
		// IMX415用
	  	debugAeSetting->objAeChara.RangeExposureTimeLower = Exposure1PER30S;		// 1/30fps
#else	// IMX662
		// IMX412用
	  	debugAeSetting->objAeChara.RangeExposureTimeLower = Exposure1PER15S;		// 1/15fps
#endif	// IMX662
	    debugAeSetting->objAeChara.RangeExposureTimeUpper = Exposure1PER500S;	// Exposure1PER125S;	// 1/500fps
	    debugAeSetting->objAeChara.RangeGain = 24;	// Gain MAX 48dB
	  	debugAeSetting->objAeChara.SlowShutterEnable = true;		// Slow Shutter on
	  	debugAeSetting->objAeChara.PrioritySlowGain = false;		// Slow Shutter 優先

	    debugAeSetting->objAeChara.MaxSlowShutter = Exposure1PER15S;

	  	
	  	debugAeSetting->objAeConvAdj.DeadZoneIn = static_cast<long>(10L);  //  1.00
	 
	  	debugAeSetting->objAeTarget.AeTarget = static_cast<long>(255L);  // 10.0 255L
#endif	// endif of AE_DEBUG
	  	
	  	notifyAeSettings(debugAeSetting);
	  	delete debugAeSetting;
  	}	// end of if (debugAeSetting != NULL)

  // K.Kawachi add ^ ^ ^
#endif  //  DISABLE_AE2PACK_PROC
#ifdef AXM_ISP_CT_AE
  AXMIspCTAe::SetLog(&m_log);
	notifyAeSettings(AXMIspCTAe::GetAeSettings());
#endif

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::onStop() {
  m_log.write(AXFLOG_DEBUG, "AE onStop()");

#ifndef DISABLE_AE2PACK_PROC
	if (sequencer != NULL){
		delete sequencer;
	}
#endif  //  DISABLE_AE2PACK_PROC

  return ax::AXFACTOR_SUCCESS;
}

void AXMIspAe::notifyAeSettings(AXMIspAeSetting *obj) {
	if(obj != NULL) {
		aeSettingObj = *obj;
	}
	aeSetting = &aeSettingObj;
#ifdef AXM_ISP_CT_AE
	aeSetting = AXMIspCTAe::GetAeSettings();
#endif
}

