/*
 * AXMIspAeSetting.cpp
 * AE設定値
 *
 */
#include <iostream>
#include "AXMIspAeSetting.hpp"
#include "AXMIspAeAlgorithm.hpp"
#ifndef PARASOFT_CPPTEST
using namespace std;
#endif

AXMIspAeCharacteristic::AXMIspAeCharacteristic() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeCharacteristic::constructor ~~~" << endl;
  #endif
#endif
#ifdef IMX662
  RangeExposureTimeLower = Exposure1PER60S;      		// シャッタースピード範囲下限
#elif IMX415	// IMX662
  // IMX415用
  RangeExposureTimeLower = Exposure1PER30S;      		// シャッタースピード範囲下限
#else	// IMX662
  // IMX412用
  RangeExposureTimeLower = Exposure1PER15S;      		// シャッタースピード範囲下限
#endif	// IMX662
  RangeExposureTimeUpper = Exposure1PER8000S;     		// シャッタースピード範囲上限
  RangeGain = 24;												// Gain MAX 48dB // ゲイン範囲
  SlowShutterEnable = true;									// 低速シャッタースピード制御ON/OFF
  MaxSlowShutter = Exposure1PER15S;						// 低速シャッタースピード制御時最長露光時間設定
  PrioritySlowGain = PRIO_GAIN;								// ゲイン制御と低速シャッタースピード制御の優先順位
  PhotometryPatternNo = E_PhotometCenter;  				// 露光パターン指定 デフォルト中央重点
  SelectBL_CorFLCEnable = 0;								// 自動逆光／過順光補正ＯＮ／ＯＦＦ
  SelectBL_CorFLC = 0;										// 逆光補正(0)／過順光補正切り替え(1)
  SelectHISTorMAIN = E_AutoCompHist;						// 自動補正モード選択
  startX = 3;
  startY = 3;
  endX = 6;
  endY = 8;

  for (UCHAR y = 0; y < 10; y++) {
  	for (UCHAR x = 0; x < 10; x++) {
		// 主要被写体指定モード時エリア指定
  		AXMIspAeMainObjectAreaInfo[(y * 10) + x] = ((startX <= x) && (x <= endX) && (startY <= y) && (y <= endY)) ? 1 : 0;
  	}
  }
}

AXMIspAeCharacteristic::~AXMIspAeCharacteristic() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeCharacteristic::destructor ~~~" << endl;
  #endif
#endif

}

static const UCHAR defaultPhotometUser[100]={
		1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 ,
		1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 ,
		1 , 1 , 1 , 1 , 2 , 2 , 1 , 1 , 1 , 1 ,
		1 , 1 , 1 , 2 , 3 , 3 , 2 , 1 , 1 , 1 ,
		1 , 1 , 1 , 2 , 3 , 3 , 3 , 1 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1
};

AXMIspAePhotometryPattern::AXMIspAePhotometryPattern() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAePhotometryPattern::constructor ~~~" << endl;
  #endif
#endif
  for (short i = 0; i < 100; i++) {		// ※コンパイラ都合によりenumから数値に変更（_HUNDRED -> 100）
    PhotometUSER[i] = defaultPhotometUser[i];			//　エリア重み
  }
}

AXMIspAePhotometryPattern::~AXMIspAePhotometryPattern() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAePhotometryPattern::destructor ~~~" << endl;
  #endif
#endif

}

#ifdef MECHA_IRIS
AXMIspAeMechaIrisAdjust::AXMIspAeMechaIrisAdjust() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeMechaIrisAdjust::constructor ~~~" << endl;
  #endif
#endif
  FlagIrisRegion = 0;					//　メカアイリス（DCサーボタイプ）調整モード起動
  RoughIrisValue = IRIS_CONT_CLOSE_FAST;
   irisStopUpper = IRIS_CONT_STOP_UPPER;					// 1）停止範囲上限電圧
   irisStopLower = IRIS_CONT_STOP_LOWER;					// 2）停止範囲下限電圧
   irisCloseSlow = IRIS_CONT_CLOSE_SLOW;					// 3）アイリス閉低速電圧
   irisCloseFast = IRIS_CONT_CLOSE_FAST;					// 4）アイリス閉高速電圧
   irisOpenSlow  = IRIS_CONT_OPEN_SLOW;					// 5）アイリス開低速電圧
   irisOpenFast  = IRIS_CONT_OPEN_FAST;					// 6）アイリス開高速電圧

}
#endif
#ifdef MECHA_IRIS
AXMIspAeMechaIrisAdjust::~AXMIspAeMechaIrisAdjust() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeMechaIrisAdjust::destructor ~~~" << endl;
  #endif
#endif
}
#endif
AXMIspAeTarget::AXMIspAeTarget() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeTarget::constructor ~~~" << endl;
  #endif
#endif
  AeTarget = 256L;			// AE目標値
}

AXMIspAeTarget::~AXMIspAeTarget() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeTarget::destructor ~~~" << endl;
  #endif
#endif
}

AXMIspAeManualSet::AXMIspAeManualSet() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeManualSet::constructor ~~~" << endl;
  #endif
#endif
#ifdef IMX662
  ShutterSpeed = Exposure1PER60S;		// シャッタースピード設定
#elif IMX415	// IMX662
  // IMX415用
  ShutterSpeed = Exposure1PER30S;		// シャッタースピード設定
#else	// IMX662
  // IMX412用
  ShutterSpeed = Exposure1PER15S;		// シャッタースピード設定
#endif	// IMX662
  Gain = 0;								// ゲイン設定
}

AXMIspAeManualSet::~AXMIspAeManualSet() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeManualSet::destructor ~~~" << endl;
  #endif
#endif
}

AXMIspAeConvergenceAdjust::AXMIspAeConvergenceAdjust() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeConvergenceAdjust::constructor ~~~" << endl;
  #endif
#endif
	AeSpeed = 30;				// 収束時間
	DeadZoneOut = (short) 10;					// 不感帯
	DeadZoneIn = (short) 10;
}

AXMIspAeConvergenceAdjust::~AXMIspAeConvergenceAdjust() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeConvergenceAdjust::destructor ~~~" << endl;
  #endif
#endif
}

#ifdef WDR
AXMIspAeWDRCompositionCharacteristic::AXMIspAeWDRCompositionCharacteristic() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeWDRCompositionCharacteristic::constructor ~~~" << endl;
  #endif
#endif
  LongExposureCompMin = 0;
  CompErrDetectSensity = 0;
}
#endif

#ifdef WDR
AXMIspAeWDRCompositionCharacteristic::~AXMIspAeWDRCompositionCharacteristic() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeWDRCompositionCharacteristic::destructor ~~~" << endl;
  #endif
#endif
}
#endif

#ifdef WDR
AXMIspAeWDRCharacteristic::AXMIspAeWDRCharacteristic() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeWDRCharacteristic::constructor ~~~" << endl;
  #endif
#endif
  ExposureRatio = 0x00000400;	// 16倍
  adjustExposureRatio = 0x00000400;
  adjustThrLong = 0xC00;
  adjustThrShort = 0xF00;
  ShortExposureControl = 0;
  AutoWDRShortExposureTarget = 512;
  AutoWDRLongExposureTarget = 128;				//
  ShortExposureCompMax = 0;
  adjustThrErr = 0x02000010;
}
#endif

#ifdef WDR
AXMIspAeWDRCharacteristic::~AXMIspAeWDRCharacteristic() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeWDRCharacteristic::destructor ~~~" << endl;
  #endif
#endif
}
#endif

AXMIspDayNight::AXMIspDayNight() {
  dayNightMode = 0;			//  Day/Nightモード  0. OFF
							// 					 1. ON"
  judgeMode = 0;			// 判定モード  0. AGCとシャッタスピードから算出されるセンサー像面照度に基づく判定
							//             1. AGCに基づく判定"
  upperLimit = 5;			// 上限設定（判定モード：センサー像面照度に基づく判定）"
  dayNightInThre = 75;		// Day/Nightモード IN点閾値 75lx
  dayNightOutThre = 9;		// Day/Nightモード OUT点閾値 9lx
  judgeTransTime = 10;		// 判定遷移時間 10frame = 160ms
  nightColorSig = 0;			// Night時の色信号設定
  forceMode = 0;				// 強制モード  0. OFF
										//             1. ON
  forceDayNightSelect = 0;	// 強制モード時Day/Night選択 0. Dayモード
							//                           1. Nightモード
  dayNightIndicate = 0;		// Day/Nightモード表示       0. Dayモード
							//                           1. Nightモード
}

AXMIspDayNight::~AXMIspDayNight() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspDayNight::destructor ~~~" << endl;
  #endif
#endif
}

AXMIspAeSetting::AXMIspAeSetting() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeSetting::constructor ~~~" << endl;
  #endif
#endif
	// 今回はIRISは無いためシャッター＆ゲインモードに設定
  AeMode = E_AeShutterAndGainControlMode;		//E_AeUsualProgMode;
  flickerEnable = 0;	// フリッカ補正disable
}

AXMIspAeSetting::~AXMIspAeSetting() {
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "~~~ AXMIspAeSetting::destructor ~~~" << endl;
  #endif
#endif
}

