/**
 * @file   AXMIspAeState.hpp
 * @brief  AXMIspAeクラス StateMachineオブジェクトヘッダ
 *
 * @n
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

  // StateMachine用状態定義
  enum ModelState {
    STATE_WAITING = 0,                  //  待機中:調整モード(IRIS調整)
    STATE_RUNNING,                      //  通常モード
    STATE_ADJUST,                       //  調整モード(IRIS調整)
  	STATE_SHUTT_AEMODE,                  //  AEモード指定
  	STATE_DEFECT_MODE,                  //  画素欠陥補正モード
  	
    STATE_MAX
  };

  // StateMachine用イベント定義
  enum ModelEvent {
    EVENT_START = AXFEVENT_MODEL(0),    //  周期処理開始

    EVENT_RUNNING,                      //  通常モード切替
    EVENT_ADJUST,                       //  調整モード(IRIS調整)切替				// 今回不要　アイリス使用しない
    EVENT_WAITING,                      //  調整モード(IRIS調整以外)切替		// 今回不要　該当処理ない
    EVENT_SPEC_AEMODE,                  //  AEモード指定切替
  	EVENT_DEFECT_MODE,                  //  画素欠陥補正モード指定切替			// 今回不要　欠陥モードなし
    //EVENT_STOP,
#ifdef USE_AXFTEST_COMMAND
    EVENT_SAMPLE_DATA = AXFEVENT_MODEL(1000),
    EVENT_PRIORITY_TEST = AXFEVENT_MODEL(1001),													// 今回不要　テスト用
#endif /* USE_AXFTEST_COMMAND */
    EVENT_SENSOR_GAIN_GET,              //  センサーゲイン取得

    EVENT_SPEC_ADDR,                    //  設定値保存先アドレス通知
  	
  };

  // モード切替要求用定義
  enum ModeChangeRequest {
    MODCHG_NONE = 0,                     //  モード切替なし
    MODCHG_RUNNING,                      //  通常モード切替
    MODCHG_ADJUST,                       //  調整モード(IRIS調整)切替
    MODCHG_WAITING,                      //  調整モード(IRIS調整以外)切替
    MODCHG_SPEC_AEMODE,                  //  AEモード指定切替
  	MODCHG_DEFECT_MODE,                  //  画素欠陥補正モード指定切替
  };

  // StateMachine用状態テーブル宣言
  static const AXMIspAe::StateTable state_wating[];
  static const AXMIspAe::StateTable state_running[];
  static const AXMIspAe::StateTable state_adjust[];
  static const AXMIspAe::StateTable state_shutt_aemode[];
  static const AXMIspAe::StateTable state_defect_mode[];

  // StateMachine用メンバ関数宣言
  /** 
   * @brief     通常モード切替
   *
   * @n
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix0000(const void *pParam, int size);
  /** 
   * @brief     調整モード(WB調整)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix0008(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix0009(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整以外)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix000A(const void *pParam, int size);
  /** 
   * @brief     AEモード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix000B(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix000C(const void *pParam, int size);
  /** 
   * @brief     AE周期処理
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix0100(const void *pParam, int size);
  /** 
   * @brief     通常モード切替(dummy)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix0108(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix0109(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整以外)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix010A(const void *pParam, int size);
  /** 
   * @brief     AEモード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix010B(const void *pParam, int size);
  /** 
   * @brief     画素欠陥補正モード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix010C(const void *pParam, int size);
  /** 
   * @brief     調整モード
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix1000(const void *pParam, int size);
  /** 
   * @brief     通常モード切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix1008(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整)切替(dummy)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix1009(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整以外)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix100A(const void *pParam, int size);
  /** 
   * @brief     AEモード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix100B(const void *pParam, int size);
  /** 
   * @brief     画素欠陥補正モード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix100C(const void *pParam, int size);
  /** 
   * @brief     調整モード
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix2000(const void *pParam, int size);
  /** 
   * @brief     通常モード切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix2008(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整)切替(dummy)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix2009(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整以外)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix200A(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix200B(const void *pParam, int size);
  /** 
   * @brief     画素欠陥補正モード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix200C(const void *pParam, int size);
  /** 
   * @brief     調整モード
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix3000(const void *pParam, int size);
  /** 
   * @brief     通常モード切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix3008(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整)切替(dummy)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix3009(const void *pParam, int size);
  /** 
   * @brief     調整モード(IRIS調整以外)切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix300A(const void *pParam, int size);
  /** 
   * @brief     AEモード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix300B(const void *pParam, int size);
  /** 
   * @brief     画素欠陥補正モード指定切替
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus matrix300C(const void *pParam, int size);
  /** 
   * @brief     AEイメージセンサー制御要求
   *
   * @param [in]  controlExposure デバイスドライバの設定情報
   */
  void send2Driver(AXMIspAeControlExposure *controlExposure);
  /** 
   * @brief     AEイメージセンサー制御要求クラス イメージセンサ設定
   *
   * @param [in] time	CMOSセンサーのSHS1[16:0]　蓄積時間設定　ライン単位で設定
   * @param [in] gain	CMOSセンサーのGAIN1[8:0]　ゲイン設定　
   */
  void sendShutterSpeed(unsigned int time, unsigned int gain);
  /** 
   * @brief     AEイメージセンサー制御要求クラス イメージセンサ設定
   *
   * @param [in] time	CMOSセンサーのSHS1[16:0]　蓄積時間設定　ライン単位で設定
   * @param [in] gain	CMOSセンサーのGAIN1[8:0]　ゲイン設定　
   * @param [in] frame	フレームNo.
   */
  void sendShutterSpeed(unsigned int time, unsigned int gain, unsigned int frame);
#ifdef MECHA_IRIS
  /**
   * @brief     AEイメージセンサー制御要求クラス イメージセンサ設定
   *
   * @param [in]	iris	DCアイリス/Pアイリス制御情報（高速開/低速開/停止/低速閉/高速閉）
   */
  void sendIrisControl(unsigned int iris);
#endif
  /**
   * @brief     AEイメージセンサー制御要求クラス イメージセンサ設定
   *
   * @param [in]	focus	focus制御（高速Infinity/低速Infinity/停止/低速Macro/高速Macro）
   */
  void sendFocusControl(unsigned int focus);

  /**
   * @brief     アイリス調整モード遷移
   *
   * @param [in]  isAdjust true:調整モード\n
   * @n                    false:通常モード
   */
  void modeChangeAdjust(bool isAdjust);
  /**
   * @brief     WB調整モード遷移
   *
   * @n
   */
  void modeChangeWating(void);
  /**
   * @brief     キズ補正モード遷移
   *
   * @param [in]  isAdjust true:調整モード\n
   * @n                    false:通常モード
   */
  void modeChangeSpecAe(bool isAdjust);
  /**
   * @brief     画素欠陥補正モード遷移
   *
   * @param [in]  isAdjust true:調整モード\n
   * @n                    false:通常モード
   */
  void modeChangeDefect(bool isAdjust);

  /**
   * @brief	センサーゲインを補助タスク(AXMIspAssist)へ通知する
   *
   * @param	[in]	sensorGain              センサーゲイン
   */
  void sendSensorGainToIspAssist(unsigned char sensorGain);
  /**
   * @brief 設定値保存先アドレス通知を受信し、設定値参照先にそのアドレスを設定する
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus funcSpecAddr(const void *pParam, int size);


#ifdef USE_AXFTEST_COMMAND
  ax::actorFuncStatus funcSampleData(const void *pParam, int size);
  ax::actorFuncStatus funcPriorityTest(const void *pParam, int size);
#endif /* USE_AXFTEST_COMMAND */
#ifdef PARASOFT_CPPTEST
  int send(AXFObjectName& name, AXFEvent_t eventId, void* data, int size);
  int return_stub_send;
  int setStateInfo(AXFActor* obj, int initState, int maxState);
  int return_stub_setStateInfo;
  void setStateTable(int registState, const StateTable* stateTable);
  
#endif	// PARASOFT_CPPTEST
  int   state;                          //  次期ステータス格納用
  AXMIspAeSetting *aeSetteingSav;
  UCHAR modeChangeReq;


