/*
 * AXMIspAf.cpp
 */

#include "AXMIspAf.hpp"
#include "AXFEvent.hpp"
#include "AXFStage.hpp"
#include "../AXMIsp/AXMIsp.hpp"
#ifndef BB_TMP_PASS	/* 一旦コンパイルを通す用 */
#include "../../project/refkit/AXMIspConfig.hpp"
#endif

#ifdef USE_AXFTEST_COMMAND
#include "../AXMIspAe/AXMIspAe.hpp"
const std::string afSampleData("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
#endif /*USE_AXFTEST_COMMAND*/

AXMIspAf::AXMIspAf(AXFObjectName& name)
    : AXModelActor(name),
      m_log(name),
      m_name(name),
      m_count(0) {
  m_log.write(AXFLOG_DEBUG, "AF Constractor");
  base = NULL;
  state = 0;
#ifdef PARASOFT_CPPTEST
  return_stub_send = 0;;
  return_stub_setStateInfo = 0;
  flag_newStub = 0;
#endif	// PARASOFT_CPPTEST

}

AXMIspAf::~AXMIspAf() {
  m_log.write(AXFLOG_DEBUG, "AF Destractor");
}

ax::actorFuncStatus AXMIspAf::onCreate() {
  m_log.write(AXFLOG_DEBUG, "AF onCreate()");

  // StateMachine に必要な情報を登録する
  //      自オブジェクト,
  //      初期状態,
  //      状態の最大数
  if (0 > setStateInfo(this, STATE_WAITING, STATE_MAX)) {
    m_log.write(AXFLOG_ERR, "AE fail registHandle");
    return ax::AXFACTOR_ERROR;
  }

  // STATE_SAMPLE_DATA状態の状態テーブルを登録する
  //      状態テーブルで登録する状態,
  //      状態テーブルのポインタ,
  setStateTable(STATE_WAITING, state_waiting);
  setStateTable(STATE_RUNNING, state_running);

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAf::onStart() {
  m_log.write(AXFLOG_DEBUG, "AF onStart()");

  	base = new AXMIspAfBase;
#ifdef PARASOFT_CPPTEST
  if(flag_newStub) {
	  base = NULL;
  }
#endif

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAf::onStop() {
  m_log.write(AXFLOG_DEBUG, "AF onStop()");
	
  if(base) {
	delete base;
  }
  return ax::AXFACTOR_SUCCESS;
}

