/**
 * @file   AXMIspAfState.hpp
 * @brief  AXMIspAfクラス StateMachineオブジェクトヘッダ
 *
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

  // StateMachine用状態定義
  enum ModelState {
    STATE_WAITING = 0,
    STATE_RUNNING ,
    STATE_MAX
  };

  // StateMachine用イベント定義
  enum ModelEvent {
    EVENT_AF_EXEC = AXFEVENT_MODEL(1000),
#ifdef USE_AXFTEST_COMMAND
    EVENT_SAMPLE_DATA = AXFEVENT_MODEL(1001),
    EVENT_PRIORITY_TEST = AXFEVENT_MODEL(1002),
    EVENT_AXTORCOMM_TEST = AXFEVENT_MODEL(1003),
#endif /*USE_AXFTEST_COMMAND*/
    EVENT_SPEC_ADDR = AXFEVENT_MODEL(1004),                 //  設定値保存先アドレス通知

  };

  // StateMachine用状態テーブル宣言
  static const AXMIspAf::StateTable state_waiting[];
  static const AXMIspAf::StateTable state_running[];

  // StateMachine用メンバ関数宣言
  ax::actorFuncStatus funcAfExec(const void *pParam, int size);
  ax::actorFuncStatus funcSpecAddr(const void *pParam, int size);

#ifdef USE_AXFTEST_COMMAND
  ax::actorFuncStatus funcSampleData(const void *pParam, int size);
  ax::actorFuncStatus funcPriorityTest(const void *pParam, int size);
  ax::actorFuncStatus funcActorCommTest(const void *pParam, int size);
#endif /*USE_AXFTEST_COMMAND*/
#ifdef PARASOFT_CPPTEST
//  int send(AXFObjectName& name, ax::AXFEVENT_t eventId, void* data, int size);
  int send(AXFObjectName& name, AXFEvent_t eventId, void* data, int size);
  int return_stub_send;
  int setStateInfo(AXFActor* obj, int initState, int maxState);
  int return_stub_setStateInfo;
  void setStateTable(int registState, const StateTable* stateTable);
  int flag_newStub;
#endif	// PARASOFT_CPPTEST
  int state;



