/**
 * @file			AXMIspCh.hpp
 * @brief			AXMIspCh計算クラス群ヘッダ
 *
 * @par			言語
 * 					C++
 */
#ifndef AXMISPCH_HPP_
#define AXMISPCH_HPP_
#include "AXMIspAssistType.hpp"

/**
 * @class     AXMIspChCalc
 * @brief     低輝度クロマサプレスゲイン計算クラス
 *
 * @n         低輝度クロマサプレスのゲインを計算する。
 */
class AXMIspChCalc {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspChCalc();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspChCalc();

public:
	/**
	 * @brief	低輝度クロマサプレス計算
	 *
	 * @param	[in]  sensorGain               センサーゲイン
	 * @param	[in]  lowStartGain             低輝度クロマサプレス開始ゲイン
	 * @param	[in]  lowInc                   低輝度クロマサプレス傾き
	 * @param	[out] gain                     変換ゲイン
	 */
	void				CalcLowLuminanceChromaSuppress(BYTE sensorGain, BYTE lowStartGain, BYTE lowInc, BYTE* gain);
};

#endif /* AXMISPCH_HPP_ */
