/**
 * @file			AXMIspOb.hpp
 * @brief			AXMIspOb計算クラス群ヘッダ
 *
 * @par			言語
 * 					C++
 */

#ifndef AXMISPOB_HPP_
#define AXMISPOB_HPP_

class AXMIspObSettings;
/**
 * @class     AXMIspObCalcBase
 * @brief     OB計算基底クラス
 *
 * @n         基本的なOB計算を行う
 */
class AXMIspObCalcBase {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspObCalcBase();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspObCalcBase();
public:
	virtual void			Exec() = 0;
	virtual void			NotifyObSettings(AXMIspObSettings* obSettings);
protected:
	AXMIspObSettings*		m_obSettings;
};

/**
 * @class		AXMIspObFeedback
 * @brief		OBフィードバック計算クラス
 *
 * @n         OBフィードバック値の計算を行う
 */
class AXMIspObFeedback : public AXMIspObCalcBase {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspObFeedback();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	AXMIspObFeedback(AXMIspObSettings* obSettings);
	virtual ~AXMIspObFeedback();
public:
	/**
	 * @brief		Feedbackモード時の黒レベル計算
	 */
	void					Exec();
};
#endif /* AXMISPOB_HPP_ */
